/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.outlookmessageparser.simplejavamail.rtf;

import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simplejavamail.outlookmessageparser.simplejavamail.rtf.RTF2HTMLConverter;
import org.simplejavamail.outlookmessageparser.simplejavamail.rtf.util.ByteUtil;
import org.simplejavamail.outlookmessageparser.simplejavamail.rtf.util.CharsetHelper;

public class SimpleRTF2HTMLConverter
implements RTF2HTMLConverter {
    private static final String[] HTML_START_TAGS = new String[]{"<html ", "<Html ", "<HTML "};
    private static final String[] HTML_END_TAGS = new String[]{"</html>", "</Html>", "</HTML>"};

    @Override
    public String rtf2html(String rtf) {
        if (rtf != null) {
            Charset charset = this.extractCodepage(rtf);
            String plain = this.fetchHtmlSection(rtf);
            plain = this.replaceSpecialSequences(plain);
            plain = this.replaceHexSequences(plain, "(?:\\\\f\\d(?:\\\\'..)+)", CharsetHelper.WINDOWS_CHARSET);
            plain = this.replaceHexSequences(plain, "(?:\\\\'..)+", charset);
            plain = this.cleanupRemainingSequences(plain);
            plain = this.replaceLineBreaks(plain);
            return plain;
        }
        return null;
    }

    private String cleanupRemainingSequences(String plain) {
        return plain.replaceAll("(\\\\f\\d.+?;)+", "").replaceAll("\\\\\\S+", "").replaceAll("BM__MailAutoSig((?s).*?(?-s))BM__MailAutoSig", "$1");
    }

    private Charset extractCodepage(String rtf) {
        Matcher codePageMatcher = Pattern.compile("(?:\\\\ansicpg(?<codePage>.+?)\\\\)+").matcher(rtf);
        if (codePageMatcher.find()) {
            return CharsetHelper.findCharset(codePageMatcher.group("codePage"));
        }
        return CharsetHelper.WINDOWS_CHARSET;
    }

    private String replaceLineBreaks(String text) {
        return text.replaceAll("( <br/> ( <br/> )+)", " <br/> ").replaceAll("\\r\\n", "\n").replaceAll("[\\r\\u0000]", "");
    }

    private String replaceHexSequences(String text, String sequencesToMatch, Charset charset) {
        StringBuilder res = new StringBuilder();
        int lastPosition = 0;
        Matcher escapedHexGroupMatcher = Pattern.compile(sequencesToMatch).matcher(text);
        while (escapedHexGroupMatcher.find()) {
            res.append(text, lastPosition, escapedHexGroupMatcher.start());
            StringBuilder hexText = new StringBuilder();
            String escapedHexGroup = escapedHexGroupMatcher.group(0);
            Matcher unescapedHexCharacterMatcher = Pattern.compile("\\\\'(..)").matcher(escapedHexGroup);
            while (unescapedHexCharacterMatcher.find()) {
                hexText.append(unescapedHexCharacterMatcher.group(1));
            }
            res.append(ByteUtil.hexToString(hexText.toString(), charset));
            lastPosition = escapedHexGroupMatcher.end();
        }
        if (res.length() == 0) {
            res.append(text);
        } else {
            res.append(text, lastPosition, text.length());
        }
        return res.toString();
    }

    private String fetchHtmlSection(String text) {
        int i;
        int htmlStart = -1;
        int htmlEnd = -1;
        for (i = 0; i < HTML_START_TAGS.length && htmlStart < 0; ++i) {
            htmlStart = text.indexOf(HTML_START_TAGS[i]);
        }
        for (i = 0; i < HTML_END_TAGS.length && htmlEnd < 0; ++i) {
            htmlEnd = text.indexOf(HTML_END_TAGS[i]);
            if (htmlEnd <= 0) continue;
            htmlEnd += HTML_END_TAGS[i].length();
        }
        if (htmlStart > -1 && htmlEnd > -1) {
            return text.substring(htmlStart, htmlEnd + 1);
        }
        String html = "<html><body style=\"font-family:'Courier',monospace;font-size:10pt;\">" + text + "</body></html>";
        html = html.replaceAll("[\\n\\r]+", " <br/> ");
        html = html.replaceAll("(http://\\S+)", "<a href=\"$1\">$1</a>");
        return html.replaceAll("mailto:(\\S+@\\S+)", "<a href=\"mailto:$1\">$1</a>");
    }

    private String replaceSpecialSequences(String text) {
        String replacedText = text;
        replacedText = replacedText.replaceAll("\\{\\\\S+ [^\\s\\\\}]*\\}", "");
        replacedText = replacedText.replaceAll("\\{HYPERLINK[^\\}]*\\}", "");
        replacedText = replacedText.replaceAll("\\{\\\\pntext[^\\}]*\\}", "");
        replacedText = replacedText.replaceAll("\\{\\\\\\*\\\\htmltag\\d+[^\\}<]+(<.+>)\\}", "$1");
        replacedText = replacedText.replaceAll("\\{\\\\\\*\\\\htmltag\\d+[^\\}<]+\\}", "");
        replacedText = replacedText.replaceAll("([^\\\\])\\}+", "$1");
        replacedText = replacedText.replaceAll("([^\\\\])\\{+", "$1");
        replacedText = replacedText.replaceAll("\\\\\\}", "}");
        replacedText = replacedText.replaceAll("\\\\\\{", "{");
        replacedText = replacedText.replaceAll("\\\\pard*", "\n");
        replacedText = replacedText.replaceAll("\\\\tab", "\t");
        replacedText = replacedText.replaceAll("\\\\\\*\\\\\\S+", "");
        return replacedText;
    }
}

