/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal.mailsender;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Phaser;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.simplejavamail.converter.EmailConverter;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageHelper;
import org.simplejavamail.email.Email;
import org.simplejavamail.email.Recipient;
import org.simplejavamail.internal.util.Preconditions;
import org.simplejavamail.mailer.config.TransportStrategy;
import org.simplejavamail.mailer.internal.mailsender.MailSenderException;
import org.simplejavamail.mailer.internal.mailsender.OperationalConfig;
import org.simplejavamail.mailer.internal.mailsender.ProxyConfig;
import org.simplejavamail.mailer.internal.mailsender.concurrent.NamedRunnable;
import org.simplejavamail.mailer.internal.socks.AuthenticatingSocks5Bridge;
import org.simplejavamail.mailer.internal.socks.SocksProxyConfig;
import org.simplejavamail.mailer.internal.socks.socks5server.AnonymousSocks5Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailSender.class);
    private final Session session;
    @Nullable
    private final TransportStrategy transportStrategy;
    private final OperationalConfig operationalConfig;
    @Nullable
    private AnonymousSocks5Server proxyServer;
    private ExecutorService executor;
    private Phaser smtpRequestsPhaser;

    public MailSender(@Nonnull Session session, @Nonnull OperationalConfig operationalConfig, @Nonnull ProxyConfig proxyConfig, @Nullable TransportStrategy transportStrategy) {
        this.session = session;
        this.operationalConfig = operationalConfig;
        this.transportStrategy = transportStrategy;
        this.proxyServer = MailSender.configureSessionWithProxy(proxyConfig, session, transportStrategy);
        this.init(operationalConfig);
    }

    private void init(@Nonnull OperationalConfig operationalConfig) {
        this.session.setDebug(operationalConfig.isDebugLogging());
        this.session.getProperties().putAll((Map<?, ?>)operationalConfig.getProperties());
        if (this.transportStrategy != null) {
            if (operationalConfig.isTrustAllSSLHost()) {
                this.trustAllHosts(true);
            } else {
                this.trustHosts(operationalConfig.getSslHostsToTrust());
            }
        }
    }

    private static AnonymousSocks5Server configureSessionWithProxy(@Nonnull ProxyConfig proxyConfig, @Nonnull Session session, @Nullable TransportStrategy transportStrategy) {
        if (!proxyConfig.requiresProxy()) {
            LOGGER.debug("No proxy set, skipping proxy.");
        } else {
            if (transportStrategy == TransportStrategy.SMTPS) {
                throw new MailSenderException("Proxy is not supported for SSL connections (this is a limitation by the underlying JavaMail framework)");
            }
            Properties sessionProperties = session.getProperties();
            if (transportStrategy != null) {
                sessionProperties.put(transportStrategy.propertyNameSocksHost(), proxyConfig.getRemoteProxyHost());
                sessionProperties.put(transportStrategy.propertyNameSocksPort(), String.valueOf(proxyConfig.getRemoteProxyPort()));
            } else {
                LOGGER.debug("no transport strategy provided, expecting mail.smtp(s).socks.host and .port properties to be set to proxy config on Session");
            }
            if (proxyConfig.requiresAuthentication()) {
                if (transportStrategy != null) {
                    sessionProperties.put(transportStrategy.propertyNameSocksHost(), "localhost");
                    sessionProperties.put(transportStrategy.propertyNameSocksPort(), String.valueOf(proxyConfig.getProxyBridgePort()));
                } else {
                    LOGGER.debug("no transport strategy provided but authenticated proxy required, expecting mail.smtp(s).socks.host and .port properties to be set to localhost and port " + proxyConfig.getProxyBridgePort());
                }
                SocksProxyConfig socksProxyConfig = new SocksProxyConfig(proxyConfig.getRemoteProxyHost(), proxyConfig.getRemoteProxyPort(), proxyConfig.getUsername(), proxyConfig.getPassword(), proxyConfig.getProxyBridgePort());
                return new AnonymousSocks5Server(new AuthenticatingSocks5Bridge(socksProxyConfig), proxyConfig.getProxyBridgePort());
            }
        }
        return null;
    }

    public final synchronized void send(final Email email, boolean async) {
        if (this.smtpRequestsPhaser == null || this.smtpRequestsPhaser.isTerminated()) {
            this.smtpRequestsPhaser = new Phaser();
        }
        this.smtpRequestsPhaser.register();
        if (async) {
            if (this.executor == null || this.executor.isShutdown()) {
                this.executor = Executors.newFixedThreadPool(this.operationalConfig.getThreadPoolSize());
            }
            this.configureSessionWithTimeout(this.session, this.operationalConfig.getSessionTimeout());
            this.executor.execute(new NamedRunnable("sendMail process"){

                @Override
                public void run() {
                    try {
                        MailSender.this.sendMailClosure(MailSender.this.session, email);
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to send email", (Throwable)e);
                    }
                }
            });
        } else {
            this.sendMailClosure(this.session, email);
        }
    }

    private void configureSessionWithTimeout(Session session, int sessionTimeout) {
        if (this.transportStrategy != null) {
            Properties sessionProperties = session.getProperties();
            sessionProperties.put(this.transportStrategy.propertyNameConnectionTimeout(), String.valueOf(sessionTimeout));
            sessionProperties.put(this.transportStrategy.propertyNameTimeout(), String.valueOf(sessionTimeout));
            sessionProperties.put(this.transportStrategy.propertyNameWriteTimeout(), String.valueOf(sessionTimeout));
        } else {
            LOGGER.debug("No transport strategy provided, skipping defaults for .connectiontimout, .timout and .writetimeout");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMailClosure(@Nonnull Session session, @Nonnull Email email) {
        block27: {
            LOGGER.trace("sending email...");
            try {
                MimeMessage message = MimeMessageHelper.produceMimeMessage(Preconditions.checkNonEmptyArgument(email, "email"), Preconditions.checkNonEmptyArgument(session, "session"));
                this.configureBounceToAddress(session, email);
                MailSender.logSession(session, "mail");
                message.saveChanges();
                email.internalSetId(message.getMessageID());
                try {
                    MailSender mailSender = this;
                    synchronized (mailSender) {
                        if (this.needsAuthenticatedProxy() && !this.proxyServer.isRunning()) {
                            LOGGER.trace("starting proxy bridge");
                            this.proxyServer.start();
                        }
                    }
                    if (!this.operationalConfig.isTransportModeLoggingOnly()) {
                        LOGGER.trace("\t\nEmail: {}", (Object)email);
                        LOGGER.trace("\t\nMimeMessage: {}\n", (Object)EmailConverter.mimeMessageToEML(message));
                        try (Transport transport = session.getTransport();){
                            transport.connect();
                            transport.sendMessage((Message)message, message.getAllRecipients());
                            break block27;
                        }
                        finally {
                            LOGGER.trace("closing transport");
                        }
                    }
                    LOGGER.info("TRANSPORT_MODE_LOGGING_ONLY: skipping actual sending...");
                    LOGGER.info("\n\nEmail: {}\n", (Object)email);
                    LOGGER.info("\n\nMimeMessage: {}\n", (Object)EmailConverter.mimeMessageToEML(message));
                }
                finally {
                    this.checkShutDownRunningProcesses();
                }
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("Failed to send email:\n{}", (Object)email);
                throw new MailSenderException("Encoding not accepted", e);
            }
            catch (MessagingException e) {
                LOGGER.error("Failed to send email:\n{}", (Object)email);
                throw new MailSenderException("Third party error", (Exception)((Object)e));
            }
            catch (Exception e) {
                LOGGER.error("Failed to send email:\n{}", (Object)email);
                throw e;
            }
        }
    }

    private void configureBounceToAddress(Session session, Email email) {
        Recipient bounceAddress = email.getBounceToRecipient();
        if (bounceAddress != null) {
            if (this.transportStrategy != null) {
                String formattedRecipient = String.format("%s <%s>", bounceAddress.getName(), bounceAddress.getAddress());
                session.getProperties().setProperty(this.transportStrategy.propertyNameEnvelopeFrom(), formattedRecipient);
            } else {
                throw new MailSenderException("Cannot determine the envelope .from property to set without a provided transport strategy");
            }
        }
    }

    private synchronized void checkShutDownRunningProcesses() {
        this.smtpRequestsPhaser.arriveAndDeregister();
        LOGGER.trace("SMTP request threads left: {}", (Object)this.smtpRequestsPhaser.getUnarrivedParties());
        if (this.smtpRequestsPhaser.getUnarrivedParties() == 0) {
            LOGGER.trace("all threads have finished processing");
            if (this.needsAuthenticatedProxy() && this.proxyServer.isRunning() && !this.proxyServer.isStopping()) {
                LOGGER.trace("stopping proxy bridge...");
                this.proxyServer.stop();
            }
            if (this.executor != null) {
                this.executor.shutdown();
            }
        }
    }

    private static void logSession(Session session, String activity) {
        TransportStrategy transportStrategy = TransportStrategy.findStrategyForSession(session);
        Properties properties = session.getProperties();
        String sessionDetails = transportStrategy != null ? transportStrategy.toString(properties) : properties.toString();
        LOGGER.debug("starting {} with {}", (Object)activity, (Object)sessionDetails);
    }

    private void trustAllHosts(boolean trustAllHosts) {
        if (this.transportStrategy != null) {
            this.session.getProperties().remove(this.transportStrategy.propertyNameSSLTrust());
            if (trustAllHosts) {
                this.session.getProperties().setProperty(this.transportStrategy.propertyNameSSLTrust(), "*");
            }
        } else {
            throw new MailSenderException("Cannot determine the trust properties to set without a provided transport strategy");
        }
    }

    private void trustHosts(@Nonnull List<String> hosts) {
        this.trustAllHosts(false);
        if (!hosts.isEmpty()) {
            if (this.transportStrategy == null) {
                throw new MailSenderException("Cannot determine the trust properties to set without a provided transport strategy");
            }
            StringBuilder builder = new StringBuilder(hosts.get(0));
            for (int i = 1; i < hosts.size(); ++i) {
                builder.append(" ").append(hosts.get(i));
            }
            this.session.getProperties().setProperty(this.transportStrategy.propertyNameSSLTrust(), builder.toString());
        }
    }

    public synchronized void testConnection() {
        boolean proxyBridgeStartedForTestingConnection = false;
        this.configureSessionWithTimeout(this.session, this.operationalConfig.getSessionTimeout());
        MailSender.logSession(this.session, "connection test");
        try (Transport transport = this.session.getTransport();){
            if (this.needsAuthenticatedProxy() && !this.proxyServer.isRunning()) {
                LOGGER.trace("starting proxy bridge for testing connection");
                this.proxyServer.start();
                proxyBridgeStartedForTestingConnection = true;
            }
            transport.connect();
        }
        catch (MessagingException e) {
            throw new MailSenderException("Was unable to connect to SMTP server", (Exception)((Object)e));
        }
        finally {
            if (proxyBridgeStartedForTestingConnection) {
                LOGGER.trace("stopping proxy bridge after connection test");
                this.proxyServer.stop();
            }
        }
    }

    private boolean needsAuthenticatedProxy() {
        return this.proxyServer != null;
    }

    public Session getSession() {
        return this.session;
    }

    public OperationalConfig getOperationalConfig() {
        return this.operationalConfig;
    }
}

