/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer;

import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.hazlewood.connor.bottema.emailaddress.EmailAddressCriteria;
import org.hazlewood.connor.bottema.emailaddress.EmailAddressValidator;
import org.simplejavamail.MailException;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageHelper;
import org.simplejavamail.email.AttachmentResource;
import org.simplejavamail.email.Email;
import org.simplejavamail.email.Recipient;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.mailer.MailerBuilder;
import org.simplejavamail.mailer.MailerException;
import org.simplejavamail.mailer.MailerFromSessionBuilder;
import org.simplejavamail.mailer.MailerGenericBuilder;
import org.simplejavamail.mailer.ServerConfig;
import org.simplejavamail.mailer.config.TransportStrategy;
import org.simplejavamail.mailer.internal.mailsender.MailSender;
import org.simplejavamail.mailer.internal.mailsender.OperationalConfig;
import org.simplejavamail.mailer.internal.mailsender.ProxyConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mailer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Mailer.class);
    private final MailSender mailSender;
    @Nonnull
    private final EnumSet<EmailAddressCriteria> emailAddressCriteria;
    @Nullable
    private final TransportStrategy transportStrategy;
    @Nullable
    private final ServerConfig serverConfig;
    @Nonnull
    private final ProxyConfig proxyConfig;

    Mailer(@Nonnull MailerFromSessionBuilder fromSessionBuilder) {
        this.serverConfig = null;
        this.transportStrategy = null;
        this.emailAddressCriteria = fromSessionBuilder.getEmailAddressCriteria();
        this.proxyConfig = fromSessionBuilder.buildProxyConfig();
        Session session = fromSessionBuilder.getSession();
        this.mailSender = this.initFromGenericBuilder(TransportStrategy.findStrategyForSession(session), this.proxyConfig, session, fromSessionBuilder);
    }

    Mailer(@Nonnull MailerBuilder.MailerRegularBuilder regularBuilder) {
        this.serverConfig = regularBuilder.buildServerConfig();
        this.transportStrategy = regularBuilder.getTransportStrategy();
        this.emailAddressCriteria = regularBuilder.getEmailAddressCriteria();
        this.proxyConfig = regularBuilder.buildProxyConfig();
        Session session = Mailer.createMailSession(this.serverConfig, this.transportStrategy);
        this.mailSender = this.initFromGenericBuilder(this.transportStrategy, this.proxyConfig, session, regularBuilder);
    }

    private MailSender initFromGenericBuilder(@Nonnull TransportStrategy transportStrategy, @Nonnull ProxyConfig proxyConfig, @Nonnull Session session, @Nonnull MailerGenericBuilder<?> genericBuiler) {
        OperationalConfig operationalConfig = genericBuiler.buildOperationalConfig();
        return new MailSender(session, operationalConfig, proxyConfig, transportStrategy);
    }

    public static Session createMailSession(@Nonnull ServerConfig serverConfig, @Nonnull TransportStrategy transportStrategy) {
        Properties props = transportStrategy.generateProperties();
        props.put(transportStrategy.propertyNameHost(), serverConfig.getHost());
        props.put(transportStrategy.propertyNamePort(), String.valueOf(serverConfig.getPort()));
        if (serverConfig.getUsername() != null) {
            props.put(transportStrategy.propertyNameUsername(), serverConfig.getUsername());
        }
        if (serverConfig.getPassword() != null) {
            props.put(transportStrategy.propertyNameAuthenticate(), "true");
            return Session.getInstance((Properties)props, (Authenticator)new SmtpAuthenticator(serverConfig));
        }
        return Session.getInstance((Properties)props);
    }

    public Session getSession() {
        LOGGER.warn("Providing access to Session instance for emergency fall-back scenario. Please let us know why you need it.");
        LOGGER.warn("\t\t> https://github.com/bbottema/simple-java-mail/issues");
        return this.mailSender.getSession();
    }

    @Nullable
    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    @Nullable
    public TransportStrategy getTransportStrategy() {
        return this.transportStrategy;
    }

    @Nonnull
    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    @Nonnull
    public OperationalConfig getOperationalConfig() {
        return this.mailSender.getOperationalConfig();
    }

    @Nonnull
    public EnumSet<EmailAddressCriteria> getEmailAddressCriteria() {
        return this.emailAddressCriteria;
    }

    public void testConnection() {
        this.mailSender.testConnection();
    }

    public final void sendMail(Email email) {
        this.sendMail(email, false);
    }

    public final synchronized void sendMail(Email email, boolean async) {
        if (this.validate(email)) {
            this.mailSender.send(email, async);
        }
    }

    public boolean validate(Email email) throws MailException {
        if (email.getRecipients().size() == 0) {
            throw new MailerException("Email is not valid: missing recipients");
        }
        if (email.getFromRecipient() == null) {
            throw new MailerException("Email is not valid: missing sender");
        }
        if (email.isUseDispositionNotificationTo() && email.getDispositionNotificationTo() == null) {
            throw new MailerException("Email is not valid: missing \"Disposition Notification To\" address");
        }
        if (email.isUseReturnReceiptTo() && email.getReturnReceiptTo() == null) {
            throw new MailerException("Email is not valid: missing \"Return Receipt To\" address");
        }
        if (!this.emailAddressCriteria.isEmpty()) {
            if (!EmailAddressValidator.isValid((String)email.getFromRecipient().getAddress(), this.emailAddressCriteria)) {
                throw new MailerException(String.format("Invalid FROM address: %s", email));
            }
            for (Recipient recipient : email.getRecipients()) {
                if (EmailAddressValidator.isValid((String)recipient.getAddress(), this.emailAddressCriteria)) continue;
                throw new MailerException(String.format("Invalid TO address: %s", email));
            }
            if (email.getReplyToRecipient() != null && !EmailAddressValidator.isValid((String)email.getReplyToRecipient().getAddress(), this.emailAddressCriteria)) {
                throw new MailerException(String.format("Invalid REPLY TO address: %s", email));
            }
            if (email.getBounceToRecipient() != null && !EmailAddressValidator.isValid((String)email.getBounceToRecipient().getAddress(), this.emailAddressCriteria)) {
                throw new MailerException(String.format("Invalid BOUNCE TO address: %s", email));
            }
            if (email.isUseDispositionNotificationTo() && !EmailAddressValidator.isValid((String)email.getDispositionNotificationTo().getAddress(), this.emailAddressCriteria)) {
                throw new MailerException(String.format("Invalid \"Disposition Notification To\" address: %s", email));
            }
            if (email.isUseReturnReceiptTo() && !EmailAddressValidator.isValid((String)email.getReturnReceiptTo().getAddress(), this.emailAddressCriteria)) {
                throw new MailerException(String.format("Invalid \"Return Receipt To\" address: %s", email));
            }
        }
        Mailer.scanForInjectionAttack(email.getSubject(), "email.subject");
        for (Map.Entry entry : email.getHeaders().entrySet()) {
            Mailer.scanForInjectionAttack((String)entry.getKey(), "email.header.mapEntryKey");
            if (((String)entry.getKey()).equals("References")) {
                Mailer.scanForInjectionAttack(MimeUtility.unfold((String)((String)entry.getValue())), "email.header.References");
                continue;
            }
            Mailer.scanForInjectionAttack((String)entry.getValue(), "email.header." + (String)entry.getKey());
        }
        for (AttachmentResource attachmentResource : email.getAttachments()) {
            Mailer.scanForInjectionAttack(attachmentResource.getName(), "email.attachment.name");
        }
        for (AttachmentResource attachmentResource : email.getEmbeddedImages()) {
            Mailer.scanForInjectionAttack(attachmentResource.getName(), "email.embeddedImage.name");
        }
        Mailer.scanForInjectionAttack(email.getFromRecipient().getName(), "email.fromRecipient.name");
        Mailer.scanForInjectionAttack(email.getFromRecipient().getAddress(), "email.fromRecipient.address");
        if (!MiscUtil.valueNullOrEmpty(email.getReplyToRecipient())) {
            Mailer.scanForInjectionAttack(email.getReplyToRecipient().getName(), "email.replyToRecipient.name");
            Mailer.scanForInjectionAttack(email.getReplyToRecipient().getAddress(), "email.replyToRecipient.address");
        }
        if (!MiscUtil.valueNullOrEmpty(email.getBounceToRecipient())) {
            Mailer.scanForInjectionAttack(email.getBounceToRecipient().getName(), "email.bounceToRecipient.name");
            Mailer.scanForInjectionAttack(email.getBounceToRecipient().getAddress(), "email.bounceToRecipient.address");
        }
        for (Recipient recipient : email.getRecipients()) {
            Mailer.scanForInjectionAttack(recipient.getName(), "email.recipient.name");
            Mailer.scanForInjectionAttack(recipient.getAddress(), "email.recipient.address");
        }
        return true;
    }

    private static void scanForInjectionAttack(String value, String valueLabel) {
        if (value != null && (value.contains("\n") || value.contains("\r") || value.contains("%0A"))) {
            throw new MailerException(String.format("Suspected of injection attack, field: %s with suspicious value: %s", valueLabel, value));
        }
    }

    public static MimeMessage signMessageWithDKIM(MimeMessage messageToSign, Email emailContainingSigningDetails) {
        return MimeMessageHelper.signMessageWithDKIM(messageToSign, emailContainingSigningDetails);
    }

    private static class SmtpAuthenticator
    extends Authenticator {
        private final ServerConfig serverConfig;

        public SmtpAuthenticator(ServerConfig serverConfig) {
            this.serverConfig = serverConfig;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.serverConfig.getUsername(), this.serverConfig.getPassword());
        }
    }
}

