/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParameterList;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.email.AttachmentResource;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.converter.internal.mimemessage.NamedDataSource;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;

public class MimeMessageHelper {
    private static final String CHARACTER_ENCODING = StandardCharsets.UTF_8.name();

    private MimeMessageHelper() {
    }

    static void setSubject(Email email, MimeMessage message) throws MessagingException {
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/internal/mimemessage/MimeMessageHelper.setSubject must not be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/converter/internal/mimemessage/MimeMessageHelper.setSubject must not be null");
        }
        message.setSubject(email.getSubject(), CHARACTER_ENCODING);
    }

    static void setFrom(Email email, MimeMessage message) throws UnsupportedEncodingException, MessagingException {
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/internal/mimemessage/MimeMessageHelper.setFrom must not be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/converter/internal/mimemessage/MimeMessageHelper.setFrom must not be null");
        }
        if (email.getFromRecipient() != null) {
            message.setFrom((Address)new InternetAddress(email.getFromRecipient().getAddress(), email.getFromRecipient().getName(), CHARACTER_ENCODING));
        }
    }

    static void setRecipients(Email email, Message message) throws UnsupportedEncodingException, MessagingException {
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/internal/mimemessage/MimeMessageHelper.setRecipients must not be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/converter/internal/mimemessage/MimeMessageHelper.setRecipients must not be null");
        }
        for (Recipient recipient : email.getRecipients()) {
            InternetAddress address = new InternetAddress(recipient.getAddress(), recipient.getName(), CHARACTER_ENCODING);
            message.addRecipient(recipient.getType(), (Address)address);
        }
    }

    static void setReplyTo(Email email, Message message) throws UnsupportedEncodingException, MessagingException {
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/internal/mimemessage/MimeMessageHelper.setReplyTo must not be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/converter/internal/mimemessage/MimeMessageHelper.setReplyTo must not be null");
        }
        Recipient replyToRecipient = email.getReplyToRecipient();
        if (replyToRecipient != null) {
            InternetAddress replyToAddress = new InternetAddress(replyToRecipient.getAddress(), replyToRecipient.getName(), CHARACTER_ENCODING);
            message.setReplyTo(new Address[]{replyToAddress});
        }
    }

    static void setTexts(Email email, MimeMultipart multipartAlternativeMessages) throws MessagingException {
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/internal/mimemessage/MimeMessageHelper.setTexts must not be null");
        }
        if (multipartAlternativeMessages == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/converter/internal/mimemessage/MimeMessageHelper.setTexts must not be null");
        }
        if (email.getPlainText() != null) {
            MimeBodyPart messagePart = new MimeBodyPart();
            messagePart.setText(email.getPlainText(), CHARACTER_ENCODING);
            multipartAlternativeMessages.addBodyPart((BodyPart)messagePart);
        }
        if (email.getHTMLText() != null) {
            MimeBodyPart messagePartHTML = new MimeBodyPart();
            messagePartHTML.setContent((Object)email.getHTMLText(), "text/html; charset=\"" + CHARACTER_ENCODING + "\"");
            multipartAlternativeMessages.addBodyPart((BodyPart)messagePartHTML);
        }
        if (email.getCalendarText() != null && email.getCalendarMethod() != null) {
            MimeBodyPart messagePartCalendar = new MimeBodyPart();
            messagePartCalendar.setContent((Object)email.getCalendarText(), "text/calendar; charset=\"" + CHARACTER_ENCODING + "\"; method=\"" + email.getCalendarMethod().toString() + "\"");
            multipartAlternativeMessages.addBodyPart((BodyPart)messagePartCalendar);
        }
    }

    static void setTexts(Email email, MimePart messagePart) throws MessagingException {
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/internal/mimemessage/MimeMessageHelper.setTexts must not be null");
        }
        if (messagePart == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/converter/internal/mimemessage/MimeMessageHelper.setTexts must not be null");
        }
        if (email.getPlainText() != null) {
            messagePart.setText(email.getPlainText(), CHARACTER_ENCODING);
        }
        if (email.getHTMLText() != null) {
            messagePart.setContent((Object)email.getHTMLText(), "text/html; charset=\"" + CHARACTER_ENCODING + "\"");
        }
        if (email.getCalendarText() != null && email.getCalendarMethod() != null) {
            messagePart.setContent((Object)email.getCalendarText(), "text/calendar; charset=\"" + CHARACTER_ENCODING + "\"; method=\"" + email.getCalendarMethod().toString() + "\"");
        }
    }

    static void configureForwarding(@NotNull Email email, @NotNull MimeMultipart multipartRootMixed) throws MessagingException {
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/internal/mimemessage/MimeMessageHelper.configureForwarding must not be null");
        }
        if (multipartRootMixed == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/converter/internal/mimemessage/MimeMessageHelper.configureForwarding must not be null");
        }
        if (email.getEmailToForward() != null) {
            MimeBodyPart fordwardedMessage = new MimeBodyPart();
            fordwardedMessage.setContent((Object)email.getEmailToForward(), "message/rfc822");
            multipartRootMixed.addBodyPart((BodyPart)fordwardedMessage);
        }
    }

    static void setEmbeddedImages(Email email, MimeMultipart multipartRelated) throws MessagingException {
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/internal/mimemessage/MimeMessageHelper.setEmbeddedImages must not be null");
        }
        if (multipartRelated == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/converter/internal/mimemessage/MimeMessageHelper.setEmbeddedImages must not be null");
        }
        for (AttachmentResource embeddedImage : email.getEmbeddedImages()) {
            multipartRelated.addBodyPart(MimeMessageHelper.getBodyPartFromDatasource(embeddedImage, "inline"));
        }
    }

    static void setAttachments(Email email, MimeMultipart multipartRoot) throws MessagingException {
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/internal/mimemessage/MimeMessageHelper.setAttachments must not be null");
        }
        if (multipartRoot == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/converter/internal/mimemessage/MimeMessageHelper.setAttachments must not be null");
        }
        for (AttachmentResource resource : email.getAttachments()) {
            multipartRoot.addBodyPart(MimeMessageHelper.getBodyPartFromDatasource(resource, "attachment"));
        }
    }

    static void setHeaders(Email email, Message message) throws UnsupportedEncodingException, MessagingException {
        InternetAddress address;
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/internal/mimemessage/MimeMessageHelper.setHeaders must not be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/converter/internal/mimemessage/MimeMessageHelper.setHeaders must not be null");
        }
        for (Map.Entry header : email.getHeaders().entrySet()) {
            String headerName = (String)header.getKey();
            String headerValue = MimeUtility.encodeText((String)((String)header.getValue()), (String)CHARACTER_ENCODING, null);
            String foldedHeaderValue = MimeUtility.fold((int)(headerName.length() + 2), (String)headerValue);
            message.addHeader((String)header.getKey(), foldedHeaderValue);
        }
        if (email.isUseDispositionNotificationTo()) {
            Recipient dispositionTo = (Recipient)Preconditions.checkNonEmptyArgument((Object)email.getDispositionNotificationTo(), (String)"dispositionNotificationTo");
            address = new InternetAddress(dispositionTo.getAddress(), dispositionTo.getName(), CHARACTER_ENCODING);
            message.setHeader("Disposition-Notification-To", address.toString());
        }
        if (email.isUseReturnReceiptTo()) {
            Recipient returnReceiptTo = (Recipient)Preconditions.checkNonEmptyArgument((Object)email.getReturnReceiptTo(), (String)"returnReceiptTo");
            address = new InternetAddress(returnReceiptTo.getAddress(), returnReceiptTo.getName(), CHARACTER_ENCODING);
            message.setHeader("Return-Receipt-To", address.toString());
        }
    }

    private static BodyPart getBodyPartFromDatasource(AttachmentResource attachmentResource, String dispositionType) throws MessagingException {
        if (attachmentResource == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/internal/mimemessage/MimeMessageHelper.getBodyPartFromDatasource must not be null");
        }
        if (dispositionType == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/converter/internal/mimemessage/MimeMessageHelper.getBodyPartFromDatasource must not be null");
        }
        MimeBodyPart attachmentPart = new MimeBodyPart();
        String resourceName = MimeMessageHelper.determineResourceName(attachmentResource, false);
        String fileName = MimeMessageHelper.determineResourceName(attachmentResource, true);
        attachmentPart.setDataHandler(new DataHandler((DataSource)new NamedDataSource(fileName, attachmentResource.getDataSource())));
        attachmentPart.setFileName(fileName);
        String contentType = attachmentResource.getDataSource().getContentType();
        ParameterList pl = new ParameterList();
        pl.set("filename", fileName);
        pl.set("name", resourceName);
        attachmentPart.setHeader("Content-Type", contentType + pl.toString());
        attachmentPart.setHeader("Content-ID", String.format("<%s>", resourceName));
        attachmentPart.setDisposition(dispositionType);
        MimeBodyPart mimeBodyPart = attachmentPart;
        if (mimeBodyPart == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/internal/mimemessage/MimeMessageHelper.getBodyPartFromDatasource must not return null");
        }
        return mimeBodyPart;
    }

    static String determineResourceName(AttachmentResource attachmentResource, boolean includeExtension) {
        if (attachmentResource == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/internal/mimemessage/MimeMessageHelper.determineResourceName must not be null");
        }
        String datasourceName = attachmentResource.getDataSource().getName();
        String resourceName = !MiscUtil.valueNullOrEmpty((Object)attachmentResource.getName()) ? attachmentResource.getName() : (!MiscUtil.valueNullOrEmpty((Object)datasourceName) ? datasourceName : "resource" + UUID.randomUUID());
        if (includeExtension && !MiscUtil.valueNullOrEmpty((Object)datasourceName)) {
            String extension;
            String possibleFilename = datasourceName;
            if (!resourceName.contains(".") && possibleFilename.contains(".") && !resourceName.endsWith(extension = possibleFilename.substring(possibleFilename.lastIndexOf(".")))) {
                resourceName = resourceName + extension;
            }
        } else if (!includeExtension && resourceName.contains(".") && resourceName.equals(datasourceName)) {
            String extension = resourceName.substring(resourceName.lastIndexOf("."));
            resourceName = resourceName.replace(extension, "");
        }
        String string = MiscUtil.encodeText((String)resourceName);
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/internal/mimemessage/MimeMessageHelper.determineResourceName must not return null");
        }
        return string;
    }
}

