/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.email.internal;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataSource;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.util.ByteArrayDataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.AttachmentResource;
import org.simplejavamail.api.email.CalendarMethod;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.EmailPopulatingBuilder;
import org.simplejavamail.api.email.OriginalSmimeDetails;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.api.internal.clisupport.model.Cli;
import org.simplejavamail.api.internal.smimesupport.model.PlainSmimeDetails;
import org.simplejavamail.api.mailer.config.Pkcs12Config;
import org.simplejavamail.config.ConfigLoader;
import org.simplejavamail.email.internal.EmailException;
import org.simplejavamail.email.internal.InternalEmailPopulatingBuilder;
import org.simplejavamail.internal.smimesupport.SmimeRecognitionUtil;
import org.simplejavamail.internal.util.CertificationUtil;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;

public class EmailPopulatingBuilderImpl
implements InternalEmailPopulatingBuilder {
    private String id;
    private Recipient fromRecipient;
    private Recipient replyToRecipient;
    private Recipient bounceToRecipient;
    private String subject;
    private String text;
    private String textHTML;
    private CalendarMethod calendarMethod;
    private String textCalendar;
    @NotNull
    private final Set<Recipient> recipients = new HashSet<Recipient>();
    @NotNull
    private final List<AttachmentResource> embeddedImages = new ArrayList<AttachmentResource>();
    @NotNull
    private final List<AttachmentResource> attachments = new ArrayList<AttachmentResource>();
    @NotNull
    private final List<AttachmentResource> decryptedAttachments = new ArrayList<AttachmentResource>();
    @NotNull
    private final Map<String, String> headers = new HashMap<String, String>();
    private File dkimPrivateKeyFile;
    private InputStream dkimPrivateKeyInputStream;
    private String dkimSigningDomain;
    private String dkimSelector;
    private Pkcs12Config pkcs12ConfigForSmimeSigning;
    private X509Certificate x509CertificateForSmimeEncryption;
    private boolean useDispositionNotificationTo;
    private Recipient dispositionNotificationTo;
    private boolean useReturnReceiptTo;
    private Recipient returnReceiptTo;
    private MimeMessage emailToForward;
    @NotNull
    private OriginalSmimeDetails originalSmimeDetails = new PlainSmimeDetails();
    private Email smimeSignedEmail;
    private boolean mergeSingleSMIMESignedAttachment = true;
    @Nullable
    private Date sentDate;

    EmailPopulatingBuilderImpl(boolean applyDefaults) {
        if (applyDefaults) {
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_FROM_ADDRESS)) {
                this.from(ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_FROM_NAME), (String)Preconditions.assumeNonNull((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_FROM_ADDRESS)));
            }
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_REPLYTO_ADDRESS)) {
                this.withReplyTo(ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_REPLYTO_NAME), (String)Preconditions.assumeNonNull((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_REPLYTO_ADDRESS)));
            }
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_BOUNCETO_ADDRESS)) {
                this.withBounceTo(ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_BOUNCETO_NAME), (String)Preconditions.assumeNonNull((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_BOUNCETO_ADDRESS)));
            }
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_TO_ADDRESS)) {
                if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_TO_NAME)) {
                    this.to(ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_TO_NAME), ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_TO_ADDRESS));
                } else {
                    this.to((String)Preconditions.assumeNonNull((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_TO_ADDRESS)));
                }
            }
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CC_ADDRESS)) {
                if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CC_NAME)) {
                    this.cc(ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CC_NAME), ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CC_ADDRESS));
                } else {
                    this.cc((String)Preconditions.assumeNonNull((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CC_ADDRESS)));
                }
            }
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_BCC_ADDRESS)) {
                if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_BCC_NAME)) {
                    this.bcc(ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_BCC_NAME), ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_BCC_ADDRESS));
                } else {
                    this.bcc((String)Preconditions.assumeNonNull((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_BCC_ADDRESS)));
                }
            }
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_SUBJECT)) {
                this.withSubject((String)ConfigLoader.getProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_SUBJECT));
            }
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.SMIME_SIGNING_KEYSTORE)) {
                this.signWithSmime(Pkcs12Config.builder().pkcs12Store((String)Preconditions.assumeNonNull((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.SMIME_SIGNING_KEYSTORE))).storePassword((String)Preconditions.checkNonEmptyArgument((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.SMIME_SIGNING_KEYSTORE_PASSWORD), (String)"Keystore password property")).keyAlias((String)Preconditions.checkNonEmptyArgument((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.SMIME_SIGNING_KEY_ALIAS), (String)"Key alias property")).keyPassword((String)Preconditions.checkNonEmptyArgument((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.SMIME_SIGNING_KEY_PASSWORD), (String)"Key password property")).build());
            }
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.SMIME_ENCRYPTION_CERTIFICATE)) {
                this.encryptWithSmime((String)Preconditions.assumeNonNull((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.SMIME_ENCRYPTION_CERTIFICATE)));
            }
        }
    }

    @Cli.ExcludeApi(reason="This API is specifically for Java use")
    public Email buildEmail() {
        this.validateDkim();
        Email email = new Email((EmailPopulatingBuilder)this);
        if (email == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.buildEmail must not return null");
        }
        return email;
    }

    private void validateDkim() {
        if (this.getDkimPrivateKeyFile() != null || this.getDkimPrivateKeyInputStream() != null) {
            Preconditions.checkNonEmptyArgument((Object)this.getDkimSelector(), (String)"dkimSelector");
            Preconditions.checkNonEmptyArgument((Object)this.getDkimSigningDomain(), (String)"dkimSigningDomain");
            Preconditions.checkNonEmptyArgument((Object)this.getFromRecipient(), (String)"fromRecipient required when signing DKIM");
        }
    }

    public EmailPopulatingBuilder fixingMessageId(@Nullable String id) {
        this.id = id;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.fixingMessageId must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    @Cli.ExcludeApi(reason="API is subset of another API")
    public EmailPopulatingBuilder from(@NotNull String fromAddress) {
        if (fromAddress == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.from must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.from(null, fromAddress);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.from must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder from(@Nullable String name, @NotNull String fromAddress) {
        if (fromAddress == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.from must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.from(new Recipient(name, (String)Preconditions.checkNonEmptyArgument((Object)fromAddress, (String)"fromAddress"), null));
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.from must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder from(@Nullable String fixedName, @NotNull InternetAddress fromAddress) {
        if (fromAddress == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.from must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)fromAddress, (String)"fromAddress");
        EmailPopulatingBuilder emailPopulatingBuilder = this.from(new Recipient(fixedName, fromAddress.getAddress(), null));
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.from must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder from(@NotNull InternetAddress fromAddress) {
        if (fromAddress == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.from must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)fromAddress, (String)"fromAddress");
        EmailPopulatingBuilder emailPopulatingBuilder = this.from(new Recipient(fromAddress.getPersonal(), fromAddress.getAddress(), null));
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.from must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder from(@NotNull Recipient recipient) {
        if (recipient == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.from must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)recipient, (String)"from recipient");
        this.fromRecipient = new Recipient(recipient.getName(), recipient.getAddress(), null);
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.from must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    @Cli.ExcludeApi(reason="API is subset of another API")
    public EmailPopulatingBuilder withReplyTo(@Nullable String replyToAddress) {
        EmailPopulatingBuilder emailPopulatingBuilder = this.withReplyTo(replyToAddress != null ? new Recipient(null, replyToAddress, null) : null);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withReplyTo must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder withReplyTo(@Nullable String fixedName, @NotNull String replyToAddress) {
        if (replyToAddress == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withReplyTo must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)replyToAddress, (String)"replyToAddress");
        EmailPopulatingBuilder emailPopulatingBuilder = this.withReplyTo(new Recipient(fixedName, replyToAddress, null));
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withReplyTo must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder withReplyTo(@NotNull InternetAddress replyToAddress) {
        if (replyToAddress == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withReplyTo must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)replyToAddress, (String)"replyToAddress");
        EmailPopulatingBuilder emailPopulatingBuilder = this.withReplyTo(new Recipient(replyToAddress.getPersonal(), replyToAddress.getAddress(), null));
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withReplyTo must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder withReplyTo(@Nullable String fixedName, @NotNull InternetAddress replyToAddress) {
        if (replyToAddress == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withReplyTo must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)replyToAddress, (String)"replyToAddress");
        EmailPopulatingBuilder emailPopulatingBuilder = this.withReplyTo(new Recipient(fixedName, replyToAddress.getAddress(), null));
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withReplyTo must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder withReplyTo(@Nullable Recipient recipient) {
        this.replyToRecipient = recipient != null ? new Recipient(recipient.getName(), recipient.getAddress(), null) : null;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withReplyTo must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    @Cli.ExcludeApi(reason="API is subset of another API")
    public EmailPopulatingBuilder withBounceTo(@Nullable String bounceToAddress) {
        EmailPopulatingBuilder emailPopulatingBuilder = this.withBounceTo(bounceToAddress != null ? new Recipient(null, bounceToAddress, null) : null);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withBounceTo must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder withBounceTo(@Nullable String name, @NotNull String bounceToAddress) {
        if (bounceToAddress == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withBounceTo must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withBounceTo(new Recipient(name, (String)Preconditions.checkNonEmptyArgument((Object)bounceToAddress, (String)"bounceToAddress"), null));
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withBounceTo must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder withBounceTo(@NotNull InternetAddress bounceToAddress) {
        if (bounceToAddress == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withBounceTo must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)bounceToAddress, (String)"bounceToAddress");
        EmailPopulatingBuilder emailPopulatingBuilder = this.withBounceTo(new Recipient(bounceToAddress.getPersonal(), bounceToAddress.getAddress(), null));
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withBounceTo must not return null");
        }
        return emailPopulatingBuilder;
    }

    @Cli.ExcludeApi(reason="Method is not detailed enough for CLI")
    public EmailPopulatingBuilder withBounceTo(@Nullable String name, @NotNull InternetAddress bounceToAddress) {
        if (bounceToAddress == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withBounceTo must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)bounceToAddress, (String)"bounceToAddress");
        EmailPopulatingBuilder emailPopulatingBuilder = this.withBounceTo(new Recipient(name, bounceToAddress.getAddress(), null));
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withBounceTo must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder withBounceTo(@Nullable Recipient recipient) {
        this.bounceToRecipient = recipient != null ? new Recipient(recipient.getName(), recipient.getAddress(), null) : null;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withBounceTo must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder withSubject(@Nullable String subject) {
        this.subject = subject;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withSubject must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    @Override
    @NotNull
    public InternalEmailPopulatingBuilder withForward(@Nullable MimeMessage emailMessageToForward) {
        this.emailToForward = emailMessageToForward;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withForward must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    @Cli.OptionNameOverride(value="withPlainTextFromFile")
    public EmailPopulatingBuilder withPlainText(@NotNull File textFile) {
        EmailPopulatingBuilder emailPopulatingBuilder;
        if (textFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withPlainText must not be null");
        }
        try {
            emailPopulatingBuilder = this.withPlainText(MiscUtil.readFileContent((File)textFile));
        }
        catch (IOException e) {
            throw new EmailException(String.format("Error reading from file: %s", textFile), e);
        }
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withPlainText must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder withPlainText(@Nullable String text) {
        this.text = text;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withPlainText must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    @Cli.OptionNameOverride(value="prependTextFromFile")
    public EmailPopulatingBuilder prependText(@NotNull File textFile) {
        EmailPopulatingBuilder emailPopulatingBuilder;
        if (textFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.prependText must not be null");
        }
        try {
            emailPopulatingBuilder = this.prependText(MiscUtil.readFileContent((File)textFile));
        }
        catch (IOException e) {
            throw new EmailException(String.format("Error reading from file: %s", textFile), e);
        }
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.prependText must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder prependText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.prependText must not be null");
        }
        this.text = text + (String)MiscUtil.defaultTo((Object)this.text, (Object)"");
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.prependText must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    @Cli.OptionNameOverride(value="appendTextFromFile")
    public EmailPopulatingBuilder appendText(@NotNull File textFile) {
        EmailPopulatingBuilder emailPopulatingBuilder;
        if (textFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.appendText must not be null");
        }
        try {
            emailPopulatingBuilder = this.appendText(MiscUtil.readFileContent((File)textFile));
        }
        catch (IOException e) {
            throw new EmailException(String.format("Error reading from file: %s", textFile), e);
        }
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.appendText must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder appendText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.appendText must not be null");
        }
        this.text = (String)MiscUtil.defaultTo((Object)this.text, (Object)"") + text;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.appendText must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    @Cli.OptionNameOverride(value="withHTMLTextFromFile")
    public EmailPopulatingBuilder withHTMLText(@NotNull File textHTMLFile) {
        EmailPopulatingBuilder emailPopulatingBuilder;
        if (textHTMLFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withHTMLText must not be null");
        }
        try {
            emailPopulatingBuilder = this.withHTMLText(MiscUtil.readFileContent((File)textHTMLFile));
        }
        catch (IOException e) {
            throw new EmailException(String.format("Error reading from file: %s", textHTMLFile), e);
        }
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withHTMLText must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder withHTMLText(@Nullable String textHTML) {
        this.textHTML = textHTML;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withHTMLText must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    @Cli.OptionNameOverride(value="prependTextHTMLFromFile")
    public EmailPopulatingBuilder prependTextHTML(@NotNull File textHTMLFile) {
        EmailPopulatingBuilder emailPopulatingBuilder;
        if (textHTMLFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.prependTextHTML must not be null");
        }
        try {
            emailPopulatingBuilder = this.prependTextHTML(MiscUtil.readFileContent((File)textHTMLFile));
        }
        catch (IOException e) {
            throw new EmailException(String.format("Error reading from file: %s", textHTMLFile), e);
        }
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.prependTextHTML must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder prependTextHTML(@NotNull String textHTML) {
        if (textHTML == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.prependTextHTML must not be null");
        }
        this.textHTML = textHTML + (String)MiscUtil.defaultTo((Object)this.textHTML, (Object)"");
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.prependTextHTML must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    @Cli.OptionNameOverride(value="appendTextHTMLFromFile")
    public EmailPopulatingBuilder appendTextHTML(@NotNull File textHTMLFile) {
        EmailPopulatingBuilder emailPopulatingBuilder;
        if (textHTMLFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.appendTextHTML must not be null");
        }
        try {
            emailPopulatingBuilder = this.appendTextHTML(MiscUtil.readFileContent((File)textHTMLFile));
        }
        catch (IOException e) {
            throw new EmailException(String.format("Error reading from file: %s", textHTMLFile), e);
        }
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.appendTextHTML must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder appendTextHTML(@NotNull String textHTML) {
        if (textHTML == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.appendTextHTML must not be null");
        }
        this.textHTML = (String)MiscUtil.defaultTo((Object)this.textHTML, (Object)"") + textHTML;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.appendTextHTML must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder withCalendarText(@NotNull CalendarMethod calendarMethod, @NotNull String textCalendar) {
        if (calendarMethod == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withCalendarText must not be null");
        }
        if (textCalendar == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withCalendarText must not be null");
        }
        this.calendarMethod = calendarMethod;
        this.textCalendar = textCalendar;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withCalendarText must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder to(Recipient ... recipients) {
        if (recipients == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.to must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipients(Arrays.asList(recipients), Message.RecipientType.TO);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.to must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder to(@NotNull Collection<Recipient> recipients) {
        if (recipients == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.to must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipients(recipients, Message.RecipientType.TO);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.to must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder to(@Nullable String name, String oneOrMoreAddresses) {
        if (oneOrMoreAddresses == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.to must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipients(name, true, Collections.singletonList(oneOrMoreAddresses), Message.RecipientType.TO);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.to must not return null");
        }
        return emailPopulatingBuilder;
    }

    @Cli.ExcludeApi(reason="API is subset of another API method")
    public EmailPopulatingBuilder to(@NotNull String oneOrMoreAddresses) {
        if (oneOrMoreAddresses == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.to must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipientsWithDefaultName(null, Collections.singletonList(oneOrMoreAddresses), Message.RecipientType.TO);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.to must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder to(@Nullable String name, String ... oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.to must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.toWithFixedName(name, oneOrMoreAddressesEach);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.to must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder to(@Nullable String name, @NotNull Collection<String> oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.to must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.toWithFixedName(name, oneOrMoreAddressesEach);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.to must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder toMultiple(String ... oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toMultiple must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipientsWithDefaultName(null, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.TO);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toMultiple must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder toMultiple(@NotNull Collection<String> oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toMultiple must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipientsWithDefaultName(null, oneOrMoreAddressesEach, Message.RecipientType.TO);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toMultiple must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder toWithFixedName(@Nullable String name, String ... oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toWithFixedName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipientsWithFixedName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.TO);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toWithFixedName must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder toWithDefaultName(@NotNull String name, String ... oneOrMoreAddressesEach) {
        if (name == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toWithDefaultName must not be null");
        }
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toWithDefaultName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipientsWithDefaultName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.TO);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toWithDefaultName must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder toWithFixedName(@Nullable String name, @NotNull Collection<String> oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toWithFixedName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipientsWithFixedName(name, oneOrMoreAddressesEach, Message.RecipientType.TO);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toWithFixedName must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder toWithDefaultName(@NotNull String name, @NotNull Collection<String> oneOrMoreAddressesEach) {
        if (name == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toWithDefaultName must not be null");
        }
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toWithDefaultName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipientsWithDefaultName(name, oneOrMoreAddressesEach, Message.RecipientType.TO);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toWithDefaultName must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder to(@Nullable String name, InternetAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.to must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.toAddressesWithFixedName(name, address);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.to must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder to(@NotNull InternetAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.to must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withAddressesWithDefaultName(null, Collections.singletonList(address), Message.RecipientType.TO);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.to must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder to(@Nullable String name, InternetAddress ... oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.to must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.toAddressesWithFixedName(name, oneOrMoreAddressesEach);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.to must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder toAddresses(@Nullable String name, @NotNull Collection<InternetAddress> oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toAddresses must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.toAddressesWithFixedName(name, oneOrMoreAddressesEach);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toAddresses must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder toMultiple(InternetAddress ... oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toMultiple must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withAddressesWithDefaultName(null, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.TO);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toMultiple must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder toMultipleAddresses(@NotNull Collection<InternetAddress> oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toMultipleAddresses must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withAddressesWithDefaultName(null, oneOrMoreAddressesEach, Message.RecipientType.TO);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toMultipleAddresses must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder toAddressesWithFixedName(@Nullable String name, InternetAddress ... oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toAddressesWithFixedName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withAddressesWithFixedName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.TO);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toAddressesWithFixedName must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder toAddressesWithDefaultName(@NotNull String name, InternetAddress ... oneOrMoreAddressesEach) {
        if (name == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toAddressesWithDefaultName must not be null");
        }
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toAddressesWithDefaultName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withAddressesWithDefaultName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.TO);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toAddressesWithDefaultName must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder toAddressesWithFixedName(@Nullable String name, @NotNull Collection<InternetAddress> oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toAddressesWithFixedName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withAddressesWithFixedName(name, oneOrMoreAddressesEach, Message.RecipientType.TO);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toAddressesWithFixedName must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder toAddressesWithDefaultName(@NotNull String name, @NotNull Collection<InternetAddress> oneOrMoreAddressesEach) {
        if (name == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toAddressesWithDefaultName must not be null");
        }
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toAddressesWithDefaultName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withAddressesWithDefaultName(name, oneOrMoreAddressesEach, Message.RecipientType.TO);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.toAddressesWithDefaultName must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder cc(Recipient ... recipients) {
        if (recipients == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.cc must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipients(Arrays.asList(recipients), Message.RecipientType.CC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.cc must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder cc(@NotNull Collection<Recipient> recipients) {
        if (recipients == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.cc must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipients(recipients, Message.RecipientType.CC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.cc must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder cc(@Nullable String name, String oneOrMoreAddresses) {
        if (oneOrMoreAddresses == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.cc must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipients(name, true, Collections.singletonList(oneOrMoreAddresses), Message.RecipientType.CC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.cc must not return null");
        }
        return emailPopulatingBuilder;
    }

    @Cli.ExcludeApi(reason="API is subset of another API method")
    public EmailPopulatingBuilder cc(@NotNull String oneOrMoreAddresses) {
        if (oneOrMoreAddresses == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.cc must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipientsWithDefaultName(null, Collections.singletonList(oneOrMoreAddresses), Message.RecipientType.CC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.cc must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder cc(@Nullable String name, String ... oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.cc must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.ccWithFixedName(name, oneOrMoreAddressesEach);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.cc must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder cc(@Nullable String name, @NotNull Collection<String> oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.cc must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.ccWithFixedName(name, oneOrMoreAddressesEach);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.cc must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder ccMultiple(String ... oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccMultiple must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipientsWithDefaultName(null, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.CC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccMultiple must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder ccAddresses(@NotNull Collection<String> oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccAddresses must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipientsWithDefaultName(null, oneOrMoreAddressesEach, Message.RecipientType.CC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccAddresses must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder ccWithFixedName(@Nullable String name, String ... oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccWithFixedName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipientsWithFixedName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.CC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccWithFixedName must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder ccWithDefaultName(@NotNull String name, String ... oneOrMoreAddressesEach) {
        if (name == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccWithDefaultName must not be null");
        }
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccWithDefaultName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipientsWithDefaultName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.CC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccWithDefaultName must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder ccWithFixedName(@Nullable String name, @NotNull Collection<String> oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccWithFixedName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipientsWithFixedName(name, oneOrMoreAddressesEach, Message.RecipientType.CC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccWithFixedName must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder ccWithDefaultName(@NotNull String name, @NotNull Collection<String> oneOrMoreAddressesEach) {
        if (name == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccWithDefaultName must not be null");
        }
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccWithDefaultName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipientsWithDefaultName(name, oneOrMoreAddressesEach, Message.RecipientType.CC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccWithDefaultName must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder cc(@Nullable String name, InternetAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.cc must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.ccAddressesWithFixedName(name, address);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.cc must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder cc(@NotNull InternetAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.cc must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withAddressesWithDefaultName(null, Collections.singletonList(address), Message.RecipientType.CC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.cc must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder cc(@Nullable String name, InternetAddress ... oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.cc must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.ccAddressesWithFixedName(name, oneOrMoreAddressesEach);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.cc must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder ccAddresses(@Nullable String name, @NotNull Collection<InternetAddress> oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccAddresses must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.ccAddressesWithFixedName(name, oneOrMoreAddressesEach);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccAddresses must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder ccMultiple(InternetAddress ... oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccMultiple must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withAddressesWithDefaultName(null, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.CC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccMultiple must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder ccMultipleAddresses(@NotNull Collection<InternetAddress> oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccMultipleAddresses must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withAddressesWithDefaultName(null, oneOrMoreAddressesEach, Message.RecipientType.CC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccMultipleAddresses must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder ccAddressesWithFixedName(@Nullable String name, InternetAddress ... oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccAddressesWithFixedName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withAddressesWithFixedName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.CC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccAddressesWithFixedName must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder ccAddressesWithDefaultName(@NotNull String name, InternetAddress ... oneOrMoreAddressesEach) {
        if (name == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccAddressesWithDefaultName must not be null");
        }
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccAddressesWithDefaultName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withAddressesWithDefaultName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.CC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccAddressesWithDefaultName must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder ccAddressesWithFixedName(@Nullable String name, @NotNull Collection<InternetAddress> oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccAddressesWithFixedName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withAddressesWithFixedName(name, oneOrMoreAddressesEach, Message.RecipientType.CC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccAddressesWithFixedName must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder ccAddressesWithDefaultName(@NotNull String name, @NotNull Collection<InternetAddress> oneOrMoreAddressesEach) {
        if (name == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccAddressesWithDefaultName must not be null");
        }
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccAddressesWithDefaultName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withAddressesWithDefaultName(name, oneOrMoreAddressesEach, Message.RecipientType.CC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.ccAddressesWithDefaultName must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder bcc(Recipient ... recipients) {
        if (recipients == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bcc must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipients(Arrays.asList(recipients), Message.RecipientType.BCC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bcc must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder bcc(@NotNull Collection<Recipient> recipients) {
        if (recipients == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bcc must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipients(recipients, Message.RecipientType.BCC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bcc must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder bcc(@Nullable String name, String oneOrMoreAddresses) {
        if (oneOrMoreAddresses == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bcc must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipients(name, true, Collections.singletonList(oneOrMoreAddresses), Message.RecipientType.BCC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bcc must not return null");
        }
        return emailPopulatingBuilder;
    }

    @Cli.ExcludeApi(reason="API is subset of another API")
    public EmailPopulatingBuilder bcc(@NotNull String oneOrMoreAddresses) {
        if (oneOrMoreAddresses == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bcc must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipientsWithDefaultName(null, Collections.singletonList(oneOrMoreAddresses), Message.RecipientType.BCC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bcc must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder bcc(@Nullable String name, String ... oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bcc must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.bccWithFixedName(name, oneOrMoreAddressesEach);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bcc must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder bcc(@Nullable String name, @NotNull Collection<String> oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bcc must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.bccWithFixedName(name, oneOrMoreAddressesEach);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bcc must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder bccMultiple(String ... oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccMultiple must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipientsWithDefaultName(null, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.BCC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccMultiple must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder bccAddresses(@NotNull Collection<String> oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccAddresses must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipientsWithDefaultName(null, oneOrMoreAddressesEach, Message.RecipientType.BCC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccAddresses must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder bccWithFixedName(@Nullable String name, String ... oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccWithFixedName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipientsWithFixedName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.BCC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccWithFixedName must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder bccWithDefaultName(@NotNull String name, String ... oneOrMoreAddressesEach) {
        if (name == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccWithDefaultName must not be null");
        }
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccWithDefaultName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipientsWithDefaultName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.BCC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccWithDefaultName must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder bccWithFixedName(@Nullable String name, @NotNull Collection<String> oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccWithFixedName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipientsWithFixedName(name, oneOrMoreAddressesEach, Message.RecipientType.BCC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccWithFixedName must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder bccWithDefaultName(@NotNull String name, @NotNull Collection<String> oneOrMoreAddressesEach) {
        if (name == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccWithDefaultName must not be null");
        }
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccWithDefaultName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipientsWithDefaultName(name, oneOrMoreAddressesEach, Message.RecipientType.BCC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccWithDefaultName must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder bcc(@Nullable String name, InternetAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bcc must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.bccAddressesWithFixedName(name, address);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bcc must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder bcc(@NotNull InternetAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bcc must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withAddressesWithDefaultName(null, Collections.singletonList(address), Message.RecipientType.BCC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bcc must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder bcc(@Nullable String name, InternetAddress ... oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bcc must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.bccAddressesWithFixedName(name, oneOrMoreAddressesEach);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bcc must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder bccAddresses(@Nullable String name, @NotNull Collection<InternetAddress> oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccAddresses must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.bccAddressesWithFixedName(name, oneOrMoreAddressesEach);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccAddresses must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder bccMultiple(InternetAddress ... oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccMultiple must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withAddressesWithDefaultName(null, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.BCC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccMultiple must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder bccMultipleAddresses(@NotNull Collection<InternetAddress> oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccMultipleAddresses must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withAddressesWithDefaultName(null, oneOrMoreAddressesEach, Message.RecipientType.BCC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccMultipleAddresses must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder bccAddressesWithFixedName(@Nullable String name, InternetAddress ... oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccAddressesWithFixedName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withAddressesWithFixedName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.BCC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccAddressesWithFixedName must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder bccAddressesWithDefaultName(@NotNull String name, InternetAddress ... oneOrMoreAddressesEach) {
        if (name == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccAddressesWithDefaultName must not be null");
        }
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccAddressesWithDefaultName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withAddressesWithDefaultName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.BCC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccAddressesWithDefaultName must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder bccAddressesWithFixedName(@Nullable String name, @NotNull Collection<InternetAddress> oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccAddressesWithFixedName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withAddressesWithFixedName(name, oneOrMoreAddressesEach, Message.RecipientType.BCC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccAddressesWithFixedName must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder bccAddressesWithDefaultName(@NotNull String name, @NotNull Collection<InternetAddress> oneOrMoreAddressesEach) {
        if (name == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccAddressesWithDefaultName must not be null");
        }
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccAddressesWithDefaultName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withAddressesWithDefaultName(name, oneOrMoreAddressesEach, Message.RecipientType.BCC);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.bccAddressesWithDefaultName must not return null");
        }
        return emailPopulatingBuilder;
    }

    @NotNull
    public EmailPopulatingBuilder withRecipientsWithDefaultName(@Nullable String defaultName, @NotNull Collection<String> oneOrMoreAddressesEach, @Nullable Message.RecipientType recipientType) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withRecipientsWithDefaultName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipients(defaultName, false, oneOrMoreAddressesEach, recipientType);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withRecipientsWithDefaultName must not return null");
        }
        return emailPopulatingBuilder;
    }

    @NotNull
    public EmailPopulatingBuilder withRecipientsWithFixedName(@Nullable String fixedName, @NotNull Collection<String> oneOrMoreAddressesEach, @Nullable Message.RecipientType recipientType) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withRecipientsWithFixedName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipients(fixedName, true, oneOrMoreAddressesEach, recipientType);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withRecipientsWithFixedName must not return null");
        }
        return emailPopulatingBuilder;
    }

    @NotNull
    public EmailPopulatingBuilder withRecipientsWithDefaultName(@Nullable String name, @Nullable Message.RecipientType recipientType, String ... oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withRecipientsWithDefaultName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipients(name, false, Arrays.asList(oneOrMoreAddressesEach), recipientType);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withRecipientsWithDefaultName must not return null");
        }
        return emailPopulatingBuilder;
    }

    @NotNull
    public EmailPopulatingBuilder withRecipientsWithFixedName(@Nullable String name, @Nullable Message.RecipientType recipientType, String ... oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withRecipientsWithFixedName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipients(name, true, Arrays.asList(oneOrMoreAddressesEach), recipientType);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withRecipientsWithFixedName must not return null");
        }
        return emailPopulatingBuilder;
    }

    @NotNull
    public EmailPopulatingBuilder withRecipients(@Nullable String name, boolean fixedName, @Nullable Message.RecipientType recipientType, String ... oneOrMoreAddressesEach) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withRecipients must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipients(name, fixedName, Arrays.asList(oneOrMoreAddressesEach), recipientType);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withRecipients must not return null");
        }
        return emailPopulatingBuilder;
    }

    @NotNull
    public EmailPopulatingBuilder withRecipients(@Nullable String name, boolean fixedName, @NotNull Collection<String> oneOrMoreAddressesEach, @Nullable Message.RecipientType recipientType) {
        if (oneOrMoreAddressesEach == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withRecipients must not be null");
        }
        for (String oneOrMoreAddresses : oneOrMoreAddressesEach) {
            for (String emailAddress : MiscUtil.extractEmailAddresses((String)oneOrMoreAddresses)) {
                this.withRecipient(MiscUtil.interpretRecipient((String)name, (boolean)fixedName, (String)emailAddress, (Message.RecipientType)recipientType));
            }
        }
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withRecipients must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    @NotNull
    public EmailPopulatingBuilder withAddressesWithDefaultName(@Nullable String defaultName, @NotNull Collection<InternetAddress> addresses, @Nullable Message.RecipientType recipientType) {
        if (addresses == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withAddressesWithDefaultName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withAddresses(defaultName, false, addresses, recipientType);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withAddressesWithDefaultName must not return null");
        }
        return emailPopulatingBuilder;
    }

    @NotNull
    public EmailPopulatingBuilder withAddressesWithFixedName(@Nullable String fixedName, @NotNull Collection<InternetAddress> addresses, @Nullable Message.RecipientType recipientType) {
        if (addresses == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withAddressesWithFixedName must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withAddresses(fixedName, true, addresses, recipientType);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withAddressesWithFixedName must not return null");
        }
        return emailPopulatingBuilder;
    }

    @NotNull
    public EmailPopulatingBuilder withAddresses(@Nullable String name, boolean fixedName, @NotNull Collection<InternetAddress> addresses, @Nullable Message.RecipientType recipientType) {
        if (addresses == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withAddresses must not be null");
        }
        for (InternetAddress address : addresses) {
            String effectiveName = fixedName || MiscUtil.valueNullOrEmpty((Object)address.getPersonal()) ? name : address.getPersonal();
            this.withRecipient(effectiveName, address.getAddress(), recipientType);
        }
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withAddresses must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder withRecipients(@NotNull Collection<Recipient> recipients) {
        if (recipients == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withRecipients must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipients(recipients, null);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withRecipients must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder withRecipients(Recipient ... recipients) {
        if (recipients == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withRecipients must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipients(Arrays.asList(recipients), null);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withRecipients must not return null");
        }
        return emailPopulatingBuilder;
    }

    @NotNull
    public EmailPopulatingBuilder withRecipients(@NotNull Collection<Recipient> recipients, @Nullable Message.RecipientType fixedRecipientType) {
        if (recipients == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withRecipients must not be null");
        }
        for (Recipient recipient : recipients) {
            this.withRecipient(recipient.getName(), recipient.getAddress(), (Message.RecipientType)MiscUtil.defaultTo((Object)fixedRecipientType, (Object)recipient.getType()));
        }
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withRecipients must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder withRecipient(@NotNull String singleAddress, @Nullable Message.RecipientType recipientType) {
        if (singleAddress == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withRecipient must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.withRecipient(null, singleAddress, recipientType);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withRecipient must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder withRecipient(@Nullable String name, @NotNull String singleAddress, @Nullable Message.RecipientType recipientType) {
        if (singleAddress == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withRecipient must not be null");
        }
        this.recipients.add(MiscUtil.interpretRecipient((String)name, (boolean)true, (String)singleAddress, (Message.RecipientType)recipientType));
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withRecipient must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder withRecipient(@NotNull Recipient recipient) {
        if (recipient == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withRecipient must not be null");
        }
        this.recipients.add(new Recipient(recipient.getName(), recipient.getAddress(), recipient.getType()));
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withRecipient must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder withEmbeddedImage(@NotNull String name, @NotNull byte[] data, @NotNull String mimetype) {
        if (name == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withEmbeddedImage must not be null");
        }
        if (data == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withEmbeddedImage must not be null");
        }
        if (mimetype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withEmbeddedImage must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)name, (String)"name");
        Preconditions.checkNonEmptyArgument((Object)data, (String)"data");
        Preconditions.checkNonEmptyArgument((Object)mimetype, (String)"mimetype");
        ByteArrayDataSource dataSource = new ByteArrayDataSource(data, mimetype);
        dataSource.setName(name);
        EmailPopulatingBuilder emailPopulatingBuilder = this.withEmbeddedImage(name, (DataSource)dataSource);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withEmbeddedImage must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder withEmbeddedImage(@Nullable String name, @NotNull DataSource imagedata) {
        if (imagedata == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withEmbeddedImage must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)imagedata, (String)"imagedata");
        if (MiscUtil.valueNullOrEmpty((Object)name) && MiscUtil.valueNullOrEmpty((Object)imagedata.getName())) {
            throw new EmailException("No name given for embedded image nor passed inside the data source");
        }
        this.embeddedImages.add(new AttachmentResource(name, imagedata));
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withEmbeddedImage must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder withEmbeddedImages(@NotNull List<AttachmentResource> embeddedImages) {
        if (embeddedImages == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withEmbeddedImages must not be null");
        }
        for (AttachmentResource embeddedImage : embeddedImages) {
            this.withEmbeddedImage(embeddedImage.getName(), embeddedImage.getDataSource());
        }
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withEmbeddedImages must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public <T> EmailPopulatingBuilder withHeaders(@NotNull Map<String, T> headers) {
        if (headers == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withHeaders must not be null");
        }
        InternalEmailPopulatingBuilder internalEmailPopulatingBuilder = this.withHeaders(headers, false);
        if (internalEmailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withHeaders must not return null");
        }
        return internalEmailPopulatingBuilder;
    }

    @Override
    @NotNull
    public <T> InternalEmailPopulatingBuilder withHeaders(@NotNull Map<String, T> headers, boolean ignoreSmimeMessageId) {
        if (headers == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withHeaders must not be null");
        }
        for (Map.Entry<String, T> headerEntry : headers.entrySet()) {
            if (ignoreSmimeMessageId && SmimeRecognitionUtil.isGeneratedSmimeMessageId(headerEntry)) continue;
            this.withHeader(headerEntry.getKey(), headerEntry.getValue());
        }
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withHeaders must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder withHeader(@NotNull String name, @Nullable Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withHeader must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)name, (String)"name");
        this.headers.put(name, value != null ? String.valueOf(value) : null);
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withHeader must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder withAttachment(@Nullable String name, @NotNull byte[] data, @NotNull String mimetype) {
        if (data == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withAttachment must not be null");
        }
        if (mimetype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withAttachment must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)data, (String)"data");
        Preconditions.checkNonEmptyArgument((Object)mimetype, (String)"mimetype");
        ByteArrayDataSource dataSource = new ByteArrayDataSource(data, mimetype);
        dataSource.setName(name);
        this.withAttachment(name, (DataSource)dataSource);
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withAttachment must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder withAttachment(@Nullable String name, @NotNull DataSource filedata) {
        if (filedata == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withAttachment must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)filedata, (String)"filedata");
        this.attachments.add(new AttachmentResource(name, filedata));
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withAttachment must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder withAttachments(@NotNull List<AttachmentResource> attachments) {
        if (attachments == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withAttachments must not be null");
        }
        for (AttachmentResource attachment : attachments) {
            this.withAttachment(attachment.getName(), attachment.getDataSource());
        }
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withAttachments must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    @Override
    @NotNull
    public InternalEmailPopulatingBuilder withDecryptedAttachments(@NotNull List<AttachmentResource> attachments) {
        if (attachments == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withDecryptedAttachments must not be null");
        }
        this.decryptedAttachments.addAll(attachments);
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withDecryptedAttachments must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    @Cli.ExcludeApi(reason="delegated method is an identical api from CLI point of view")
    public EmailPopulatingBuilder signWithDomainKey(@NotNull byte[] dkimPrivateKey, @NotNull String signingDomain, @NotNull String dkimSelector) {
        if (dkimPrivateKey == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithDomainKey must not be null");
        }
        if (signingDomain == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithDomainKey must not be null");
        }
        if (dkimSelector == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithDomainKey must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)dkimPrivateKey, (String)"dkimPrivateKey");
        EmailPopulatingBuilder emailPopulatingBuilder = this.signWithDomainKey(new ByteArrayInputStream(dkimPrivateKey), signingDomain, dkimSelector);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithDomainKey must not return null");
        }
        return emailPopulatingBuilder;
    }

    @Cli.ExcludeApi(reason="delegated method is an identical api from CLI point of view")
    public EmailPopulatingBuilder signWithDomainKey(@NotNull String dkimPrivateKey, @NotNull String signingDomain, @NotNull String dkimSelector) {
        if (dkimPrivateKey == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithDomainKey must not be null");
        }
        if (signingDomain == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithDomainKey must not be null");
        }
        if (dkimSelector == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithDomainKey must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)dkimPrivateKey, (String)"dkimPrivateKey");
        EmailPopulatingBuilder emailPopulatingBuilder = this.signWithDomainKey(new ByteArrayInputStream(dkimPrivateKey.getBytes(StandardCharsets.UTF_8)), signingDomain, dkimSelector);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithDomainKey must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder signWithDomainKey(@NotNull InputStream dkimPrivateKeyInputStream, @NotNull String signingDomain, @NotNull String dkimSelector) {
        if (dkimPrivateKeyInputStream == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithDomainKey must not be null");
        }
        if (signingDomain == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithDomainKey must not be null");
        }
        if (dkimSelector == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithDomainKey must not be null");
        }
        this.dkimPrivateKeyInputStream = (InputStream)Preconditions.checkNonEmptyArgument((Object)dkimPrivateKeyInputStream, (String)"dkimPrivateKeyInputStream");
        this.dkimSigningDomain = (String)Preconditions.checkNonEmptyArgument((Object)signingDomain, (String)"dkimSigningDomain");
        this.dkimSelector = (String)Preconditions.checkNonEmptyArgument((Object)dkimSelector, (String)"dkimSelector");
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithDomainKey must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    @Cli.ExcludeApi(reason="delegated method is an identical api from CLI point of view")
    public EmailPopulatingBuilder signWithDomainKey(@NotNull File dkimPrivateKeyFile, @NotNull String signingDomain, @NotNull String dkimSelector) {
        if (dkimPrivateKeyFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithDomainKey must not be null");
        }
        if (signingDomain == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithDomainKey must not be null");
        }
        if (dkimSelector == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithDomainKey must not be null");
        }
        this.dkimPrivateKeyFile = (File)Preconditions.checkNonEmptyArgument((Object)dkimPrivateKeyFile, (String)"dkimPrivateKeyFile");
        this.dkimSigningDomain = (String)Preconditions.checkNonEmptyArgument((Object)signingDomain, (String)"dkimSigningDomain");
        this.dkimSelector = (String)Preconditions.checkNonEmptyArgument((Object)dkimSelector, (String)"dkimSelector");
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithDomainKey must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="Input stream being created should not be closed here")
    public EmailPopulatingBuilder signWithSmime(@NotNull File pkcs12StoreFile, @NotNull String storePassword, @NotNull String keyAlias, @NotNull String keyPassword) {
        EmailPopulatingBuilder emailPopulatingBuilder;
        if (pkcs12StoreFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithSmime must not be null");
        }
        if (storePassword == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithSmime must not be null");
        }
        if (keyAlias == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithSmime must not be null");
        }
        if (keyPassword == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithSmime must not be null");
        }
        try {
            emailPopulatingBuilder = this.signWithSmime(new FileInputStream(pkcs12StoreFile), storePassword, keyAlias, keyPassword);
        }
        catch (FileNotFoundException e) {
            throw new EmailException(String.format("Error reading from file: %s", pkcs12StoreFile), e);
        }
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithSmime must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder signWithSmime(@NotNull InputStream pkcs12StoreStream, @NotNull String storePassword, @NotNull String keyAlias, @NotNull String keyPassword) {
        if (pkcs12StoreStream == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithSmime must not be null");
        }
        if (storePassword == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithSmime must not be null");
        }
        if (keyAlias == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithSmime must not be null");
        }
        if (keyPassword == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithSmime must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.signWithSmime(Pkcs12Config.builder().pkcs12Store(pkcs12StoreStream).storePassword(storePassword).keyAlias(keyAlias).keyPassword(keyPassword).build());
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithSmime must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder signWithSmime(@NotNull Pkcs12Config pkcs12Config) {
        if (pkcs12Config == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithSmime must not be null");
        }
        this.pkcs12ConfigForSmimeSigning = pkcs12Config;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.signWithSmime must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="Input stream being created should not be closed here")
    public EmailPopulatingBuilder encryptWithSmime(@NotNull String pemFile) {
        EmailPopulatingBuilder emailPopulatingBuilder;
        if (pemFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.encryptWithSmime must not be null");
        }
        try {
            emailPopulatingBuilder = this.encryptWithSmime(new FileInputStream(new File(pemFile)));
        }
        catch (FileNotFoundException e) {
            throw new EmailException(String.format("Error reading from file: %s", pemFile), e);
        }
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.encryptWithSmime must not return null");
        }
        return emailPopulatingBuilder;
    }

    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="Input stream being created should not be closed here")
    public EmailPopulatingBuilder encryptWithSmime(@NotNull File pemFile) {
        EmailPopulatingBuilder emailPopulatingBuilder;
        if (pemFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.encryptWithSmime must not be null");
        }
        try {
            emailPopulatingBuilder = this.encryptWithSmime(new FileInputStream(pemFile));
        }
        catch (FileNotFoundException e) {
            throw new EmailException(String.format("Error reading from file: %s", pemFile), e);
        }
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.encryptWithSmime must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder encryptWithSmime(@NotNull InputStream pemStream) {
        EmailPopulatingBuilder emailPopulatingBuilder;
        if (pemStream == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.encryptWithSmime must not be null");
        }
        try {
            emailPopulatingBuilder = this.encryptWithSmime(CertificationUtil.readFromPem((InputStream)pemStream));
        }
        catch (CertificateException e) {
            throw new EmailException("Was unable to convert PEM data to X509 certificate", e);
        }
        catch (NoSuchProviderException e) {
            throw new EmailException("Unable to load certificate (missing bouncy castle), is the S/MIME module on the class path?", e);
        }
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.encryptWithSmime must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder encryptWithSmime(@NotNull X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.encryptWithSmime must not be null");
        }
        this.x509CertificateForSmimeEncryption = x509Certificate;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.encryptWithSmime must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    @Cli.OptionNameOverride(value="withDispositionNotificationToEnabled")
    public EmailPopulatingBuilder withDispositionNotificationTo() {
        this.useDispositionNotificationTo = true;
        this.dispositionNotificationTo = null;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withDispositionNotificationTo must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    @Cli.ExcludeApi(reason="API is subset of another API")
    public EmailPopulatingBuilder withDispositionNotificationTo(@NotNull String address) {
        if (address == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withDispositionNotificationTo must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)address, (String)"dispositionNotificationToAddress");
        EmailPopulatingBuilder emailPopulatingBuilder = this.withDispositionNotificationTo(new Recipient(null, address, null));
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withDispositionNotificationTo must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder withDispositionNotificationTo(@Nullable String name, @NotNull String address) {
        if (address == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withDispositionNotificationTo must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)address, (String)"dispositionNotificationToAddress");
        EmailPopulatingBuilder emailPopulatingBuilder = this.withDispositionNotificationTo(new Recipient(name, address, null));
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withDispositionNotificationTo must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder withDispositionNotificationTo(@NotNull InternetAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withDispositionNotificationTo must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)address, (String)"dispositionNotificationToAddress");
        EmailPopulatingBuilder emailPopulatingBuilder = this.withDispositionNotificationTo(new Recipient(address.getPersonal(), address.getAddress(), null));
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withDispositionNotificationTo must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder withDispositionNotificationTo(@Nullable String fixedName, @NotNull InternetAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withDispositionNotificationTo must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)address, (String)"dispositionNotificationToAddress");
        EmailPopulatingBuilder emailPopulatingBuilder = this.withDispositionNotificationTo(new Recipient(fixedName, address.getAddress(), null));
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withDispositionNotificationTo must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder withDispositionNotificationTo(@NotNull Recipient recipient) {
        if (recipient == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withDispositionNotificationTo must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)recipient.getAddress(), (String)"recipient.address");
        this.useDispositionNotificationTo = true;
        this.dispositionNotificationTo = new Recipient(recipient.getName(), recipient.getAddress(), null);
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withDispositionNotificationTo must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    @Cli.OptionNameOverride(value="withReturnReceiptToEnabled")
    public EmailPopulatingBuilder withReturnReceiptTo() {
        this.useReturnReceiptTo = true;
        this.returnReceiptTo = null;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withReturnReceiptTo must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    @Cli.ExcludeApi(reason="API is subset of another API")
    public EmailPopulatingBuilder withReturnReceiptTo(@NotNull String address) {
        if (address == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withReturnReceiptTo must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)address, (String)"address");
        EmailPopulatingBuilder emailPopulatingBuilder = this.withReturnReceiptTo(new Recipient(null, address, null));
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withReturnReceiptTo must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder withReturnReceiptTo(@Nullable String name, @NotNull String address) {
        if (address == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withReturnReceiptTo must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)address, (String)"address");
        EmailPopulatingBuilder emailPopulatingBuilder = this.withReturnReceiptTo(new Recipient(name, address, null));
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withReturnReceiptTo must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder withReturnReceiptTo(@NotNull InternetAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withReturnReceiptTo must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)address, (String)"address");
        EmailPopulatingBuilder emailPopulatingBuilder = this.withReturnReceiptTo(new Recipient(address.getPersonal(), address.getAddress(), null));
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withReturnReceiptTo must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder withReturnReceiptTo(@Nullable String fixedName, @NotNull InternetAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withReturnReceiptTo must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)address, (String)"address");
        EmailPopulatingBuilder emailPopulatingBuilder = this.withReturnReceiptTo(new Recipient(fixedName, address.getAddress(), null));
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withReturnReceiptTo must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder withReturnReceiptTo(@NotNull Recipient recipient) {
        if (recipient == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withReturnReceiptTo must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)recipient.getAddress(), (String)"recipient.address");
        this.useReturnReceiptTo = true;
        this.returnReceiptTo = new Recipient(recipient.getName(), recipient.getAddress(), null);
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withReturnReceiptTo must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    @Override
    @NotNull
    public InternalEmailPopulatingBuilder withOriginalSmimeDetails(@NotNull OriginalSmimeDetails originalSmimeDetails) {
        if (originalSmimeDetails == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withOriginalSmimeDetails must not be null");
        }
        this.originalSmimeDetails = originalSmimeDetails;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withOriginalSmimeDetails must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    @Override
    @NotNull
    public InternalEmailPopulatingBuilder withSmimeSignedEmail(@NotNull Email smimeSignedEmail) {
        if (smimeSignedEmail == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withSmimeSignedEmail must not be null");
        }
        this.smimeSignedEmail = smimeSignedEmail;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.withSmimeSignedEmail must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder fixingSentDate(@NotNull Date sentDate) {
        if (sentDate == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.fixingSentDate must not be null");
        }
        this.sentDate = new Date(sentDate.getTime());
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.fixingSentDate must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder notMergingSingleSMIMESignedAttachment() {
        this.mergeSingleSMIMESignedAttachment = false;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.notMergingSingleSMIMESignedAttachment must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder clearId() {
        this.id = null;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.clearId must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder clearFromRecipient() {
        this.fromRecipient = null;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.clearFromRecipient must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder clearReplyTo() {
        this.replyToRecipient = null;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.clearReplyTo must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder clearBounceTo() {
        this.bounceToRecipient = null;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.clearBounceTo must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder clearPlainText() {
        this.text = null;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.clearPlainText must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder clearHTMLText() {
        this.textHTML = null;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.clearHTMLText must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder clearSubject() {
        this.subject = null;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.clearSubject must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder clearRecipients() {
        this.recipients.clear();
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.clearRecipients must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder clearEmbeddedImages() {
        this.embeddedImages.clear();
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.clearEmbeddedImages must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder clearAttachments() {
        this.attachments.clear();
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.clearAttachments must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder clearHeaders() {
        this.headers.clear();
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.clearHeaders must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder clearDkim() {
        this.dkimPrivateKeyFile = null;
        this.dkimPrivateKeyInputStream = null;
        this.dkimSigningDomain = null;
        this.dkimSelector = null;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.clearDkim must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder clearSmime() {
        this.pkcs12ConfigForSmimeSigning = null;
        this.x509CertificateForSmimeEncryption = null;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.clearSmime must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder clearDispositionNotificationTo() {
        this.useDispositionNotificationTo = false;
        this.dispositionNotificationTo = null;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.clearDispositionNotificationTo must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder clearReturnReceiptTo() {
        this.useReturnReceiptTo = false;
        this.returnReceiptTo = null;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.clearReturnReceiptTo must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder clearSentDate() {
        this.sentDate = null;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.clearSentDate must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder clearSMIMESignedAttachmentMergingBehavior() {
        this.mergeSingleSMIMESignedAttachment = true;
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = this;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.clearSMIMESignedAttachmentMergingBehavior must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public Recipient getFromRecipient() {
        return this.fromRecipient;
    }

    @Nullable
    public Recipient getReplyToRecipient() {
        return this.replyToRecipient;
    }

    @Nullable
    public Recipient getBounceToRecipient() {
        return this.bounceToRecipient;
    }

    @Nullable
    public String getText() {
        return this.text;
    }

    @Nullable
    public String getTextHTML() {
        return this.textHTML;
    }

    @Nullable
    public CalendarMethod getCalendarMethod() {
        return this.calendarMethod;
    }

    @Nullable
    public String getTextCalendar() {
        return this.textCalendar;
    }

    @Nullable
    public String getSubject() {
        return this.subject;
    }

    @NotNull
    public List<Recipient> getRecipients() {
        ArrayList<Recipient> arrayList = new ArrayList<Recipient>(this.recipients);
        if (arrayList == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.getRecipients must not return null");
        }
        return arrayList;
    }

    @NotNull
    public List<AttachmentResource> getEmbeddedImages() {
        ArrayList<AttachmentResource> arrayList = new ArrayList<AttachmentResource>(this.embeddedImages);
        if (arrayList == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.getEmbeddedImages must not return null");
        }
        return arrayList;
    }

    @NotNull
    public List<AttachmentResource> getAttachments() {
        ArrayList<AttachmentResource> arrayList = new ArrayList<AttachmentResource>(this.attachments);
        if (arrayList == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.getAttachments must not return null");
        }
        return arrayList;
    }

    @NotNull
    public List<AttachmentResource> getDecryptedAttachments() {
        List<AttachmentResource> list = this.decryptedAttachments;
        if (list == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.getDecryptedAttachments must not return null");
        }
        return list;
    }

    @NotNull
    public Map<String, String> getHeaders() {
        HashMap<String, String> hashMap = new HashMap<String, String>(this.headers);
        if (hashMap == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.getHeaders must not return null");
        }
        return hashMap;
    }

    @Nullable
    public File getDkimPrivateKeyFile() {
        return this.dkimPrivateKeyFile;
    }

    @Nullable
    public InputStream getDkimPrivateKeyInputStream() {
        return this.dkimPrivateKeyInputStream;
    }

    @Nullable
    public String getDkimSigningDomain() {
        return this.dkimSigningDomain;
    }

    @Nullable
    public String getDkimSelector() {
        return this.dkimSelector;
    }

    public boolean isUseDispositionNotificationTo() {
        return this.useDispositionNotificationTo;
    }

    @Nullable
    public Recipient getDispositionNotificationTo() {
        return this.dispositionNotificationTo;
    }

    public boolean isUseReturnReceiptTo() {
        return this.useReturnReceiptTo;
    }

    @Nullable
    public Recipient getReturnReceiptTo() {
        return this.returnReceiptTo;
    }

    @Nullable
    public MimeMessage getEmailToForward() {
        return this.emailToForward;
    }

    @NotNull
    public OriginalSmimeDetails getOriginalSmimeDetails() {
        OriginalSmimeDetails originalSmimeDetails = this.originalSmimeDetails;
        if (originalSmimeDetails == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailPopulatingBuilderImpl.getOriginalSmimeDetails must not return null");
        }
        return originalSmimeDetails;
    }

    @Nullable
    public Email getSmimeSignedEmail() {
        return this.smimeSignedEmail;
    }

    public boolean isMergeSingleSMIMESignedAttachment() {
        return this.mergeSingleSMIMESignedAttachment;
    }

    @Nullable
    public Pkcs12Config getPkcs12ConfigForSmimeSigning() {
        return this.pkcs12ConfigForSmimeSigning;
    }

    @Nullable
    public X509Certificate getX509CertificateForSmimeEncryption() {
        return this.x509CertificateForSmimeEncryption;
    }

    @Nullable
    public Date getSentDate() {
        return this.sentDate != null ? new Date(this.sentDate.getTime()) : null;
    }
}

