/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.hazlewood.connor.bottema.emailaddress.EmailAddressCriteria;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.mailer.CustomMailer;
import org.simplejavamail.api.mailer.MailerGenericBuilder;
import org.simplejavamail.api.mailer.config.LoadBalancingStrategy;
import org.simplejavamail.api.mailer.config.OperationalConfig;
import org.simplejavamail.api.mailer.config.ProxyConfig;
import org.simplejavamail.config.ConfigLoader;
import org.simplejavamail.internal.modules.ModuleLoader;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;
import org.simplejavamail.mailer.internal.OperationalConfigImpl;
import org.simplejavamail.mailer.internal.ProxyConfigImpl;

abstract class MailerGenericBuilderImpl<T extends MailerGenericBuilderImpl<?>>
implements MailerGenericBuilder<T> {
    private boolean async;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    @NotNull
    private Integer proxyBridgePort;
    private boolean debugLogging;
    @NotNull
    private Integer sessionTimeout;
    @NotNull
    private EnumSet<EmailAddressCriteria> emailAddressCriteria;
    @NotNull
    private ExecutorService executorService;
    @NotNull
    private Integer threadPoolSize;
    @NotNull
    private Integer threadPoolKeepAliveTime;
    @NotNull
    private UUID clusterKey;
    @NotNull
    private Integer connectionPoolCoreSize;
    @NotNull
    private Integer connectionPoolMaxSize;
    @NotNull
    private Integer connectionPoolClaimTimeoutMillis;
    @NotNull
    private Integer connectionPoolExpireAfterMillis;
    @NotNull
    private LoadBalancingStrategy connectionPoolLoadBalancingStrategy;
    @NotNull
    private List<String> sslHostsToTrust = new ArrayList<String>();
    private boolean trustAllSSLHost;
    private boolean verifyingServerIdentity;
    @NotNull
    private final Properties properties = new Properties();
    private boolean transportModeLoggingOnly;
    @Nullable
    private CustomMailer customMailer;

    MailerGenericBuilderImpl() {
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.PROXY_HOST)) {
            this.proxyHost = ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.PROXY_HOST);
        }
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.PROXY_USERNAME)) {
            this.proxyUsername = ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.PROXY_USERNAME);
        }
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.PROXY_PASSWORD)) {
            this.proxyPassword = ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.PROXY_PASSWORD);
        }
        this.clusterKey = ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CONNECTIONPOOL_CLUSTER_KEY) ? UUID.fromString((String)Preconditions.assumeNonNull((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CONNECTIONPOOL_CLUSTER_KEY))) : UUID.randomUUID();
        this.proxyPort = (Integer)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsInteger(null, (ConfigLoader.Property)ConfigLoader.Property.PROXY_PORT, (Integer)1080));
        this.proxyBridgePort = (Integer)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsInteger(null, (ConfigLoader.Property)ConfigLoader.Property.PROXY_SOCKS5BRIDGE_PORT, (Integer)1081));
        this.debugLogging = (Boolean)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsBoolean(null, (ConfigLoader.Property)ConfigLoader.Property.JAVAXMAIL_DEBUG, (Boolean)false));
        this.sessionTimeout = (Integer)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsInteger(null, (ConfigLoader.Property)ConfigLoader.Property.DEFAULT_SESSION_TIMEOUT_MILLIS, (Integer)60000));
        this.trustAllSSLHost = (Boolean)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsBoolean(null, (ConfigLoader.Property)ConfigLoader.Property.DEFAULT_TRUST_ALL_HOSTS, (Boolean)true));
        this.verifyingServerIdentity = (Boolean)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsBoolean(null, (ConfigLoader.Property)ConfigLoader.Property.DEFAULT_VERIFY_SERVER_IDENTITY, (Boolean)true));
        this.threadPoolSize = (Integer)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsInteger(null, (ConfigLoader.Property)ConfigLoader.Property.DEFAULT_POOL_SIZE, (Integer)10));
        this.threadPoolKeepAliveTime = (Integer)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsInteger(null, (ConfigLoader.Property)ConfigLoader.Property.DEFAULT_POOL_KEEP_ALIVE_TIME, (Integer)1));
        this.connectionPoolCoreSize = (Integer)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsInteger(null, (ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CONNECTIONPOOL_CORE_SIZE, (Integer)0));
        this.connectionPoolMaxSize = (Integer)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsInteger(null, (ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CONNECTIONPOOL_MAX_SIZE, (Integer)4));
        this.connectionPoolClaimTimeoutMillis = (Integer)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsInteger(null, (ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CONNECTIONPOOL_CLAIMTIMEOUT_MILLIS, (Integer)Integer.MAX_VALUE));
        this.connectionPoolExpireAfterMillis = (Integer)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsInteger(null, (ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CONNECTIONPOOL_EXPIREAFTER_MILLIS, (Integer)5000));
        this.connectionPoolLoadBalancingStrategy = (LoadBalancingStrategy)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrProperty(null, (ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CONNECTIONPOOL_LOADBALANCING_STRATEGY, (Object)LoadBalancingStrategy.valueOf((String)"ROUND_ROBIN")));
        this.transportModeLoggingOnly = (Boolean)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsBoolean(null, (ConfigLoader.Property)ConfigLoader.Property.TRANSPORT_MODE_LOGGING_ONLY, (Boolean)false));
        String trustedHosts = ConfigLoader.valueOrPropertyAsString(null, (ConfigLoader.Property)ConfigLoader.Property.DEFAULT_TRUSTED_HOSTS, null);
        if (trustedHosts != null) {
            this.sslHostsToTrust = Arrays.asList(trustedHosts.split(";"));
        }
        this.emailAddressCriteria = EmailAddressCriteria.RFC_COMPLIANT.clone();
        this.executorService = this.determineDefaultExecutorService();
    }

    ProxyConfig buildProxyConfig() {
        this.validateProxy();
        ProxyConfigImpl proxyConfigImpl = new ProxyConfigImpl(this.getProxyHost(), this.getProxyPort(), this.getProxyUsername(), this.getProxyPassword(), this.getProxyBridgePort());
        if (proxyConfigImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.buildProxyConfig must not return null");
        }
        return proxyConfigImpl;
    }

    private void validateProxy() {
        if (!MiscUtil.valueNullOrEmpty((Object)this.proxyHost)) {
            MiscUtil.checkArgumentNotEmpty((Object)this.proxyPort, (String)"proxyHost provided, but not a proxyPort");
            if (!MiscUtil.valueNullOrEmpty((Object)this.proxyUsername) && MiscUtil.valueNullOrEmpty((Object)this.proxyPassword)) {
                throw new IllegalArgumentException("Proxy username provided but not a password");
            }
            if (MiscUtil.valueNullOrEmpty((Object)this.proxyUsername) && !MiscUtil.valueNullOrEmpty((Object)this.proxyPassword)) {
                throw new IllegalArgumentException("Proxy password provided but not a username");
            }
            if (!MiscUtil.valueNullOrEmpty((Object)this.proxyUsername) && MiscUtil.valueNullOrEmpty((Object)this.proxyBridgePort)) {
                throw new IllegalArgumentException("Cannot authenticate with proxy if no proxy bridge port is configured");
            }
        }
    }

    OperationalConfig buildOperationalConfig() {
        OperationalConfigImpl operationalConfigImpl = new OperationalConfigImpl(this.isAsync(), this.getProperties(), this.getSessionTimeout(), this.getThreadPoolSize(), this.getThreadPoolKeepAliveTime(), this.getClusterKey(), this.getConnectionPoolCoreSize(), this.getConnectionPoolMaxSize(), this.getConnectionPoolClaimTimeoutMillis(), this.getConnectionPoolExpireAfterMillis(), this.getConnectionPoolLoadBalancingStrategy(), this.isTransportModeLoggingOnly(), this.isDebugLogging(), this.getSslHostsToTrust(), this.isTrustAllSSLHost(), this.isVerifyingServerIdentity(), this.getExecutorService(), this.getCustomMailer());
        if (operationalConfigImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.buildOperationalConfig must not return null");
        }
        return operationalConfigImpl;
    }

    public T async() {
        this.async = true;
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.async must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T withProxy(@Nullable String proxyHost, @Nullable Integer proxyPort) {
        MailerGenericBuilder mailerGenericBuilder = this.withProxyHost(proxyHost).withProxyPort(proxyPort);
        if (mailerGenericBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withProxy must not return null");
        }
        return (T)mailerGenericBuilder;
    }

    public T withProxy(@Nullable String proxyHost, @Nullable Integer proxyPort, @Nullable String proxyUsername, @Nullable String proxyPassword) {
        MailerGenericBuilder mailerGenericBuilder = this.withProxyHost(proxyHost).withProxyPort(proxyPort).withProxyUsername(proxyUsername).withProxyPassword(proxyPassword);
        if (mailerGenericBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withProxy must not return null");
        }
        return (T)mailerGenericBuilder;
    }

    public T withProxyHost(@Nullable String proxyHost) {
        this.proxyHost = proxyHost;
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withProxyHost must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T withProxyPort(@Nullable Integer proxyPort) {
        this.proxyPort = proxyPort;
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withProxyPort must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T withProxyUsername(@Nullable String proxyUsername) {
        this.proxyUsername = proxyUsername;
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withProxyUsername must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T withProxyPassword(@Nullable String proxyPassword) {
        this.proxyPassword = proxyPassword;
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withProxyPassword must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T withProxyBridgePort(@NotNull Integer proxyBridgePort) {
        if (proxyBridgePort == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withProxyBridgePort must not be null");
        }
        this.proxyBridgePort = proxyBridgePort;
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withProxyBridgePort must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T withDebugLogging(@NotNull Boolean debugLogging) {
        if (debugLogging == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withDebugLogging must not be null");
        }
        this.debugLogging = debugLogging;
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withDebugLogging must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T withSessionTimeout(@NotNull Integer sessionTimeout) {
        if (sessionTimeout == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withSessionTimeout must not be null");
        }
        this.sessionTimeout = sessionTimeout;
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withSessionTimeout must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T withEmailAddressCriteria(@NotNull EnumSet<EmailAddressCriteria> emailAddressCriteria) {
        if (emailAddressCriteria == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withEmailAddressCriteria must not be null");
        }
        this.emailAddressCriteria = emailAddressCriteria.clone();
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withEmailAddressCriteria must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T withExecutorService(@NotNull ExecutorService executorService) {
        if (executorService == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withExecutorService must not be null");
        }
        this.executorService = executorService;
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withExecutorService must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T withThreadPoolSize(@NotNull Integer threadPoolSize) {
        if (threadPoolSize == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withThreadPoolSize must not be null");
        }
        this.threadPoolSize = threadPoolSize;
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withThreadPoolSize must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T withThreadPoolKeepAliveTime(@NotNull Integer threadPoolKeepAliveTime) {
        if (threadPoolKeepAliveTime == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withThreadPoolKeepAliveTime must not be null");
        }
        this.threadPoolKeepAliveTime = threadPoolKeepAliveTime;
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withThreadPoolKeepAliveTime must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T withClusterKey(@NotNull UUID clusterKey) {
        if (clusterKey == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withClusterKey must not be null");
        }
        this.clusterKey = clusterKey;
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withClusterKey must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T withConnectionPoolCoreSize(@NotNull Integer connectionPoolCoreSize) {
        if (connectionPoolCoreSize == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withConnectionPoolCoreSize must not be null");
        }
        this.connectionPoolCoreSize = connectionPoolCoreSize;
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withConnectionPoolCoreSize must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T withConnectionPoolMaxSize(@NotNull Integer connectionPoolMaxSize) {
        if (connectionPoolMaxSize == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withConnectionPoolMaxSize must not be null");
        }
        this.connectionPoolMaxSize = connectionPoolMaxSize;
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withConnectionPoolMaxSize must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T withConnectionPoolClaimTimeoutMillis(@NotNull Integer connectionPoolClaimTimeoutMillis) {
        if (connectionPoolClaimTimeoutMillis == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withConnectionPoolClaimTimeoutMillis must not be null");
        }
        this.connectionPoolClaimTimeoutMillis = connectionPoolClaimTimeoutMillis;
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withConnectionPoolClaimTimeoutMillis must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T withConnectionPoolExpireAfterMillis(@NotNull Integer connectionPoolExpireAfterMillis) {
        if (connectionPoolExpireAfterMillis == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withConnectionPoolExpireAfterMillis must not be null");
        }
        this.connectionPoolExpireAfterMillis = connectionPoolExpireAfterMillis;
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withConnectionPoolExpireAfterMillis must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T withConnectionPoolLoadBalancingStrategy(@NotNull LoadBalancingStrategy loadBalancingStrategy) {
        if (loadBalancingStrategy == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withConnectionPoolLoadBalancingStrategy must not be null");
        }
        this.connectionPoolLoadBalancingStrategy = loadBalancingStrategy;
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withConnectionPoolLoadBalancingStrategy must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T withTransportModeLoggingOnly(@NotNull Boolean transportModeLoggingOnly) {
        if (transportModeLoggingOnly == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withTransportModeLoggingOnly must not be null");
        }
        this.transportModeLoggingOnly = transportModeLoggingOnly;
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withTransportModeLoggingOnly must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T trustingSSLHosts(String ... sslHostsToTrust) {
        if (sslHostsToTrust == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.trustingSSLHosts must not be null");
        }
        this.sslHostsToTrust = Arrays.asList(sslHostsToTrust);
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.trustingSSLHosts must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T trustingAllHosts(boolean trustAllHosts) {
        this.trustAllSSLHost = trustAllHosts;
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.trustingAllHosts must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T verifyingServerIdentity(boolean verifyingServerIdentity) {
        this.verifyingServerIdentity = verifyingServerIdentity;
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.verifyingServerIdentity must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T withProperties(@NotNull Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withProperties must not be null");
        }
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            this.properties.put(property.getKey(), property.getValue());
        }
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withProperties must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T withProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withProperties must not be null");
        }
        for (Map.Entry<String, String> property : properties.entrySet()) {
            this.properties.put(property.getKey(), property.getValue());
        }
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withProperties must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T withProperty(@NotNull String propertyName, @Nullable Object propertyValue) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withProperty must not be null");
        }
        if (propertyValue == null) {
            this.properties.remove(propertyName);
        } else {
            this.properties.put(propertyName, propertyValue.toString());
        }
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withProperty must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T withCustomMailer(@NotNull CustomMailer customMailer) {
        if (customMailer == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withCustomMailer must not be null");
        }
        this.customMailer = customMailer;
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.withCustomMailer must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public T resetSessionTimeout() {
        MailerGenericBuilder mailerGenericBuilder = this.withSessionTimeout(60000);
        if (mailerGenericBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.resetSessionTimeout must not return null");
        }
        return (T)mailerGenericBuilder;
    }

    public T resetTrustingAllHosts() {
        MailerGenericBuilder mailerGenericBuilder = this.trustingAllHosts(true);
        if (mailerGenericBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.resetTrustingAllHosts must not return null");
        }
        return (T)mailerGenericBuilder;
    }

    public T resetVerifyingServerIdentity() {
        MailerGenericBuilder mailerGenericBuilder = this.verifyingServerIdentity(true);
        if (mailerGenericBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.resetVerifyingServerIdentity must not return null");
        }
        return (T)mailerGenericBuilder;
    }

    public T resetEmailAddressCriteria() {
        MailerGenericBuilder mailerGenericBuilder = this.withEmailAddressCriteria(EmailAddressCriteria.RFC_COMPLIANT);
        if (mailerGenericBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.resetEmailAddressCriteria must not return null");
        }
        return (T)mailerGenericBuilder;
    }

    public T resetExecutorService() {
        this.executorService = this.determineDefaultExecutorService();
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.resetExecutorService must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    @NotNull
    private ExecutorService determineDefaultExecutorService() {
        ExecutorService executorService = ModuleLoader.batchModuleAvailable() ? ModuleLoader.loadBatchModule().createDefaultExecutorService(this.getThreadPoolSize().intValue(), this.getThreadPoolKeepAliveTime().intValue()) : Executors.newSingleThreadExecutor();
        if (executorService == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.determineDefaultExecutorService must not return null");
        }
        return executorService;
    }

    public T resetThreadPoolSize() {
        MailerGenericBuilder mailerGenericBuilder = this.withThreadPoolSize(10);
        if (mailerGenericBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.resetThreadPoolSize must not return null");
        }
        return (T)mailerGenericBuilder;
    }

    public T resetThreadPoolKeepAliveTime() {
        MailerGenericBuilder mailerGenericBuilder = this.withThreadPoolKeepAliveTime(1);
        if (mailerGenericBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.resetThreadPoolKeepAliveTime must not return null");
        }
        return (T)mailerGenericBuilder;
    }

    public T resetClusterKey() {
        MailerGenericBuilder mailerGenericBuilder = this.withClusterKey(UUID.randomUUID());
        if (mailerGenericBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.resetClusterKey must not return null");
        }
        return (T)mailerGenericBuilder;
    }

    public T resetConnectionPoolCoreSize() {
        MailerGenericBuilder mailerGenericBuilder = this.withConnectionPoolCoreSize(0);
        if (mailerGenericBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.resetConnectionPoolCoreSize must not return null");
        }
        return (T)mailerGenericBuilder;
    }

    public T resetConnectionPoolMaxSize() {
        MailerGenericBuilder mailerGenericBuilder = this.withConnectionPoolCoreSize(4);
        if (mailerGenericBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.resetConnectionPoolMaxSize must not return null");
        }
        return (T)mailerGenericBuilder;
    }

    public T resetConnectionPoolClaimTimeoutMillis() {
        MailerGenericBuilder mailerGenericBuilder = this.withConnectionPoolExpireAfterMillis(Integer.MAX_VALUE);
        if (mailerGenericBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.resetConnectionPoolClaimTimeoutMillis must not return null");
        }
        return (T)mailerGenericBuilder;
    }

    public T resetConnectionPoolExpireAfterMillis() {
        MailerGenericBuilder mailerGenericBuilder = this.withConnectionPoolExpireAfterMillis(5000);
        if (mailerGenericBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.resetConnectionPoolExpireAfterMillis must not return null");
        }
        return (T)mailerGenericBuilder;
    }

    public T resetConnectionPoolLoadBalancingStrategy() {
        MailerGenericBuilder mailerGenericBuilder = this.withConnectionPoolLoadBalancingStrategy(LoadBalancingStrategy.valueOf((String)"ROUND_ROBIN"));
        if (mailerGenericBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.resetConnectionPoolLoadBalancingStrategy must not return null");
        }
        return (T)mailerGenericBuilder;
    }

    public T resetTransportModeLoggingOnly() {
        MailerGenericBuilder mailerGenericBuilder = this.withTransportModeLoggingOnly(false);
        if (mailerGenericBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.resetTransportModeLoggingOnly must not return null");
        }
        return (T)mailerGenericBuilder;
    }

    public T clearProxy() {
        MailerGenericBuilder mailerGenericBuilder = this.withProxy(null, null, null, null).withProxyBridgePort(1081);
        if (mailerGenericBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.clearProxy must not return null");
        }
        return (T)mailerGenericBuilder;
    }

    public T clearEmailAddressCriteria() {
        MailerGenericBuilder mailerGenericBuilder = this.withEmailAddressCriteria((EnumSet)EnumSet.noneOf(EmailAddressCriteria.class));
        if (mailerGenericBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.clearEmailAddressCriteria must not return null");
        }
        return (T)mailerGenericBuilder;
    }

    public T clearTrustedSSLHosts() {
        MailerGenericBuilder mailerGenericBuilder = this.trustingSSLHosts(new String[0]);
        if (mailerGenericBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.clearTrustedSSLHosts must not return null");
        }
        return (T)mailerGenericBuilder;
    }

    public T clearProperties() {
        this.properties.clear();
        MailerGenericBuilderImpl mailerGenericBuilderImpl = this;
        if (mailerGenericBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.clearProperties must not return null");
        }
        return (T)mailerGenericBuilderImpl;
    }

    public boolean isAsync() {
        return this.async;
    }

    @Nullable
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Nullable
    public Integer getProxyPort() {
        return this.proxyPort;
    }

    @Nullable
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    @Nullable
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    @NotNull
    public Integer getProxyBridgePort() {
        Integer n = this.proxyBridgePort;
        if (n == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.getProxyBridgePort must not return null");
        }
        return n;
    }

    public boolean isDebugLogging() {
        return this.debugLogging;
    }

    @NotNull
    public Integer getSessionTimeout() {
        Integer n = this.sessionTimeout;
        if (n == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.getSessionTimeout must not return null");
        }
        return n;
    }

    @NotNull
    public EnumSet<EmailAddressCriteria> getEmailAddressCriteria() {
        EnumSet<EmailAddressCriteria> enumSet = this.emailAddressCriteria;
        if (enumSet == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.getEmailAddressCriteria must not return null");
        }
        return enumSet;
    }

    @NotNull
    public ExecutorService getExecutorService() {
        ExecutorService executorService = this.executorService;
        if (executorService == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.getExecutorService must not return null");
        }
        return executorService;
    }

    @NotNull
    public Integer getThreadPoolSize() {
        Integer n = this.threadPoolSize;
        if (n == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.getThreadPoolSize must not return null");
        }
        return n;
    }

    @NotNull
    public Integer getThreadPoolKeepAliveTime() {
        Integer n = this.threadPoolKeepAliveTime;
        if (n == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.getThreadPoolKeepAliveTime must not return null");
        }
        return n;
    }

    @NotNull
    public UUID getClusterKey() {
        UUID uUID = this.clusterKey;
        if (uUID == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.getClusterKey must not return null");
        }
        return uUID;
    }

    @NotNull
    public Integer getConnectionPoolCoreSize() {
        Integer n = this.connectionPoolCoreSize;
        if (n == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.getConnectionPoolCoreSize must not return null");
        }
        return n;
    }

    @NotNull
    public Integer getConnectionPoolMaxSize() {
        Integer n = this.connectionPoolMaxSize;
        if (n == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.getConnectionPoolMaxSize must not return null");
        }
        return n;
    }

    @NotNull
    public Integer getConnectionPoolClaimTimeoutMillis() {
        Integer n = this.connectionPoolClaimTimeoutMillis;
        if (n == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.getConnectionPoolClaimTimeoutMillis must not return null");
        }
        return n;
    }

    @NotNull
    public Integer getConnectionPoolExpireAfterMillis() {
        Integer n = this.connectionPoolExpireAfterMillis;
        if (n == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.getConnectionPoolExpireAfterMillis must not return null");
        }
        return n;
    }

    @NotNull
    public LoadBalancingStrategy getConnectionPoolLoadBalancingStrategy() {
        LoadBalancingStrategy loadBalancingStrategy = this.connectionPoolLoadBalancingStrategy;
        if (loadBalancingStrategy == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.getConnectionPoolLoadBalancingStrategy must not return null");
        }
        return loadBalancingStrategy;
    }

    @NotNull
    public List<String> getSslHostsToTrust() {
        List<String> list = this.sslHostsToTrust;
        if (list == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.getSslHostsToTrust must not return null");
        }
        return list;
    }

    public boolean isTrustAllSSLHost() {
        return this.trustAllSSLHost;
    }

    public boolean isVerifyingServerIdentity() {
        return this.verifyingServerIdentity;
    }

    public boolean isTransportModeLoggingOnly() {
        return this.transportModeLoggingOnly;
    }

    @NotNull
    public Properties getProperties() {
        Properties properties = this.properties;
        if (properties == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerGenericBuilderImpl.getProperties must not return null");
        }
        return properties;
    }

    @Nullable
    public CustomMailer getCustomMailer() {
        return this.customMailer;
    }
}

