/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.mail.EncodingAware;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.internal.util.MiscUtil;

class NamedDataSource
implements DataSource,
EncodingAware {
    private final DataSource dataSource;
    private final String name;

    public NamedDataSource(String name, DataSource dataSource) {
        if (name == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/internal/mimemessage/NamedDataSource.<init> must not be null");
        }
        if (dataSource == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/converter/internal/mimemessage/NamedDataSource.<init> must not be null");
        }
        this.dataSource = dataSource;
        this.name = name;
    }

    public InputStream getInputStream() throws IOException {
        InputStream inputStream = this.dataSource.getInputStream();
        if (inputStream == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/internal/mimemessage/NamedDataSource.getInputStream must not return null");
        }
        return inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        OutputStream outputStream = this.dataSource.getOutputStream();
        if (outputStream == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/internal/mimemessage/NamedDataSource.getOutputStream must not return null");
        }
        return outputStream;
    }

    public String getContentType() {
        String string = this.dataSource.getContentType();
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/internal/mimemessage/NamedDataSource.getContentType must not return null");
        }
        return string;
    }

    public String getName() {
        String string = !MiscUtil.valueNullOrEmpty((Object)this.name) ? this.name : this.dataSource.getName();
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/internal/mimemessage/NamedDataSource.getName must not return null");
        }
        return string;
    }

    @Nullable
    public String getEncoding() {
        return this.dataSource instanceof EncodingAware ? ((EncodingAware)this.dataSource).getEncoding() : null;
    }
}

