/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal.util;

import java.util.UUID;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.internal.batchsupport.LifecycleDelegatingTransport;
import org.simplejavamail.internal.modules.ModuleLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransportRunner.class);

    public static void sendMessage(@NotNull UUID clusterKey, Session session, final MimeMessage message, final Address[] allRecipients) throws MessagingException {
        if (clusterKey == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/util/TransportRunner.sendMessage must not be null");
        }
        if (session == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/mailer/internal/util/TransportRunner.sendMessage must not be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/simplejavamail/mailer/internal/util/TransportRunner.sendMessage must not be null");
        }
        if (allRecipients == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/simplejavamail/mailer/internal/util/TransportRunner.sendMessage must not be null");
        }
        TransportRunner.runOnSessionTransport(clusterKey, session, false, new TransportRunnable(){

            @Override
            public void run(Transport transport) throws MessagingException {
                if (transport == null) {
                    throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/util/TransportRunner$1.run must not be null");
                }
                transport.sendMessage((Message)message, allRecipients);
                LOGGER.trace("...email sent");
            }
        });
    }

    public static void connect(@NotNull UUID clusterKey, Session session) throws MessagingException {
        if (clusterKey == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/util/TransportRunner.connect must not be null");
        }
        if (session == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/mailer/internal/util/TransportRunner.connect must not be null");
        }
        TransportRunner.runOnSessionTransport(clusterKey, session, true, new TransportRunnable(){

            @Override
            public void run(Transport transport) {
                if (transport == null) {
                    throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/util/TransportRunner$2.run must not be null");
                }
                LOGGER.debug("...connection successful");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runOnSessionTransport(@NotNull UUID clusterKey, Session session, boolean stickySession, TransportRunnable runnable) throws MessagingException {
        if (clusterKey == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/util/TransportRunner.runOnSessionTransport must not be null");
        }
        if (session == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/mailer/internal/util/TransportRunner.runOnSessionTransport must not be null");
        }
        if (runnable == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/simplejavamail/mailer/internal/util/TransportRunner.runOnSessionTransport must not be null");
        }
        if (ModuleLoader.batchModuleAvailable()) {
            LifecycleDelegatingTransport delegatingTransport = ModuleLoader.loadBatchModule().acquireTransport(clusterKey, session, stickySession);
            try {
                runnable.run(delegatingTransport.getTransport());
            }
            catch (MessagingException messagingException) {
                delegatingTransport.signalTransportFailed();
                throw messagingException;
            }
            delegatingTransport.signalTransportUsed();
        } else {
            try (Transport transport = session.getTransport();){
                transport.connect();
                runnable.run(transport);
            }
            finally {
                LOGGER.trace("closing transport");
            }
        }
    }

    public static interface TransportRunnable {
        public void run(Transport var1) throws MessagingException;
    }
}

