/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.email.internal;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.activation.DataSource;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.util.ByteArrayDataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.AttachmentResource;
import org.simplejavamail.api.email.CalendarMethod;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.EmailPopulatingBuilder;
import org.simplejavamail.api.email.OriginalSmimeDetails;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.api.internal.clisupport.model.Cli;
import org.simplejavamail.api.internal.smimesupport.model.PlainSmimeDetails;
import org.simplejavamail.api.mailer.config.Pkcs12Config;
import org.simplejavamail.config.ConfigLoader;
import org.simplejavamail.email.internal.EmailException;
import org.simplejavamail.email.internal.InternalEmailPopulatingBuilder;
import org.simplejavamail.internal.smimesupport.SmimeRecognitionUtil;
import org.simplejavamail.internal.util.CertificationUtil;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.NamedDataSource;
import org.simplejavamail.internal.util.Preconditions;

public class EmailPopulatingBuilderImpl
implements InternalEmailPopulatingBuilder {
    private String id;
    private Recipient fromRecipient;
    private Recipient replyToRecipient;
    private Recipient bounceToRecipient;
    private String subject;
    private String text;
    private String textHTML;
    private CalendarMethod calendarMethod;
    private String textCalendar;
    @NotNull
    private final List<Recipient> recipients = new ArrayList<Recipient>();
    private boolean embeddedImageAutoResolutionForFiles;
    private boolean embeddedImageAutoResolutionForClassPathResources;
    private boolean embeddedImageAutoResolutionForURLs;
    private String embeddedImageBaseDir;
    private String embeddedImageBaseClassPath;
    private URL embeddedImageBaseUrl;
    private boolean allowEmbeddedImageOutsideBaseDir;
    private boolean allowEmbeddedImageOutsideBaseClassPath;
    private boolean allowEmbeddedImageOutsideBaseUrl;
    private boolean embeddedImageAutoResolutionMustBeSuccesful;
    @NotNull
    private final List<AttachmentResource> embeddedImages = new ArrayList<AttachmentResource>();
    @NotNull
    private final List<AttachmentResource> attachments = new ArrayList<AttachmentResource>();
    @NotNull
    private final List<AttachmentResource> decryptedAttachments = new ArrayList<AttachmentResource>();
    @NotNull
    private final Map<String, Collection<String>> headers = new HashMap<String, Collection<String>>();
    private byte[] dkimPrivateKeyData;
    private String dkimSigningDomain;
    private String dkimSelector;
    private Pkcs12Config pkcs12ConfigForSmimeSigning;
    private X509Certificate x509CertificateForSmimeEncryption;
    private boolean useDispositionNotificationTo;
    private Recipient dispositionNotificationTo;
    private boolean useReturnReceiptTo;
    private Recipient returnReceiptTo;
    private MimeMessage emailToForward;
    @NotNull
    private OriginalSmimeDetails originalSmimeDetails = new PlainSmimeDetails();
    private Email smimeSignedEmail;
    private boolean mergeSingleSMIMESignedAttachment = true;
    @Nullable
    private Date sentDate;

    EmailPopulatingBuilderImpl(boolean applyDefaults) {
        if (applyDefaults) {
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_FROM_ADDRESS)) {
                this.from(ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_FROM_NAME), (String)Preconditions.assumeNonNull((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_FROM_ADDRESS)));
            }
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_REPLYTO_ADDRESS)) {
                this.withReplyTo(ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_REPLYTO_NAME), (String)Preconditions.assumeNonNull((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_REPLYTO_ADDRESS)));
            }
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_BOUNCETO_ADDRESS)) {
                this.withBounceTo(ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_BOUNCETO_NAME), (String)Preconditions.assumeNonNull((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_BOUNCETO_ADDRESS)));
            }
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_TO_ADDRESS)) {
                if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_TO_NAME)) {
                    this.to(ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_TO_NAME), ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_TO_ADDRESS));
                } else {
                    this.to((String)Preconditions.assumeNonNull((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_TO_ADDRESS)));
                }
            }
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CC_ADDRESS)) {
                if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CC_NAME)) {
                    this.cc(ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CC_NAME), ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CC_ADDRESS));
                } else {
                    this.cc((String)Preconditions.assumeNonNull((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CC_ADDRESS)));
                }
            }
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_BCC_ADDRESS)) {
                if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_BCC_NAME)) {
                    this.bcc(ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_BCC_NAME), ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_BCC_ADDRESS));
                } else {
                    this.bcc((String)Preconditions.assumeNonNull((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_BCC_ADDRESS)));
                }
            }
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_SUBJECT)) {
                this.withSubject((String)ConfigLoader.getProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_SUBJECT));
            }
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.SMIME_ENCRYPTION_CERTIFICATE)) {
                this.encryptWithSmime((String)Preconditions.assumeNonNull((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.SMIME_ENCRYPTION_CERTIFICATE)));
            }
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.EMBEDDEDIMAGES_DYNAMICRESOLUTION_ENABLE_DIR)) {
                this.withEmbeddedImageAutoResolutionForFiles((Boolean)Preconditions.assumeNonNull((Object)ConfigLoader.getBooleanProperty((ConfigLoader.Property)ConfigLoader.Property.EMBEDDEDIMAGES_DYNAMICRESOLUTION_ENABLE_DIR)));
            }
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.EMBEDDEDIMAGES_DYNAMICRESOLUTION_ENABLE_CLASSPATH)) {
                this.withEmbeddedImageAutoResolutionForClassPathResources((Boolean)Preconditions.assumeNonNull((Object)ConfigLoader.getBooleanProperty((ConfigLoader.Property)ConfigLoader.Property.EMBEDDEDIMAGES_DYNAMICRESOLUTION_ENABLE_CLASSPATH)));
            }
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.EMBEDDEDIMAGES_DYNAMICRESOLUTION_ENABLE_URL)) {
                this.withEmbeddedImageAutoResolutionForURLs((Boolean)Preconditions.assumeNonNull((Object)ConfigLoader.getBooleanProperty((ConfigLoader.Property)ConfigLoader.Property.EMBEDDEDIMAGES_DYNAMICRESOLUTION_ENABLE_URL)));
            }
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.EMBEDDEDIMAGES_DYNAMICRESOLUTION_BASE_DIR)) {
                this.withEmbeddedImageBaseDir((String)Preconditions.assumeNonNull((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.EMBEDDEDIMAGES_DYNAMICRESOLUTION_BASE_DIR)));
            }
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.EMBEDDEDIMAGES_DYNAMICRESOLUTION_BASE_CLASSPATH)) {
                this.withEmbeddedImageBaseClassPath((String)Preconditions.assumeNonNull((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.EMBEDDEDIMAGES_DYNAMICRESOLUTION_BASE_CLASSPATH)));
            }
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.EMBEDDEDIMAGES_DYNAMICRESOLUTION_BASE_URL)) {
                this.withEmbeddedImageBaseUrl((String)Preconditions.assumeNonNull((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.EMBEDDEDIMAGES_DYNAMICRESOLUTION_BASE_URL)));
            }
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.EMBEDDEDIMAGES_DYNAMICRESOLUTION_OUTSIDE_BASE_DIR)) {
                this.allowingEmbeddedImageOutsideBaseDir((Boolean)Preconditions.assumeNonNull((Object)ConfigLoader.getBooleanProperty((ConfigLoader.Property)ConfigLoader.Property.EMBEDDEDIMAGES_DYNAMICRESOLUTION_OUTSIDE_BASE_DIR)));
            }
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.EMBEDDEDIMAGES_DYNAMICRESOLUTION_OUTSIDE_BASE_URL)) {
                this.allowingEmbeddedImageOutsideBaseClassPath((Boolean)Preconditions.assumeNonNull((Object)ConfigLoader.getBooleanProperty((ConfigLoader.Property)ConfigLoader.Property.EMBEDDEDIMAGES_DYNAMICRESOLUTION_OUTSIDE_BASE_URL)));
            }
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.EMBEDDEDIMAGES_DYNAMICRESOLUTION_OUTSIDE_BASE_CLASSPATH)) {
                this.allowingEmbeddedImageOutsideBaseUrl((Boolean)Preconditions.assumeNonNull((Object)ConfigLoader.getBooleanProperty((ConfigLoader.Property)ConfigLoader.Property.EMBEDDEDIMAGES_DYNAMICRESOLUTION_OUTSIDE_BASE_CLASSPATH)));
            }
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.EMBEDDEDIMAGES_DYNAMICRESOLUTION_MUSTBESUCCESFUL)) {
                this.embeddedImageAutoResolutionMustBeSuccesful((Boolean)Preconditions.assumeNonNull((Object)ConfigLoader.getBooleanProperty((ConfigLoader.Property)ConfigLoader.Property.EMBEDDEDIMAGES_DYNAMICRESOLUTION_MUSTBESUCCESFUL)));
            }
        }
    }

    @Cli.ExcludeApi(reason="This API is specifically for Java use")
    public Email buildEmail() {
        this.validateDkim();
        this.resolveDynamicEmbeddedImageDataSources();
        return new Email((EmailPopulatingBuilder)this);
    }

    private void validateDkim() {
        if (this.getDkimPrivateKeyData() != null) {
            Preconditions.checkNonEmptyArgument((Object)this.getDkimSelector(), (String)"dkimSelector");
            Preconditions.checkNonEmptyArgument((Object)this.getDkimSigningDomain(), (String)"dkimSigningDomain");
            Preconditions.checkNonEmptyArgument((Object)this.getFromRecipient(), (String)"fromRecipient required when signing DKIM");
        }
    }

    private void resolveDynamicEmbeddedImageDataSources() {
        if (this.textHTML != null) {
            HashMap<String, String> generatedCids = new HashMap<String, String>();
            StringBuffer stringBuffer = new StringBuffer();
            Matcher matcher = IMG_SRC_PATTERN.matcher(this.textHTML);
            while (matcher.find()) {
                DataSource dataSource;
                String srcLocation = matcher.group("src");
                if (srcLocation.startsWith("cid:")) continue;
                if (!generatedCids.containsKey(srcLocation) && (dataSource = this.resolveDynamicEmbeddedImageDataSource(srcLocation)) != null) {
                    String cid = MiscUtil.randomCid10();
                    generatedCids.put(srcLocation, cid);
                    this.withEmbeddedImage(cid, (DataSource)new NamedDataSource(cid, dataSource));
                }
                if (!generatedCids.containsKey(srcLocation)) continue;
                String imgSrcReplacement = matcher.group("imageTagStart") + "cid:" + (String)generatedCids.get(srcLocation) + matcher.group("imageSrcEnd");
                matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(imgSrcReplacement));
            }
            matcher.appendTail(stringBuffer);
            this.textHTML = stringBuffer.toString();
        }
    }

    @Nullable
    private DataSource resolveDynamicEmbeddedImageDataSource(@NotNull String srcLocation) {
        block7: {
            try {
                DataSource resolvedDataSource = null;
                if (this.embeddedImageAutoResolutionForFiles) {
                    resolvedDataSource = MiscUtil.tryResolveImageFileDataSourceFromDisk((String)this.embeddedImageBaseDir, (boolean)this.allowEmbeddedImageOutsideBaseDir, (String)srcLocation);
                }
                if (resolvedDataSource == null && this.embeddedImageAutoResolutionForClassPathResources) {
                    resolvedDataSource = MiscUtil.tryResolveFileDataSourceFromClassPath((String)this.embeddedImageBaseClassPath, (boolean)this.allowEmbeddedImageOutsideBaseClassPath, (String)srcLocation);
                }
                if (resolvedDataSource == null && this.embeddedImageAutoResolutionForURLs) {
                    resolvedDataSource = MiscUtil.tryResolveUrlDataSource((URL)this.embeddedImageBaseUrl, (boolean)this.allowEmbeddedImageOutsideBaseUrl, (String)srcLocation);
                }
                if (resolvedDataSource == null) {
                    boolean autoresolutionWasAttempted;
                    boolean bl = autoresolutionWasAttempted = this.embeddedImageAutoResolutionForFiles || this.embeddedImageAutoResolutionForClassPathResources || this.embeddedImageAutoResolutionForURLs;
                    if (!autoresolutionWasAttempted || !this.embeddedImageAutoResolutionMustBeSuccesful) {
                        return null;
                    }
                    break block7;
                }
                return resolvedDataSource;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new EmailException(String.format("Unable to dynamically resolve data source for the following image src: %s", srcLocation));
    }

    public EmailPopulatingBuilder fixingMessageId(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Cli.ExcludeApi(reason="API is subset of another API")
    public EmailPopulatingBuilder from(@NotNull String fromAddress) {
        return this.from(null, fromAddress);
    }

    public EmailPopulatingBuilder from(@Nullable String name, @NotNull String fromAddress) {
        return this.from(new Recipient(name, (String)Preconditions.checkNonEmptyArgument((Object)fromAddress, (String)"fromAddress"), null));
    }

    public EmailPopulatingBuilder from(@Nullable String fixedName, @NotNull InternetAddress fromAddress) {
        Preconditions.checkNonEmptyArgument((Object)fromAddress, (String)"fromAddress");
        return this.from(new Recipient(fixedName, fromAddress.getAddress(), null));
    }

    public EmailPopulatingBuilder from(@NotNull InternetAddress fromAddress) {
        Preconditions.checkNonEmptyArgument((Object)fromAddress, (String)"fromAddress");
        return this.from(new Recipient(fromAddress.getPersonal(), fromAddress.getAddress(), null));
    }

    public EmailPopulatingBuilder from(@NotNull Recipient recipient) {
        Preconditions.checkNonEmptyArgument((Object)recipient, (String)"from recipient");
        this.fromRecipient = new Recipient(recipient.getName(), recipient.getAddress(), null);
        return this;
    }

    @Cli.ExcludeApi(reason="API is subset of another API")
    public EmailPopulatingBuilder withReplyTo(@Nullable String replyToAddress) {
        return this.withReplyTo(replyToAddress != null ? new Recipient(null, replyToAddress, null) : null);
    }

    public EmailPopulatingBuilder withReplyTo(@Nullable String fixedName, @NotNull String replyToAddress) {
        Preconditions.checkNonEmptyArgument((Object)replyToAddress, (String)"replyToAddress");
        return this.withReplyTo(new Recipient(fixedName, replyToAddress, null));
    }

    public EmailPopulatingBuilder withReplyTo(@NotNull InternetAddress replyToAddress) {
        Preconditions.checkNonEmptyArgument((Object)replyToAddress, (String)"replyToAddress");
        return this.withReplyTo(new Recipient(replyToAddress.getPersonal(), replyToAddress.getAddress(), null));
    }

    public EmailPopulatingBuilder withReplyTo(@Nullable String fixedName, @NotNull InternetAddress replyToAddress) {
        Preconditions.checkNonEmptyArgument((Object)replyToAddress, (String)"replyToAddress");
        return this.withReplyTo(new Recipient(fixedName, replyToAddress.getAddress(), null));
    }

    public EmailPopulatingBuilder withReplyTo(@Nullable Recipient recipient) {
        this.replyToRecipient = recipient != null ? new Recipient(recipient.getName(), recipient.getAddress(), null) : null;
        return this;
    }

    @Cli.ExcludeApi(reason="API is subset of another API")
    public EmailPopulatingBuilder withBounceTo(@Nullable String bounceToAddress) {
        return this.withBounceTo(bounceToAddress != null ? new Recipient(null, bounceToAddress, null) : null);
    }

    public EmailPopulatingBuilder withBounceTo(@Nullable String name, @NotNull String bounceToAddress) {
        return this.withBounceTo(new Recipient(name, (String)Preconditions.checkNonEmptyArgument((Object)bounceToAddress, (String)"bounceToAddress"), null));
    }

    public EmailPopulatingBuilder withBounceTo(@NotNull InternetAddress bounceToAddress) {
        Preconditions.checkNonEmptyArgument((Object)bounceToAddress, (String)"bounceToAddress");
        return this.withBounceTo(new Recipient(bounceToAddress.getPersonal(), bounceToAddress.getAddress(), null));
    }

    @Cli.ExcludeApi(reason="Method is not detailed enough for CLI")
    public EmailPopulatingBuilder withBounceTo(@Nullable String name, @NotNull InternetAddress bounceToAddress) {
        Preconditions.checkNonEmptyArgument((Object)bounceToAddress, (String)"bounceToAddress");
        return this.withBounceTo(new Recipient(name, bounceToAddress.getAddress(), null));
    }

    public EmailPopulatingBuilder withBounceTo(@Nullable Recipient recipient) {
        this.bounceToRecipient = recipient != null ? new Recipient(recipient.getName(), recipient.getAddress(), null) : null;
        return this;
    }

    public EmailPopulatingBuilder withSubject(@Nullable String subject) {
        this.subject = subject;
        return this;
    }

    @Override
    @NotNull
    public InternalEmailPopulatingBuilder withForward(@Nullable MimeMessage emailMessageToForward) {
        this.emailToForward = emailMessageToForward;
        return this;
    }

    @Cli.OptionNameOverride(value="withPlainTextFromFile")
    public EmailPopulatingBuilder withPlainText(@NotNull File textFile) {
        try {
            return this.withPlainText(MiscUtil.readFileContent((File)textFile));
        }
        catch (IOException e) {
            throw new EmailException(String.format("Error reading from file: %s", textFile), e);
        }
    }

    public EmailPopulatingBuilder withPlainText(@Nullable String text) {
        this.text = text;
        return this;
    }

    @Cli.OptionNameOverride(value="prependTextFromFile")
    public EmailPopulatingBuilder prependText(@NotNull File textFile) {
        try {
            return this.prependText(MiscUtil.readFileContent((File)textFile));
        }
        catch (IOException e) {
            throw new EmailException(String.format("Error reading from file: %s", textFile), e);
        }
    }

    public EmailPopulatingBuilder prependText(@NotNull String text) {
        this.text = text + (String)MiscUtil.defaultTo((Object)this.text, (Object)"");
        return this;
    }

    @Cli.OptionNameOverride(value="appendTextFromFile")
    public EmailPopulatingBuilder appendText(@NotNull File textFile) {
        try {
            return this.appendText(MiscUtil.readFileContent((File)textFile));
        }
        catch (IOException e) {
            throw new EmailException(String.format("Error reading from file: %s", textFile), e);
        }
    }

    public EmailPopulatingBuilder appendText(@NotNull String text) {
        this.text = (String)MiscUtil.defaultTo((Object)this.text, (Object)"") + text;
        return this;
    }

    @Cli.OptionNameOverride(value="withHTMLTextFromFile")
    public EmailPopulatingBuilder withHTMLText(@NotNull File textHTMLFile) {
        try {
            return this.withHTMLText(MiscUtil.readFileContent((File)textHTMLFile));
        }
        catch (IOException e) {
            throw new EmailException(String.format("Error reading from file: %s", textHTMLFile), e);
        }
    }

    public EmailPopulatingBuilder withHTMLText(@Nullable String textHTML) {
        this.textHTML = textHTML;
        return this;
    }

    @Cli.OptionNameOverride(value="prependTextHTMLFromFile")
    public EmailPopulatingBuilder prependTextHTML(@NotNull File textHTMLFile) {
        try {
            return this.prependTextHTML(MiscUtil.readFileContent((File)textHTMLFile));
        }
        catch (IOException e) {
            throw new EmailException(String.format("Error reading from file: %s", textHTMLFile), e);
        }
    }

    public EmailPopulatingBuilder prependTextHTML(@NotNull String textHTML) {
        this.textHTML = textHTML + (String)MiscUtil.defaultTo((Object)this.textHTML, (Object)"");
        return this;
    }

    @Cli.OptionNameOverride(value="appendTextHTMLFromFile")
    public EmailPopulatingBuilder appendTextHTML(@NotNull File textHTMLFile) {
        try {
            return this.appendTextHTML(MiscUtil.readFileContent((File)textHTMLFile));
        }
        catch (IOException e) {
            throw new EmailException(String.format("Error reading from file: %s", textHTMLFile), e);
        }
    }

    public EmailPopulatingBuilder appendTextHTML(@NotNull String textHTML) {
        this.textHTML = (String)MiscUtil.defaultTo((Object)this.textHTML, (Object)"") + textHTML;
        return this;
    }

    public EmailPopulatingBuilder withCalendarText(@NotNull CalendarMethod calendarMethod, @NotNull String textCalendar) {
        this.calendarMethod = calendarMethod;
        this.textCalendar = textCalendar;
        return this;
    }

    public EmailPopulatingBuilder to(Recipient ... recipients) {
        return this.withRecipients(Arrays.asList(recipients), Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder to(@NotNull Collection<Recipient> recipients) {
        return this.withRecipients(recipients, Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder to(@Nullable String name, String oneOrMoreAddresses) {
        return this.withRecipients(name, true, Collections.singletonList(oneOrMoreAddresses), Message.RecipientType.TO);
    }

    @Cli.ExcludeApi(reason="API is subset of another API method")
    public EmailPopulatingBuilder to(@NotNull String oneOrMoreAddresses) {
        return this.withRecipientsWithDefaultName(null, Collections.singletonList(oneOrMoreAddresses), Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder to(@Nullable String name, String ... oneOrMoreAddressesEach) {
        return this.toWithFixedName(name, oneOrMoreAddressesEach);
    }

    public EmailPopulatingBuilder to(@Nullable String name, @NotNull Collection<String> oneOrMoreAddressesEach) {
        return this.toWithFixedName(name, oneOrMoreAddressesEach);
    }

    public EmailPopulatingBuilder toMultiple(String ... oneOrMoreAddressesEach) {
        return this.withRecipientsWithDefaultName(null, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder toMultiple(@NotNull Collection<String> oneOrMoreAddressesEach) {
        return this.withRecipientsWithDefaultName(null, oneOrMoreAddressesEach, Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder toWithFixedName(@Nullable String name, String ... oneOrMoreAddressesEach) {
        return this.withRecipientsWithFixedName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder toWithDefaultName(@NotNull String name, String ... oneOrMoreAddressesEach) {
        return this.withRecipientsWithDefaultName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder toWithFixedName(@Nullable String name, @NotNull Collection<String> oneOrMoreAddressesEach) {
        return this.withRecipientsWithFixedName(name, oneOrMoreAddressesEach, Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder toWithDefaultName(@NotNull String name, @NotNull Collection<String> oneOrMoreAddressesEach) {
        return this.withRecipientsWithDefaultName(name, oneOrMoreAddressesEach, Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder to(@Nullable String name, InternetAddress address) {
        return this.toAddressesWithFixedName(name, address);
    }

    public EmailPopulatingBuilder to(@NotNull InternetAddress address) {
        return this.withAddressesWithDefaultName(null, Collections.singletonList(address), Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder to(@Nullable String name, InternetAddress ... adresses) {
        return this.toAddressesWithFixedName(name, adresses);
    }

    public EmailPopulatingBuilder toAddresses(@Nullable String name, @NotNull Collection<InternetAddress> adresses) {
        return this.toAddressesWithFixedName(name, adresses);
    }

    public EmailPopulatingBuilder toMultiple(InternetAddress ... adresses) {
        return this.withAddressesWithDefaultName(null, Arrays.asList(adresses), Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder toMultipleAddresses(@NotNull Collection<InternetAddress> adresses) {
        return this.withAddressesWithDefaultName(null, adresses, Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder toAddressesWithFixedName(@Nullable String name, InternetAddress ... adresses) {
        return this.withAddressesWithFixedName(name, Arrays.asList(adresses), Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder toAddressesWithDefaultName(@NotNull String name, InternetAddress ... adresses) {
        return this.withAddressesWithDefaultName(name, Arrays.asList(adresses), Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder toAddressesWithFixedName(@Nullable String name, @NotNull Collection<InternetAddress> adresses) {
        return this.withAddressesWithFixedName(name, adresses, Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder toAddressesWithDefaultName(@NotNull String name, @NotNull Collection<InternetAddress> adresses) {
        return this.withAddressesWithDefaultName(name, adresses, Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder cc(Recipient ... recipients) {
        return this.withRecipients(Arrays.asList(recipients), Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder cc(@NotNull Collection<Recipient> recipients) {
        return this.withRecipients(recipients, Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder cc(@Nullable String name, String oneOrMoreAddresses) {
        return this.withRecipients(name, true, Collections.singletonList(oneOrMoreAddresses), Message.RecipientType.CC);
    }

    @Cli.ExcludeApi(reason="API is subset of another API method")
    public EmailPopulatingBuilder cc(@NotNull String oneOrMoreAddresses) {
        return this.withRecipientsWithDefaultName(null, Collections.singletonList(oneOrMoreAddresses), Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder cc(@Nullable String name, String ... oneOrMoreAddressesEach) {
        return this.ccWithFixedName(name, oneOrMoreAddressesEach);
    }

    public EmailPopulatingBuilder cc(@Nullable String name, @NotNull Collection<String> oneOrMoreAddressesEach) {
        return this.ccWithFixedName(name, oneOrMoreAddressesEach);
    }

    public EmailPopulatingBuilder ccMultiple(String ... oneOrMoreAddressesEach) {
        return this.withRecipientsWithDefaultName(null, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder ccAddresses(@NotNull Collection<String> oneOrMoreAddressesEach) {
        return this.withRecipientsWithDefaultName(null, oneOrMoreAddressesEach, Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder ccWithFixedName(@Nullable String name, String ... oneOrMoreAddressesEach) {
        return this.withRecipientsWithFixedName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder ccWithDefaultName(@NotNull String name, String ... oneOrMoreAddressesEach) {
        return this.withRecipientsWithDefaultName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder ccWithFixedName(@Nullable String name, @NotNull Collection<String> oneOrMoreAddressesEach) {
        return this.withRecipientsWithFixedName(name, oneOrMoreAddressesEach, Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder ccWithDefaultName(@NotNull String name, @NotNull Collection<String> oneOrMoreAddressesEach) {
        return this.withRecipientsWithDefaultName(name, oneOrMoreAddressesEach, Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder cc(@Nullable String name, InternetAddress address) {
        return this.ccAddressesWithFixedName(name, address);
    }

    public EmailPopulatingBuilder cc(@NotNull InternetAddress address) {
        return this.withAddressesWithDefaultName(null, Collections.singletonList(address), Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder cc(@Nullable String name, InternetAddress ... adresses) {
        return this.ccAddressesWithFixedName(name, adresses);
    }

    public EmailPopulatingBuilder ccAddresses(@Nullable String name, @NotNull Collection<InternetAddress> adresses) {
        return this.ccAddressesWithFixedName(name, adresses);
    }

    public EmailPopulatingBuilder ccMultiple(InternetAddress ... adresses) {
        return this.withAddressesWithDefaultName(null, Arrays.asList(adresses), Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder ccMultipleAddresses(@NotNull Collection<InternetAddress> adresses) {
        return this.withAddressesWithDefaultName(null, adresses, Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder ccAddressesWithFixedName(@Nullable String name, InternetAddress ... adresses) {
        return this.withAddressesWithFixedName(name, Arrays.asList(adresses), Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder ccAddressesWithDefaultName(@NotNull String name, InternetAddress ... adresses) {
        return this.withAddressesWithDefaultName(name, Arrays.asList(adresses), Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder ccAddressesWithFixedName(@Nullable String name, @NotNull Collection<InternetAddress> adresses) {
        return this.withAddressesWithFixedName(name, adresses, Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder ccAddressesWithDefaultName(@NotNull String name, @NotNull Collection<InternetAddress> adresses) {
        return this.withAddressesWithDefaultName(name, adresses, Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder bcc(Recipient ... recipients) {
        return this.withRecipients(Arrays.asList(recipients), Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bcc(@NotNull Collection<Recipient> recipients) {
        return this.withRecipients(recipients, Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bcc(@Nullable String name, String oneOrMoreAddresses) {
        return this.withRecipients(name, true, Collections.singletonList(oneOrMoreAddresses), Message.RecipientType.BCC);
    }

    @Cli.ExcludeApi(reason="API is subset of another API")
    public EmailPopulatingBuilder bcc(@NotNull String oneOrMoreAddresses) {
        return this.withRecipientsWithDefaultName(null, Collections.singletonList(oneOrMoreAddresses), Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bcc(@Nullable String name, String ... oneOrMoreAddressesEach) {
        return this.bccWithFixedName(name, oneOrMoreAddressesEach);
    }

    public EmailPopulatingBuilder bcc(@Nullable String name, @NotNull Collection<String> oneOrMoreAddressesEach) {
        return this.bccWithFixedName(name, oneOrMoreAddressesEach);
    }

    public EmailPopulatingBuilder bccMultiple(String ... oneOrMoreAddressesEach) {
        return this.withRecipientsWithDefaultName(null, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bccAddresses(@NotNull Collection<String> oneOrMoreAddressesEach) {
        return this.withRecipientsWithDefaultName(null, oneOrMoreAddressesEach, Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bccWithFixedName(@Nullable String name, String ... oneOrMoreAddressesEach) {
        return this.withRecipientsWithFixedName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bccWithDefaultName(@NotNull String name, String ... oneOrMoreAddressesEach) {
        return this.withRecipientsWithDefaultName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bccWithFixedName(@Nullable String name, @NotNull Collection<String> oneOrMoreAddressesEach) {
        return this.withRecipientsWithFixedName(name, oneOrMoreAddressesEach, Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bccWithDefaultName(@NotNull String name, @NotNull Collection<String> oneOrMoreAddressesEach) {
        return this.withRecipientsWithDefaultName(name, oneOrMoreAddressesEach, Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bcc(@Nullable String name, InternetAddress address) {
        return this.bccAddressesWithFixedName(name, address);
    }

    public EmailPopulatingBuilder bcc(@NotNull InternetAddress address) {
        return this.withAddressesWithDefaultName(null, Collections.singletonList(address), Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bcc(@Nullable String name, InternetAddress ... adresses) {
        return this.bccAddressesWithFixedName(name, adresses);
    }

    public EmailPopulatingBuilder bccAddresses(@Nullable String name, @NotNull Collection<InternetAddress> adresses) {
        return this.bccAddressesWithFixedName(name, adresses);
    }

    public EmailPopulatingBuilder bccMultiple(InternetAddress ... adresses) {
        return this.withAddressesWithDefaultName(null, Arrays.asList(adresses), Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bccMultipleAddresses(@NotNull Collection<InternetAddress> adresses) {
        return this.withAddressesWithDefaultName(null, adresses, Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bccAddressesWithFixedName(@Nullable String name, InternetAddress ... adresses) {
        return this.withAddressesWithFixedName(name, Arrays.asList(adresses), Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bccAddressesWithDefaultName(@NotNull String name, InternetAddress ... adresses) {
        return this.withAddressesWithDefaultName(name, Arrays.asList(adresses), Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bccAddressesWithFixedName(@Nullable String name, @NotNull Collection<InternetAddress> adresses) {
        return this.withAddressesWithFixedName(name, adresses, Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bccAddressesWithDefaultName(@NotNull String name, @NotNull Collection<InternetAddress> adresses) {
        return this.withAddressesWithDefaultName(name, adresses, Message.RecipientType.BCC);
    }

    @NotNull
    public EmailPopulatingBuilder withRecipientsWithDefaultName(@Nullable String defaultName, @NotNull Collection<String> oneOrMoreAddressesEach, @Nullable Message.RecipientType recipientType) {
        return this.withRecipients(defaultName, false, oneOrMoreAddressesEach, recipientType);
    }

    @NotNull
    public EmailPopulatingBuilder withRecipientsWithFixedName(@Nullable String fixedName, @NotNull Collection<String> oneOrMoreAddressesEach, @Nullable Message.RecipientType recipientType) {
        return this.withRecipients(fixedName, true, oneOrMoreAddressesEach, recipientType);
    }

    @NotNull
    public EmailPopulatingBuilder withRecipientsWithDefaultName(@Nullable String name, @Nullable Message.RecipientType recipientType, String ... oneOrMoreAddressesEach) {
        return this.withRecipients(name, false, Arrays.asList(oneOrMoreAddressesEach), recipientType);
    }

    @NotNull
    public EmailPopulatingBuilder withRecipientsWithFixedName(@Nullable String name, @Nullable Message.RecipientType recipientType, String ... oneOrMoreAddressesEach) {
        return this.withRecipients(name, true, Arrays.asList(oneOrMoreAddressesEach), recipientType);
    }

    @NotNull
    public EmailPopulatingBuilder withRecipients(@Nullable String name, boolean fixedName, @Nullable Message.RecipientType recipientType, String ... oneOrMoreAddressesEach) {
        return this.withRecipients(name, fixedName, Arrays.asList(oneOrMoreAddressesEach), recipientType);
    }

    @NotNull
    public EmailPopulatingBuilder withRecipients(@Nullable String name, boolean fixedName, @NotNull Collection<String> oneOrMoreAddressesEach, @Nullable Message.RecipientType recipientType) {
        for (String oneOrMoreAddresses : oneOrMoreAddressesEach) {
            for (String emailAddress : MiscUtil.extractEmailAddresses((String)oneOrMoreAddresses)) {
                this.withRecipient(MiscUtil.interpretRecipient((String)name, (boolean)fixedName, (String)emailAddress, (Message.RecipientType)recipientType));
            }
        }
        return this;
    }

    @NotNull
    public EmailPopulatingBuilder withAddressesWithDefaultName(@Nullable String defaultName, @NotNull Collection<InternetAddress> addresses, @Nullable Message.RecipientType recipientType) {
        return this.withAddresses(defaultName, false, addresses, recipientType);
    }

    @NotNull
    public EmailPopulatingBuilder withAddressesWithFixedName(@Nullable String fixedName, @NotNull Collection<InternetAddress> addresses, @Nullable Message.RecipientType recipientType) {
        return this.withAddresses(fixedName, true, addresses, recipientType);
    }

    @NotNull
    public EmailPopulatingBuilder withAddresses(@Nullable String name, boolean fixedName, @NotNull Collection<InternetAddress> addresses, @Nullable Message.RecipientType recipientType) {
        for (InternetAddress address : addresses) {
            String effectiveName = fixedName || MiscUtil.valueNullOrEmpty((Object)address.getPersonal()) ? name : address.getPersonal();
            this.withRecipient(effectiveName, address.getAddress(), recipientType);
        }
        return this;
    }

    public EmailPopulatingBuilder withRecipients(@NotNull Collection<Recipient> recipients) {
        return this.withRecipients(recipients, null);
    }

    public EmailPopulatingBuilder withRecipients(Recipient ... recipients) {
        return this.withRecipients(Arrays.asList(recipients), null);
    }

    @NotNull
    public EmailPopulatingBuilder withRecipients(@NotNull Collection<Recipient> recipients, @Nullable Message.RecipientType fixedRecipientType) {
        for (Recipient recipient : recipients) {
            this.withRecipient(recipient.getName(), recipient.getAddress(), (Message.RecipientType)MiscUtil.defaultTo((Object)fixedRecipientType, (Object)recipient.getType()));
        }
        return this;
    }

    public EmailPopulatingBuilder withRecipient(@NotNull String singleAddress, @Nullable Message.RecipientType recipientType) {
        return this.withRecipient(null, singleAddress, recipientType);
    }

    public EmailPopulatingBuilder withRecipient(@Nullable String name, @NotNull String singleAddress, @Nullable Message.RecipientType recipientType) {
        this.recipients.add(MiscUtil.interpretRecipient((String)name, (boolean)true, (String)singleAddress, (Message.RecipientType)recipientType));
        return this;
    }

    public EmailPopulatingBuilder withRecipient(@NotNull Recipient recipient) {
        this.recipients.add(new Recipient(recipient.getName(), recipient.getAddress(), recipient.getType()));
        return this;
    }

    public EmailPopulatingBuilder withEmbeddedImageBaseDir(@NotNull String embeddedImageBaseDir) {
        this.embeddedImageBaseDir = (String)Preconditions.checkNonEmptyArgument((Object)embeddedImageBaseDir, (String)"embeddedImageBaseDir");
        return this;
    }

    public EmailPopulatingBuilder withEmbeddedImageAutoResolutionForFiles(boolean embeddedImageAutoResolutionForFiles) {
        this.embeddedImageAutoResolutionForFiles = embeddedImageAutoResolutionForFiles;
        return this;
    }

    public EmailPopulatingBuilder withEmbeddedImageAutoResolutionForClassPathResources(boolean embeddedImageAutoResolutionForClassPathResources) {
        this.embeddedImageAutoResolutionForClassPathResources = embeddedImageAutoResolutionForClassPathResources;
        return this;
    }

    public EmailPopulatingBuilder withEmbeddedImageAutoResolutionForURLs(boolean embeddedImageAutoResolutionForURLs) {
        this.embeddedImageAutoResolutionForURLs = embeddedImageAutoResolutionForURLs;
        return this;
    }

    public EmailPopulatingBuilder withEmbeddedImageBaseClassPath(@NotNull String embeddedImageBaseClassPath) {
        this.embeddedImageBaseClassPath = (String)Preconditions.checkNonEmptyArgument((Object)embeddedImageBaseClassPath, (String)"embeddedImageBaseClassPath");
        return this;
    }

    public EmailPopulatingBuilder withEmbeddedImageBaseUrl(@NotNull String embeddedImageBaseUrl) {
        try {
            return this.withEmbeddedImageBaseUrl(new URL(embeddedImageBaseUrl));
        }
        catch (MalformedURLException e) {
            throw new EmailException(String.format("Unable to parse URL: %s", embeddedImageBaseUrl), e);
        }
    }

    public EmailPopulatingBuilder withEmbeddedImageBaseUrl(@NotNull URL embeddedImageBaseUrl) {
        this.embeddedImageBaseUrl = (URL)Preconditions.checkNonEmptyArgument((Object)embeddedImageBaseUrl, (String)"embeddedImageBaseUrl");
        return this;
    }

    public EmailPopulatingBuilder allowingEmbeddedImageOutsideBaseDir(boolean allowEmbeddedImageOutsideBaseDir) {
        this.allowEmbeddedImageOutsideBaseDir = allowEmbeddedImageOutsideBaseDir;
        return this;
    }

    public EmailPopulatingBuilder allowingEmbeddedImageOutsideBaseClassPath(boolean allowEmbeddedImageOutsideBaseClassPath) {
        this.allowEmbeddedImageOutsideBaseClassPath = allowEmbeddedImageOutsideBaseClassPath;
        return this;
    }

    public EmailPopulatingBuilder allowingEmbeddedImageOutsideBaseUrl(boolean allowEmbeddedImageOutsideBaseUrl) {
        this.allowEmbeddedImageOutsideBaseUrl = allowEmbeddedImageOutsideBaseUrl;
        return this;
    }

    public EmailPopulatingBuilder embeddedImageAutoResolutionMustBeSuccesful(boolean embeddedImageAutoResolutionMustBeSuccesful) {
        this.embeddedImageAutoResolutionMustBeSuccesful = embeddedImageAutoResolutionMustBeSuccesful;
        return this;
    }

    public EmailPopulatingBuilder withEmbeddedImage(@NotNull String name, @NotNull byte[] data, @NotNull String mimetype) {
        Preconditions.checkNonEmptyArgument((Object)name, (String)"name");
        Preconditions.checkNonEmptyArgument((Object)data, (String)"data");
        Preconditions.checkNonEmptyArgument((Object)mimetype, (String)"mimetype");
        ByteArrayDataSource dataSource = new ByteArrayDataSource(data, mimetype);
        dataSource.setName(name);
        return this.withEmbeddedImage(name, (DataSource)dataSource);
    }

    public EmailPopulatingBuilder withEmbeddedImage(@Nullable String name, @NotNull DataSource imagedata) {
        Preconditions.checkNonEmptyArgument((Object)imagedata, (String)"imagedata");
        if (MiscUtil.valueNullOrEmpty((Object)name) && MiscUtil.valueNullOrEmpty((Object)imagedata.getName())) {
            throw new EmailException("No name given for embedded image nor passed inside the data source");
        }
        this.embeddedImages.add(new AttachmentResource(name, imagedata));
        return this;
    }

    public EmailPopulatingBuilder withEmbeddedImages(@NotNull List<AttachmentResource> embeddedImages) {
        for (AttachmentResource embeddedImage : embeddedImages) {
            this.withEmbeddedImage(embeddedImage.getName(), embeddedImage.getDataSource());
        }
        return this;
    }

    public <T> EmailPopulatingBuilder withHeaders(@NotNull Map<String, Collection<T>> headers) {
        return this.withHeaders(headers, false);
    }

    @Override
    @NotNull
    public <T> InternalEmailPopulatingBuilder withHeaders(@NotNull Map<String, Collection<T>> headers, boolean ignoreSmimeMessageId) {
        for (Map.Entry<String, Collection<T>> headerEntry : headers.entrySet()) {
            for (T headerValue : headerEntry.getValue()) {
                if (ignoreSmimeMessageId && SmimeRecognitionUtil.isGeneratedSmimeMessageId((String)headerEntry.getKey(), headerValue)) continue;
                this.withHeader(headerEntry.getKey(), headerValue);
            }
        }
        return this;
    }

    public EmailPopulatingBuilder withHeader(@NotNull String name, @Nullable Object value) {
        Preconditions.checkNonEmptyArgument((Object)name, (String)"name");
        if (!this.headers.containsKey(name)) {
            this.headers.put(name, new ArrayList());
        }
        this.headers.get(name).add(value != null ? String.valueOf(value) : null);
        return this;
    }

    public EmailPopulatingBuilder withAttachment(@Nullable String name, @NotNull byte[] data, @NotNull String mimetype) {
        Preconditions.checkNonEmptyArgument((Object)data, (String)"data");
        Preconditions.checkNonEmptyArgument((Object)mimetype, (String)"mimetype");
        ByteArrayDataSource dataSource = new ByteArrayDataSource(data, mimetype);
        dataSource.setName(name);
        this.withAttachment(name, (DataSource)dataSource);
        return this;
    }

    public EmailPopulatingBuilder withAttachment(@Nullable String name, @NotNull DataSource filedata) {
        Preconditions.checkNonEmptyArgument((Object)filedata, (String)"filedata");
        this.attachments.add(new AttachmentResource(name, filedata));
        return this;
    }

    public EmailPopulatingBuilder withAttachments(@NotNull List<AttachmentResource> attachments) {
        for (AttachmentResource attachment : attachments) {
            this.withAttachment(attachment.getName(), attachment.getDataSource());
        }
        return this;
    }

    @Override
    @NotNull
    public InternalEmailPopulatingBuilder withDecryptedAttachments(@NotNull List<AttachmentResource> attachments) {
        this.decryptedAttachments.addAll(attachments);
        return this;
    }

    @Cli.ExcludeApi(reason="delegated method is an identical api from CLI point of view")
    public EmailPopulatingBuilder signWithDomainKey(@NotNull String dkimPrivateKey, @NotNull String signingDomain, @NotNull String dkimSelector) {
        Preconditions.checkNonEmptyArgument((Object)dkimPrivateKey, (String)"dkimPrivateKey");
        return this.signWithDomainKey(dkimPrivateKey.getBytes(StandardCharsets.UTF_8), signingDomain, dkimSelector);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Cli.ExcludeApi(reason="delegated method is an identical api from CLI point of view")
    public EmailPopulatingBuilder signWithDomainKey(@NotNull File dkimPrivateKeyFile, @NotNull String signingDomain, @NotNull String dkimSelector) {
        Preconditions.checkNonEmptyArgument((Object)dkimPrivateKeyFile, (String)"dkimPrivateKeyFile");
        try (FileInputStream dkimPrivateKeyInputStream = new FileInputStream(dkimPrivateKeyFile);){
            EmailPopulatingBuilder emailPopulatingBuilder = this.signWithDomainKey(dkimPrivateKeyInputStream, signingDomain, dkimSelector);
            return emailPopulatingBuilder;
        }
        catch (IOException e) {
            throw new EmailException(String.format("Error reading from file: %s", dkimPrivateKeyFile), e);
        }
    }

    public EmailPopulatingBuilder signWithDomainKey(@NotNull InputStream dkimPrivateKeyInputStream, @NotNull String signingDomain, @NotNull String dkimSelector) {
        Preconditions.checkNonEmptyArgument((Object)dkimPrivateKeyInputStream, (String)"dkimPrivateKeyInputStream");
        try {
            this.signWithDomainKey(MiscUtil.readInputStreamToBytes((InputStream)dkimPrivateKeyInputStream), signingDomain, dkimSelector);
        }
        catch (IOException e) {
            throw new EmailException("Was unable to read DKIM data from input stream", e);
        }
        return this;
    }

    @Cli.ExcludeApi(reason="delegated method is an identical api from CLI point of view")
    public EmailPopulatingBuilder signWithDomainKey(@NotNull byte[] dkimPrivateKey, @NotNull String signingDomain, @NotNull String dkimSelector) {
        this.dkimPrivateKeyData = (byte[])Preconditions.checkNonEmptyArgument((Object)dkimPrivateKey, (String)"dkimPrivateKey");
        this.dkimSigningDomain = (String)Preconditions.checkNonEmptyArgument((Object)signingDomain, (String)"dkimSigningDomain");
        this.dkimSelector = (String)Preconditions.checkNonEmptyArgument((Object)dkimSelector, (String)"dkimSelector");
        return this;
    }

    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="Input stream being created should not be closed here")
    public EmailPopulatingBuilder signWithSmime(@NotNull File pkcs12StoreFile, @NotNull String storePassword, @NotNull String keyAlias, @NotNull String keyPassword) {
        try {
            return this.signWithSmime(new FileInputStream(pkcs12StoreFile), storePassword, keyAlias, keyPassword);
        }
        catch (IOException e) {
            throw new EmailException(String.format("Error reading from file: %s", pkcs12StoreFile), e);
        }
    }

    public EmailPopulatingBuilder signWithSmime(@NotNull InputStream pkcs12StoreStream, @NotNull String storePassword, @NotNull String keyAlias, @NotNull String keyPassword) {
        byte[] pkcs12StoreData;
        try {
            pkcs12StoreData = MiscUtil.readInputStreamToBytes((InputStream)pkcs12StoreStream);
        }
        catch (IOException e) {
            throw new EmailException("Was unable to read S/MIME data from input stream", e);
        }
        return this.signWithSmime(pkcs12StoreData, storePassword, keyAlias, keyPassword);
    }

    public EmailPopulatingBuilder signWithSmime(@NotNull byte[] pkcs12StoreData, @NotNull String storePassword, @NotNull String keyAlias, @NotNull String keyPassword) {
        return this.signWithSmime(Pkcs12Config.builder().pkcs12Store(pkcs12StoreData).storePassword(storePassword).keyAlias(keyAlias).keyPassword(keyPassword).build());
    }

    public EmailPopulatingBuilder signWithSmime(@NotNull Pkcs12Config pkcs12Config) {
        this.pkcs12ConfigForSmimeSigning = pkcs12Config;
        return this;
    }

    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="Input stream being created should not be closed here")
    public EmailPopulatingBuilder encryptWithSmime(@NotNull String pemFile) {
        try {
            return this.encryptWithSmime(new FileInputStream(new File(pemFile)));
        }
        catch (FileNotFoundException e) {
            throw new EmailException(String.format("Error reading from file: %s", pemFile), e);
        }
    }

    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="Input stream being created should not be closed here")
    public EmailPopulatingBuilder encryptWithSmime(@NotNull File pemFile) {
        try {
            return this.encryptWithSmime(new FileInputStream(pemFile));
        }
        catch (FileNotFoundException e) {
            throw new EmailException(String.format("Error reading from file: %s", pemFile), e);
        }
    }

    public EmailPopulatingBuilder encryptWithSmime(@NotNull InputStream pemStream) {
        try {
            return this.encryptWithSmime(CertificationUtil.readFromPem((InputStream)pemStream));
        }
        catch (CertificateException e) {
            throw new EmailException("Was unable to convert PEM data to X509 certificate", e);
        }
        catch (NoSuchProviderException e) {
            throw new EmailException("Unable to load certificate (missing bouncy castle), is the S/MIME module on the class path?", e);
        }
    }

    public EmailPopulatingBuilder encryptWithSmime(@NotNull X509Certificate x509Certificate) {
        this.x509CertificateForSmimeEncryption = x509Certificate;
        return this;
    }

    @Cli.OptionNameOverride(value="withDispositionNotificationToEnabled")
    public EmailPopulatingBuilder withDispositionNotificationTo() {
        this.useDispositionNotificationTo = true;
        this.dispositionNotificationTo = null;
        return this;
    }

    @Cli.ExcludeApi(reason="API is subset of another API")
    public EmailPopulatingBuilder withDispositionNotificationTo(@NotNull String address) {
        Preconditions.checkNonEmptyArgument((Object)address, (String)"dispositionNotificationToAddress");
        return this.withDispositionNotificationTo(new Recipient(null, address, null));
    }

    public EmailPopulatingBuilder withDispositionNotificationTo(@Nullable String name, @NotNull String address) {
        Preconditions.checkNonEmptyArgument((Object)address, (String)"dispositionNotificationToAddress");
        return this.withDispositionNotificationTo(new Recipient(name, address, null));
    }

    public EmailPopulatingBuilder withDispositionNotificationTo(@NotNull InternetAddress address) {
        Preconditions.checkNonEmptyArgument((Object)address, (String)"dispositionNotificationToAddress");
        return this.withDispositionNotificationTo(new Recipient(address.getPersonal(), address.getAddress(), null));
    }

    public EmailPopulatingBuilder withDispositionNotificationTo(@Nullable String fixedName, @NotNull InternetAddress address) {
        Preconditions.checkNonEmptyArgument((Object)address, (String)"dispositionNotificationToAddress");
        return this.withDispositionNotificationTo(new Recipient(fixedName, address.getAddress(), null));
    }

    public EmailPopulatingBuilder withDispositionNotificationTo(@NotNull Recipient recipient) {
        Preconditions.checkNonEmptyArgument((Object)recipient.getAddress(), (String)"recipient.address");
        this.useDispositionNotificationTo = true;
        this.dispositionNotificationTo = new Recipient(recipient.getName(), recipient.getAddress(), null);
        return this;
    }

    @Cli.OptionNameOverride(value="withReturnReceiptToEnabled")
    public EmailPopulatingBuilder withReturnReceiptTo() {
        this.useReturnReceiptTo = true;
        this.returnReceiptTo = null;
        return this;
    }

    @Cli.ExcludeApi(reason="API is subset of another API")
    public EmailPopulatingBuilder withReturnReceiptTo(@NotNull String address) {
        Preconditions.checkNonEmptyArgument((Object)address, (String)"address");
        return this.withReturnReceiptTo(new Recipient(null, address, null));
    }

    public EmailPopulatingBuilder withReturnReceiptTo(@Nullable String name, @NotNull String address) {
        Preconditions.checkNonEmptyArgument((Object)address, (String)"address");
        return this.withReturnReceiptTo(new Recipient(name, address, null));
    }

    public EmailPopulatingBuilder withReturnReceiptTo(@NotNull InternetAddress address) {
        Preconditions.checkNonEmptyArgument((Object)address, (String)"address");
        return this.withReturnReceiptTo(new Recipient(address.getPersonal(), address.getAddress(), null));
    }

    public EmailPopulatingBuilder withReturnReceiptTo(@Nullable String fixedName, @NotNull InternetAddress address) {
        Preconditions.checkNonEmptyArgument((Object)address, (String)"address");
        return this.withReturnReceiptTo(new Recipient(fixedName, address.getAddress(), null));
    }

    public EmailPopulatingBuilder withReturnReceiptTo(@NotNull Recipient recipient) {
        Preconditions.checkNonEmptyArgument((Object)recipient.getAddress(), (String)"recipient.address");
        this.useReturnReceiptTo = true;
        this.returnReceiptTo = new Recipient(recipient.getName(), recipient.getAddress(), null);
        return this;
    }

    @Override
    @NotNull
    public InternalEmailPopulatingBuilder withOriginalSmimeDetails(@NotNull OriginalSmimeDetails originalSmimeDetails) {
        this.originalSmimeDetails = originalSmimeDetails;
        return this;
    }

    @Override
    @NotNull
    public InternalEmailPopulatingBuilder withSmimeSignedEmail(@NotNull Email smimeSignedEmail) {
        this.smimeSignedEmail = smimeSignedEmail;
        return this;
    }

    public EmailPopulatingBuilder fixingSentDate(@NotNull Date sentDate) {
        this.sentDate = new Date(sentDate.getTime());
        return this;
    }

    public EmailPopulatingBuilder notMergingSingleSMIMESignedAttachment() {
        this.mergeSingleSMIMESignedAttachment = false;
        return this;
    }

    public EmailPopulatingBuilder clearId() {
        this.id = null;
        return this;
    }

    public EmailPopulatingBuilder clearFromRecipient() {
        this.fromRecipient = null;
        return this;
    }

    public EmailPopulatingBuilder clearReplyTo() {
        this.replyToRecipient = null;
        return this;
    }

    public EmailPopulatingBuilder clearBounceTo() {
        this.bounceToRecipient = null;
        return this;
    }

    public EmailPopulatingBuilder clearPlainText() {
        this.text = null;
        return this;
    }

    public EmailPopulatingBuilder clearHTMLText() {
        this.textHTML = null;
        return this;
    }

    public EmailPopulatingBuilder clearSubject() {
        this.subject = null;
        return this;
    }

    public EmailPopulatingBuilder clearRecipients() {
        this.recipients.clear();
        return this;
    }

    public EmailPopulatingBuilder clearEmbeddedImageBaseDir() {
        this.embeddedImageBaseDir = null;
        return this;
    }

    public EmailPopulatingBuilder clearEmbeddedImageBaseClassPath() {
        this.embeddedImageBaseClassPath = null;
        return this;
    }

    public EmailPopulatingBuilder clearEmbeddedImageBaseUrl() {
        this.embeddedImageBaseUrl = null;
        return this;
    }

    public EmailPopulatingBuilder clearEmbeddedImages() {
        this.embeddedImages.clear();
        return this;
    }

    public EmailPopulatingBuilder clearAttachments() {
        this.attachments.clear();
        return this;
    }

    public EmailPopulatingBuilder clearHeaders() {
        this.headers.clear();
        return this;
    }

    public EmailPopulatingBuilder clearDkim() {
        this.dkimPrivateKeyData = null;
        this.dkimSigningDomain = null;
        this.dkimSelector = null;
        return this;
    }

    public EmailPopulatingBuilder clearSmime() {
        this.pkcs12ConfigForSmimeSigning = null;
        this.x509CertificateForSmimeEncryption = null;
        return this;
    }

    public EmailPopulatingBuilder clearDispositionNotificationTo() {
        this.useDispositionNotificationTo = false;
        this.dispositionNotificationTo = null;
        return this;
    }

    public EmailPopulatingBuilder clearReturnReceiptTo() {
        this.useReturnReceiptTo = false;
        this.returnReceiptTo = null;
        return this;
    }

    public EmailPopulatingBuilder clearSentDate() {
        this.sentDate = null;
        return this;
    }

    public EmailPopulatingBuilder clearSMIMESignedAttachmentMergingBehavior() {
        this.mergeSingleSMIMESignedAttachment = true;
        return this;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public Recipient getFromRecipient() {
        return this.fromRecipient;
    }

    @Nullable
    public Recipient getReplyToRecipient() {
        return this.replyToRecipient;
    }

    @Nullable
    public Recipient getBounceToRecipient() {
        return this.bounceToRecipient;
    }

    @Nullable
    public String getText() {
        return this.text;
    }

    @Nullable
    public String getTextHTML() {
        return this.textHTML;
    }

    @Nullable
    public CalendarMethod getCalendarMethod() {
        return this.calendarMethod;
    }

    @Nullable
    public String getTextCalendar() {
        return this.textCalendar;
    }

    @Nullable
    public String getSubject() {
        return this.subject;
    }

    @NotNull
    public List<Recipient> getRecipients() {
        return new ArrayList<Recipient>(this.recipients);
    }

    @NotNull
    public List<AttachmentResource> getEmbeddedImages() {
        return new ArrayList<AttachmentResource>(this.embeddedImages);
    }

    @NotNull
    public List<AttachmentResource> getAttachments() {
        return new ArrayList<AttachmentResource>(this.attachments);
    }

    @NotNull
    public List<AttachmentResource> getDecryptedAttachments() {
        return this.decryptedAttachments;
    }

    @NotNull
    public Map<String, Collection<String>> getHeaders() {
        return new HashMap<String, Collection<String>>(this.headers);
    }

    @Nullable
    public byte[] getDkimPrivateKeyData() {
        return this.dkimPrivateKeyData;
    }

    @Nullable
    public String getDkimSigningDomain() {
        return this.dkimSigningDomain;
    }

    @Nullable
    public String getDkimSelector() {
        return this.dkimSelector;
    }

    public boolean isUseDispositionNotificationTo() {
        return this.useDispositionNotificationTo;
    }

    @Nullable
    public Recipient getDispositionNotificationTo() {
        return this.dispositionNotificationTo;
    }

    public boolean isUseReturnReceiptTo() {
        return this.useReturnReceiptTo;
    }

    @Nullable
    public Recipient getReturnReceiptTo() {
        return this.returnReceiptTo;
    }

    @Nullable
    public MimeMessage getEmailToForward() {
        return this.emailToForward;
    }

    @NotNull
    public OriginalSmimeDetails getOriginalSmimeDetails() {
        return this.originalSmimeDetails;
    }

    @Nullable
    public Email getSmimeSignedEmail() {
        return this.smimeSignedEmail;
    }

    public boolean isMergeSingleSMIMESignedAttachment() {
        return this.mergeSingleSMIMESignedAttachment;
    }

    @Nullable
    public Pkcs12Config getPkcs12ConfigForSmimeSigning() {
        return this.pkcs12ConfigForSmimeSigning;
    }

    @Nullable
    public X509Certificate getX509CertificateForSmimeEncryption() {
        return this.x509CertificateForSmimeEncryption;
    }

    @Nullable
    public Date getSentDate() {
        return this.sentDate != null ? new Date(this.sentDate.getTime()) : null;
    }
}

