/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.hazlewood.connor.bottema.emailaddress.EmailAddressCriteria;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.mailer.CustomMailer;
import org.simplejavamail.api.mailer.config.EmailGovernance;
import org.simplejavamail.api.mailer.config.LoadBalancingStrategy;
import org.simplejavamail.api.mailer.config.OperationalConfig;
import org.simplejavamail.api.mailer.config.Pkcs12Config;
import org.simplejavamail.api.mailer.config.ProxyConfig;
import org.simplejavamail.config.ConfigLoader;
import org.simplejavamail.internal.modules.ModuleLoader;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;
import org.simplejavamail.mailer.internal.EmailGovernanceImpl;
import org.simplejavamail.mailer.internal.InternalMailerBuilder;
import org.simplejavamail.mailer.internal.MailerException;
import org.simplejavamail.mailer.internal.OperationalConfigImpl;
import org.simplejavamail.mailer.internal.ProxyConfigImpl;

abstract class MailerGenericBuilderImpl<T extends MailerGenericBuilderImpl<?>>
implements InternalMailerBuilder<T> {
    private boolean async;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    @NotNull
    private Integer proxyBridgePort;
    private boolean debugLogging;
    @NotNull
    private Integer sessionTimeout;
    @NotNull
    private EnumSet<EmailAddressCriteria> emailAddressCriteria;
    @Nullable
    private Pkcs12Config pkcs12ConfigForSmimeSigning;
    @Nullable
    private ExecutorService executorService;
    @NotNull
    private Integer threadPoolSize;
    @NotNull
    private Integer threadPoolKeepAliveTime;
    @NotNull
    private UUID clusterKey;
    @NotNull
    private Integer connectionPoolCoreSize;
    @NotNull
    private Integer connectionPoolMaxSize;
    @NotNull
    private Integer connectionPoolClaimTimeoutMillis;
    @NotNull
    private Integer connectionPoolExpireAfterMillis;
    @NotNull
    private LoadBalancingStrategy connectionPoolLoadBalancingStrategy;
    @NotNull
    private List<String> sslHostsToTrust = new ArrayList<String>();
    private boolean trustAllSSLHost;
    private boolean verifyingServerIdentity;
    @NotNull
    private final Properties properties = new Properties();
    private boolean transportModeLoggingOnly;
    @Nullable
    private CustomMailer customMailer;

    MailerGenericBuilderImpl() {
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.PROXY_HOST)) {
            this.proxyHost = ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.PROXY_HOST);
        }
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.PROXY_USERNAME)) {
            this.proxyUsername = ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.PROXY_USERNAME);
        }
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.PROXY_PASSWORD)) {
            this.proxyPassword = ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.PROXY_PASSWORD);
        }
        this.clusterKey = ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CONNECTIONPOOL_CLUSTER_KEY) ? UUID.fromString((String)Preconditions.assumeNonNull((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CONNECTIONPOOL_CLUSTER_KEY))) : UUID.randomUUID();
        this.proxyPort = (Integer)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsInteger(null, (ConfigLoader.Property)ConfigLoader.Property.PROXY_PORT, (Integer)1080));
        this.proxyBridgePort = (Integer)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsInteger(null, (ConfigLoader.Property)ConfigLoader.Property.PROXY_SOCKS5BRIDGE_PORT, (Integer)1081));
        this.debugLogging = (Boolean)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsBoolean(null, (ConfigLoader.Property)ConfigLoader.Property.JAVAXMAIL_DEBUG, (Boolean)false));
        this.sessionTimeout = (Integer)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsInteger(null, (ConfigLoader.Property)ConfigLoader.Property.DEFAULT_SESSION_TIMEOUT_MILLIS, (Integer)60000));
        this.trustAllSSLHost = (Boolean)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsBoolean(null, (ConfigLoader.Property)ConfigLoader.Property.DEFAULT_TRUST_ALL_HOSTS, (Boolean)true));
        this.verifyingServerIdentity = (Boolean)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsBoolean(null, (ConfigLoader.Property)ConfigLoader.Property.DEFAULT_VERIFY_SERVER_IDENTITY, (Boolean)true));
        this.threadPoolSize = (Integer)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsInteger(null, (ConfigLoader.Property)ConfigLoader.Property.DEFAULT_POOL_SIZE, (Integer)10));
        this.threadPoolKeepAliveTime = (Integer)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsInteger(null, (ConfigLoader.Property)ConfigLoader.Property.DEFAULT_POOL_KEEP_ALIVE_TIME, (Integer)1));
        this.connectionPoolCoreSize = (Integer)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsInteger(null, (ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CONNECTIONPOOL_CORE_SIZE, (Integer)0));
        this.connectionPoolMaxSize = (Integer)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsInteger(null, (ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CONNECTIONPOOL_MAX_SIZE, (Integer)4));
        this.connectionPoolClaimTimeoutMillis = (Integer)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsInteger(null, (ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CONNECTIONPOOL_CLAIMTIMEOUT_MILLIS, (Integer)Integer.MAX_VALUE));
        this.connectionPoolExpireAfterMillis = (Integer)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsInteger(null, (ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CONNECTIONPOOL_EXPIREAFTER_MILLIS, (Integer)5000));
        this.connectionPoolLoadBalancingStrategy = (LoadBalancingStrategy)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrProperty(null, (ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CONNECTIONPOOL_LOADBALANCING_STRATEGY, (Object)LoadBalancingStrategy.valueOf((String)"ROUND_ROBIN")));
        this.transportModeLoggingOnly = (Boolean)Preconditions.assumeNonNull((Object)ConfigLoader.valueOrPropertyAsBoolean(null, (ConfigLoader.Property)ConfigLoader.Property.TRANSPORT_MODE_LOGGING_ONLY, (Boolean)false));
        String trustedHosts = ConfigLoader.valueOrPropertyAsString(null, (ConfigLoader.Property)ConfigLoader.Property.DEFAULT_TRUSTED_HOSTS, null);
        if (trustedHosts != null) {
            this.sslHostsToTrust = Arrays.asList(trustedHosts.split(";"));
        }
        this.emailAddressCriteria = EmailAddressCriteria.RFC_COMPLIANT.clone();
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.SMIME_SIGNING_KEYSTORE)) {
            this.signByDefaultWithSmime(Pkcs12Config.builder().pkcs12Store((String)Preconditions.assumeNonNull((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.SMIME_SIGNING_KEYSTORE))).storePassword((String)Preconditions.checkNonEmptyArgument((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.SMIME_SIGNING_KEYSTORE_PASSWORD), (String)"Keystore password property")).keyAlias((String)Preconditions.checkNonEmptyArgument((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.SMIME_SIGNING_KEY_ALIAS), (String)"Key alias property")).keyPassword((String)Preconditions.checkNonEmptyArgument((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.SMIME_SIGNING_KEY_PASSWORD), (String)"Key password property")).build());
        }
    }

    ProxyConfig buildProxyConfig() {
        this.validateProxy();
        return new ProxyConfigImpl(this.getProxyHost(), this.getProxyPort(), this.getProxyUsername(), this.getProxyPassword(), this.getProxyBridgePort());
    }

    private void validateProxy() {
        if (!MiscUtil.valueNullOrEmpty((Object)this.proxyHost)) {
            MiscUtil.checkArgumentNotEmpty((Object)this.proxyPort, (String)"proxyHost provided, but not a proxyPort");
            if (!MiscUtil.valueNullOrEmpty((Object)this.proxyUsername) && MiscUtil.valueNullOrEmpty((Object)this.proxyPassword)) {
                throw new IllegalArgumentException("Proxy username provided but not a password");
            }
            if (MiscUtil.valueNullOrEmpty((Object)this.proxyUsername) && !MiscUtil.valueNullOrEmpty((Object)this.proxyPassword)) {
                throw new IllegalArgumentException("Proxy password provided but not a username");
            }
            if (!MiscUtil.valueNullOrEmpty((Object)this.proxyUsername) && MiscUtil.valueNullOrEmpty((Object)this.proxyBridgePort)) {
                throw new IllegalArgumentException("Cannot authenticate with proxy if no proxy bridge port is configured");
            }
        }
    }

    EmailGovernance buildEmailGovernance() {
        return new EmailGovernanceImpl((EnumSet)Preconditions.assumeNonNull(this.getEmailAddressCriteria()), this.getPkcs12ConfigForSmimeSigning());
    }

    OperationalConfig buildOperationalConfig() {
        return new OperationalConfigImpl(this.isAsync(), this.getProperties(), this.getSessionTimeout(), this.getThreadPoolSize(), this.getThreadPoolKeepAliveTime(), this.getClusterKey(), this.getConnectionPoolCoreSize(), this.getConnectionPoolMaxSize(), this.getConnectionPoolClaimTimeoutMillis(), this.getConnectionPoolExpireAfterMillis(), this.getConnectionPoolLoadBalancingStrategy(), this.isTransportModeLoggingOnly(), this.isDebugLogging(), this.getSslHostsToTrust(), this.isTrustAllSSLHost(), this.isVerifyingServerIdentity(), this.getExecutorService() != null ? this.getExecutorService() : this.determineDefaultExecutorService(), this.isExecutorServiceUserProvided(), this.getCustomMailer());
    }

    public T async() {
        this.async = true;
        return (T)this;
    }

    public T withProxy(@Nullable String proxyHost, @Nullable Integer proxyPort) {
        return (T)this.withProxyHost(proxyHost).withProxyPort(proxyPort);
    }

    public T withProxy(@Nullable String proxyHost, @Nullable Integer proxyPort, @Nullable String proxyUsername, @Nullable String proxyPassword) {
        return (T)this.withProxyHost(proxyHost).withProxyPort(proxyPort).withProxyUsername(proxyUsername).withProxyPassword(proxyPassword);
    }

    public T withProxyHost(@Nullable String proxyHost) {
        this.proxyHost = proxyHost;
        return (T)this;
    }

    public T withProxyPort(@Nullable Integer proxyPort) {
        this.proxyPort = proxyPort;
        return (T)this;
    }

    public T withProxyUsername(@Nullable String proxyUsername) {
        this.proxyUsername = proxyUsername;
        return (T)this;
    }

    public T withProxyPassword(@Nullable String proxyPassword) {
        this.proxyPassword = proxyPassword;
        return (T)this;
    }

    public T withProxyBridgePort(@NotNull Integer proxyBridgePort) {
        this.proxyBridgePort = proxyBridgePort;
        return (T)this;
    }

    public T withDebugLogging(@NotNull Boolean debugLogging) {
        this.debugLogging = debugLogging;
        return (T)this;
    }

    public T withSessionTimeout(@NotNull Integer sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        return (T)this;
    }

    public T withEmailAddressCriteria(@NotNull EnumSet<EmailAddressCriteria> emailAddressCriteria) {
        this.emailAddressCriteria = emailAddressCriteria.clone();
        return (T)this;
    }

    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="Input stream being created should not be closed here")
    public T signByDefaultWithSmime(@NotNull File pkcs12StoreFile, @NotNull String storePassword, @NotNull String keyAlias, @NotNull String keyPassword) {
        try {
            return (T)this.signByDefaultWithSmime(new FileInputStream(pkcs12StoreFile), storePassword, keyAlias, keyPassword);
        }
        catch (IOException e) {
            throw new MailerException(String.format("Error reading from file: %s", pkcs12StoreFile), e);
        }
    }

    public T signByDefaultWithSmime(@NotNull InputStream pkcs12StoreStream, @NotNull String storePassword, @NotNull String keyAlias, @NotNull String keyPassword) {
        byte[] pkcs12StoreData;
        try {
            pkcs12StoreData = MiscUtil.readInputStreamToBytes((InputStream)pkcs12StoreStream);
        }
        catch (IOException e) {
            throw new MailerException("Was unable to read S/MIME data from input stream", e);
        }
        return (T)this.signByDefaultWithSmime(pkcs12StoreData, storePassword, keyAlias, keyPassword);
    }

    public T signByDefaultWithSmime(@NotNull byte[] pkcs12StoreData, @NotNull String storePassword, @NotNull String keyAlias, @NotNull String keyPassword) {
        return (T)this.signByDefaultWithSmime(Pkcs12Config.builder().pkcs12Store(pkcs12StoreData).storePassword(storePassword).keyAlias(keyAlias).keyPassword(keyPassword).build());
    }

    public T signByDefaultWithSmime(@NotNull Pkcs12Config pkcs12Config) {
        this.pkcs12ConfigForSmimeSigning = pkcs12Config;
        return (T)this;
    }

    public T withExecutorService(@NotNull ExecutorService executorService) {
        this.executorService = executorService;
        return (T)this;
    }

    public T withThreadPoolSize(@NotNull Integer threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
        return (T)this;
    }

    public T withThreadPoolKeepAliveTime(@NotNull Integer threadPoolKeepAliveTime) {
        this.threadPoolKeepAliveTime = threadPoolKeepAliveTime;
        return (T)this;
    }

    public T withClusterKey(@NotNull UUID clusterKey) {
        this.clusterKey = clusterKey;
        return (T)this;
    }

    public T withConnectionPoolCoreSize(@NotNull Integer connectionPoolCoreSize) {
        this.connectionPoolCoreSize = connectionPoolCoreSize;
        return (T)this;
    }

    public T withConnectionPoolMaxSize(@NotNull Integer connectionPoolMaxSize) {
        this.connectionPoolMaxSize = connectionPoolMaxSize;
        return (T)this;
    }

    public T withConnectionPoolClaimTimeoutMillis(@NotNull Integer connectionPoolClaimTimeoutMillis) {
        this.connectionPoolClaimTimeoutMillis = connectionPoolClaimTimeoutMillis;
        return (T)this;
    }

    public T withConnectionPoolExpireAfterMillis(@NotNull Integer connectionPoolExpireAfterMillis) {
        this.connectionPoolExpireAfterMillis = connectionPoolExpireAfterMillis;
        return (T)this;
    }

    public T withConnectionPoolLoadBalancingStrategy(@NotNull LoadBalancingStrategy loadBalancingStrategy) {
        this.connectionPoolLoadBalancingStrategy = loadBalancingStrategy;
        return (T)this;
    }

    public T withTransportModeLoggingOnly(@NotNull Boolean transportModeLoggingOnly) {
        this.transportModeLoggingOnly = transportModeLoggingOnly;
        return (T)this;
    }

    public T trustingSSLHosts(String ... sslHostsToTrust) {
        this.sslHostsToTrust = Arrays.asList(sslHostsToTrust);
        return (T)this;
    }

    public T trustingAllHosts(boolean trustAllHosts) {
        this.trustAllSSLHost = trustAllHosts;
        return (T)this;
    }

    public T verifyingServerIdentity(boolean verifyingServerIdentity) {
        this.verifyingServerIdentity = verifyingServerIdentity;
        return (T)this;
    }

    public T withProperties(@NotNull Properties properties) {
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            this.properties.put(property.getKey(), property.getValue());
        }
        return (T)this;
    }

    public T withProperties(@NotNull Map<String, String> properties) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            this.properties.put(property.getKey(), property.getValue());
        }
        return (T)this;
    }

    public T withProperty(@NotNull String propertyName, @Nullable Object propertyValue) {
        if (propertyValue == null) {
            this.properties.remove(propertyName);
        } else {
            this.properties.put(propertyName, propertyValue.toString());
        }
        return (T)this;
    }

    public T withCustomMailer(@NotNull CustomMailer customMailer) {
        this.customMailer = customMailer;
        return (T)this;
    }

    public T resetSessionTimeout() {
        return (T)this.withSessionTimeout(60000);
    }

    public T resetTrustingAllHosts() {
        return (T)this.trustingAllHosts(true);
    }

    public T resetVerifyingServerIdentity() {
        return (T)this.verifyingServerIdentity(true);
    }

    public T resetEmailAddressCriteria() {
        return (T)this.withEmailAddressCriteria(EmailAddressCriteria.RFC_COMPLIANT);
    }

    public T resetExecutorService() {
        this.executorService = null;
        return (T)this;
    }

    @NotNull
    private ExecutorService determineDefaultExecutorService() {
        return ModuleLoader.batchModuleAvailable() ? ModuleLoader.loadBatchModule().createDefaultExecutorService(this.getThreadPoolSize().intValue(), this.getThreadPoolKeepAliveTime().intValue()) : Executors.newSingleThreadExecutor();
    }

    public T resetThreadPoolSize() {
        return (T)this.withThreadPoolSize(10);
    }

    public T resetThreadPoolKeepAliveTime() {
        return (T)this.withThreadPoolKeepAliveTime(1);
    }

    public T resetClusterKey() {
        return (T)this.withClusterKey(UUID.randomUUID());
    }

    public T resetConnectionPoolCoreSize() {
        return (T)this.withConnectionPoolCoreSize(0);
    }

    public T resetConnectionPoolMaxSize() {
        return (T)this.withConnectionPoolCoreSize(4);
    }

    public T resetConnectionPoolClaimTimeoutMillis() {
        return (T)this.withConnectionPoolExpireAfterMillis(Integer.MAX_VALUE);
    }

    public T resetConnectionPoolExpireAfterMillis() {
        return (T)this.withConnectionPoolExpireAfterMillis(5000);
    }

    public T resetConnectionPoolLoadBalancingStrategy() {
        return (T)this.withConnectionPoolLoadBalancingStrategy(LoadBalancingStrategy.valueOf((String)"ROUND_ROBIN"));
    }

    public T resetTransportModeLoggingOnly() {
        return (T)this.withTransportModeLoggingOnly(false);
    }

    public T clearProxy() {
        return (T)this.withProxy(null, null, null, null).withProxyBridgePort(1081);
    }

    public T clearEmailAddressCriteria() {
        return (T)this.withEmailAddressCriteria((EnumSet)EnumSet.noneOf(EmailAddressCriteria.class));
    }

    public T clearSignByDefaultWithSmime() {
        this.pkcs12ConfigForSmimeSigning = null;
        return (T)this;
    }

    public T clearTrustedSSLHosts() {
        return (T)this.trustingSSLHosts(new String[0]);
    }

    public T clearProperties() {
        this.properties.clear();
        return (T)this;
    }

    public boolean isAsync() {
        return this.async;
    }

    @Nullable
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Nullable
    public Integer getProxyPort() {
        return this.proxyPort;
    }

    @Nullable
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    @Nullable
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    @NotNull
    public Integer getProxyBridgePort() {
        return this.proxyBridgePort;
    }

    public boolean isDebugLogging() {
        return this.debugLogging;
    }

    @NotNull
    public Integer getSessionTimeout() {
        return this.sessionTimeout;
    }

    @NotNull
    public EnumSet<EmailAddressCriteria> getEmailAddressCriteria() {
        return this.emailAddressCriteria;
    }

    @Nullable
    public Pkcs12Config getPkcs12ConfigForSmimeSigning() {
        return this.pkcs12ConfigForSmimeSigning;
    }

    @Nullable
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public boolean isExecutorServiceUserProvided() {
        return this.executorService != null;
    }

    @NotNull
    public Integer getThreadPoolSize() {
        return this.threadPoolSize;
    }

    @NotNull
    public Integer getThreadPoolKeepAliveTime() {
        return this.threadPoolKeepAliveTime;
    }

    @NotNull
    public UUID getClusterKey() {
        return this.clusterKey;
    }

    @NotNull
    public Integer getConnectionPoolCoreSize() {
        return this.connectionPoolCoreSize;
    }

    @NotNull
    public Integer getConnectionPoolMaxSize() {
        return this.connectionPoolMaxSize;
    }

    @NotNull
    public Integer getConnectionPoolClaimTimeoutMillis() {
        return this.connectionPoolClaimTimeoutMillis;
    }

    @NotNull
    public Integer getConnectionPoolExpireAfterMillis() {
        return this.connectionPoolExpireAfterMillis;
    }

    @NotNull
    public LoadBalancingStrategy getConnectionPoolLoadBalancingStrategy() {
        return this.connectionPoolLoadBalancingStrategy;
    }

    @NotNull
    public List<String> getSslHostsToTrust() {
        return this.sslHostsToTrust;
    }

    public boolean isTrustAllSSLHost() {
        return this.trustAllSSLHost;
    }

    public boolean isVerifyingServerIdentity() {
        return this.verifyingServerIdentity;
    }

    public boolean isTransportModeLoggingOnly() {
        return this.transportModeLoggingOnly;
    }

    @NotNull
    public Properties getProperties() {
        return this.properties;
    }

    @Nullable
    public CustomMailer getCustomMailer() {
        return this.customMailer;
    }
}

