/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.CalendarMethod;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.EmailPopulatingBuilder;
import org.simplejavamail.api.email.EmailStartingBuilder;
import org.simplejavamail.api.email.OriginalSmimeDetails;
import org.simplejavamail.api.internal.general.EmailPopulatingBuilderFactory;
import org.simplejavamail.api.internal.outlooksupport.model.EmailFromOutlookMessage;
import org.simplejavamail.api.internal.outlooksupport.model.OutlookMessage;
import org.simplejavamail.api.internal.smimesupport.builder.SmimeParseResult;
import org.simplejavamail.api.internal.smimesupport.model.AttachmentDecryptionResult;
import org.simplejavamail.api.mailer.config.Pkcs12Config;
import org.simplejavamail.converter.EmailConverterException;
import org.simplejavamail.converter.internal.InternalEmailConverterImpl;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageParser;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducerHelper;
import org.simplejavamail.email.EmailBuilder;
import org.simplejavamail.email.internal.EmailPopulatingBuilderFactoryImpl;
import org.simplejavamail.email.internal.EmailStartingBuilderImpl;
import org.simplejavamail.email.internal.InternalEmailPopulatingBuilder;
import org.simplejavamail.internal.modules.ModuleLoader;
import org.simplejavamail.internal.smimesupport.model.OriginalSmimeDetailsImpl;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;

public final class EmailConverter {
    private static final PathMatcher EML_PATH_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**/*.eml");
    private static final PathMatcher MSG_PATH_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**/*.msg");

    private EmailConverter() {
    }

    @NotNull
    public static Email mimeMessageToEmail(@NotNull MimeMessage mimeMessage) {
        return EmailConverter.mimeMessageToEmail(mimeMessage, null);
    }

    @NotNull
    public static Email mimeMessageToEmail(@NotNull MimeMessage mimeMessage, @Nullable Pkcs12Config pkcs12Config) {
        return EmailConverter.mimeMessageToEmailBuilder(mimeMessage, pkcs12Config).buildEmail();
    }

    @NotNull
    public static Email mimeMessageToEmail(@NotNull MimeMessage mimeMessage, @Nullable Pkcs12Config pkcs12Config, boolean fetchAttachmentData) {
        return EmailConverter.mimeMessageToEmailBuilder(mimeMessage, pkcs12Config, fetchAttachmentData).buildEmail();
    }

    @NotNull
    public static EmailPopulatingBuilder mimeMessageToEmailBuilder(@NotNull MimeMessage mimeMessage) {
        return EmailConverter.mimeMessageToEmailBuilder(mimeMessage, null);
    }

    @NotNull
    public static EmailPopulatingBuilder mimeMessageToEmailBuilder(@NotNull MimeMessage mimeMessage, @Nullable Pkcs12Config pkcs12Config) {
        return EmailConverter.mimeMessageToEmailBuilder(mimeMessage, pkcs12Config, true);
    }

    @NotNull
    public static EmailPopulatingBuilder mimeMessageToEmailBuilder(@NotNull MimeMessage mimeMessage, @Nullable Pkcs12Config pkcs12Config, boolean fetchAttachmentData) {
        Preconditions.checkNonEmptyArgument((Object)mimeMessage, (String)"mimeMessage");
        EmailPopulatingBuilder builder = EmailBuilder.ignoringDefaults().startingBlank();
        MimeMessageParser.ParsedMimeMessageComponents parsed = MimeMessageParser.parseMimeMessage(mimeMessage, fetchAttachmentData);
        return EmailConverter.decryptAttachments(EmailConverter.buildEmailFromMimeMessage(builder, parsed), mimeMessage, pkcs12Config);
    }

    @NotNull
    public static Email outlookMsgToEmail(@NotNull String msgData) {
        return EmailConverter.outlookMsgToEmail(msgData, null);
    }

    @NotNull
    public static Email outlookMsgToEmail(@NotNull String msgData, @Nullable Pkcs12Config pkcs12Config) {
        Preconditions.checkNonEmptyArgument((Object)msgData, (String)"msgFile");
        EmailFromOutlookMessage result = ModuleLoader.loadOutlookModule().outlookMsgToEmailBuilder(msgData, (EmailStartingBuilder)new EmailStartingBuilderImpl(), (EmailPopulatingBuilderFactory)new EmailPopulatingBuilderFactoryImpl(), InternalEmailConverterImpl.INSTANCE);
        return EmailConverter.decryptAttachments(result.getEmailBuilder(), result.getOutlookMessage(), pkcs12Config).buildEmail();
    }

    @NotNull
    public static Email outlookMsgToEmail(@NotNull File msgFile) {
        return EmailConverter.outlookMsgToEmailBuilder(msgFile).buildEmail();
    }

    @NotNull
    public static Email outlookMsgToEmail(@NotNull File msgFile, @Nullable Pkcs12Config pkcs12Config) {
        return EmailConverter.outlookMsgToEmailBuilder(msgFile, pkcs12Config).buildEmail();
    }

    @NotNull
    public static EmailPopulatingBuilder outlookMsgToEmailBuilder(@NotNull File msgFile) {
        return EmailConverter.outlookMsgToEmailBuilder(msgFile, null);
    }

    @NotNull
    public static EmailPopulatingBuilder outlookMsgToEmailBuilder(@NotNull File msgFile, @Nullable Pkcs12Config pkcs12Config) {
        Preconditions.checkNonEmptyArgument((Object)msgFile, (String)"msgFile");
        if (!MSG_PATH_MATCHER.matches(msgFile.toPath())) {
            throw new EmailConverterException(String.format("Outlook file should have \".msg\" extension: %s", msgFile));
        }
        EmailFromOutlookMessage result = ModuleLoader.loadOutlookModule().outlookMsgToEmailBuilder(msgFile, (EmailStartingBuilder)new EmailStartingBuilderImpl(), (EmailPopulatingBuilderFactory)new EmailPopulatingBuilderFactoryImpl(), InternalEmailConverterImpl.INSTANCE);
        return EmailConverter.decryptAttachments(result.getEmailBuilder(), result.getOutlookMessage(), pkcs12Config);
    }

    @NotNull
    public static Email outlookMsgToEmail(@NotNull InputStream msgInputStream) {
        return EmailConverter.outlookMsgToEmail(msgInputStream, null);
    }

    @NotNull
    public static Email outlookMsgToEmail(@NotNull InputStream msgInputStream, @Nullable Pkcs12Config pkcs12Config) {
        return EmailConverter.outlookMsgToEmailBuilder(msgInputStream, pkcs12Config).getEmailBuilder().buildEmail();
    }

    @NotNull
    public static EmailFromOutlookMessage outlookMsgToEmailBuilder(@NotNull InputStream msgInputStream) {
        return EmailConverter.outlookMsgToEmailBuilder(msgInputStream, null);
    }

    @NotNull
    public static EmailFromOutlookMessage outlookMsgToEmailBuilder(@NotNull InputStream msgInputStream, @Nullable Pkcs12Config pkcs12Config) {
        EmailFromOutlookMessage fromMsgBuilder = ModuleLoader.loadOutlookModule().outlookMsgToEmailBuilder(msgInputStream, (EmailStartingBuilder)new EmailStartingBuilderImpl(), (EmailPopulatingBuilderFactory)new EmailPopulatingBuilderFactoryImpl(), InternalEmailConverterImpl.INSTANCE);
        EmailConverter.decryptAttachments(fromMsgBuilder.getEmailBuilder(), fromMsgBuilder.getOutlookMessage(), pkcs12Config);
        return fromMsgBuilder;
    }

    private static EmailPopulatingBuilder decryptAttachments(EmailPopulatingBuilder emailBuilder, OutlookMessage outlookMessage, @Nullable Pkcs12Config pkcs12Config) {
        if (ModuleLoader.smimeModuleAvailable()) {
            SmimeParseResult smimeParseResult = ModuleLoader.loadSmimeModule().decryptAttachments(emailBuilder.getAttachments(), outlookMessage, pkcs12Config);
            EmailConverter.handleSmimeParseResult((InternalEmailPopulatingBuilder)emailBuilder, smimeParseResult);
            EmailConverter.updateEmailIfBothSignedAndEncrypted(emailBuilder, smimeParseResult);
        }
        return emailBuilder;
    }

    private static EmailPopulatingBuilder decryptAttachments(EmailPopulatingBuilder emailBuilder, MimeMessage mimeMessage, @Nullable Pkcs12Config pkcs12Config) {
        if (ModuleLoader.smimeModuleAvailable()) {
            SmimeParseResult smimeParseResult = ModuleLoader.loadSmimeModule().decryptAttachments(emailBuilder.getAttachments(), mimeMessage, pkcs12Config);
            EmailConverter.handleSmimeParseResult((InternalEmailPopulatingBuilder)emailBuilder, smimeParseResult);
            EmailConverter.updateEmailIfBothSignedAndEncrypted(emailBuilder, smimeParseResult);
        }
        return emailBuilder;
    }

    private static void updateEmailIfBothSignedAndEncrypted(EmailPopulatingBuilder emailBuilder, SmimeParseResult smimeParseResult) {
        if (emailBuilder.getSmimeSignedEmail() != null) {
            OriginalSmimeDetails nestedSmime = emailBuilder.getSmimeSignedEmail().getOriginalSmimeDetails();
            OriginalSmimeDetailsImpl originalSmimeDetails = (OriginalSmimeDetailsImpl)emailBuilder.getOriginalSmimeDetails();
            if (nestedSmime.getSmimeMode() != OriginalSmimeDetails.SmimeMode.PLAIN && nestedSmime.getSmimeMode() != originalSmimeDetails.getSmimeMode()) {
                originalSmimeDetails.completeWithSmimeMode(OriginalSmimeDetails.SmimeMode.SIGNED_ENCRYPTED);
            } else if (smimeParseResult.getDecryptedAttachmentResults().size() == 1) {
                OriginalSmimeDetails.SmimeMode smimeMode = ((AttachmentDecryptionResult)smimeParseResult.getDecryptedAttachmentResults().get(0)).getSmimeMode();
                originalSmimeDetails.completeWithSmimeMode(smimeMode);
            }
        }
    }

    private static void handleSmimeParseResult(InternalEmailPopulatingBuilder emailBuilder, SmimeParseResult smimeParseResult) {
        emailBuilder.withDecryptedAttachments(smimeParseResult.getDecryptedAttachments());
        emailBuilder.withOriginalSmimeDetails(smimeParseResult.getOriginalSmimeDetails());
        if (smimeParseResult.getSmimeSignedEmail() != null) {
            emailBuilder.withSmimeSignedEmail(EmailConverter.emlToEmail(smimeParseResult.getSmimeSignedEmail().getDataSourceInputStream()));
        }
    }

    @NotNull
    public static Email emlToEmail(@NotNull InputStream emlInputStream) {
        return EmailConverter.emlToEmail(emlInputStream, null);
    }

    @NotNull
    public static Email emlToEmail(@NotNull InputStream emlInputStream, @Nullable Pkcs12Config pkcs12Config) {
        return EmailConverter.emlToEmailBuilder(emlInputStream, pkcs12Config).buildEmail();
    }

    @NotNull
    public static Email emlToEmail(@NotNull String eml) {
        return EmailConverter.emlToEmail(eml, null);
    }

    @NotNull
    public static Email emlToEmail(@NotNull String eml, @Nullable Pkcs12Config pkcs12Config) {
        return EmailConverter.emlToEmailBuilder(eml, pkcs12Config).buildEmail();
    }

    @NotNull
    public static Email emlToEmail(@NotNull File emlFile) {
        return EmailConverter.emlToEmail(emlFile, null);
    }

    @NotNull
    public static Email emlToEmail(@NotNull File emlFile, @Nullable Pkcs12Config pkcs12Config) {
        return EmailConverter.emlToEmailBuilder(emlFile, pkcs12Config).buildEmail();
    }

    @NotNull
    public static EmailPopulatingBuilder emlToEmailBuilder(@NotNull File emlFile) {
        return EmailConverter.emlToEmailBuilder(emlFile, null);
    }

    @NotNull
    public static EmailPopulatingBuilder emlToEmailBuilder(@NotNull File emlFile, @Nullable Pkcs12Config pkcs12Config) {
        return EmailConverter.mimeMessageToEmailBuilder(EmailConverter.emlToMimeMessage(emlFile), pkcs12Config);
    }

    @NotNull
    public static EmailPopulatingBuilder emlToEmailBuilder(@NotNull InputStream emlInputStream) {
        return EmailConverter.emlToEmailBuilder(emlInputStream, null);
    }

    @NotNull
    public static EmailPopulatingBuilder emlToEmailBuilder(@NotNull InputStream emlInputStream, @Nullable Pkcs12Config pkcs12Config) {
        try {
            String emlStr = MiscUtil.readInputStreamToString((InputStream)((InputStream)Preconditions.checkNonEmptyArgument((Object)emlInputStream, (String)"emlInputStream")), (Charset)StandardCharsets.UTF_8);
            return EmailConverter.emlToEmailBuilder(emlStr, pkcs12Config);
        }
        catch (IOException e) {
            throw new EmailConverterException("Error reading EML string from given InputStream", e);
        }
    }

    @NotNull
    public static EmailPopulatingBuilder emlToEmailBuilder(@NotNull String eml) {
        return EmailConverter.emlToEmailBuilder(eml, null);
    }

    @NotNull
    public static EmailPopulatingBuilder emlToEmailBuilder(@NotNull String eml, @Nullable Pkcs12Config pkcs12Config) {
        MimeMessage mimeMessage = EmailConverter.emlToMimeMessage((String)Preconditions.checkNonEmptyArgument((Object)eml, (String)"eml"), EmailConverter.createDummySession());
        return EmailConverter.mimeMessageToEmailBuilder(mimeMessage, pkcs12Config);
    }

    @NotNull
    public static MimeMessage outlookMsgToMimeMessage(@NotNull String msgFile) {
        return EmailConverter.outlookMsgToMimeMessage(msgFile, null);
    }

    @NotNull
    public static MimeMessage outlookMsgToMimeMessage(@NotNull String msgData, @Nullable Pkcs12Config pkcs12Config) {
        Preconditions.checkNonEmptyArgument((Object)msgData, (String)"outlookMsgData");
        return EmailConverter.emailToMimeMessage(EmailConverter.outlookMsgToEmail(msgData, pkcs12Config));
    }

    @NotNull
    public static MimeMessage outlookMsgToMimeMessage(@NotNull File outlookMsgFile) {
        return EmailConverter.outlookMsgToMimeMessage(outlookMsgFile, null);
    }

    @NotNull
    public static MimeMessage outlookMsgToMimeMessage(@NotNull File outlookMsgFile, @Nullable Pkcs12Config pkcs12Config) {
        Preconditions.checkNonEmptyArgument((Object)outlookMsgFile, (String)"outlookMsgFile");
        return EmailConverter.emailToMimeMessage(EmailConverter.outlookMsgToEmail(outlookMsgFile, pkcs12Config));
    }

    @NotNull
    public static MimeMessage outlookMsgToMimeMessage(@NotNull InputStream outlookMsgInputStream) {
        return EmailConverter.outlookMsgToMimeMessage(outlookMsgInputStream, null);
    }

    @NotNull
    public static MimeMessage outlookMsgToMimeMessage(@NotNull InputStream outlookMsgInputStream, @Nullable Pkcs12Config pkcs12Config) {
        Preconditions.checkNonEmptyArgument((Object)outlookMsgInputStream, (String)"outlookMsgInputStream");
        return EmailConverter.emailToMimeMessage(EmailConverter.outlookMsgToEmail(outlookMsgInputStream, pkcs12Config));
    }

    public static MimeMessage emailToMimeMessage(@NotNull Email email) {
        return EmailConverter.emailToMimeMessage((Email)Preconditions.checkNonEmptyArgument((Object)email, (String)"email"), EmailConverter.createDummySession());
    }

    public static MimeMessage emailToMimeMessage(@NotNull Email email, @NotNull Session session, @NotNull Pkcs12Config defaultSmimeSigningStore) {
        try {
            return MimeMessageProducerHelper.produceMimeMessage((Email)Preconditions.checkNonEmptyArgument((Object)email, (String)"email"), (Session)Preconditions.checkNonEmptyArgument((Object)session, (String)"session"), (Pkcs12Config)Preconditions.checkNonEmptyArgument((Object)defaultSmimeSigningStore, (String)"defaultSmimeSigningStore"));
        }
        catch (UnsupportedEncodingException | MessagingException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static MimeMessage emailToMimeMessage(@NotNull Email email, @NotNull Session session) {
        try {
            return MimeMessageProducerHelper.produceMimeMessage((Email)Preconditions.checkNonEmptyArgument((Object)email, (String)"email"), (Session)Preconditions.checkNonEmptyArgument((Object)session, (String)"session"), null);
        }
        catch (UnsupportedEncodingException | MessagingException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @NotNull
    public static MimeMessage emlToMimeMessage(@NotNull File emlFile) {
        return EmailConverter.emlToMimeMessage(emlFile, EmailConverter.createDummySession());
    }

    public static MimeMessage emlToMimeMessage(@NotNull File emlFile, @NotNull Session session) {
        if (!EML_PATH_MATCHER.matches(emlFile.toPath())) {
            throw new EmailConverterException(String.format("Eml file should have \".eml\" extension: %s", emlFile));
        }
        try {
            return EmailConverter.emlToMimeMessage(new FileInputStream((File)Preconditions.checkNonEmptyArgument((Object)emlFile, (String)"emlFile")), session);
        }
        catch (FileNotFoundException e) {
            throw new EmailConverterException(String.format("Error parsing EML data from file: %s", e.getMessage()), e);
        }
    }

    @NotNull
    public static MimeMessage emlToMimeMessage(@NotNull InputStream inputStream) {
        return EmailConverter.emlToMimeMessage(inputStream, EmailConverter.createDummySession());
    }

    @NotNull
    public static MimeMessage emlToMimeMessage(@NotNull InputStream inputStream, @NotNull Session session) {
        try {
            return new MimeMessage(session, inputStream);
        }
        catch (MessagingException e) {
            throw new EmailConverterException(String.format("Error parsing EML data from input stream: %s", e.getMessage()), (Exception)((Object)e));
        }
    }

    public static MimeMessage emlToMimeMessage(@NotNull String eml) {
        return EmailConverter.emlToMimeMessage((String)Preconditions.checkNonEmptyArgument((Object)eml, (String)"eml"), EmailConverter.createDummySession());
    }

    public static MimeMessage emlToMimeMessage(@NotNull String eml, @NotNull Session session) {
        Preconditions.checkNonEmptyArgument((Object)session, (String)"session");
        Preconditions.checkNonEmptyArgument((Object)eml, (String)"eml");
        try {
            return new MimeMessage(session, (InputStream)new ByteArrayInputStream(eml.getBytes(StandardCharsets.UTF_8)));
        }
        catch (MessagingException e) {
            throw new EmailConverterException(String.format("Error parsing EML data from input stream: %s", e.getMessage()), (Exception)((Object)e));
        }
    }

    public static byte[] mimeMessageToEMLByteArray(@NotNull MimeMessage mimeMessage) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ((MimeMessage)Preconditions.checkNonEmptyArgument((Object)mimeMessage, (String)"mimeMessage")).writeTo((OutputStream)os);
            return os.toByteArray();
        }
        catch (IOException | MessagingException e) {
            throw new IllegalStateException("This should never happen", e);
        }
    }

    public static String mimeMessageToEML(@NotNull MimeMessage mimeMessage) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ((MimeMessage)Preconditions.checkNonEmptyArgument((Object)mimeMessage, (String)"mimeMessage")).writeTo((OutputStream)os);
            return os.toString(StandardCharsets.UTF_8.name());
        }
        catch (IOException | MessagingException e) {
            throw new IllegalStateException("This should never happen", e);
        }
    }

    public static String emailToEML(@NotNull Email email) {
        return EmailConverter.mimeMessageToEML(EmailConverter.emailToMimeMessage((Email)Preconditions.checkNonEmptyArgument((Object)email, (String)"email")));
    }

    @NotNull
    public static String outlookMsgToEML(@NotNull String msgFile) {
        return EmailConverter.outlookMsgToEML(msgFile, null);
    }

    @NotNull
    public static String outlookMsgToEML(@NotNull String msgData, @Nullable Pkcs12Config pkcs12Config) {
        Preconditions.checkNonEmptyArgument((Object)msgData, (String)"outlookMsgData");
        return EmailConverter.emailToEML(EmailConverter.outlookMsgToEmail(msgData, pkcs12Config));
    }

    @NotNull
    public static String outlookMsgToEML(@NotNull File outlookMsgFile) {
        return EmailConverter.outlookMsgToEML(outlookMsgFile, null);
    }

    @NotNull
    public static String outlookMsgToEML(@NotNull File outlookMsgFile, @Nullable Pkcs12Config pkcs12Config) {
        Preconditions.checkNonEmptyArgument((Object)outlookMsgFile, (String)"outlookMsgFile");
        return EmailConverter.emailToEML(EmailConverter.outlookMsgToEmail(outlookMsgFile, pkcs12Config));
    }

    @NotNull
    public static String outlookMsgToEML(@NotNull InputStream outlookMsgInputStream) {
        return EmailConverter.outlookMsgToEML(outlookMsgInputStream, null);
    }

    @NotNull
    public static String outlookMsgToEML(@NotNull InputStream outlookMsgInputStream, @Nullable Pkcs12Config pkcs12Config) {
        Preconditions.checkNonEmptyArgument((Object)outlookMsgInputStream, (String)"outlookMsgInputStream");
        return EmailConverter.emailToEML(EmailConverter.outlookMsgToEmail(outlookMsgInputStream, pkcs12Config));
    }

    private static EmailPopulatingBuilder buildEmailFromMimeMessage(@NotNull EmailPopulatingBuilder builder, @NotNull MimeMessageParser.ParsedMimeMessageComponents parsed) {
        InternetAddress bTo;
        InternetAddress rrTo;
        Preconditions.checkNonEmptyArgument((Object)builder, (String)"emailBuilder");
        Preconditions.checkNonEmptyArgument((Object)parsed, (String)"parsedMimeMessageComponents");
        if (parsed.getSentDate() != null) {
            builder.fixingSentDate(parsed.getSentDate());
        }
        if (parsed.getFromAddress() != null) {
            builder.from(parsed.getFromAddress().getPersonal(), parsed.getFromAddress().getAddress());
        }
        if (parsed.getReplyToAddresses() != null) {
            builder.withReplyTo(parsed.getReplyToAddresses().getPersonal(), parsed.getReplyToAddresses().getAddress());
        }
        builder.withHeaders(parsed.getHeaders());
        InternetAddress dnTo = parsed.getDispositionNotificationTo();
        if (dnTo != null) {
            builder.withDispositionNotificationTo(dnTo);
        }
        if ((rrTo = parsed.getReturnReceiptTo()) != null) {
            builder.withReturnReceiptTo(rrTo);
        }
        if ((bTo = parsed.getBounceToAddress()) != null) {
            builder.withBounceTo(bTo);
        }
        builder.fixingMessageId(parsed.getMessageId());
        for (InternetAddress internetAddress : parsed.getToAddresses()) {
            builder.to(internetAddress);
        }
        for (InternetAddress internetAddress : parsed.getCcAddresses()) {
            builder.cc(internetAddress);
        }
        for (InternetAddress internetAddress : parsed.getBccAddresses()) {
            builder.bcc(internetAddress);
        }
        builder.withSubject(parsed.getSubject() != null ? parsed.getSubject() : "");
        builder.withPlainText(parsed.getPlainContent());
        builder.withHTMLText(parsed.getHtmlContent());
        if (parsed.getCalendarMethod() != null) {
            builder.withCalendarText(CalendarMethod.valueOf((String)parsed.getCalendarMethod()), (String)Preconditions.verifyNonnullOrEmpty((Object)parsed.getCalendarContent()));
        }
        for (Map.Entry entry : parsed.getCidMap().entrySet()) {
            String cidName = (String)Preconditions.checkNonEmptyArgument(entry.getKey(), (String)"cid.key");
            builder.withEmbeddedImage(MiscUtil.extractCID((String)cidName), (DataSource)entry.getValue());
        }
        for (Map.Entry entry : parsed.getAttachmentList()) {
            builder.withAttachment(MiscUtil.extractCID((String)((String)entry.getKey())), (DataSource)entry.getValue());
        }
        return builder;
    }

    private static Session createDummySession() {
        return Session.getDefaultInstance((Properties)new Properties());
    }
}

