/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.mailer.config.EmailGovernance;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageHelper;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProduceException;
import org.simplejavamail.converter.internal.mimemessage.SpecializedMimeMessageProducer;

class MimeMessageProducerMixedAlternative
extends SpecializedMimeMessageProducer {
    MimeMessageProducerMixedAlternative() {
    }

    @Override
    boolean compatibleWithEmail(@NotNull Email email) {
        return MimeMessageProducerMixedAlternative.emailContainsMixedContent(email) && !MimeMessageProducerMixedAlternative.emailContainsRelatedContent(email) && MimeMessageProducerMixedAlternative.emailContainsAlternativeContent(email);
    }

    @Override
    void populateMimeMessageMultipartStructure(MimeMessage message, Email email, EmailGovernance emailGovernance) throws MessagingException {
        MultipartStructureWrapper multipartStructureWrapper = new MultipartStructureWrapper();
        MimeMessageHelper.setTexts(email, emailGovernance, multipartStructureWrapper.multipartAlternativeMessages);
        MimeMessageHelper.configureForwarding(email, emailGovernance, multipartStructureWrapper.multipartRootMixed);
        MimeMessageHelper.setAttachments(email, emailGovernance, multipartStructureWrapper.multipartRootMixed);
        message.setContent((Multipart)multipartStructureWrapper.multipartRootMixed);
    }

    private static class MultipartStructureWrapper {
        private final MimeMultipart multipartRootMixed = new MimeMultipart("mixed");
        private final MimeMultipart multipartAlternativeMessages;

        private MultipartStructureWrapper() {
            MimeBodyPart contentAlternativeMessages = new MimeBodyPart();
            this.multipartAlternativeMessages = new MimeMultipart("alternative");
            try {
                this.multipartRootMixed.addBodyPart((BodyPart)contentAlternativeMessages);
                contentAlternativeMessages.setContent((Multipart)this.multipartAlternativeMessages);
            }
            catch (MessagingException e) {
                throw new MimeMessageProduceException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }
}

