/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal;

import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.internal.authenticatedsockssupport.socks5server.AnonymousSocks5Server;
import org.simplejavamail.api.mailer.config.OperationalConfig;
import org.simplejavamail.mailer.internal.AbstractProxyServerSyncingClosure;
import org.simplejavamail.mailer.internal.MailerException;
import org.simplejavamail.mailer.internal.SessionBasedEmailToMimeMessageConverter;
import org.simplejavamail.mailer.internal.util.TransportRunner;

class SendMailClosure
extends AbstractProxyServerSyncingClosure {
    @NotNull
    private final OperationalConfig operationalConfig;
    @NotNull
    private final Session session;
    @NotNull
    private final Email email;
    private final boolean transportModeLoggingOnly;

    SendMailClosure(@NotNull OperationalConfig operationalConfig, @NotNull Session session, @NotNull Email email, @Nullable AnonymousSocks5Server proxyServer, boolean transportModeLoggingOnly, @NotNull AtomicInteger smtpConnectionCounter) {
        super(smtpConnectionCounter, proxyServer);
        this.operationalConfig = operationalConfig;
        this.session = session;
        this.email = email;
        this.transportModeLoggingOnly = transportModeLoggingOnly;
    }

    @Override
    public void executeClosure() {
        LOGGER.trace("sending email...");
        try {
            if (this.transportModeLoggingOnly) {
                SessionBasedEmailToMimeMessageConverter.convertAndLogMimeMessage(this.session, this.email);
                LOGGER.info("TRANSPORT_MODE_LOGGING_ONLY: skipping actual sending...");
            } else if (this.operationalConfig.getCustomMailer() != null) {
                MimeMessage message = SessionBasedEmailToMimeMessageConverter.convertAndLogMimeMessage(this.session, this.email);
                this.operationalConfig.getCustomMailer().sendMessage(this.operationalConfig, this.session, message);
            } else {
                TransportRunner.sendMessage(this.operationalConfig.getClusterKey(), this.session, this.email);
            }
        }
        catch (MessagingException e) {
            this.handleException((Exception)((Object)e), "Failed to send email [%s], reason: Third party error");
        }
        catch (Exception e) {
            this.handleException(e, "Failed to send email [%s], reason: Unknown error");
        }
    }

    private void handleException(Exception e, String errorMsg) {
        LOGGER.trace("Failed to send email {}\n{}", (Object)this.email.getId(), (Object)this.email);
        throw new MailerException(String.format(errorMsg, this.email.getId()), e);
    }
}

