/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal;

import com.sanctionco.jmail.EmailValidator;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.CalendarMethod;
import org.simplejavamail.api.email.ContentTransferEncoding;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.EmailPopulatingBuilder;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.api.email.config.DkimConfig;
import org.simplejavamail.api.mailer.config.EmailGovernance;
import org.simplejavamail.api.mailer.config.Pkcs12Config;
import org.simplejavamail.config.ConfigLoader;
import org.simplejavamail.email.EmailBuilder;
import org.simplejavamail.email.internal.InternalEmail;
import org.simplejavamail.internal.config.EmailProperty;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;

public class EmailGovernanceImpl
implements EmailGovernance {
    @Nullable
    private final EmailValidator emailValidator;
    @NotNull
    private final Email emailDefaults;
    @NotNull
    private final Email emailOverrides;
    @Nullable
    private final Integer maximumEmailSize;

    public static EmailGovernance NO_GOVERNANCE() {
        return new EmailGovernanceImpl(null, null, null, null);
    }

    public EmailGovernanceImpl(@Nullable EmailValidator emailValidator, @Nullable Email emailDefaults, @Nullable Email emailOverrides, @Nullable Integer maximumEmailSize) {
        this.emailValidator = emailValidator;
        this.emailDefaults = emailDefaults != null ? emailDefaults : this.newDefaultsEmailWithDefaultDefaults();
        this.emailOverrides = emailOverrides != null ? emailOverrides : EmailBuilder.startingBlank().buildEmail();
        this.maximumEmailSize = maximumEmailSize;
    }

    private Email newDefaultsEmailWithDefaultDefaults() {
        EmailPopulatingBuilder allDefaults = EmailBuilder.startingBlank();
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_FROM_ADDRESS)) {
            allDefaults.from(ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_FROM_NAME), (String)Preconditions.verifyNonnullOrEmpty((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_FROM_ADDRESS)));
        }
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_REPLYTO_ADDRESS)) {
            allDefaults.withReplyTo(ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_REPLYTO_NAME), (String)Preconditions.verifyNonnullOrEmpty((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_REPLYTO_ADDRESS)));
        }
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_BOUNCETO_ADDRESS)) {
            allDefaults.withBounceTo(ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_BOUNCETO_NAME), (String)Preconditions.verifyNonnullOrEmpty((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_BOUNCETO_ADDRESS)));
        }
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_TO_ADDRESS)) {
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_TO_NAME)) {
                allDefaults.to(ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_TO_NAME), ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_TO_ADDRESS));
            } else {
                allDefaults.to((String)Preconditions.verifyNonnullOrEmpty((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_TO_ADDRESS)));
            }
        }
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CC_ADDRESS)) {
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CC_NAME)) {
                allDefaults.cc(ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CC_NAME), ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CC_ADDRESS));
            } else {
                allDefaults.cc((String)Preconditions.verifyNonnullOrEmpty((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CC_ADDRESS)));
            }
        }
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_BCC_ADDRESS)) {
            if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_BCC_NAME)) {
                allDefaults.bcc(ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_BCC_NAME), ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_BCC_ADDRESS));
            } else {
                allDefaults.bcc((String)Preconditions.verifyNonnullOrEmpty((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_BCC_ADDRESS)));
            }
        }
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CONTENT_TRANSFER_ENCODING)) {
            allDefaults.withContentTransferEncoding((ContentTransferEncoding)Preconditions.verifyNonnullOrEmpty((Object)ConfigLoader.getProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_CONTENT_TRANSFER_ENCODING)));
        }
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_SUBJECT)) {
            allDefaults.withSubject((String)ConfigLoader.getProperty((ConfigLoader.Property)ConfigLoader.Property.DEFAULT_SUBJECT));
        }
        if (allDefaults.getPkcs12ConfigForSmimeSigning() == null && ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.SMIME_SIGNING_KEYSTORE)) {
            allDefaults.signWithSmime(Pkcs12Config.builder().pkcs12Store((String)Preconditions.verifyNonnullOrEmpty((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.SMIME_SIGNING_KEYSTORE))).storePassword((String)Preconditions.checkNonEmptyArgument((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.SMIME_SIGNING_KEYSTORE_PASSWORD), (String)"Keystore password property")).keyAlias((String)Preconditions.checkNonEmptyArgument((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.SMIME_SIGNING_KEY_ALIAS), (String)"Key alias property")).keyPassword((String)Preconditions.checkNonEmptyArgument((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.SMIME_SIGNING_KEY_PASSWORD), (String)"Key password property")).build());
        }
        if (allDefaults.getX509CertificateForSmimeEncryption() == null && ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.SMIME_ENCRYPTION_CERTIFICATE)) {
            allDefaults.encryptWithSmime((String)Preconditions.verifyNonnullOrEmpty((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.SMIME_ENCRYPTION_CERTIFICATE)));
        }
        if (allDefaults.getDkimConfig() == null && ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.DKIM_PRIVATE_KEY_FILE_OR_DATA)) {
            DkimConfig.DkimConfigBuilder dkimConfigBuilder = DkimConfig.builder().dkimSelector((String)Preconditions.verifyNonnullOrEmpty((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DKIM_SELECTOR))).dkimSigningDomain((String)Preconditions.verifyNonnullOrEmpty((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DKIM_SIGNING_DOMAIN))).excludedHeadersFromDkimDefaultSigningList(new String[]{(String)Preconditions.verifyNonnullOrEmpty((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DKIM_EXCLUDED_HEADERS_FROM_DEFAULT_SIGNING_LIST))});
            String dkimPrivateKeyFileOrData = (String)Preconditions.verifyNonnullOrEmpty((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.DKIM_PRIVATE_KEY_FILE_OR_DATA));
            if (new File(dkimPrivateKeyFileOrData).exists()) {
                dkimConfigBuilder.dkimPrivateKeyPath(dkimPrivateKeyFileOrData);
            } else {
                dkimConfigBuilder.dkimPrivateKeyData(dkimPrivateKeyFileOrData);
            }
            allDefaults.signWithDomainKey(dkimConfigBuilder.build());
        }
        return allDefaults.buildEmail();
    }

    @NotNull
    public Email produceEmailApplyingDefaultsAndOverrides(@Nullable Email provided) {
        Object useDispositionNotificationTo;
        EmailPopulatingBuilder builder = provided == null || provided.getEmailToForward() == null ? EmailBuilder.startingBlank() : EmailBuilder.forwarding(provided.getEmailToForward());
        Recipient fromRecipient = (Recipient)this.resolveEmailProperty(provided, EmailProperty.FROM_RECIPIENT);
        Recipient replyToRecipient = (Recipient)this.resolveEmailProperty(provided, EmailProperty.REPLYTO_RECIPIENT);
        Optional.ofNullable(fromRecipient).ifPresent(arg_0 -> ((EmailPopulatingBuilder)builder).from(arg_0));
        builder.withReplyTo(replyToRecipient);
        builder.to(this.resolveEmailCollectionProperty(provided, EmailProperty.TO_RECIPIENTS));
        builder.cc(this.resolveEmailCollectionProperty(provided, EmailProperty.CC_RECIPIENTS));
        builder.bcc(this.resolveEmailCollectionProperty(provided, EmailProperty.BCC_RECIPIENTS));
        builder.withSubject((String)this.resolveEmailProperty(provided, EmailProperty.SUBJECT));
        builder.withPlainText((String)this.resolveEmailProperty(provided, EmailProperty.BODY_TEXT));
        builder.withHTMLText((String)this.resolveEmailProperty(provided, EmailProperty.BODY_HTML));
        String calendarText = (String)this.resolveEmailProperty(provided, EmailProperty.CALENDAR_TEXT);
        if (calendarText != null) {
            CalendarMethod calendarMethod = (CalendarMethod)this.resolveEmailProperty(provided, EmailProperty.CALENDAR_METHOD);
            builder.withCalendarText(Objects.requireNonNull(calendarMethod, "calendarMethod"), calendarText);
        }
        builder.withHeaders(this.resolveEmailHeadersProperty(provided));
        builder.withAttachments(this.resolveEmailCollectionProperty(provided, EmailProperty.ATTACHMENTS));
        builder.withEmbeddedImages(this.resolveEmailCollectionProperty(provided, EmailProperty.EMBEDDED_IMAGES));
        Object useReturnReceiptTo = this.resolveEmailProperty(provided, EmailProperty.USE_RETURN_RECEIPT_TO);
        if (Boolean.TRUE.equals(useReturnReceiptTo)) {
            Recipient returnReceiptToRecipient = (Recipient)this.resolveEmailProperty(provided, EmailProperty.RETURN_RECEIPT_TO);
            if (returnReceiptToRecipient != null) {
                builder.withReturnReceiptTo(returnReceiptToRecipient);
            } else if (replyToRecipient != null) {
                builder.withReturnReceiptTo(replyToRecipient);
            } else if (fromRecipient != null) {
                builder.withReturnReceiptTo(fromRecipient);
            } else {
                builder.withReturnReceiptTo();
            }
        }
        if (Boolean.TRUE.equals(useDispositionNotificationTo = this.resolveEmailProperty(provided, EmailProperty.USE_DISPOSITION_NOTIFICATION_TO))) {
            Recipient dispositionNotificationToRecipient = (Recipient)this.resolveEmailProperty(provided, EmailProperty.DISPOSITION_NOTIFICATION_TO);
            if (dispositionNotificationToRecipient != null) {
                builder.withDispositionNotificationTo(dispositionNotificationToRecipient);
            } else if (replyToRecipient != null) {
                builder.withDispositionNotificationTo(replyToRecipient);
            } else if (fromRecipient != null) {
                builder.withDispositionNotificationTo(fromRecipient);
            } else {
                builder.withDispositionNotificationTo();
            }
        }
        Optional.ofNullable(this.resolveEmailProperty(provided, EmailProperty.CONTENT_TRANSFER_ENCODING)).ifPresent(arg_0 -> ((EmailPopulatingBuilder)builder).withContentTransferEncoding(arg_0));
        Optional.ofNullable(this.resolveEmailProperty(provided, EmailProperty.SMIME_SIGNING_CONFIG)).ifPresent(arg_0 -> ((EmailPopulatingBuilder)builder).signWithSmime(arg_0));
        Optional.ofNullable(this.resolveEmailProperty(provided, EmailProperty.SMIME_ENCRYPTION_CONFIG)).ifPresent(arg_0 -> ((EmailPopulatingBuilder)builder).encryptWithSmime(arg_0));
        Optional.ofNullable(this.resolveEmailProperty(provided, EmailProperty.DKIM_SIGNING_CONFIG)).ifPresent(arg_0 -> ((EmailPopulatingBuilder)builder).signWithDomainKey(arg_0));
        builder.withBounceTo((Recipient)this.resolveEmailProperty(provided, EmailProperty.BOUNCETO_RECIPIENT));
        Optional.ofNullable(this.resolveEmailProperty(provided, EmailProperty.SENT_DATE)).ifPresent(arg_0 -> ((EmailPopulatingBuilder)builder).fixingSentDate(arg_0));
        builder.fixingMessageId((String)this.resolveEmailProperty(provided, EmailProperty.ID));
        Email email = builder.buildEmail();
        if (provided != null) {
            ((InternalEmail)email).setUserProvidedEmail(provided);
        }
        ((InternalEmail)email).markAsDefaultsAndOverridesApplied();
        return email;
    }

    @Nullable
    private <T> T resolveEmailProperty(@Nullable Email email, @NotNull EmailProperty emailProperty) {
        return (T)MiscUtil.overrideOrProvideOrDefaultProperty((Email)email, (Email)this.emailDefaults, (Email)this.emailOverrides, (EmailProperty)emailProperty);
    }

    @NotNull
    private <T> List<T> resolveEmailCollectionProperty(@Nullable Email email, @NotNull EmailProperty emailProperty) {
        return MiscUtil.overrideAndOrProvideAndOrDefaultCollection((Email)email, (Email)this.emailDefaults, (Email)this.emailOverrides, (EmailProperty)emailProperty);
    }

    @NotNull
    private Map<String, Collection<String>> resolveEmailHeadersProperty(@Nullable Email email) {
        return MiscUtil.overrideAndOrProvideAndOrDefaultHeaders((Email)email, (Email)this.emailDefaults, (Email)this.emailOverrides);
    }

    public String toString() {
        return "EmailGovernanceImpl(emailValidator=" + this.getEmailValidator() + ", emailDefaults=" + this.emailDefaults + ", emailOverrides=" + this.emailOverrides + ", maximumEmailSize=" + this.getMaximumEmailSize() + ")";
    }

    @Nullable
    public EmailValidator getEmailValidator() {
        return this.emailValidator;
    }

    @Nullable
    public Integer getMaximumEmailSize() {
        return this.maximumEmailSize;
    }
}

