/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimePart;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.internet.ParameterList;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.AttachmentResource;
import org.simplejavamail.api.email.CalendarMethod;
import org.simplejavamail.api.email.ContentTransferEncoding;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.NamedDataSource;
import org.simplejavamail.internal.util.Preconditions;

public class MimeMessageHelper {
    private static final String CHARACTER_ENCODING = StandardCharsets.UTF_8.name();
    private static final String HEADER_CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";

    private MimeMessageHelper() {
    }

    static void setSubject(@NotNull Email email, MimeMessage message) throws MessagingException {
        message.setSubject(email.getSubject(), CHARACTER_ENCODING);
    }

    static void setFrom(@NotNull Email email, MimeMessage message) throws UnsupportedEncodingException, MessagingException {
        Recipient fromRecipient = email.getFromRecipient();
        if (fromRecipient != null) {
            message.setFrom((Address)new InternetAddress(fromRecipient.getAddress(), fromRecipient.getName(), CHARACTER_ENCODING));
        }
    }

    static void setRecipients(Email email, Message message) throws UnsupportedEncodingException, MessagingException {
        for (Recipient recipient : email.getRecipients()) {
            message.addRecipient(recipient.getType(), (Address)new InternetAddress(recipient.getAddress(), recipient.getName(), CHARACTER_ENCODING));
        }
    }

    static void setReplyTo(@NotNull Email email, Message message) throws UnsupportedEncodingException, MessagingException {
        if (!email.getReplyToRecipients().isEmpty()) {
            Address[] replyToAddresses = new Address[email.getReplyToRecipients().size()];
            int i = 0;
            for (Recipient replyToRecipient : email.getReplyToRecipients()) {
                replyToAddresses[i++] = new InternetAddress(replyToRecipient.getAddress(), replyToRecipient.getName(), CHARACTER_ENCODING);
            }
            message.setReplyTo(replyToAddresses);
        }
    }

    static void setTexts(@NotNull Email email, MimeMultipart multipartAlternativeMessages) throws MessagingException {
        if (email.getPlainText() != null) {
            MimeBodyPart messagePart = new MimeBodyPart();
            messagePart.setText(email.getPlainText(), CHARACTER_ENCODING);
            messagePart.addHeader(HEADER_CONTENT_TRANSFER_ENCODING, MimeMessageHelper.determineContentTransferEncoder(email));
            multipartAlternativeMessages.addBodyPart((BodyPart)messagePart);
        }
        if (email.getHTMLText() != null) {
            MimeBodyPart messagePartHTML = new MimeBodyPart();
            messagePartHTML.setContent((Object)email.getHTMLText(), String.format("text/html; charset=\"%s\"", CHARACTER_ENCODING));
            messagePartHTML.addHeader(HEADER_CONTENT_TRANSFER_ENCODING, MimeMessageHelper.determineContentTransferEncoder(email));
            multipartAlternativeMessages.addBodyPart((BodyPart)messagePartHTML);
        }
        if (email.getCalendarText() != null) {
            CalendarMethod calendarMethod = Objects.requireNonNull(email.getCalendarMethod(), "calendarMethod is required when calendarText is set");
            MimeBodyPart messagePartCalendar = new MimeBodyPart();
            messagePartCalendar.setContent((Object)email.getCalendarText(), String.format("text/calendar; charset=\"%s\"; method=\"%s\"", CHARACTER_ENCODING, calendarMethod));
            messagePartCalendar.addHeader(HEADER_CONTENT_TRANSFER_ENCODING, MimeMessageHelper.determineContentTransferEncoder(email));
            multipartAlternativeMessages.addBodyPart((BodyPart)messagePartCalendar);
        }
    }

    private static String determineContentTransferEncoder(@NotNull Email email) {
        return (email.getContentTransferEncoding() != null ? email.getContentTransferEncoding() : ContentTransferEncoding.getDefault()).getEncoder();
    }

    static void setTexts(@NotNull Email email, MimePart messagePart) throws MessagingException {
        if (email.getPlainText() != null) {
            messagePart.setText(email.getPlainText(), CHARACTER_ENCODING);
        }
        if (email.getHTMLText() != null) {
            messagePart.setContent((Object)email.getHTMLText(), String.format("text/html; charset=\"%s\"", CHARACTER_ENCODING));
        }
        if (email.getCalendarText() != null) {
            CalendarMethod calendarMethod = Objects.requireNonNull(email.getCalendarMethod(), "CalendarMethod must be set when CalendarText is set");
            messagePart.setContent((Object)email.getCalendarText(), String.format("text/calendar; charset=\"%s\"; method=\"%s\"", CHARACTER_ENCODING, calendarMethod));
        }
        messagePart.addHeader(HEADER_CONTENT_TRANSFER_ENCODING, MimeMessageHelper.determineContentTransferEncoder(email));
    }

    static void configureForwarding(@NotNull Email email, @NotNull MimeMultipart multipartRootMixed) throws MessagingException {
        if (email.getEmailToForward() != null) {
            MimeBodyPart fordwardedMessage = new MimeBodyPart();
            fordwardedMessage.setContent((Object)email.getEmailToForward(), "message/rfc822");
            multipartRootMixed.addBodyPart((BodyPart)fordwardedMessage);
        }
    }

    static void setEmbeddedImages(@NotNull Email email, MimeMultipart multipartRelated) throws MessagingException {
        for (AttachmentResource embeddedImage : email.getEmbeddedImages()) {
            multipartRelated.addBodyPart(MimeMessageHelper.getBodyPartFromDatasource(embeddedImage, "inline"));
        }
    }

    static void setAttachments(@NotNull Email email, MimeMultipart multipartRoot) throws MessagingException {
        for (AttachmentResource attachment : email.getAttachments()) {
            multipartRoot.addBodyPart(MimeMessageHelper.getBodyPartFromDatasource(attachment, "attachment"));
        }
    }

    static void setHeaders(@NotNull Email email, Message message) throws UnsupportedEncodingException, MessagingException {
        for (Map.Entry<String, Collection<String>> entry : email.getHeaders().entrySet()) {
            MimeMessageHelper.setHeader(message, entry);
        }
        if (Boolean.TRUE.equals(email.getUseDispositionNotificationTo())) {
            Recipient dispositionTo = (Recipient)Preconditions.checkNonEmptyArgument((Object)email.getDispositionNotificationTo(), (String)"dispositionNotificationTo");
            InternetAddress internetAddress = new InternetAddress(dispositionTo.getAddress(), dispositionTo.getName(), CHARACTER_ENCODING);
            message.setHeader("Disposition-Notification-To", internetAddress.toString());
        }
        if (Boolean.TRUE.equals(email.getUseReturnReceiptTo())) {
            Recipient returnReceiptTo = (Recipient)Preconditions.checkNonEmptyArgument((Object)email.getReturnReceiptTo(), (String)"returnReceiptTo");
            InternetAddress internetAddress = new InternetAddress(returnReceiptTo.getAddress(), returnReceiptTo.getName(), CHARACTER_ENCODING);
            message.setHeader("Return-Receipt-To", internetAddress.toString());
        }
    }

    private static void setHeader(Message message, Map.Entry<String, Collection<String>> header) throws UnsupportedEncodingException, MessagingException {
        for (String headerValue : header.getValue()) {
            String headerName = header.getKey();
            String headerValueEncoded = MimeUtility.encodeText((String)headerValue, (String)CHARACTER_ENCODING, null);
            String foldedHeaderValue = MimeUtility.fold((int)(headerName.length() + 2), (String)headerValueEncoded);
            message.addHeader(header.getKey(), foldedHeaderValue);
        }
    }

    private static BodyPart getBodyPartFromDatasource(AttachmentResource attachmentResource, String dispositionType) throws MessagingException {
        MimeBodyPart attachmentPart = new MimeBodyPart();
        String resourceName = MimeMessageHelper.determineResourceName(attachmentResource, true);
        String fileName = MimeMessageHelper.determineResourceName(attachmentResource, false);
        attachmentPart.setDataHandler(new DataHandler((DataSource)new NamedDataSource(fileName, attachmentResource.getDataSource())));
        attachmentPart.setFileName(fileName);
        String contentType = attachmentResource.getDataSource().getContentType();
        ParameterList pl = new ParameterList();
        pl.set("filename", fileName);
        pl.set("name", fileName);
        attachmentPart.setHeader("Content-Type", contentType + pl);
        attachmentPart.setHeader("Content-ID", String.format("<%s>", resourceName));
        attachmentPart.setHeader("Content-Description", MimeMessageHelper.determineAttachmentDescription(attachmentResource));
        if (!MiscUtil.valueNullOrEmpty((Object)attachmentResource.getContentTransferEncoding())) {
            attachmentPart.setHeader(HEADER_CONTENT_TRANSFER_ENCODING, attachmentResource.getContentTransferEncoding().getEncoder());
        }
        attachmentPart.setDisposition(dispositionType);
        return attachmentPart;
    }

    static String determineResourceName(AttachmentResource attachmentResource, boolean encodeResourceName) {
        String datasourceName = attachmentResource.getDataSource().getName();
        String resourceName = !MiscUtil.valueNullOrEmpty((Object)attachmentResource.getName()) ? attachmentResource.getName() : (!MiscUtil.valueNullOrEmpty((Object)datasourceName) ? datasourceName : "resource" + UUID.randomUUID());
        if (!MiscUtil.valueNullOrEmpty((Object)datasourceName)) {
            resourceName = MimeMessageHelper.possiblyAddExtension(datasourceName, resourceName);
        }
        return encodeResourceName ? MiscUtil.encodeText((String)resourceName) : resourceName;
    }

    @NotNull
    private static String possiblyAddExtension(String datasourceName, String resourceName) {
        String extension;
        String possibleFilename = datasourceName;
        if (!resourceName.contains(".") && possibleFilename.contains(".") && !resourceName.endsWith(extension = possibleFilename.substring(possibleFilename.lastIndexOf(".")))) {
            resourceName = resourceName + extension;
        }
        return resourceName;
    }

    @Nullable
    private static String determineAttachmentDescription(AttachmentResource attachmentResource) {
        return Optional.ofNullable(attachmentResource.getDescription()).map(MiscUtil::encodeText).orElse(null);
    }
}

