/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import com.pivovarit.function.ThrowingFunction;
import jakarta.activation.ActivationDataFlavor;
import jakarta.activation.CommandMap;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.MailcapCommandMap;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimePart;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.internet.ParseException;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.angus.mail.handlers.text_plain;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.converter.internal.mimemessage.DecodedHeader;
import org.simplejavamail.converter.internal.mimemessage.MimeDataSource;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageParseException;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.NamedDataSource;
import org.simplejavamail.internal.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MimeMessageParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MimeMessageParser.class);

    public static ParsedMimeMessageComponents parseMimeMessage(@NotNull MimeMessage mimeMessage) {
        return MimeMessageParser.parseMimeMessage(mimeMessage, true);
    }

    public static ParsedMimeMessageComponents parseMimeMessage(@NotNull MimeMessage mimeMessage, boolean fetchAttachmentData) {
        ParsedMimeMessageComponents parsedComponents = new ParsedMimeMessageComponents();
        parsedComponents.messageId = MimeMessageParser.parseMessageId(mimeMessage);
        parsedComponents.sentDate = MimeMessageParser.parseSentDate(mimeMessage);
        parsedComponents.subject = MimeMessageParser.parseSubject(mimeMessage);
        parsedComponents.toAddresses.addAll(MimeMessageParser.parseToAddresses(mimeMessage));
        parsedComponents.ccAddresses.addAll(MimeMessageParser.parseCcAddresses(mimeMessage));
        parsedComponents.bccAddresses.addAll(MimeMessageParser.parseBccAddresses(mimeMessage));
        parsedComponents.fromAddress = MimeMessageParser.parseFromAddress(mimeMessage);
        parsedComponents.replyToAddresses = MimeMessageParser.parseReplyToAddresses(mimeMessage);
        MimeMessageParser.parseMimePartTree((MimePart)mimeMessage, parsedComponents, fetchAttachmentData);
        MimeMessageParser.moveInvalidEmbeddedResourcesToAttachments(parsedComponents);
        return parsedComponents;
    }

    private static void parseMimePartTree(@NotNull MimePart currentPart, @NotNull ParsedMimeMessageComponents parsedComponents, boolean fetchAttachmentData) {
        for (DecodedHeader header : MimeMessageParser.retrieveAllHeaders(currentPart)) {
            MimeMessageParser.parseHeader(header, parsedComponents);
        }
        String disposition = MimeMessageParser.parseDisposition(currentPart);
        if (MimeMessageParser.isMimeType(currentPart, "text/plain") && !"attachment".equalsIgnoreCase(disposition)) {
            parsedComponents.plainContent.append(MimeMessageParser.parseContent(currentPart));
            MimeMessageParser.checkContentTransferEncoding(currentPart, parsedComponents);
        } else if (MimeMessageParser.isMimeType(currentPart, "text/html") && !"attachment".equalsIgnoreCase(disposition)) {
            parsedComponents.htmlContent.append(MimeMessageParser.parseContent(currentPart));
            MimeMessageParser.checkContentTransferEncoding(currentPart, parsedComponents);
        } else if (MimeMessageParser.isMimeType(currentPart, "text/calendar") && parsedComponents.calendarContent == null && !"attachment".equalsIgnoreCase(disposition)) {
            parsedComponents.calendarContent = MimeMessageParser.parseCalendarContent(currentPart);
            parsedComponents.calendarMethod = MimeMessageParser.parseCalendarMethod(currentPart);
            MimeMessageParser.checkContentTransferEncoding(currentPart, parsedComponents);
        } else if (MimeMessageParser.isMimeType(currentPart, "multipart/*")) {
            Multipart mp = (Multipart)MimeMessageParser.parseContent(currentPart);
            int count = MimeMessageParser.countBodyParts(mp);
            for (int i = 0; i < count; ++i) {
                MimeMessageParser.parseMimePartTree((MimePart)MimeMessageParser.getBodyPartAtIndex(mp, i), parsedComponents, fetchAttachmentData);
            }
        } else {
            MimeMessageParser.parseDataSource(currentPart, parsedComponents, fetchAttachmentData, disposition);
        }
    }

    private static void parseDataSource(@NotNull MimePart currentPart, @NotNull ParsedMimeMessageComponents parsedComponents, boolean fetchAttachmentData, String disposition) {
        String contentID = MimeMessageParser.parseContentID(currentPart);
        MimeDataSource mimeDataSource = MimeMessageParser.parseAttachment(contentID, currentPart, MimeMessageParser.createDataSource(currentPart, fetchAttachmentData));
        boolean isAttachment = "attachment".equalsIgnoreCase(disposition);
        boolean isInline = "inline".equalsIgnoreCase(disposition);
        if (disposition != null && !isAttachment && !isInline) {
            LOGGER.warn("Content-Disposition '{}' for data source not recognized (it should be either 'attachment' or 'inline'). Skipping body part", (Object)disposition);
        }
        if (!isInline || contentID == null) {
            parsedComponents.attachmentList.add(mimeDataSource);
        }
        if (contentID != null) {
            parsedComponents.cidMap.put(contentID, mimeDataSource);
        }
    }

    private static void checkContentTransferEncoding(MimePart currentPart, @NotNull ParsedMimeMessageComponents parsedComponents) {
        if (parsedComponents.contentTransferEncoding == null) {
            for (DecodedHeader header : MimeMessageParser.retrieveAllHeaders(currentPart)) {
                if (!MimeMessageParser.isEmailHeader(header, "Content-Transfer-Encoding")) continue;
                parsedComponents.contentTransferEncoding = header.getValue();
            }
        }
    }

    private static MimeDataSource parseAttachment(@Nullable String contentId, @NotNull MimePart mimePart, DataSource ds) {
        return MimeDataSource.builder().name(MimeMessageParser.parseResourceNameOrUnnamed(contentId, MimeMessageParser.parseFileName((Part)mimePart))).dataSource(ds).contentDescription(MimeMessageParser.parseContentDescription(mimePart)).contentTransferEncoding(MimeMessageParser.parseContentTransferEncoding(mimePart)).build();
    }

    private static void parseHeader(DecodedHeader header, @NotNull ParsedMimeMessageComponents parsedComponents) {
        String headerValue = MimeMessageParser.decodeText(header.getValue());
        String headerName = MimeMessageParser.decodeText(header.getName());
        if (MimeMessageParser.isEmailHeader(header, "Disposition-Notification-To")) {
            parsedComponents.dispositionNotificationTo = MimeMessageParser.createAddress(headerValue, "Disposition-Notification-To");
        } else if (MimeMessageParser.isEmailHeader(header, "Return-Receipt-To")) {
            parsedComponents.returnReceiptTo = MimeMessageParser.createAddress(headerValue, "Return-Receipt-To");
        } else if (MimeMessageParser.isEmailHeader(header, "Return-Path")) {
            parsedComponents.bounceToAddress = MimeMessageParser.createAddress(headerValue, "Return-Path");
        } else {
            if (!parsedComponents.headers.containsKey(headerName)) {
                parsedComponents.headers.put(headerName, new ArrayList());
            }
            ((Collection)parsedComponents.headers.get(headerName)).add(MimeUtility.unfold((String)headerValue));
        }
    }

    private static boolean isEmailHeader(DecodedHeader header, String emailHeaderName) {
        return header.getName().equals(emailHeaderName) && !MiscUtil.valueNullOrEmpty((Object)header.getValue()) && !MiscUtil.valueNullOrEmpty((Object)header.getValue().trim()) && !header.getValue().equals("<>");
    }

    public static String parseFileName(@NotNull Part currentPart) {
        try {
            if (currentPart.getFileName() != null) {
                return MimeMessageParser.decodeText(currentPart.getFileName());
            }
            if (Arrays.asList(currentPart.getHeader("Content-Type")).contains("message/rfc822")) {
                return "ForwardedMessage.eml";
            }
            return "UnknownAttachment";
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error getting file name", (Exception)((Object)e));
        }
    }

    public static String parseCalendarContent(@NotNull MimePart currentPart) {
        Object content = MimeMessageParser.parseContent(currentPart);
        if (content instanceof InputStream) {
            InputStream calendarContent = (InputStream)content;
            try {
                return MiscUtil.readInputStreamToString((InputStream)calendarContent, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new MimeMessageParseException("Error parsing MimeMessage Calendar content", e);
            }
        }
        return String.valueOf(content);
    }

    public static String parseCalendarMethod(@NotNull MimePart currentPart) {
        String contentType;
        Pattern compile = Pattern.compile("method=\"?(\\w+)");
        try {
            contentType = currentPart.getDataHandler().getContentType();
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error getting content type from Calendar bodypart. Unable to determine Calendar METHOD", (Exception)((Object)e));
        }
        Matcher matcher = compile.matcher(contentType);
        Preconditions.assumeTrue((boolean)matcher.find(), (String)"Calendar METHOD not found in bodypart content type");
        return matcher.group(1);
    }

    @Nullable
    public static String parseContentID(@NotNull MimePart currentPart) {
        try {
            return Optional.ofNullable(currentPart.getContentID()).map(MimeMessageParser::decodeText).orElse(null);
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error getting content ID", (Exception)((Object)e));
        }
    }

    public static MimeBodyPart getBodyPartAtIndex(Multipart parentMultiPart, int index) {
        try {
            return (MimeBodyPart)parentMultiPart.getBodyPart(index);
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException(String.format("Error getting bodypart at index %s", index), (Exception)((Object)e));
        }
    }

    public static int countBodyParts(Multipart mp) {
        try {
            return mp.getCount();
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error parsing MimeMessage multipart count", (Exception)((Object)e));
        }
    }

    public static <T> T parseContent(@NotNull MimePart currentPart) {
        try {
            return (T)currentPart.getContent();
        }
        catch (MessagingException | IOException e) {
            throw new MimeMessageParseException("Error parsing MimeMessage Content", (Exception)e);
        }
    }

    @Nullable
    public static String parseDisposition(@NotNull MimePart currentPart) {
        try {
            return currentPart.getDisposition();
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error parsing MimeMessage disposition", (Exception)((Object)e));
        }
    }

    @NotNull
    private static String parseResourceNameOrUnnamed(@Nullable String possibleWrappedContentID, @NotNull String fileName) {
        String resourceName = MimeMessageParser.parseResourceName(possibleWrappedContentID, fileName);
        return MiscUtil.valueNullOrEmpty((Object)resourceName) ? "unnamed" : resourceName;
    }

    @NotNull
    private static String parseResourceName(@Nullable String possibleWrappedContentID, @NotNull String fileName) {
        if (MiscUtil.valueNullOrEmpty((Object)fileName) && !MiscUtil.valueNullOrEmpty((Object)possibleWrappedContentID)) {
            return possibleWrappedContentID.replaceAll("^<?(.*?)>?$", "$1");
        }
        return fileName;
    }

    @NotNull
    public static List<DecodedHeader> retrieveAllHeaders(@NotNull MimePart part) {
        try {
            return Collections.list(part.getAllHeaders()).stream().map(DecodedHeader::of).collect(Collectors.toList());
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error getting all headers", (Exception)((Object)e));
        }
    }

    @Nullable
    static InternetAddress createAddress(String address, String typeOfAddress) {
        try {
            return address.trim().isEmpty() ? null : new InternetAddress(address);
        }
        catch (AddressException e) {
            if (e.getMessage().equals("Empty address")) {
                return null;
            }
            throw new MimeMessageParseException(String.format("Error parsing [%s] address [%s]", typeOfAddress, address), (Exception)((Object)e));
        }
    }

    public static boolean isMimeType(@NotNull MimePart part, @NotNull String mimeType) {
        try {
            ContentType contentType = new ContentType(MimeMessageParser.retrieveDataHandler(part).getContentType());
            return contentType.match(mimeType);
        }
        catch (ParseException ex) {
            return MimeMessageParser.retrieveContentType(part).equalsIgnoreCase(mimeType);
        }
    }

    public static String retrieveContentType(@NotNull MimePart part) {
        try {
            return part.getContentType();
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error getting content type", (Exception)((Object)e));
        }
    }

    public static DataHandler retrieveDataHandler(@NotNull MimePart part) {
        try {
            return part.getDataHandler();
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error getting data handler", (Exception)((Object)e));
        }
    }

    @NotNull
    private static DataSource createDataSource(@NotNull MimePart part, boolean fetchAttachmentData) {
        DataSource dataSource = MimeMessageParser.retrieveDataHandler(part).getDataSource();
        String dataSourceName = MimeMessageParser.parseDataSourceName((Part)part, dataSource);
        if (fetchAttachmentData) {
            String contentType = MiscUtil.parseBaseMimeType((String)dataSource.getContentType());
            ByteArrayDataSource result = new ByteArrayDataSource(MimeMessageParser.readContent(MimeMessageParser.retrieveInputStream(dataSource)), contentType);
            result.setName(dataSourceName);
            return result;
        }
        return new NamedDataSource(dataSourceName, dataSource);
    }

    public static InputStream retrieveInputStream(DataSource dataSource) {
        try {
            return dataSource.getInputStream();
        }
        catch (IOException e) {
            throw new MimeMessageParseException("Error getting input stream", e);
        }
    }

    @Nullable
    private static String parseDataSourceName(@NotNull Part part, @NotNull DataSource dataSource) {
        String result = !MiscUtil.valueNullOrEmpty((Object)dataSource.getName()) ? dataSource.getName() : MimeMessageParser.parseFileName(part);
        return !MiscUtil.valueNullOrEmpty((Object)result) ? MimeMessageParser.decodeText(result) : null;
    }

    private static byte @NotNull [] readContent(@NotNull InputStream is) {
        try {
            return MiscUtil.readInputStreamToBytes((InputStream)is);
        }
        catch (IOException e) {
            throw new MimeMessageParseException("Error reading content", e);
        }
    }

    @NotNull
    public static List<InternetAddress> parseToAddresses(@NotNull MimeMessage mimeMessage) {
        return MimeMessageParser.parseInternetAddresses(MimeMessageParser.retrieveRecipients(mimeMessage, Message.RecipientType.TO));
    }

    @NotNull
    public static List<InternetAddress> parseCcAddresses(@NotNull MimeMessage mimeMessage) {
        return MimeMessageParser.parseInternetAddresses(MimeMessageParser.retrieveRecipients(mimeMessage, Message.RecipientType.CC));
    }

    @NotNull
    public static List<InternetAddress> parseBccAddresses(@NotNull MimeMessage mimeMessage) {
        return MimeMessageParser.parseInternetAddresses(MimeMessageParser.retrieveRecipients(mimeMessage, Message.RecipientType.BCC));
    }

    @Nullable
    public static Address[] retrieveRecipients(@NotNull MimeMessage mimeMessage, Message.RecipientType recipientType) {
        try {
            String recipientHeader = mimeMessage.getHeader(MimeMessageParser.getHeaderName(recipientType), ",");
            return Optional.ofNullable(recipientHeader).map(ThrowingFunction.unchecked(h -> InternetAddress.parseHeader((String)h, (boolean)false))).map(ias -> (Address[])Arrays.stream(ias).map(ThrowingFunction.unchecked(ia -> new InternetAddress(ia.getAddress(), MimeMessageParser.decodePersonalName(ia.getPersonal())))).toArray(Address[]::new)).orElse(null);
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException(String.format("Error getting [%s] recipient types", recipientType), (Exception)((Object)e));
        }
    }

    private static String getHeaderName(Message.RecipientType recipientType) {
        if (recipientType == Message.RecipientType.TO) {
            return "To";
        }
        if (recipientType == Message.RecipientType.CC) {
            return "Cc";
        }
        Preconditions.assumeTrue((recipientType == Message.RecipientType.BCC ? 1 : 0) != 0, (String)("invalid recipient type: " + recipientType));
        return "Bcc";
    }

    @Nullable
    private static String decodePersonalName(String personalName) {
        return personalName != null ? MimeMessageParser.decodeText(personalName) : null;
    }

    @Nullable
    public static String parseContentDescription(@NotNull MimePart mimePart) {
        try {
            return Optional.ofNullable(mimePart.getHeader("Content-Description", ",")).map(MimeMessageParser::decodeText).orElse(null);
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error reading Content-Description header", (Exception)((Object)e));
        }
    }

    @Nullable
    public static String parseContentTransferEncoding(@NotNull MimePart mimePart) {
        try {
            return Optional.ofNullable(mimePart.getHeader("Content-Transfer-Encoding", ",")).map(MimeMessageParser::decodeText).orElse(null);
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error reading Content-Transfer-Encoding header", (Exception)((Object)e));
        }
    }

    @NotNull
    static String decodeText(@NotNull String result) {
        try {
            return MimeUtility.decodeText((String)result);
        }
        catch (UnsupportedEncodingException e) {
            throw new MimeMessageParseException("Error decoding text", e);
        }
    }

    @NotNull
    private static List<InternetAddress> parseInternetAddresses(@Nullable Address[] recipients) {
        ArrayList addresses = recipients != null ? Arrays.asList(recipients) : new ArrayList();
        ArrayList<InternetAddress> mailAddresses = new ArrayList<InternetAddress>();
        for (Address address : addresses) {
            if (!(address instanceof InternetAddress)) continue;
            mailAddresses.add((InternetAddress)address);
        }
        return mailAddresses;
    }

    @Nullable
    public static InternetAddress parseFromAddress(@NotNull MimeMessage mimeMessage) {
        try {
            Address[] addresses = mimeMessage.getFrom();
            return addresses == null || addresses.length == 0 ? null : (InternetAddress)addresses[0];
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error parsing from-address", (Exception)((Object)e));
        }
    }

    @Nullable
    public static InternetAddress parseReplyToAddresses(@NotNull MimeMessage mimeMessage) {
        try {
            Address[] addresses = mimeMessage.getReplyTo();
            return addresses == null || addresses.length == 0 ? null : (InternetAddress)addresses[0];
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error parsing replyTo addresses", (Exception)((Object)e));
        }
    }

    @NotNull
    public static String parseSubject(@NotNull MimeMessage mimeMessage) {
        try {
            return Optional.ofNullable(mimeMessage.getSubject()).orElse("");
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error getting subject", (Exception)((Object)e));
        }
    }

    @Nullable
    public static String parseMessageId(@NotNull MimeMessage mimeMessage) {
        try {
            return mimeMessage.getMessageID();
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error getting message ID", (Exception)((Object)e));
        }
    }

    @Nullable
    public static Date parseSentDate(@NotNull MimeMessage mimeMessage) {
        try {
            return mimeMessage.getSentDate();
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error getting sent-date", (Exception)((Object)e));
        }
    }

    static void moveInvalidEmbeddedResourcesToAttachments(ParsedMimeMessageComponents parsedComponents) {
        String htmlContent = parsedComponents.htmlContent.toString();
        Iterator<Map.Entry<String, MimeDataSource>> it = parsedComponents.cidMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, MimeDataSource> cidEntry = it.next();
            String cid = MiscUtil.extractCID((String)cidEntry.getKey());
            if (htmlContent.contains("cid:" + cid)) continue;
            parsedComponents.attachmentList.add(cidEntry.getValue());
            it.remove();
        }
    }

    static {
        MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mc.addMailcap("text/calendar;; x-java-content-handler=" + text_calendar.class.getName());
        CommandMap.setDefaultCommandMap((CommandMap)mc);
    }

    static class text_calendar
    extends text_plain {
        private static final ActivationDataFlavor[] myDF = new ActivationDataFlavor[]{new ActivationDataFlavor(String.class, "text/calendar", "iCalendar String")};

        text_calendar() {
        }

        protected ActivationDataFlavor[] getDataFlavors() {
            return myDF;
        }
    }

    public static class ParsedMimeMessageComponents {
        final Set<MimeDataSource> attachmentList = new LinkedHashSet<MimeDataSource>();
        final Map<String, MimeDataSource> cidMap = new TreeMap<String, MimeDataSource>();
        private final Map<String, Collection<Object>> headers = new HashMap<String, Collection<Object>>();
        private final List<InternetAddress> toAddresses = new ArrayList<InternetAddress>();
        private final List<InternetAddress> ccAddresses = new ArrayList<InternetAddress>();
        private final List<InternetAddress> bccAddresses = new ArrayList<InternetAddress>();
        @Nullable
        private String messageId;
        @Nullable
        private String subject;
        @Nullable
        private InternetAddress fromAddress;
        @Nullable
        private InternetAddress replyToAddresses;
        @Nullable
        private InternetAddress dispositionNotificationTo;
        @Nullable
        private InternetAddress returnReceiptTo;
        @Nullable
        private InternetAddress bounceToAddress;
        @Nullable
        private String contentTransferEncoding;
        private final StringBuilder plainContent = new StringBuilder();
        final StringBuilder htmlContent = new StringBuilder();
        @Nullable
        private String calendarMethod;
        @Nullable
        private String calendarContent;
        @Nullable
        private Date sentDate;

        @Nullable
        public String getPlainContent() {
            return this.plainContent.length() == 0 ? null : this.plainContent.toString();
        }

        @Nullable
        public String getHtmlContent() {
            return this.htmlContent.length() == 0 ? null : this.htmlContent.toString();
        }

        @Nullable
        public Date getSentDate() {
            return this.sentDate != null ? new Date(this.sentDate.getTime()) : null;
        }

        public Set<MimeDataSource> getAttachmentList() {
            return this.attachmentList;
        }

        public Map<String, MimeDataSource> getCidMap() {
            return this.cidMap;
        }

        public Map<String, Collection<Object>> getHeaders() {
            return this.headers;
        }

        public List<InternetAddress> getToAddresses() {
            return this.toAddresses;
        }

        public List<InternetAddress> getCcAddresses() {
            return this.ccAddresses;
        }

        public List<InternetAddress> getBccAddresses() {
            return this.bccAddresses;
        }

        @Nullable
        public String getMessageId() {
            return this.messageId;
        }

        @Nullable
        public String getSubject() {
            return this.subject;
        }

        @Nullable
        public InternetAddress getFromAddress() {
            return this.fromAddress;
        }

        @Nullable
        public InternetAddress getReplyToAddresses() {
            return this.replyToAddresses;
        }

        @Nullable
        public InternetAddress getDispositionNotificationTo() {
            return this.dispositionNotificationTo;
        }

        @Nullable
        public InternetAddress getReturnReceiptTo() {
            return this.returnReceiptTo;
        }

        @Nullable
        public InternetAddress getBounceToAddress() {
            return this.bounceToAddress;
        }

        @Nullable
        public String getContentTransferEncoding() {
            return this.contentTransferEncoding;
        }

        @Nullable
        public String getCalendarMethod() {
            return this.calendarMethod;
        }

        @Nullable
        public String getCalendarContent() {
            return this.calendarContent;
        }
    }
}

