/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.smtpconnectionpool;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.mail.MessagingException;
import jakarta.mail.NoSuchProviderException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import org.bbottema.genericobjectpool.Allocator;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.smtpconnectionpool.SessionTransport;
import org.simplejavamail.smtpconnectionpool.TransportHandlingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransportAllocator
extends Allocator<SessionTransport> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransportAllocator.class);
    @NotNull
    private final Session session;

    TransportAllocator(@NotNull Session session) {
        this.session = session;
    }

    @NotNull
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="generated code by se.eris Maven plugin")
    public SessionTransport allocate() {
        LOGGER.trace("opening transport connection...");
        try {
            Transport transport = this.session.getTransport();
            this.connectTransport(transport);
            return new SessionTransport(this.session, transport);
        }
        catch (NoSuchProviderException e) {
            throw new TransportHandlingException("unable to get transport from session:\n\t" + this.session.getProperties(), e);
        }
    }

    public void allocateForReuse(SessionTransport sessionTransport) {
        if (!sessionTransport.getTransport().isConnected()) {
            this.connectTransport(sessionTransport.getTransport());
        }
    }

    private void connectTransport(Transport transport) {
        try {
            String oauth2Token = (String)this.session.getProperties().getOrDefault((Object)"smtp.connection.pool.transport.allocator.oauth2token", (Object)null);
            if (oauth2Token != null) {
                transport.connect(this.session.getProperties().getProperty("mail.smtp.user"), oauth2Token);
            } else {
                transport.connect();
            }
        }
        catch (MessagingException e) {
            throw new TransportHandlingException("Error when trying to open connection to the server, session:\n\t" + this.session.getProperties(), e);
        }
    }

    public void deallocate(SessionTransport sessionTransport) {
        LOGGER.trace("closing transport...");
        try {
            sessionTransport.getTransport().close();
        }
        catch (MessagingException e) {
            throw new TransportHandlingException("error closing transport connection", e);
        }
    }
}

