/*
 * Decompiled with CFR 0.152.
 */
package org.simplericity.jettyconsole;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarFile;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.simplericity.jettyconsole.AdditionalDependency;
import org.simplericity.jettyconsole.creator.Creator;
import org.simplericity.jettyconsole.creator.CreatorExecutionException;
import org.simplericity.jettyconsole.creator.DefaultCreator;

public class CreateDescriptorMojo
extends AbstractMojo {
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private File classesDirectory;
    private String name;
    private File backgroundImage;
    private MavenProject project;
    private File workingDirectory;
    private File destinationFile;
    private List<AdditionalDependency> additionalDependencies;
    private MavenProjectHelper projectHelper;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver resolver;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private ArtifactMetadataSource artifactMetadataSource;
    private Creator creator;
    private boolean attachWithClassifier;
    private String properties;
    private Properties props;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getProps();
        if (this.backgroundImage != null && !this.backgroundImage.exists()) {
            throw new MojoExecutionException("The 'backgroundImage' file you specified does not exist");
        }
        Artifact warArtifact = this.getWarArtifact();
        this.creator = new DefaultCreator();
        this.creator.setWorkingDirectory(this.workingDirectory);
        this.creator.setSourceWar(warArtifact.getFile());
        this.creator.setDestinationWar(this.destinationFile);
        this.creator.setName(this.name);
        this.creator.setProperties(this.properties);
        this.creator.setManifestEntries(this.archive.getManifestEntries());
        if (this.backgroundImage != null && this.backgroundImage.exists() && this.backgroundImage.isFile()) {
            try {
                this.creator.setBackgroundImage(this.backgroundImage.toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        this.setDeps();
        try {
            this.getLog().info((CharSequence)"Creating JettyConsole package");
            this.creator.create();
        }
        catch (CreatorExecutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        if (this.attachWithClassifier) {
            this.attachArtifact();
        } else {
            this.project.getArtifact().setFile(this.destinationFile);
        }
    }

    private void setDeps() throws MojoExecutionException, MojoFailureException {
        List<File> deps = this.getDependencies();
        ArrayList<URL> additionalDeps = new ArrayList<URL>();
        for (File file : deps) {
            if (file.getName().contains("jetty-console-core")) {
                try {
                    this.creator.setCoreDependency(file.toURL());
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
            try {
                additionalDeps.add(file.toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        if (this.additionalDependencies != null) {
            for (AdditionalDependency dep : this.additionalDependencies) {
                String groupId = dep.getGroupId();
                String version = dep.getVersion();
                if (groupId == null && version == null) {
                    groupId = "org.simplericity.jettyconsole";
                    version = this.props.getProperty("version");
                }
                artifacts.add(this.artifactFactory.createDependencyArtifact(groupId, dep.getArtifactId(), VersionRange.createFromVersion((String)version), dep.getType(), dep.getClassifier(), dep.getScope()));
            }
        }
        try {
            HashSet<Artifact> slf4jBindingArtifacts = new HashSet<Artifact>();
            if (artifacts.size() > 0) {
                ArtifactResolutionResult result = this.resolver.resolveTransitively(artifacts, this.project.getArtifact(), this.localRepository, this.remoteRepositories, this.artifactMetadataSource, (ArtifactFilter)new ScopeArtifactFilter("runtime"));
                for (Artifact artifact : result.getArtifacts()) {
                    if ("slf4j-api".equals(artifact.getArtifactId())) continue;
                    additionalDeps.add(artifact.getFile().toURL());
                    if (!this.hasSlf4jBinding(artifact.getFile())) continue;
                    slf4jBindingArtifacts.add(artifact);
                }
            }
            if (this.project.getPackaging().equals("jar")) {
                additionalDeps.add(this.project.getArtifact().getFile().toURL());
            }
            if (slf4jBindingArtifacts.isEmpty()) {
                String slf4jVersion = this.props.getProperty("slf4jVersion");
                Artifact slf4jArtifact = this.artifactFactory.createDependencyArtifact("org.slf4j", "slf4j-simple", VersionRange.createFromVersion((String)slf4jVersion), "jar", null, "runtime");
                this.resolver.resolve(slf4jArtifact, this.remoteRepositories, this.localRepository);
                additionalDeps.add(slf4jArtifact.getFile().toURL());
            } else if (slf4jBindingArtifacts.size() > 1) {
                throw new MojoFailureException("You have dependencies on multiple SJF4J artifacts, please select a single one: " + slf4jBindingArtifacts);
            }
        }
        catch (MalformedURLException | ArtifactNotFoundException | ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        this.creator.setAdditionalDependecies(additionalDeps);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasSlf4jBinding(File file) throws MojoExecutionException {
        try (JarFile jarFile = new JarFile(file);){
            boolean bl = jarFile.getEntry("org/slf4j/impl/StaticLoggerBinder.class") != null;
            return bl;
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private List<File> getDependencies() throws MojoExecutionException {
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        String version = this.props.getProperty("version");
        String jettyVersion = this.props.getProperty("jettyVersion");
        this.getLog().info((CharSequence)("Resolving dependencies for version " + version + " of jetty-console-core"));
        artifacts.add(this.artifactFactory.createDependencyArtifact("org.simplericity.jettyconsole", "jetty-console-core", VersionRange.createFromVersion((String)version), "jar", null, "runtime"));
        ArrayList<File> artifactFiles = new ArrayList<File>();
        try {
            ArtifactResolutionResult result = this.resolver.resolveTransitively(artifacts, this.project.getArtifact(), this.remoteRepositories, this.localRepository, this.artifactMetadataSource);
            for (Artifact artifact : result.getArtifacts()) {
                artifactFiles.add(artifact.getFile());
            }
            return artifactFiles;
        }
        catch (ArtifactNotFoundException | ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void getProps() throws MojoExecutionException {
        this.props = new Properties();
        try {
            this.props.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("pluginversion.properties"));
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void attachArtifact() {
        this.projectHelper.attachArtifact(this.project, "war", "jetty-console", this.destinationFile);
    }

    public Artifact getWarArtifact() throws MojoExecutionException {
        if (this.project.getArtifact().getFile().getName().endsWith(".war")) {
            return this.project.getArtifact();
        }
        ArrayList<Artifact> wars = new ArrayList<Artifact>();
        for (Artifact artifact : this.project.getArtifacts()) {
            if (!"war".equals(artifact.getType())) continue;
            wars.add(artifact);
        }
        if (wars.size() == 0) {
            throw new MojoExecutionException("Can't find any war dependency");
        }
        if (wars.size() > 1) {
            throw new MojoExecutionException("Found more than one war dependency, can't continue");
        }
        return (Artifact)wars.get(0);
    }
}

