/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins;

import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.bouncycastle.openpgp.PGPUtil;
import org.simplify4u.plugins.AbstractPGPMojo;
import org.simplify4u.plugins.ArtifactResolver;
import org.simplify4u.plugins.PGPMojoException;
import org.simplify4u.plugins.keyserver.PGPKeysCache;
import org.simplify4u.plugins.pgp.ArtifactInfo;
import org.simplify4u.plugins.pgp.KeyInfo;
import org.simplify4u.plugins.pgp.PGPSignatureInfo;
import org.simplify4u.plugins.pgp.SignatureInfo;
import org.simplify4u.plugins.pgp.SignatureStatus;
import org.simplify4u.plugins.utils.PGPSignatureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="show", requiresDirectInvocation=true, requiresOnline=true, requiresProject=false)
public class PGPShowMojo
extends AbstractPGPMojo {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PGPShowMojo.class);
    public static final String MOJO_NAME = "show";
    private final RepositorySystem repositorySystem;
    @Parameter(property="showPom", defaultValue="false")
    protected boolean showPom;
    @Parameter(property="artifact", required=true)
    private String artifact;
    private boolean hasError;

    @Inject
    PGPShowMojo(ArtifactResolver artifactResolver, PGPKeysCache pgpKeysCache, PGPSignatureUtils pgpSignatureUtils, MavenSession session, RepositorySystem repositorySystem) {
        super(artifactResolver, pgpKeysCache, pgpSignatureUtils, session);
        this.repositorySystem = repositorySystem;
    }

    @Override
    protected String getMojoName() {
        return MOJO_NAME;
    }

    @Override
    protected void executeConfiguredMojo() throws MojoExecutionException {
        HashSet<Artifact> artifactsToCheck = new HashSet<Artifact>();
        Artifact artifactToCheck = this.prepareArtifactToCheck();
        artifactsToCheck.add(this.artifactResolver.resolveArtifact(artifactToCheck));
        if (this.showPom && artifactToCheck.isResolved()) {
            artifactsToCheck.add(this.artifactResolver.resolvePom(artifactToCheck));
        }
        Map<Artifact, Artifact> artifactMap = this.artifactResolver.resolveSignatures(artifactsToCheck, ArtifactResolver.SignatureRequirement.NONE);
        artifactMap.forEach(this::processArtifact);
        if (this.hasError) {
            throw new PGPMojoException("Some of artifact can't be checked");
        }
    }

    private void processArtifact(Artifact artifact, Artifact artifactAsc) {
        PGPSignatureInfo signatureInfo = this.pgpSignatureUtils.getSignatureInfo(artifact, artifactAsc, this.pgpKeysCache);
        MessageBuilder messageBuilder = MessageUtils.buffer();
        messageBuilder.newline();
        messageBuilder.newline();
        ArtifactInfo artifactInfo = signatureInfo.getArtifact();
        messageBuilder.a((CharSequence)"Artifact:").newline();
        messageBuilder.a((CharSequence)"\tgroupId:     ").strong((Object)artifactInfo.getGroupId()).newline();
        messageBuilder.a((CharSequence)"\tartifactId:  ").strong((Object)artifactInfo.getArtifactId()).newline();
        messageBuilder.a((CharSequence)"\ttype:        ").strong((Object)artifactInfo.getType()).newline();
        Optional.ofNullable(artifactInfo.getClassifier()).ifPresent(classifier -> messageBuilder.a((CharSequence)"\tclassifier:  ").strong(classifier).newline());
        messageBuilder.a((CharSequence)"\tversion:     ").strong((Object)artifactInfo.getVersion()).newline();
        if (signatureInfo.getStatus() == SignatureStatus.ARTIFACT_NOT_RESOLVED) {
            messageBuilder.a((CharSequence)"\t").error((Object)"artifact was not resolved  - try mvn -U ...").newline();
        }
        messageBuilder.newline();
        SignatureInfo signature = signatureInfo.getSignature();
        if (signature != null) {
            messageBuilder.a((CharSequence)"PGP signature:").newline();
            messageBuilder.a((CharSequence)"\tversion:     ").strong((Object)signature.getVersion()).newline();
            messageBuilder.a((CharSequence)"\talgorithm:   ").strong(Try.of((CheckedFunction0 & Serializable)() -> PGPUtil.getSignatureName((int)signature.getKeyAlgorithm(), (int)signature.getHashAlgorithm())).get()).newline();
            messageBuilder.a((CharSequence)"\tkeyId:       ").strong((Object)signature.getKeyId()).newline();
            messageBuilder.a((CharSequence)"\tcreate date: ").strong((Object)signature.getDate()).newline();
            messageBuilder.a((CharSequence)"\tstatus:      ");
            if (signatureInfo.getStatus() == SignatureStatus.SIGNATURE_VALID) {
                messageBuilder.success((Object)"valid");
            } else {
                messageBuilder.error((Object)"invalid");
            }
            messageBuilder.newline();
        } else if (signatureInfo.getStatus() == SignatureStatus.SIGNATURE_NOT_RESOLVED) {
            messageBuilder.a((CharSequence)"\t").error((Object)"PGP signature was not resolved - try mvn -U ...").newline();
        }
        messageBuilder.newline();
        KeyInfo key = signatureInfo.getKey();
        if (key != null) {
            messageBuilder.a((CharSequence)"PGP key:").newline();
            messageBuilder.a((CharSequence)"\tversion:     ").strong((Object)key.getVersion()).newline();
            messageBuilder.a((CharSequence)"\talgorithm:   ").strong((Object)this.pgpSignatureUtils.keyAlgorithmName(key.getAlgorithm())).newline();
            messageBuilder.a((CharSequence)"\tbits:        ").strong((Object)key.getBits()).newline();
            messageBuilder.a((CharSequence)"\tfingerprint: ").strong((Object)key.getFingerprint()).newline();
            Optional.ofNullable(key.getMaster()).ifPresent(masterKey -> messageBuilder.a((CharSequence)"\tmaster key:  ").strong(masterKey).newline());
            messageBuilder.a((CharSequence)"\tcreate date: ").strong((Object)key.getDate()).newline();
            messageBuilder.a((CharSequence)"\tuids:        ").strong(key.getUids()).newline();
        }
        messageBuilder.newline();
        Optional.ofNullable(signatureInfo.getErrorMessage()).ifPresent(errorMessage -> messageBuilder.error(errorMessage).newline());
        LOGGER.info(messageBuilder.toString());
        this.hasError |= signatureInfo.getStatus() != SignatureStatus.SIGNATURE_VALID && signatureInfo.getStatus() != SignatureStatus.SIGNATURE_INVALID;
    }

    private Artifact prepareArtifactToCheck() {
        String[] aItems = Optional.ofNullable(this.artifact).map(String::trim).map(s -> s.split(":")).filter(a -> ((String[])a).length >= 3 && ((String[])a).length <= 5).orElseThrow(() -> new PGPMojoException("The parameters 'artifact' is miss or in invalid format - groupId:artifactId:version[:packaging[:classifier]]"));
        return this.repositorySystem.createArtifactWithClassifier(aItems[0], aItems[1], aItems[2], PGPShowMojo.getItem(aItems, 3, "jar"), PGPShowMojo.getItem(aItems, 4, null));
    }

    private static String getItem(String[] items, int index, String defaultValue) {
        if (items.length > index) {
            return items[index];
        }
        return defaultValue;
    }

    @Generated
    public void setShowPom(boolean showPom) {
        this.showPom = showPom;
    }

    @Generated
    public void setArtifact(String artifact) {
        this.artifact = artifact;
    }
}

