/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.keysmap;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.simplify4u.plugins.keysmap.KeyInfoItem;
import org.simplify4u.plugins.keysmap.KeyInfoItemAnyKey;
import org.simplify4u.plugins.keysmap.KeyInfoItemBrokenSig;
import org.simplify4u.plugins.keysmap.KeyInfoItemKey;
import org.simplify4u.plugins.keysmap.KeyInfoItemNoKey;
import org.simplify4u.plugins.keysmap.KeyInfoItemNoSig;

class KeyInfo {
    private static final Map<String, KeyInfoItem> SPECIAL_KEYS = Stream.of(new AbstractMap.SimpleEntry<String, KeyInfoItemAnyKey>("*", new KeyInfoItemAnyKey()), new AbstractMap.SimpleEntry<String, KeyInfoItemAnyKey>("any", new KeyInfoItemAnyKey()), new AbstractMap.SimpleEntry<String, KeyInfoItemBrokenSig>("badSig", new KeyInfoItemBrokenSig()), new AbstractMap.SimpleEntry<String, KeyInfoItemNoKey>("noKey", new KeyInfoItemNoKey()), new AbstractMap.SimpleEntry<String, KeyInfoItemNoSig>("noSig", new KeyInfoItemNoSig())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    private final List<KeyInfoItem> keys = new ArrayList<KeyInfoItem>();

    public KeyInfo(String strKeys) {
        if (strKeys == null) {
            throw new IllegalArgumentException("null key not allowed");
        }
        if (strKeys.trim().isEmpty()) {
            this.keys.add(new KeyInfoItemNoSig());
            return;
        }
        Arrays.stream(strKeys.split(",")).map(String::trim).forEach(key -> {
            if (key.startsWith("0x")) {
                this.keys.add(new KeyInfoItemKey((String)key));
            } else {
                Optional<KeyInfoItem> keyInfoItem = SPECIAL_KEYS.entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase((String)key)).map(Map.Entry::getValue).findFirst();
                this.keys.add(keyInfoItem.orElseThrow(() -> new IllegalArgumentException("Invalid keyID " + key + " must start with 0x or be any of " + SPECIAL_KEYS.keySet())));
            }
        });
    }

    public boolean isKeyMatch(PGPPublicKey pgpPublicKey, PGPPublicKeyRing pgpPublicKeyRing) {
        return this.keys.stream().anyMatch(keyInfoItem -> keyInfoItem.isKeyMatch(pgpPublicKey, pgpPublicKeyRing));
    }

    public boolean isNoSignature() {
        return this.keys.stream().anyMatch(KeyInfoItem::isNoSignature);
    }

    public boolean isKeyMissing() {
        return this.keys.stream().anyMatch(KeyInfoItem::isKeyMissing);
    }

    public boolean isBrokenSignature() {
        return this.keys.stream().anyMatch(KeyInfoItem::isBrokenSignature);
    }
}

