/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.utils;

import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Optional;
import javax.inject.Named;
import org.apache.maven.artifact.Artifact;
import org.bouncycastle.bcpg.sig.IssuerFingerprint;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.simplify4u.plugins.keyserver.PGPKeysCache;
import org.simplify4u.plugins.pgp.ArtifactInfo;
import org.simplify4u.plugins.pgp.KeyInfo;
import org.simplify4u.plugins.pgp.PGPSignatureInfo;
import org.simplify4u.plugins.pgp.SignatureInfo;
import org.simplify4u.plugins.pgp.SignatureStatus;
import org.simplify4u.plugins.utils.HexUtils;
import org.simplify4u.plugins.utils.PGPKeyId;
import org.simplify4u.plugins.utils.PGPSignatureException;
import org.simplify4u.plugins.utils.PublicKeyUtils;

@Named
public class PGPSignatureUtils {
    public String checkWeakHashAlgorithm(PGPSignature signature) {
        switch (signature.getHashAlgorithm()) {
            case 1: {
                return "MD5";
            }
            case 4: {
                return "double-width SHA";
            }
            case 5: {
                return "MD2";
            }
            case 6: {
                return "TIGER/192";
            }
            case 7: {
                return "HAVAL (5 pass, 160-bit)";
            }
            case 11: {
                return "SHA-224";
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                return null;
            }
        }
        throw new UnsupportedOperationException("Unknown hash algorithm value encountered: " + signature.getHashAlgorithm());
    }

    public PGPSignature loadSignature(InputStream input) throws PGPSignatureException {
        try {
            Object nextObject;
            InputStream sigInputStream = PGPUtil.getDecoderStream((InputStream)input);
            PGPObjectFactory pgpObjectFactory = new PGPObjectFactory(sigInputStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            while ((nextObject = pgpObjectFactory.nextObject()) != null) {
                if (nextObject instanceof PGPSignatureList) {
                    return ((PGPSignatureList)nextObject).get(0);
                }
                if (nextObject instanceof PGPCompressedData) {
                    pgpObjectFactory = new PGPObjectFactory(((PGPCompressedData)nextObject).getDataStream(), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                }
                if (!(nextObject instanceof PGPLiteralData)) continue;
                InputStream dataStream = ((PGPLiteralData)nextObject).getDataStream();
                byte[] buf = new byte[8192];
                while (dataStream.read(buf) > 0) {
                }
            }
        }
        catch (IOException | PGPException e) {
            throw new PGPSignatureException(e.getMessage(), e);
        }
        throw new PGPSignatureException("PGP signature not found.");
    }

    public PGPSignature loadSignature(File file) throws IOException, PGPSignatureException {
        try (FileInputStream in = new FileInputStream(file);){
            PGPSignature pGPSignature = this.loadSignature(in);
            return pGPSignature;
        }
    }

    public void readFileContentInto(PGPSignature signature, File file) throws IOException {
        try (BufferedInputStream inArtifact = new BufferedInputStream(new FileInputStream(file));){
            int t;
            byte[] buf = new byte[8192];
            while ((t = ((InputStream)inArtifact).read(buf)) >= 0) {
                signature.update(buf, 0, t);
            }
        }
    }

    public PGPKeyId retrieveKeyId(PGPSignature signature) throws PGPSignatureException {
        Optional<Long> issuerKeyId;
        Optional<PGPSignatureSubpacketVector> hashedSubPackets = Optional.ofNullable(signature.getHashedSubPackets());
        Optional<PGPSignatureSubpacketVector> unHashedSubPackets = Optional.ofNullable(signature.getUnhashedSubPackets());
        Optional<IssuerFingerprint> issuerFingerprint = hashedSubPackets.map(PGPSignatureSubpacketVector::getIssuerFingerprint);
        if (!issuerFingerprint.isPresent()) {
            issuerFingerprint = unHashedSubPackets.map(PGPSignatureSubpacketVector::getIssuerFingerprint);
        }
        if (!(issuerKeyId = unHashedSubPackets.map(PGPSignatureSubpacketVector::getIssuerKeyID).filter(id -> id != 0L)).isPresent()) {
            issuerKeyId = hashedSubPackets.map(PGPSignatureSubpacketVector::getIssuerKeyID).filter(id -> id != 0L);
        }
        if (issuerKeyId.isPresent() && signature.getKeyID() != issuerKeyId.get().longValue()) {
            throw new PGPSignatureException(String.format("Signature KeyID 0x%016X is not equals to IssuerKeyID 0x%016X", signature.getKeyID(), issuerKeyId.get()));
        }
        if (issuerKeyId.isPresent() && issuerFingerprint.isPresent() && issuerFingerprint.get().getKeyVersion() == 4) {
            byte[] bKey = new byte[8];
            byte[] fingerprint = issuerFingerprint.get().getFingerprint();
            System.arraycopy(fingerprint, fingerprint.length - 8, bKey, 0, 8);
            BigInteger bigInteger = new BigInteger(bKey);
            if (bigInteger.longValue() != issuerKeyId.get().longValue()) {
                throw new PGPSignatureException(String.format("Signature IssuerFingerprint 0x%s not contains IssuerKeyID 0x%016X", HexUtils.fingerprintToString(fingerprint), issuerKeyId.get()));
            }
        }
        PGPKeyId pgpKeyId = issuerFingerprint.isPresent() ? PGPKeyId.from(issuerFingerprint.get().getFingerprint()) : (issuerKeyId.isPresent() ? PGPKeyId.from(issuerKeyId.get()) : PGPKeyId.from(signature.getKeyID()));
        return pgpKeyId;
    }

    public PGPSignatureInfo getSignatureInfo(Artifact artifact, Artifact artifactAsc, PGPKeysCache cache) {
        PGPSignatureInfo.PGPSignatureInfoBuilder signatureInfoBuilder = PGPSignatureInfo.builder();
        signatureInfoBuilder.artifact(ArtifactInfo.builder().groupId(artifact.getGroupId()).artifactId(artifact.getArtifactId()).type(artifact.getType()).classifier(artifact.getClassifier()).version(artifact.getVersion()).build());
        if (!artifact.isResolved()) {
            return signatureInfoBuilder.status(SignatureStatus.ARTIFACT_NOT_RESOLVED).build();
        }
        if (artifactAsc == null || !artifactAsc.isResolved()) {
            return signatureInfoBuilder.status(SignatureStatus.SIGNATURE_NOT_RESOLVED).build();
        }
        PGPSignature signature = (PGPSignature)Try.of((CheckedFunction0 & Serializable)() -> this.loadSignature(artifactAsc.getFile())).onFailure(e -> signatureInfoBuilder.errorMessage(e.getMessage()).status(SignatureStatus.SIGNATURE_ERROR)).getOrNull();
        if (signature == null) {
            return signatureInfoBuilder.build();
        }
        PGPKeyId keyId = (PGPKeyId)Try.of((CheckedFunction0 & Serializable)() -> this.retrieveKeyId(signature)).onFailure(e -> signatureInfoBuilder.errorMessage(e.getMessage()).status(SignatureStatus.SIGNATURE_ERROR)).getOrNull();
        if (keyId == null) {
            return signatureInfoBuilder.build();
        }
        signatureInfoBuilder.signature(SignatureInfo.builder().hashAlgorithm(signature.getHashAlgorithm()).keyAlgorithm(signature.getKeyAlgorithm()).date(signature.getCreationTime()).keyId(keyId.toString()).version(signature.getVersion()).build());
        PGPPublicKeyRing publicKeys = (PGPPublicKeyRing)Try.of((CheckedFunction0 & Serializable)() -> cache.getKeyRing(keyId)).onFailure(e -> signatureInfoBuilder.errorMessage(e.getMessage()).status(SignatureStatus.ERROR)).getOrNull();
        if (publicKeys == null) {
            return signatureInfoBuilder.build();
        }
        PGPPublicKey publicKey = keyId.getKeyFromRing(publicKeys);
        signatureInfoBuilder.key(KeyInfo.builder().fingerprint(PublicKeyUtils.fingerprint(publicKey)).master(PublicKeyUtils.getMasterKey(publicKey, publicKeys).map(PublicKeyUtils::fingerprint).orElse(null)).uids(PublicKeyUtils.getUserIDs(publicKey, publicKeys)).version(publicKey.getVersion()).algorithm(publicKey.getAlgorithm()).bits(publicKey.getBitStrength()).date(publicKey.getCreationTime()).build());
        Boolean verifyStatus = (Boolean)Try.of((CheckedFunction0 & Serializable)() -> {
            signature.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), publicKey);
            this.readFileContentInto(signature, artifact.getFile());
            return signature.verify();
        }).onFailure(e -> signatureInfoBuilder.errorMessage(e.getMessage()).status(SignatureStatus.ERROR)).getOrNull();
        if (verifyStatus == null) {
            return signatureInfoBuilder.build();
        }
        return signatureInfoBuilder.status(Boolean.TRUE.equals(verifyStatus) ? SignatureStatus.SIGNATURE_VALID : SignatureStatus.SIGNATURE_INVALID).build();
    }

    public String keyAlgorithmName(int keyAlgorithm) {
        switch (keyAlgorithm) {
            case 1: {
                return "RSA (Encrypt or Sign)";
            }
            case 2: {
                return "RSA Encrypt-Only";
            }
            case 3: {
                return "RSA Sign-Only";
            }
            case 16: {
                return "Elgamal (Encrypt-Only)";
            }
            case 17: {
                return "DSA (Digital Signature Algorithm)";
            }
            case 18: {
                return "Elliptic Curve";
            }
            case 19: {
                return "Elliptic Curve Digital Signature";
            }
            case 20: {
                return "Elgamal (Encrypt or Sign)";
            }
            case 21: {
                return "Diffie-Hellman";
            }
            case 22: {
                return "EdDSA";
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: {
                return "Experimental - " + keyAlgorithm;
            }
        }
        throw new UnsupportedOperationException("Unknown key algorithm value encountered: " + keyAlgorithm);
    }
}

