/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.keysmap;

import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.simplify4u.plugins.keysmap.KeyItem;
import org.simplify4u.plugins.utils.HexUtils;
import org.simplify4u.plugins.utils.PublicKeyUtils;

class KeyItemFingerprint
implements KeyItem {
    private final byte[] fingerPrint;

    public KeyItemFingerprint(String key) {
        this.fingerPrint = HexUtils.stringToFingerprint(key);
    }

    @Override
    public boolean isKeyMatch(PGPPublicKey pgpPublicKey, PGPPublicKeyRing pgpPublicKeyRing) {
        if (KeyItemFingerprint.compareArrays(this.fingerPrint, pgpPublicKey.getFingerprint())) {
            return true;
        }
        Optional<PGPPublicKey> masterKey = PublicKeyUtils.getMasterKey(pgpPublicKey, pgpPublicKeyRing);
        return masterKey.filter(publicKey -> this.isKeyMatch((PGPPublicKey)publicKey, pgpPublicKeyRing)).isPresent();
    }

    private static boolean compareArrays(byte[] keyBytes, byte[] fingerprint) {
        for (int i = 1; i <= keyBytes.length && i <= fingerprint.length; ++i) {
            if (keyBytes[keyBytes.length - i] == fingerprint[fingerprint.length - i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return HexUtils.fingerprintToString(this.fingerPrint);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyItemFingerprint)) {
            return false;
        }
        KeyItemFingerprint other = (KeyItemFingerprint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.fingerPrint, other.fingerPrint);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KeyItemFingerprint;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.fingerPrint);
        return result;
    }
}

