/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.keysmap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import org.simplify4u.plugins.keysmap.KeyItem;
import org.simplify4u.plugins.keysmap.KeyItemSpecialValue;

public class KeysMapLocationConfig {
    private static final List<Filter> DEFAULT_FILTERS = Collections.singletonList(new Filter());
    private String location = "";
    private List<Filter> includes = new ArrayList<Filter>();
    private List<Filter> excludes = new ArrayList<Filter>();

    public void set(String location) {
        this.location = location;
    }

    public void addInclude(Filter filter) {
        this.includes.add(filter);
    }

    public List<Filter> getIncludes() {
        if (this.includes.isEmpty()) {
            return DEFAULT_FILTERS;
        }
        return this.includes;
    }

    public void addExclude(Filter filter) {
        this.excludes.add(filter);
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public List<Filter> getExcludes() {
        return this.excludes;
    }

    @Generated
    public String toString() {
        return "KeysMapLocationConfig(location=" + this.getLocation() + ", includes=" + this.getIncludes() + ", excludes=" + this.getExcludes() + ")";
    }

    public static class Filter {
        private static final Pattern ANY_PATTERN = Pattern.compile(".*");
        private Pattern pattern = ANY_PATTERN;
        private KeyItem value = KeyItemSpecialValue.ANY.getKeyItem();

        public void setPattern(String pattern) {
            this.pattern = Pattern.compile(pattern);
        }

        public void setValue(String value) {
            this.value = KeyItemSpecialValue.keyItemFromString(value).orElseThrow(() -> new IllegalArgumentException("Invalid include/exclude value [" + value + "] must be one of [" + KeyItemSpecialValue.getAllowedValue() + "]"));
        }

        @Generated
        public Pattern getPattern() {
            return this.pattern;
        }

        @Generated
        public KeyItem getValue() {
            return this.value;
        }

        @Generated
        public String toString() {
            return "KeysMapLocationConfig.Filter(pattern=" + this.getPattern() + ", value=" + this.getValue() + ")";
        }
    }
}

