/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.keysmap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import lombok.NonNull;
import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.simplify4u.plugins.keysmap.ArtifactData;
import org.simplify4u.plugins.keysmap.ArtifactPattern;
import org.simplify4u.plugins.keysmap.KeyItem;
import org.simplify4u.plugins.keysmap.KeyItems;
import org.simplify4u.plugins.keysmap.KeysMapContext;
import org.simplify4u.plugins.keysmap.KeysMapLocationConfig;
import org.simplify4u.plugins.pgp.KeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class KeysMap {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(KeysMap.class);
    private ResourceManager resourceManager;
    private final Map<ArtifactPattern, KeyItems> items = new HashMap<ArtifactPattern, KeyItems>();

    @Inject
    KeysMap(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void load(@NonNull KeysMapLocationConfig locationConfig) throws ResourceNotFoundException, IOException {
        if (locationConfig == null) {
            throw new NullPointerException("locationConfig is marked non-null but is null");
        }
        String location = locationConfig.getLocation();
        if (location != null && !location.trim().isEmpty()) {
            try (InputStream inputStream = this.resourceManager.getResourceAsInputStream(location);){
                this.loadKeysMap(inputStream, locationConfig, new KeysMapContext(location));
            }
        }
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public boolean isNoSignature(Artifact artifact) {
        ArtifactData artifactData = new ArtifactData(artifact);
        return this.items.entrySet().stream().filter(entry -> ((ArtifactPattern)entry.getKey()).isMatch(artifactData)).anyMatch(entry -> ((KeyItems)entry.getValue()).isNoSignature());
    }

    public boolean isBrokenSignature(Artifact artifact) {
        ArtifactData artifactData = new ArtifactData(artifact);
        return this.items.entrySet().stream().filter(entry -> ((ArtifactPattern)entry.getKey()).isMatch(artifactData)).anyMatch(entry -> ((KeyItems)entry.getValue()).isBrokenSignature());
    }

    public boolean isKeyMissing(Artifact artifact) {
        ArtifactData artifactData = new ArtifactData(artifact);
        return this.items.entrySet().stream().filter(entry -> ((ArtifactPattern)entry.getKey()).isMatch(artifactData)).anyMatch(entry -> ((KeyItems)entry.getValue()).isKeyMissing());
    }

    public boolean isWithKey(Artifact artifact) {
        ArtifactData artifactData = new ArtifactData(artifact);
        return this.items.entrySet().stream().filter(entry -> ((ArtifactPattern)entry.getKey()).isMatch(artifactData)).anyMatch(entry -> !((KeyItems)entry.getValue()).isNoSignature());
    }

    public boolean isValidKey(Artifact artifact, KeyInfo keyInfo) {
        if (this.items.isEmpty()) {
            return true;
        }
        ArtifactData artifactData = new ArtifactData(artifact);
        return this.items.entrySet().stream().filter(entry -> ((ArtifactPattern)entry.getKey()).isMatch(artifactData)).anyMatch(entry -> ((KeyItems)entry.getValue()).isKeyMatch(keyInfo));
    }

    private void loadKeysMap(InputStream inputStream, KeysMapLocationConfig locationConfig, final KeysMapContext keysMapContext) throws IOException {
        String currentLine;
        BufferedReader mapReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.US_ASCII)){

            @Override
            public String readLine() throws IOException {
                keysMapContext.incLineNumber();
                return super.readLine();
            }
        };
        while ((currentLine = KeysMap.getNextLine(mapReader)) != null) {
            String[] parts = currentLine.split("=", 2);
            String artifactPatternStr = parts[0].trim();
            String keyItemsStr = parts.length == 1 ? "" : parts[1].trim();
            ArtifactPattern artifactPattern = new ArtifactPattern(artifactPatternStr);
            List<KeyItem> includeValues = KeysMap.getFilterForItem(artifactPatternStr, locationConfig.getIncludes());
            List<KeyItem> excludeValues = KeysMap.getFilterForItem(artifactPatternStr, locationConfig.getExcludes());
            KeyItems keyItems = new KeyItems().addKeys(keyItemsStr, keysMapContext);
            keyItems.includes(includeValues);
            keyItems.excludes(excludeValues);
            if (this.items.containsKey(artifactPattern)) {
                LOGGER.debug("Existing artifact pattern: {} - only update key items in {}", (Object)artifactPatternStr, (Object)keysMapContext);
                this.items.get(artifactPattern).addKeys(keyItems, keysMapContext);
                continue;
            }
            if (keyItems.isEmpty()) continue;
            this.items.put(artifactPattern, keyItems);
        }
    }

    private static List<KeyItem> getFilterForItem(String artifactPattern, List<KeysMapLocationConfig.Filter> filters) {
        return filters.stream().filter(filter -> filter.getPattern().matcher(artifactPattern).matches()).map(KeysMapLocationConfig.Filter::getValue).collect(Collectors.toList());
    }

    private static String getNextLine(BufferedReader mapReader) throws IOException {
        String ret;
        String line;
        StringBuilder nextLine = new StringBuilder();
        while ((line = KeysMap.getNextNotEmptyLine(mapReader)) != null) {
            if (line.charAt(line.length() - 1) == '\\') {
                nextLine.append(line, 0, line.length() - 1);
                nextLine.append(" ");
                continue;
            }
            nextLine.append(line);
            break;
        }
        return (ret = nextLine.toString().trim()).length() == 0 ? null : ret;
    }

    private static String getNextNotEmptyLine(BufferedReader readLine) throws IOException {
        String line;
        String nextLine = null;
        while ((line = readLine.readLine()) != null && (nextLine = KeysMap.stripComments(line.trim())).isEmpty()) {
        }
        return nextLine == null || nextLine.length() == 0 ? null : nextLine;
    }

    private static String stripComments(String line) {
        if (line.length() < 1) {
            return line;
        }
        int hashIndex = line.indexOf(35);
        return hashIndex >= 0 ? line.substring(0, hashIndex).trim() : line;
    }

    int size() {
        return this.items.size();
    }
}

