/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins;

import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ValidationChecksum {
    private static final Logger LOG = LoggerFactory.getLogger(ValidationChecksum.class);
    private final File file;
    private final byte[] checksum;

    private ValidationChecksum(File file, byte[] checksum) {
        this.file = Objects.requireNonNull(file);
        this.checksum = Objects.requireNonNull(checksum);
    }

    boolean checkValidation() {
        if (this.disabled()) {
            return false;
        }
        return (Boolean)Try.of((CheckedFunction0 & Serializable)() -> FileUtils.readFileToByteArray((File)this.file)).map(checksumPriorValidation -> Arrays.equals(this.checksum, checksumPriorValidation)).onFailure(e -> LOG.debug("Validation of artifacts against prior validation run failed with: {}", (Object)e.getMessage())).getOrElse((Object)false);
    }

    void saveChecksum() {
        if (this.disabled()) {
            return;
        }
        Try.run(() -> FileUtils.writeByteArrayToFile((File)this.file, (byte[])this.checksum)).onFailure(e -> LOG.debug("Failed to save checksum after successful artifact validation.", e));
    }

    boolean disabled() {
        return this.checksum.length == 0;
    }

    static final class Builder {
        private static final String FILENAME_CHECKSUM_PRIOR_VALIDATION = "pgpverify-prior-validation-checksum";
        private static final Logger LOG = LoggerFactory.getLogger(Builder.class);
        private File file;
        private boolean disabled;
        private Iterable<Artifact> artifacts;

        Builder() {
        }

        Builder destination(File directory) {
            this.file = new File(directory, FILENAME_CHECKSUM_PRIOR_VALIDATION);
            return this;
        }

        Builder disabled(boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        Builder artifacts(Iterable<Artifact> artifacts) {
            this.artifacts = Objects.requireNonNull(artifacts);
            return this;
        }

        ValidationChecksum build() {
            if (this.artifacts == null) {
                throw new IllegalStateException("artifacts need to be provided");
            }
            return new ValidationChecksum(this.file, this.disabled ? new byte[]{} : this.calculateChecksum());
        }

        private byte[] calculateChecksum() {
            SHA256Digest digest = new SHA256Digest();
            byte[] result = new byte[digest.getDigestSize()];
            for (Artifact artifact : this.artifacts) {
                byte[] id = artifact.getId().getBytes(StandardCharsets.UTF_8);
                digest.update(id, 0, id.length);
                digest.update((byte)0);
            }
            digest.doFinal(result, 0);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checksum of resolved artifacts: {}", (Object)ByteUtils.toHexString((byte[])result, (String)"0x", (String)""));
            }
            return result;
        }
    }
}

