/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.keysmap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.simplify4u.plugins.keysmap.KeyItem;
import org.simplify4u.plugins.keysmap.KeyItemFingerprint;
import org.simplify4u.plugins.keysmap.KeyItemSpecialValue;
import org.simplify4u.plugins.keysmap.KeysMapContext;
import org.simplify4u.plugins.pgp.KeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KeyItems {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyItems.class);
    private final List<KeyItem> keys = new ArrayList<KeyItem>();

    KeyItems() {
    }

    public KeyItems addKeys(String strKeys, KeysMapContext keysMapContext) {
        if (strKeys == null) {
            throw new IllegalArgumentException("null key not allowed in " + keysMapContext);
        }
        if (strKeys.trim().isEmpty()) {
            LOGGER.warn("Empty value for key is deprecated - please provide some value - now assume as noSig in: {}", (Object)keysMapContext);
            this.addKey(KeyItemSpecialValue.NO_SIG.getKeyItem(), keysMapContext);
            return this;
        }
        Arrays.stream(strKeys.split(",")).map(String::trim).forEach(key -> {
            if (key.startsWith("0x")) {
                this.addKey(new KeyItemFingerprint((String)key), keysMapContext);
            } else {
                KeyItem keyInfoItem = KeyItemSpecialValue.keyItemFromString(key).orElseThrow(() -> new IllegalArgumentException("Invalid keyID " + key + " must start with 0x or be any of " + KeyItemSpecialValue.getAllowedValue()));
                this.addKey(keyInfoItem, keysMapContext);
            }
        });
        return this;
    }

    public KeyItems addKeys(KeyItems keyItems, KeysMapContext keysMapContext) {
        keyItems.keys.forEach(key -> this.addKey((KeyItem)key, keysMapContext));
        return this;
    }

    private void addKey(KeyItem keyItem, KeysMapContext keysMapContext) {
        if (!this.keys.contains(keyItem)) {
            this.keys.add(keyItem);
        } else {
            LOGGER.warn("Duplicate key item: {} in: {}", (Object)keyItem, (Object)keysMapContext);
        }
    }

    public boolean isKeyMatch(KeyInfo keyInfo) {
        return this.keys.stream().anyMatch(keyInfoItem -> keyInfoItem.isKeyMatch(keyInfo));
    }

    public boolean isNoSignature() {
        return this.keys.stream().anyMatch(KeyItem::isNoSignature);
    }

    public boolean isKeyMissing() {
        return this.keys.stream().anyMatch(KeyItem::isKeyMissing);
    }

    public boolean isBrokenSignature() {
        return this.keys.stream().anyMatch(KeyItem::isBrokenSignature);
    }

    public void includes(List<KeyItem> values) {
        if (values.contains(KeyItemSpecialValue.ANY.getKeyItem())) {
            return;
        }
        this.keys.removeIf(k -> !values.contains(k));
    }

    public void excludes(List<KeyItem> values) {
        if (values.isEmpty()) {
            return;
        }
        this.keys.removeIf(values::contains);
    }

    public boolean isEmpty() {
        return this.keys.isEmpty();
    }
}

