/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.skipfilters;

import java.util.Arrays;
import java.util.Objects;
import org.apache.maven.artifact.Artifact;
import org.simplify4u.plugins.skipfilters.SkipFilter;

public final class CompositeSkipper
implements SkipFilter {
    private final Iterable<SkipFilter> filters;

    public CompositeSkipper(Iterable<SkipFilter> filters) {
        this.filters = Objects.requireNonNull(filters);
    }

    public CompositeSkipper(SkipFilter ... filters) {
        if (Arrays.stream(filters).anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("filters cannot contain null");
        }
        this.filters = Arrays.asList(filters);
    }

    @Override
    public boolean shouldSkipArtifact(Artifact artifact) {
        Objects.requireNonNull(artifact);
        for (SkipFilter filter : this.filters) {
            if (!filter.shouldSkipArtifact(artifact)) continue;
            return true;
        }
        return false;
    }
}

