/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public final class MavenCompilerUtils {
    private static final String GROUPID = "org.apache.maven.plugins";
    private static final String ARTIFACTID = "maven-compiler-plugin";
    private static final String PACKAGING = "jar";

    private MavenCompilerUtils() {
    }

    public static boolean checkCompilerPlugin(Plugin plugin) {
        return GROUPID.equals(plugin.getGroupId()) && ARTIFACTID.equals(plugin.getArtifactId());
    }

    public static Set<Artifact> extractAnnotationProcessors(RepositorySystem system, Plugin plugin) {
        Objects.requireNonNull(system);
        if (!MavenCompilerUtils.checkCompilerPlugin(plugin)) {
            throw new IllegalArgumentException("Plugin is not 'org.apache.maven.plugins:maven-compiler-plugin'.");
        }
        Object config = plugin.getConfiguration();
        if (config == null) {
            return Collections.emptySet();
        }
        if (config instanceof Xpp3Dom) {
            return Arrays.stream(((Xpp3Dom)config).getChildren("annotationProcessorPaths")).flatMap(aggregate -> Arrays.stream(aggregate.getChildren("path"))).map(processor -> system.createArtifact(MavenCompilerUtils.extractChildValue(processor, "groupId"), MavenCompilerUtils.extractChildValue(processor, "artifactId"), MavenCompilerUtils.extractChildValue(processor, "version"), PACKAGING)).filter(a -> !a.getGroupId().isEmpty()).filter(a -> !a.getArtifactId().isEmpty()).filter(a -> !a.getVersion().isEmpty()).collect(Collectors.toSet());
        }
        throw new UnsupportedOperationException("Please report that an unsupported type of configuration container was encountered: " + config.getClass());
    }

    private static String extractChildValue(Xpp3Dom node, String name) {
        Xpp3Dom child = node.getChild(name);
        return child == null ? "" : child.getValue();
    }
}

