/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.keyserver;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.settings.Proxy;

public class KeyServerClientSettings {
    private static final int DEFAULT_CONNECT_TIMEOUT = 1000;
    private static final int DEFAULT_READ_TIMEOUT = 5000;
    public static final int DEFAULT_MAX_RETRIES = 5;
    @NonNull
    MavenSession mavenSession;
    String proxyName;
    int connectTimeout;
    int readTimeout;
    int maxRetries;

    public Optional<Proxy> getProxy() {
        if (this.proxyName == null) {
            return Optional.ofNullable(this.mavenSession.getSettings().getActiveProxy());
        }
        return Optional.ofNullable(this.mavenSession.getSettings().getProxies()).orElse(Collections.emptyList()).stream().filter(proxy -> this.proxyName.equalsIgnoreCase(proxy.getId())).findFirst();
    }

    public boolean isOffline() {
        return this.mavenSession.isOffline();
    }

    @Generated
    private static int $default$connectTimeout() {
        return 1000;
    }

    @Generated
    private static int $default$readTimeout() {
        return 5000;
    }

    @Generated
    private static int $default$maxRetries() {
        return 5;
    }

    @ConstructorProperties(value={"mavenSession", "proxyName", "connectTimeout", "readTimeout", "maxRetries"})
    @Generated
    KeyServerClientSettings(@NonNull MavenSession mavenSession, String proxyName, int connectTimeout, int readTimeout, int maxRetries) {
        if (mavenSession == null) {
            throw new NullPointerException("mavenSession is marked non-null but is null");
        }
        this.mavenSession = mavenSession;
        this.proxyName = proxyName;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.maxRetries = maxRetries;
    }

    @Generated
    public static KeyServerClientSettingsBuilder builder() {
        return new KeyServerClientSettingsBuilder();
    }

    @NonNull
    @Generated
    public MavenSession getMavenSession() {
        return this.mavenSession;
    }

    @Generated
    public String getProxyName() {
        return this.proxyName;
    }

    @Generated
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Generated
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Generated
    public int getMaxRetries() {
        return this.maxRetries;
    }

    @Generated
    public static class KeyServerClientSettingsBuilder {
        @Generated
        private MavenSession mavenSession;
        @Generated
        private String proxyName;
        @Generated
        private boolean connectTimeout$set;
        @Generated
        private int connectTimeout$value;
        @Generated
        private boolean readTimeout$set;
        @Generated
        private int readTimeout$value;
        @Generated
        private boolean maxRetries$set;
        @Generated
        private int maxRetries$value;

        @Generated
        KeyServerClientSettingsBuilder() {
        }

        @Generated
        public KeyServerClientSettingsBuilder mavenSession(@NonNull MavenSession mavenSession) {
            if (mavenSession == null) {
                throw new NullPointerException("mavenSession is marked non-null but is null");
            }
            this.mavenSession = mavenSession;
            return this;
        }

        @Generated
        public KeyServerClientSettingsBuilder proxyName(String proxyName) {
            this.proxyName = proxyName;
            return this;
        }

        @Generated
        public KeyServerClientSettingsBuilder connectTimeout(int connectTimeout) {
            this.connectTimeout$value = connectTimeout;
            this.connectTimeout$set = true;
            return this;
        }

        @Generated
        public KeyServerClientSettingsBuilder readTimeout(int readTimeout) {
            this.readTimeout$value = readTimeout;
            this.readTimeout$set = true;
            return this;
        }

        @Generated
        public KeyServerClientSettingsBuilder maxRetries(int maxRetries) {
            this.maxRetries$value = maxRetries;
            this.maxRetries$set = true;
            return this;
        }

        @Generated
        public KeyServerClientSettings build() {
            int connectTimeout$value = this.connectTimeout$value;
            if (!this.connectTimeout$set) {
                connectTimeout$value = KeyServerClientSettings.$default$connectTimeout();
            }
            int readTimeout$value = this.readTimeout$value;
            if (!this.readTimeout$set) {
                readTimeout$value = KeyServerClientSettings.$default$readTimeout();
            }
            int maxRetries$value = this.maxRetries$value;
            if (!this.maxRetries$set) {
                maxRetries$value = KeyServerClientSettings.$default$maxRetries();
            }
            return new KeyServerClientSettings(this.mavenSession, this.proxyName, connectTimeout$value, readTimeout$value, maxRetries$value);
        }

        @Generated
        public String toString() {
            return "KeyServerClientSettings.KeyServerClientSettingsBuilder(mavenSession=" + this.mavenSession + ", proxyName=" + this.proxyName + ", connectTimeout$value=" + this.connectTimeout$value + ", readTimeout$value=" + this.readTimeout$value + ", maxRetries$value=" + this.maxRetries$value + ")";
        }
    }
}

