/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.skipfilters;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.simplify4u.plugins.skipfilters.SkipFilter;

public class ReactorDependencySkipper
implements SkipFilter {
    private final List<MavenProject> upstreamProjects;

    public ReactorDependencySkipper(MavenSession session) {
        this.upstreamProjects = session.getProjectDependencyGraph().getUpstreamProjects(session.getCurrentProject(), true);
    }

    @Override
    public boolean shouldSkipArtifact(Artifact artifact) {
        return this.isUpstreamReactorDependency(artifact);
    }

    private boolean isUpstreamReactorDependency(Artifact artifact) {
        for (MavenProject upstreamProject : this.upstreamProjects) {
            if (!ReactorDependencySkipper.artifactMatchesProject(artifact, upstreamProject)) continue;
            return true;
        }
        return false;
    }

    private static boolean artifactMatchesProject(Artifact artifact, MavenProject project) {
        Artifact projectArtifact = project.getArtifact();
        return projectArtifact != null && ReactorDependencySkipper.artifactsMatch(projectArtifact, artifact);
    }

    private static boolean artifactsMatch(Artifact artifact1, Artifact artifact2) {
        return artifact1.equals(artifact2) || artifact1.getGroupId().equals(artifact2.getGroupId()) && artifact1.getArtifactId().equals(artifact2.getArtifactId()) && artifact1.getVersion().equals(artifact2.getVersion());
    }
}

