/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.keysmap;

import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import lombok.Generated;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.simplify4u.plugins.keysmap.ArtifactData;

class ArtifactPattern {
    private static final Pattern DOT_REPLACE = Pattern.compile("\\.");
    private static final Pattern STAR_REPLACE = Pattern.compile("\\*");
    private static final Pattern PACKAGING = Pattern.compile("^[a-zA-Z]+$");
    private static final String VERSION_REGEX_PREFIX = "~";
    private static final String NOT_VERSION_REGEX_PREFIX = "!~";
    private final String pattern;
    private final Pattern groupIdPattern;
    private final Pattern artifactIdPattern;
    private final Pattern packagingPattern;
    private final Function<String, Boolean> versionMatch;

    public ArtifactPattern(String pattern) {
        this.pattern = pattern;
        String[] split = this.pattern.split(":");
        String groupId = split.length > 0 ? split[0].trim().toLowerCase(Locale.US) : "";
        String artifactId = split.length > 1 ? split[1].trim().toLowerCase(Locale.US) : "";
        String packaging = "";
        String version = "";
        if (split.length == 3) {
            String item = split[2].trim().toLowerCase(Locale.US);
            if (PACKAGING.matcher(item).matches()) {
                packaging = item;
            } else {
                version = item;
            }
        } else if (split.length == 4) {
            packaging = split[2].trim().toLowerCase(Locale.US);
            version = split[3].trim().toLowerCase(Locale.US);
        } else {
            packaging = "";
        }
        try {
            this.groupIdPattern = Pattern.compile(ArtifactPattern.patternPrepare(groupId));
            this.artifactIdPattern = Pattern.compile(ArtifactPattern.patternPrepare(artifactId));
            this.packagingPattern = Pattern.compile(ArtifactPattern.patternPrepare(packaging));
            this.versionMatch = ArtifactPattern.versionMatchPrepare(version);
        }
        catch (PatternSyntaxException | InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException("Invalid artifact definition: " + pattern, e);
        }
    }

    private static String patternPrepare(String str) {
        String ret;
        if (str.length() == 0) {
            return ".*";
        }
        if (str.endsWith(".*")) {
            ret = str.substring(0, str.length() - 2) + "(\\..+)?$";
        } else {
            ret = DOT_REPLACE.matcher(str).replaceAll("\\\\.");
            ret = STAR_REPLACE.matcher(ret).replaceAll(".*");
        }
        return ret;
    }

    private static Function<String, Boolean> versionMatchPrepare(String versionToPrepare) throws InvalidVersionSpecificationException {
        String versionSpec = ArtifactPattern.versionSpecPrepare(versionToPrepare);
        if (versionSpec == null) {
            return version -> true;
        }
        if (versionSpec.startsWith(VERSION_REGEX_PREFIX)) {
            Pattern versionRegex = Pattern.compile(versionSpec.substring(VERSION_REGEX_PREFIX.length()));
            return version -> versionRegex.matcher((CharSequence)version).matches();
        }
        if (versionSpec.startsWith(NOT_VERSION_REGEX_PREFIX)) {
            Pattern versionRegex = Pattern.compile(versionSpec.substring(NOT_VERSION_REGEX_PREFIX.length()));
            return version -> !versionRegex.matcher((CharSequence)version).matches();
        }
        VersionRange versionRange = VersionRange.createFromVersionSpec((String)versionSpec);
        if (versionRange.hasRestrictions()) {
            return version -> {
                DefaultArtifactVersion artifactVersion = new DefaultArtifactVersion(version);
                return versionRange.containsVersion((ArtifactVersion)artifactVersion);
            };
        }
        return versionSpec::equals;
    }

    private static String versionSpecPrepare(String versionSpec) throws InvalidVersionSpecificationException {
        if (versionSpec.length() == 0 || "*".equals(versionSpec)) {
            return null;
        }
        if (versionSpec.contains("*") && !versionSpec.startsWith(VERSION_REGEX_PREFIX) && !versionSpec.startsWith(NOT_VERSION_REGEX_PREFIX)) {
            throw new InvalidVersionSpecificationException("Invalid maven version range: " + versionSpec);
        }
        return versionSpec;
    }

    public boolean isMatch(ArtifactData artifact) {
        return ArtifactPattern.isMatchPattern(this.groupIdPattern, artifact.getGroupId()) && ArtifactPattern.isMatchPattern(this.artifactIdPattern, artifact.getArtifactId()) && ArtifactPattern.isMatchPattern(this.packagingPattern, artifact.getType()) && this.versionMatch.apply(artifact.getVersion()) != false;
    }

    private static boolean isMatchPattern(Pattern pattern, String str) {
        Matcher m = pattern.matcher(str);
        return m.matches();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArtifactPattern)) {
            return false;
        }
        ArtifactPattern other = (ArtifactPattern)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pattern = this.pattern;
        String other$pattern = other.pattern;
        return !(this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArtifactPattern;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pattern = this.pattern;
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        return result;
    }
}

