/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.keysmap;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.simplify4u.plugins.keysmap.KeyItem;
import org.simplify4u.plugins.keysmap.KeyItemAnyKey;
import org.simplify4u.plugins.keysmap.KeyItemBrokenSig;
import org.simplify4u.plugins.keysmap.KeyItemNoKey;
import org.simplify4u.plugins.keysmap.KeyItemNoSig;

enum KeyItemSpecialValue {
    ANY0("*", new KeyItemAnyKey()),
    ANY("any", new KeyItemAnyKey()),
    BAD_SIG("badSig", new KeyItemBrokenSig()),
    NO_KEY("noKey", new KeyItemNoKey()),
    NO_SIG("noSig", new KeyItemNoSig());

    private final String desc;
    private final KeyItem keyItem;

    private KeyItemSpecialValue(String desc, KeyItem keyItem) {
        this.desc = desc;
        this.keyItem = keyItem;
    }

    public static String getAllowedValue() {
        return Arrays.stream(KeyItemSpecialValue.values()).sorted(Comparator.comparing(o -> o.desc)).map(KeyItemSpecialValue::getDesc).collect(Collectors.joining(","));
    }

    public static Optional<KeyItem> keyItemFromString(String desc) {
        return Arrays.stream(KeyItemSpecialValue.values()).filter(value -> value.desc.equalsIgnoreCase(desc)).map(KeyItemSpecialValue::getKeyItem).findAny();
    }

    @Generated
    public String getDesc() {
        return this.desc;
    }

    @Generated
    public KeyItem getKeyItem() {
        return this.keyItem;
    }
}

