/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins;

import java.time.Duration;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.Parameter;
import org.simplify4u.plugins.AbstractPGPMojo;
import org.simplify4u.plugins.ArtifactResolver;
import org.simplify4u.plugins.skipfilters.CompositeSkipper;
import org.simplify4u.plugins.skipfilters.ProvidedDependencySkipper;
import org.simplify4u.plugins.skipfilters.ReactorDependencySkipper;
import org.simplify4u.plugins.skipfilters.ScopeSkipper;
import org.simplify4u.plugins.skipfilters.SkipFilter;
import org.simplify4u.plugins.skipfilters.SnapshotDependencySkipper;
import org.simplify4u.plugins.skipfilters.SystemDependencySkipper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVerifyMojo<V>
extends AbstractPGPMojo {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractVerifyMojo.class);
    @Parameter(property="pgpverify.scope", defaultValue="test")
    private String scope;
    @Parameter(property="pgpverify.verifyPomFiles", defaultValue="true")
    private boolean verifyPomFiles;
    @Parameter(property="pgpverify.verifySnapshots", defaultValue="false")
    private boolean verifySnapshots;
    @Parameter(property="pgpverify.verifyPlugins", defaultValue="false")
    private boolean verifyPlugins;
    @Parameter(property="pgpverify.verifyPluginDependencies", defaultValue="false")
    private boolean verifyPluginDependencies;
    @Parameter(property="pgpverify.verifyAtypical", defaultValue="false")
    private boolean verifyAtypical;
    @Parameter(property="pgpverify.verifyProvidedDependencies", defaultValue="false")
    private boolean verifyProvidedDependencies;
    @Parameter(property="pgpverify.verifySystemDependencies", defaultValue="false")
    private boolean verifySystemDependencies;
    @Parameter(property="pgpverify.verifyReactorDependencies", defaultValue="false")
    private boolean verifyReactorDependencies;

    @Override
    public final void executeConfiguredMojo() {
        SkipFilter dependencyFilter = this.prepareDependencyFilters();
        SkipFilter pluginFilter = this.preparePluginFilters();
        long artifactResolutionStart = System.nanoTime();
        ArtifactResolver.Configuration config = new ArtifactResolver.Configuration(dependencyFilter, pluginFilter, this.verifyPomFiles, this.verifyPlugins, this.verifyPluginDependencies, this.verifyAtypical);
        Set<Artifact> artifacts = this.artifactResolver.resolveProjectArtifacts(this.session.getCurrentProject(), config);
        LOGGER.info("Resolved {} artifact(s) in {}", (Object)artifacts.size(), (Object)Duration.ofNanos(System.nanoTime() - artifactResolutionStart));
        this.shouldProcess(artifacts, () -> {
            Collection<V> verificationResult;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Discovered project artifacts: {}", (Object)artifacts);
            }
            long signatureResolutionStart = System.nanoTime();
            Map<Artifact, Artifact> artifactMap = this.artifactResolver.resolveSignatures(artifacts);
            LOGGER.info("Resolved {} signature(s) in {}", (Object)artifactMap.size(), (Object)Duration.ofNanos(System.nanoTime() - signatureResolutionStart));
            long artifactValidationStart = System.nanoTime();
            try {
                verificationResult = this.processArtifactsSignatures(artifactMap);
            }
            finally {
                LOGGER.info("Finished {} artifact(s) validation in {}", (Object)artifactMap.size(), (Object)Duration.ofNanos(System.nanoTime() - artifactValidationStart));
            }
            this.processVerificationResult(verificationResult);
        });
    }

    protected abstract void shouldProcess(Set<Artifact> var1, Runnable var2);

    protected abstract V processArtifactSignature(Artifact var1, Artifact var2);

    protected abstract void processVerificationResult(Collection<V> var1);

    private SkipFilter prepareDependencyFilters() {
        LinkedList<SkipFilter> filters = new LinkedList<SkipFilter>();
        filters.add(new ScopeSkipper(this.scope));
        if (!this.verifySnapshots) {
            filters.add(new SnapshotDependencySkipper());
        }
        if (!this.verifyProvidedDependencies) {
            filters.add(new ProvidedDependencySkipper());
        }
        if (!this.verifySystemDependencies) {
            filters.add(new SystemDependencySkipper());
        }
        if (!this.verifyReactorDependencies) {
            filters.add(new ReactorDependencySkipper(this.session));
        }
        return new CompositeSkipper(filters);
    }

    private SkipFilter preparePluginFilters() {
        LinkedList<SkipFilter> filters = new LinkedList<SkipFilter>();
        if (!this.verifySnapshots) {
            filters.add(new SnapshotDependencySkipper());
        }
        return new CompositeSkipper(filters);
    }

    private Collection<V> processArtifactsSignatures(Map<Artifact, Artifact> artifactToAsc) {
        return artifactToAsc.entrySet().stream().map(entry -> this.processArtifactSignature((Artifact)entry.getKey(), (Artifact)entry.getValue())).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

