/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins;

import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.artifact.SubArtifact;
import org.simplify4u.plugins.skipfilters.SkipFilter;
import org.simplify4u.plugins.utils.MavenCompilerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ArtifactResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ArtifactResolver.class);
    private static final VersionRange SUREFIRE_PLUGIN_VERSION_RANGE = (VersionRange)Try.of((CheckedFunction0 & Serializable)() -> VersionRange.createFromVersionSpec((String)"(2.999999999,4)")).getOrElseThrow(e -> new IllegalStateException("BUG: Failed to create version range.", (Throwable)e));
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession repositorySession;
    private final List<RemoteRepository> remoteProjectRepositories;
    private final List<RemoteRepository> remotePluginRepositories;
    private final ArtifactHandlerManager artifactHandlerManager;
    private final List<RemoteRepository> remoteRepositoriesIgnoreCheckSum;

    @Inject
    ArtifactResolver(MavenSession session, RepositorySystem repositorySystem, ArtifactHandlerManager artifactHandlerManager) {
        this.remoteProjectRepositories = Objects.requireNonNull(session.getCurrentProject().getRemoteProjectRepositories());
        this.remotePluginRepositories = Objects.requireNonNull(session.getCurrentProject().getRemotePluginRepositories());
        this.repositorySystem = Objects.requireNonNull(repositorySystem);
        this.repositorySession = Objects.requireNonNull(session.getRepositorySession());
        this.remoteRepositoriesIgnoreCheckSum = this.repositoriesIgnoreCheckSum(this.remoteProjectRepositories, this.remotePluginRepositories);
        this.artifactHandlerManager = artifactHandlerManager;
    }

    private List<RemoteRepository> repositoriesIgnoreCheckSum(List<RemoteRepository> remoteProjectRepositories, List<RemoteRepository> remotePluginRepositories) {
        Stream remoteProjectRepositoryStream = Optional.ofNullable(remoteProjectRepositories).orElse(Collections.emptyList()).stream();
        Stream remotePluginsRepositoryStream = Optional.ofNullable(remotePluginRepositories).orElse(Collections.emptyList()).stream();
        List remoteRepositories = Stream.concat(remoteProjectRepositoryStream, remotePluginsRepositoryStream).map(ArtifactResolver::repositoryIgnoreCheckSum).collect(Collectors.toList());
        return this.repositorySystem.newResolutionRepositories(this.repositorySession, remoteRepositories);
    }

    private static RemoteRepository repositoryIgnoreCheckSum(RemoteRepository repository) {
        RepositoryPolicy snapshotPolicy = repository.getPolicy(true);
        RepositoryPolicy releasePolicy = repository.getPolicy(false);
        RemoteRepository.Builder builder = new RemoteRepository.Builder(repository);
        builder.setSnapshotPolicy(ArtifactResolver.policyIgnoreCheckSum(snapshotPolicy));
        builder.setReleasePolicy(ArtifactResolver.policyIgnoreCheckSum(releasePolicy));
        return builder.build();
    }

    private static RepositoryPolicy policyIgnoreCheckSum(RepositoryPolicy policy) {
        return new RepositoryPolicy(policy.isEnabled(), policy.getUpdatePolicy(), "ignore");
    }

    Set<Artifact> resolveProjectArtifacts(MavenProject project, Configuration config) {
        LinkedHashSet<Artifact> allArtifacts = new LinkedHashSet<Artifact>(this.resolveProjectArtifacts(project.getArtifacts(), config.dependencyFilter, config.verifyPomFiles));
        if (config.verifyPlugins) {
            for (Plugin plugin : project.getBuildPlugins()) {
                List<Artifact> resolved = this.resolvePlugin(plugin, config);
                allArtifacts.addAll(resolved);
            }
            List reportPlugins = Optional.ofNullable(project.getModel()).map(ModelBase::getReporting).map(Reporting::getPlugins).orElseGet(Collections::emptyList);
            for (ReportPlugin plugin : reportPlugins) {
                Plugin p = new Plugin();
                p.setGroupId(plugin.getGroupId());
                p.setArtifactId(plugin.getArtifactId());
                p.setVersion(plugin.getVersion());
                List<Artifact> resolved = this.resolvePlugin(p, config);
                allArtifacts.addAll(resolved);
            }
        }
        if (config.verifyAtypical) {
            List<org.eclipse.aether.artifact.Artifact> artifacts = ArtifactResolver.searchCompilerAnnotationProcessors(project);
            artifacts.forEach(a -> {
                Plugin p = new Plugin();
                p.setGroupId(a.getGroupId());
                p.setArtifactId(a.getArtifactId());
                p.setVersion(a.getVersion());
                List<Artifact> resolved = this.resolvePlugin(p, config);
                allArtifacts.addAll(resolved);
            });
            ArtifactResolver.informSurefire3RuntimeDependencyLoadingLimitation(project);
        }
        return allArtifacts;
    }

    private List<Artifact> resolvePlugin(Plugin plugin, Configuration config) {
        List<org.eclipse.aether.artifact.Artifact> result;
        org.eclipse.aether.artifact.Artifact pArtifact = ArtifactResolver.toArtifact(plugin);
        if (config.pluginFilter.shouldSkipArtifact(RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)pArtifact))) {
            return Collections.emptyList();
        }
        List<Dependency> pluginDependencies = plugin.getDependencies().stream().filter(d -> !config.dependencyFilter.shouldSkipDependency((org.apache.maven.model.Dependency)d, this.artifactHandlerManager)).map(d -> RepositoryUtils.toDependency((org.apache.maven.model.Dependency)d, (ArtifactTypeRegistry)this.repositorySession.getArtifactTypeRegistry())).collect(Collectors.toList());
        if (config.verifyPluginDependencies) {
            result = this.resolvePluginArtifactsTransitive(pArtifact, pluginDependencies, config.dependencyFilter, config.verifyPomFiles);
        } else {
            ArrayList<org.eclipse.aether.artifact.Artifact> aeArtifacts = new ArrayList<org.eclipse.aether.artifact.Artifact>();
            aeArtifacts.add(pArtifact);
            aeArtifacts.addAll(pluginDependencies.stream().map(Dependency::getArtifact).collect(Collectors.toList()));
            result = this.resolveArtifacts(aeArtifacts, this.remotePluginRepositories, config.verifyPomFiles);
        }
        return result.stream().map(RepositoryUtils::toArtifact).collect(Collectors.toList());
    }

    private List<org.eclipse.aether.artifact.Artifact> resolvePluginArtifactsTransitive(org.eclipse.aether.artifact.Artifact artifact, List<Dependency> dependencies, final SkipFilter dependencyFilter, boolean verifyPomFiles) {
        CollectRequest collectRequest = new CollectRequest(new Dependency(artifact, "runtime"), this.remotePluginRepositories);
        collectRequest.setDependencies(dependencies);
        DependencyRequest request = new DependencyRequest(collectRequest, null);
        DependencyResult dependencyResult = (DependencyResult)Try.of((CheckedFunction0 & Serializable)() -> this.repositorySystem.resolveDependencies(this.repositorySession, request)).recover(DependencyResolutionException.class, DependencyResolutionException::getResult).get();
        final ArrayList<org.eclipse.aether.artifact.Artifact> result = new ArrayList<org.eclipse.aether.artifact.Artifact>();
        dependencyResult.getRoot().accept(new DependencyVisitor(){

            public boolean visitEnter(DependencyNode node) {
                if (node.getArtifact() != null && !dependencyFilter.shouldSkipDependency(node.getDependency())) {
                    result.add(node.getArtifact());
                }
                return true;
            }

            public boolean visitLeave(DependencyNode node) {
                return true;
            }
        });
        if (verifyPomFiles) {
            this.resolvePoms(result, this.remotePluginRepositories);
        }
        return result;
    }

    private List<org.eclipse.aether.artifact.Artifact> resolveArtifacts(List<org.eclipse.aether.artifact.Artifact> artifacts, List<RemoteRepository> remoteRepositories, boolean verifyPomFiles) {
        List requestList = artifacts.stream().map(a -> new ArtifactRequest(a, remoteRepositories, null)).collect(Collectors.toList());
        ArrayList<org.eclipse.aether.artifact.Artifact> result = new ArrayList<org.eclipse.aether.artifact.Artifact>(((List)Try.of((CheckedFunction0 & Serializable)() -> this.repositorySystem.resolveArtifacts(this.repositorySession, (Collection)requestList)).recover(ArtifactResolutionException.class, ArtifactResolutionException::getResults).get()).stream().map(aResult -> aResult.isResolved() ? aResult.getArtifact() : aResult.getRequest().getArtifact()).collect(Collectors.toList()));
        if (verifyPomFiles) {
            this.resolvePoms(result, remoteRepositories);
        }
        return result;
    }

    private void resolvePoms(List<org.eclipse.aether.artifact.Artifact> result, List<RemoteRepository> remoteRepositories) {
        List<org.eclipse.aether.artifact.Artifact> poms = result.stream().filter(a -> !"pom".equals(a.getExtension())).map(a -> new SubArtifact(a, null, "pom")).collect(Collectors.toList());
        result.addAll(this.resolveArtifacts(poms, remoteRepositories, false));
    }

    private static org.eclipse.aether.artifact.Artifact toArtifact(Plugin plugin) {
        String version = plugin.getVersion();
        if (version == null || version.isEmpty()) {
            version = "RELEASE";
        }
        return new DefaultArtifact(plugin.getGroupId(), plugin.getArtifactId(), "jar", version);
    }

    private static List<org.eclipse.aether.artifact.Artifact> searchCompilerAnnotationProcessors(MavenProject project) {
        return project.getBuildPlugins().stream().filter(MavenCompilerUtils::checkCompilerPlugin).flatMap(p -> MavenCompilerUtils.extractAnnotationProcessors(p).stream()).collect(Collectors.toList());
    }

    private static void informSurefire3RuntimeDependencyLoadingLimitation(MavenProject project) {
        boolean surefireDynamicLoadingLikely = project.getBuildPlugins().stream().filter(p -> "org.apache.maven.plugins".equals(p.getGroupId())).filter(p -> "maven-surefire-plugin".equals(p.getArtifactId())).anyMatch(ArtifactResolver::matchSurefireVersion);
        if (surefireDynamicLoadingLikely) {
            LOG.info("NOTE: maven-surefire-plugin version 3 is present. This version is known to resolve and load dependencies for various unit testing frameworks (called \"providers\") during execution. These dependencies are not validated.");
        }
    }

    private static boolean matchSurefireVersion(Plugin plugin) {
        return (Boolean)Try.of((CheckedFunction0 & Serializable)() -> new DefaultArtifactVersion(plugin.getVersion())).map(arg_0 -> ((VersionRange)SUREFIRE_PLUGIN_VERSION_RANGE).containsVersion(arg_0)).onFailure(e -> LOG.debug("Found build plug-in with overly constrained version specification.", e)).getOrElse((Object)false);
    }

    Map<Artifact, Artifact> resolveSignatures(Collection<Artifact> artifacts) {
        ArrayList requestList = new ArrayList();
        artifacts.forEach(a -> {
            String version = a.getVersion();
            if (version == null && a.getVersionRange() != null) {
                version = a.getVersionRange().toString();
            }
            DefaultArtifact artifact = new DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getArtifactHandler().getExtension() + ".asc", version);
            ArtifactRequest request = new ArtifactRequest((org.eclipse.aether.artifact.Artifact)artifact, this.remoteRepositoriesIgnoreCheckSum, null);
            request.setTrace(new RequestTrace(a));
            requestList.add(request);
        });
        HashMap<Artifact, Artifact> result = new HashMap<Artifact, Artifact>();
        List artifactResults = (List)Try.of((CheckedFunction0 & Serializable)() -> this.repositorySystem.resolveArtifacts(this.repositorySession, (Collection)requestList)).recover(ArtifactResolutionException.class, ArtifactResolutionException::getResults).get();
        artifactResults.forEach(aResult -> {
            Artifact ascArtifact = RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)aResult.getArtifact());
            Artifact artifact = (Artifact)aResult.getRequest().getTrace().getData();
            if (!aResult.isResolved()) {
                aResult.getExceptions().forEach(e -> LOG.debug("Failed to resolve asc {}: {}", (Object)aResult.getRequest().getArtifact(), (Object)e.getMessage()));
            }
            result.put(artifact, ascArtifact);
        });
        return result;
    }

    private Set<Artifact> resolveProjectArtifacts(Iterable<Artifact> artifacts, SkipFilter artifactFilter, boolean verifyPom) {
        LinkedHashSet<Object> collection = new LinkedHashSet<Object>();
        for (Artifact artifact : artifacts) {
            if (artifactFilter.shouldSkipArtifact(artifact)) {
                LOG.debug("Skipping artifact: {}", (Object)artifact);
                continue;
            }
            org.eclipse.aether.artifact.Artifact aeArtifact = RepositoryUtils.toArtifact((Artifact)artifact);
            collection.add(aeArtifact);
            if (!verifyPom) continue;
            SubArtifact pomArtifact = new SubArtifact(aeArtifact, null, "pom");
            collection.add(pomArtifact);
        }
        List requestList = collection.stream().map(a -> new ArtifactRequest(a, this.remoteProjectRepositories, null)).collect(Collectors.toList());
        List artifactResults = (List)Try.of((CheckedFunction0 & Serializable)() -> this.repositorySystem.resolveArtifacts(this.repositorySession, (Collection)requestList)).recover(ArtifactResolutionException.class, ArtifactResolutionException::getResults).get();
        HashSet<Artifact> result = new HashSet<Artifact>();
        artifactResults.forEach(aResult -> {
            if (aResult.isResolved()) {
                result.add(RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)aResult.getArtifact()));
            } else {
                aResult.getExceptions().forEach(e -> LOG.debug("Failed to resolve {}: {}", (Object)aResult.getRequest().getArtifact(), (Object)e.getMessage()));
            }
        });
        return result;
    }

    public List<Artifact> resolveArtifact(Artifact artifact, boolean verifyPomFiles) {
        List<org.eclipse.aether.artifact.Artifact> artifacts = this.resolveArtifacts(Collections.singletonList(RepositoryUtils.toArtifact((Artifact)artifact)), this.remoteProjectRepositories, verifyPomFiles);
        return artifacts.stream().map(RepositoryUtils::toArtifact).collect(Collectors.toList());
    }

    public static final class Configuration {
        final SkipFilter dependencyFilter;
        final SkipFilter pluginFilter;
        final boolean verifyPomFiles;
        final boolean verifyPlugins;
        final boolean verifyPluginDependencies;
        final boolean verifyAtypical;

        public Configuration(SkipFilter dependencyFilter, SkipFilter pluginFilter, boolean verifyPomFiles, boolean verifyPlugins, boolean verifyPluginDependencies, boolean verifyAtypical) {
            this.dependencyFilter = Objects.requireNonNull(dependencyFilter);
            this.pluginFilter = Objects.requireNonNull(pluginFilter);
            this.verifyPomFiles = verifyPomFiles;
            this.verifyPlugins = verifyPlugins || verifyPluginDependencies;
            this.verifyPluginDependencies = verifyPluginDependencies;
            this.verifyAtypical = verifyAtypical;
        }
    }
}

