/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins;

import io.vavr.control.Try;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.simplify4u.plugins.AbstractVerifyMojo;
import org.simplify4u.plugins.DuplicateKeyMapKeyItemException;
import org.simplify4u.plugins.PGPMojoException;
import org.simplify4u.plugins.ValidationChecksum;
import org.simplify4u.plugins.keysmap.KeysMap;
import org.simplify4u.plugins.keysmap.KeysMapLocationConfig;
import org.simplify4u.plugins.pgp.PublicKeyUtils;
import org.simplify4u.plugins.pgp.ReportsUtils;
import org.simplify4u.plugins.pgp.SignatureCheckResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="check", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class CheckMojo
extends AbstractVerifyMojo<VerificationResult> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckMojo.class);
    public static final String MOJO_NAME = "check";
    private static final String PGP_VERIFICATION_RESULT_FORMAT = "{} PGP Signature {}\n       {} UserIds: {}";
    @Inject
    private KeysMap keysMap;
    @Inject
    private ReportsUtils reportsUtils;
    @Deprecated
    @Parameter(property="pgpverify.failNoSignature")
    private Boolean failNoSignature;
    @Deprecated
    @Parameter(property="pgpverify.strictNoSignature")
    private Boolean strictNoSignature;
    @Parameter(property="pgpgverify.failWeakSignature", defaultValue="false")
    private boolean failWeakSignature;
    @Parameter(property="pgpverify.suppressSignatureOkLogging", defaultValue="false")
    private boolean suppressSignatureOkLogging;
    @Parameter(property="pgpverify.disableChecksum", defaultValue="false")
    private boolean disableChecksum;
    @Parameter(property="pgpverify.keysMapLocation", alias="keysMapLocations")
    private List<KeysMapLocationConfig> keysMapLocation = new ArrayList<KeysMapLocationConfig>();
    @Parameter(property="pgpverify.reportFile", defaultValue="${project.build.directory}/pgpverify-report.json")
    private File reportFile;
    @Parameter(property="pgpverify.reportWrite", defaultValue="false")
    private boolean reportWrite;
    @Parameter(property="pgpverify.failDuplicateKeyItem", defaultValue="false")
    private boolean failDuplicateKeyItem;

    @Override
    protected String getMojoName() {
        return MOJO_NAME;
    }

    @Override
    protected void checkDeprecated() {
        super.checkDeprecated();
        if (this.strictNoSignature != null) {
            LOGGER.warn("strictNoSignature is deprecated - this requirement can be expressed through the keysMap");
        }
        if (this.failNoSignature != null) {
            LOGGER.warn("failNoSignature is deprecated - this requirement can be expressed through the keysMap");
        }
        if (Boolean.TRUE.equals(this.failNoSignature) && this.keysMap.isEmpty()) {
            LOGGER.warn("failNoSignature is true and keysMap is empty we add `* = any` to keysMap for backward compatibility");
            KeysMapLocationConfig keysMapLocationConfig = new KeysMapLocationConfig();
            keysMapLocationConfig.set("/any-valid-signatures.list");
            Try.run(() -> this.keysMap.load(keysMapLocationConfig)).getOrElseThrow(e -> new PGPMojoException(e.getMessage(), e));
        }
    }

    @Override
    protected void setupMojo() throws MojoFailureException {
        super.setupMojo();
        LOGGER.debug("keysMapLocation={}", this.keysMapLocation);
        this.keysMapLocation.forEach(location -> {
            Void cfr_ignored_0 = (Void)Try.run(() -> this.keysMap.load((KeysMapLocationConfig)location)).getOrElseThrow(e -> new PGPMojoException(e.getMessage(), e));
        });
        if (this.keysMap.isEmpty()) {
            LOGGER.warn("No keysmap specified in configuration or keysmap contains no entries. PGPVerify will only check artifacts against their signature. File corruption will be detected. However, without a keysmap as a reference for trust, valid signatures of any public key will be accepted.");
        }
    }

    @Override
    protected void shouldProcess(Set<Artifact> artifacts, Runnable runnable) {
        File mavenBuildDir = new File(this.session.getCurrentProject().getBuild().getDirectory());
        ValidationChecksum validationChecksum = new ValidationChecksum.Builder().destination(mavenBuildDir).artifacts(artifacts).disabled(this.disableChecksum).build();
        if (validationChecksum.checkValidation()) {
            this.logInfoWithQuiet("Artifacts were already validated in a previous run. Execution finished early as the checksum for the collection of artifacts has not changed.");
        } else {
            runnable.run();
            validationChecksum.saveChecksum();
        }
    }

    @Override
    protected VerificationResult processArtifactSignature(Artifact artifact, Artifact ascArtifact) {
        SignatureCheckResult signatureCheckResult = this.signatureUtils.checkSignature(artifact, ascArtifact, this.pgpKeysCache);
        VerificationResult.VerificationResultBuilder verificationResultBuilder = VerificationResult.builder().result(signatureCheckResult);
        switch (signatureCheckResult.getStatus()) {
            case ARTIFACT_NOT_RESOLVED: {
                throw new PGPMojoException("Artifact not resolved: %s", artifact.getId());
            }
            case ERROR: {
                throw new PGPMojoException("Failed to process signature for artifact %s", artifact.getId(), signatureCheckResult.getErrorCause());
            }
            case SIGNATURE_ERROR: {
                if (this.keysMap.isBrokenSignature(artifact)) {
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = () -> ((Artifact)artifact).getId();
                    this.logInfoWithQuiet("{} PGP Signature is broken, consistent with keys map.", supplierArray);
                    verificationResultBuilder.error(false);
                    break;
                }
                LOGGER.error("Failed to process signature for artifact {} - {}", (Object)artifact.getId(), (Object)signatureCheckResult.getErrorMessage());
                verificationResultBuilder.error(true);
                break;
            }
            case SIGNATURE_NOT_RESOLVED: {
                verificationResultBuilder.error(!this.verifySignatureUnavailable(artifact));
                break;
            }
            case SIGNATURE_VALID: {
                this.verifyWeakSignature(signatureCheckResult.getSignature().getHashAlgorithm());
                if (!this.keysMap.isValidKey(artifact, signatureCheckResult.getKey())) {
                    String msg = String.format("%s = %s", ArtifactUtils.key((Artifact)artifact), PublicKeyUtils.fingerprintForMaster(signatureCheckResult.getKey()));
                    LOGGER.error("Not allowed artifact {} and keyID:\n\t{}\n\t{}", new Object[]{artifact.getId(), msg, signatureCheckResult.getKeyShowUrl()});
                    verificationResultBuilder.error(true);
                    break;
                }
                LOGGER.debug("signature.KeyAlgorithm: {} signature.hashAlgorithm: {}", (Object)signatureCheckResult.getKey().getAlgorithm(), (Object)signatureCheckResult.getSignature().getHashAlgorithm());
                if (!this.suppressSignatureOkLogging) {
                    Supplier[] supplierArray = new Supplier[4];
                    supplierArray[0] = () -> ((Artifact)artifact).getId();
                    supplierArray[1] = () -> "OK";
                    supplierArray[2] = () -> PublicKeyUtils.keyIdDescription(signatureCheckResult.getKey());
                    supplierArray[3] = () -> signatureCheckResult.getKey().getUids();
                    this.logInfoWithQuiet(PGP_VERIFICATION_RESULT_FORMAT, supplierArray);
                }
                verificationResultBuilder.error(false);
                break;
            }
            case SIGNATURE_INVALID: {
                if (this.keysMap.isBrokenSignature(artifact)) {
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = () -> ((Artifact)artifact).getId();
                    this.logInfoWithQuiet("{} PGP Signature is broken, consistent with keys map.", supplierArray);
                    verificationResultBuilder.error(false);
                    break;
                }
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error(PGP_VERIFICATION_RESULT_FORMAT, new Object[]{artifact.getId(), "INVALID", PublicKeyUtils.keyIdDescription(signatureCheckResult.getKey()), signatureCheckResult.getKey().getUids()});
                }
                verificationResultBuilder.error(true);
                break;
            }
            case KEY_NOT_FOUND: {
                if (this.keysMap.isKeyMissing(artifact)) {
                    Supplier[] supplierArray = new Supplier[2];
                    supplierArray[0] = () -> ((Artifact)artifact).getId();
                    supplierArray[1] = signatureCheckResult.getSignature()::getKeyId;
                    this.logInfoWithQuiet("{} PGP key {} not found on keyserver, consistent with keys map.", supplierArray);
                    verificationResultBuilder.error(false);
                    break;
                }
                LOGGER.error("{} PGP key {} not found on keyserver", (Object)artifact.getId(), (Object)signatureCheckResult.getSignature().getKeyId());
                verificationResultBuilder.error(true);
                break;
            }
            case KEY_REVOCATION: {
                if (this.keysMap.isValidKeyNoPublicKey(artifact, signatureCheckResult.getKey())) {
                    Supplier[] supplierArray = new Supplier[2];
                    supplierArray[0] = () -> ((Artifact)artifact).getId();
                    supplierArray[1] = signatureCheckResult.getSignature()::getKeyId;
                    this.logInfoWithQuiet("{} PGP key {} is revoked and has no public key, consistent with keys map.", supplierArray);
                    verificationResultBuilder.error(false);
                    break;
                }
                String msg = String.format("%s = !%s", ArtifactUtils.key((Artifact)artifact), PublicKeyUtils.fingerprintForMaster(signatureCheckResult.getKey()));
                LOGGER.error("{} PGP key {} has been revoked and public key is not available\n\t{}\n\t{}", new Object[]{artifact.getId(), signatureCheckResult.getSignature().getKeyId(), msg, signatureCheckResult.getKeyShowUrl()});
                verificationResultBuilder.error(true);
                break;
            }
            default: {
                verificationResultBuilder.error(true);
            }
        }
        return verificationResultBuilder.build();
    }

    @Override
    protected void processVerificationResult(Collection<VerificationResult> verificationResult) {
        if (this.reportWrite) {
            Try.run(() -> this.reportsUtils.writeReportAsJson(this.reportFile, verificationResult.stream().map(v -> v.result).collect(Collectors.toList()))).getOrElseThrow(e -> new PGPMojoException(e.getMessage(), e));
        }
        if (verificationResult.stream().anyMatch(result -> result.error)) {
            throw new PGPMojoException("Signature errors");
        }
        if (this.failDuplicateKeyItem && this.keysMap.isWithDuplicateKeyItems()) {
            throw new DuplicateKeyMapKeyItemException();
        }
    }

    private void verifyWeakSignature(int hashAlgorithm) {
        String weakHashAlgorithm = this.signatureUtils.checkWeakHashAlgorithm(hashAlgorithm);
        if (weakHashAlgorithm == null) {
            return;
        }
        String logMessage = "Weak signature algorithm used: " + weakHashAlgorithm;
        if (this.failWeakSignature) {
            LOGGER.error(logMessage);
            throw new PGPMojoException(logMessage);
        }
        LOGGER.warn(logMessage);
    }

    private boolean verifySignatureUnavailable(Artifact artifact) {
        if (this.keysMap.isEmpty()) {
            LOGGER.warn("No signature for {}", (Object)artifact.getId());
            return true;
        }
        if (this.keysMap.isNoSignature(artifact)) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((Artifact)artifact).getId();
            this.logInfoWithQuiet("{} PGP Signature unavailable, consistent with keys map.", supplierArray);
            return true;
        }
        if (this.keysMap.isWithKey(artifact)) {
            LOGGER.error("Unsigned artifact is listed with key in keys map: {}", (Object)artifact.getId());
        } else {
            LOGGER.error("Unsigned artifact not listed in keys map: {}", (Object)artifact.getId());
        }
        return false;
    }

    public static class VerificationResult {
        boolean error;
        SignatureCheckResult result;

        @ConstructorProperties(value={"error", "result"})
        @Generated
        VerificationResult(boolean error, SignatureCheckResult result) {
            this.error = error;
            this.result = result;
        }

        @Generated
        public static VerificationResultBuilder builder() {
            return new VerificationResultBuilder();
        }

        @Generated
        public static class VerificationResultBuilder {
            @Generated
            private boolean error;
            @Generated
            private SignatureCheckResult result;

            @Generated
            VerificationResultBuilder() {
            }

            @Generated
            public VerificationResultBuilder error(boolean error) {
                this.error = error;
                return this;
            }

            @Generated
            public VerificationResultBuilder result(SignatureCheckResult result) {
                this.result = result;
                return this;
            }

            @Generated
            public VerificationResult build() {
                return new VerificationResult(this.error, this.result);
            }

            @Generated
            public String toString() {
                return "CheckMojo.VerificationResult.VerificationResultBuilder(error=" + this.error + ", result=" + this.result + ")";
            }
        }
    }
}

