/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.keysmap;

import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;
import org.simplify4u.plugins.keysmap.KeyItem;
import org.simplify4u.plugins.pgp.KeyFingerprint;
import org.simplify4u.plugins.pgp.KeyInfo;
import org.simplify4u.plugins.utils.HexUtils;

class KeyItemFingerprint
implements KeyItem {
    private final boolean allowNoPublicKey;
    private final byte[] fingerPrint;

    public KeyItemFingerprint(String key) {
        if (key.startsWith("!")) {
            this.fingerPrint = HexUtils.stringToFingerprint(key.substring(1));
            this.allowNoPublicKey = true;
        } else {
            this.fingerPrint = HexUtils.stringToFingerprint(key);
            this.allowNoPublicKey = false;
        }
    }

    @Override
    public boolean isKeyMatch(KeyInfo keyInfo) {
        return !this.allowNoPublicKey && this.compareWith(keyInfo);
    }

    @Override
    public boolean isKeyMatchNoPublicKey(KeyInfo keyInfo) {
        return this.allowNoPublicKey && this.compareWith(keyInfo);
    }

    private boolean compareWith(KeyInfo keyInfo) {
        return this.compareWith(keyInfo.getMaster()) || this.compareWith(keyInfo.getFingerprint());
    }

    private boolean compareWith(KeyFingerprint fingerprint) {
        return Optional.ofNullable(fingerprint).map(KeyFingerprint::getFingerprint).map(this::compareWith).orElse(false);
    }

    private boolean compareWith(byte[] keyBytes) {
        for (int i = 1; i <= this.fingerPrint.length && i <= keyBytes.length; ++i) {
            if (this.fingerPrint[this.fingerPrint.length - i] == keyBytes[keyBytes.length - i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return HexUtils.fingerprintToString(this.fingerPrint);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyItemFingerprint)) {
            return false;
        }
        KeyItemFingerprint other = (KeyItemFingerprint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.allowNoPublicKey != other.allowNoPublicKey) {
            return false;
        }
        return Arrays.equals(this.fingerPrint, other.fingerPrint);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KeyItemFingerprint;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.allowNoPublicKey ? 79 : 97);
        result = result * 59 + Arrays.hashCode(this.fingerPrint);
        return result;
    }
}

