/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.pgp;

import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigInteger;
import java.util.Arrays;
import lombok.Generated;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.simplify4u.plugins.utils.HexUtils;

public interface KeyId {
    public long getId();

    public String getHashPath();

    public PGPPublicKey getKeyFromRing(PGPPublicKeyRing var1);

    public static KeyId from(byte[] fingerprint) {
        return new KeyIdFingerprint(fingerprint);
    }

    public static KeyId from(Long keyId) {
        return new KeyIdLong(keyId);
    }

    public static class KeyIdFingerprint
    implements KeyId {
        private final byte[] fingerprint;

        KeyIdFingerprint(byte[] fingerprint) {
            this.fingerprint = fingerprint;
        }

        @Override
        public long getId() {
            return new BigInteger(Arrays.copyOfRange(this.fingerprint, this.fingerprint.length - 8, this.fingerprint.length)).longValue();
        }

        @Override
        public String getHashPath() {
            StringBuilder ret = new StringBuilder();
            ret.append(String.format("%02X/", this.fingerprint[0]));
            ret.append(String.format("%02X/", this.fingerprint[1]));
            for (byte b : this.fingerprint) {
                ret.append(String.format("%02X", b));
            }
            ret.append(".asc");
            return ret.toString();
        }

        @Override
        public PGPPublicKey getKeyFromRing(PGPPublicKeyRing publicKeyRing) {
            return publicKeyRing.getPublicKey(this.fingerprint);
        }

        @JsonValue
        public String toString() {
            return HexUtils.fingerprintToString(this.fingerprint);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeyIdFingerprint)) {
                return false;
            }
            KeyIdFingerprint other = (KeyIdFingerprint)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return Arrays.equals(this.fingerprint, other.fingerprint);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof KeyIdFingerprint;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.fingerprint);
            return result;
        }
    }

    public static class KeyIdLong
    implements KeyId {
        private final Long keyId;

        KeyIdLong(Long keyId) {
            this.keyId = keyId;
        }

        @Override
        public long getId() {
            return this.keyId;
        }

        @Override
        public String getHashPath() {
            return String.format("%02X/%02X/%016X.asc", (byte)(this.keyId >> 56), (byte)(this.keyId >> 48 & 0xFFL), this.keyId);
        }

        @Override
        public PGPPublicKey getKeyFromRing(PGPPublicKeyRing publicKeyRing) {
            return publicKeyRing.getPublicKey(this.keyId.longValue());
        }

        @JsonValue
        public String toString() {
            return String.format("0x%016X", this.keyId);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeyIdLong)) {
                return false;
            }
            KeyIdLong other = (KeyIdLong)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$keyId = this.keyId;
            Long other$keyId = other.keyId;
            return !(this$keyId == null ? other$keyId != null : !((Object)this$keyId).equals(other$keyId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof KeyIdLong;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $keyId = this.keyId;
            result = result * 59 + ($keyId == null ? 43 : ((Object)$keyId).hashCode());
            return result;
        }
    }
}

