/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.pgp;

import io.vavr.control.Try;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.simplify4u.plugins.pgp.KeyId;
import org.simplify4u.plugins.pgp.KeyInfo;
import org.simplify4u.plugins.pgp.PublicKeyRingPack;
import org.simplify4u.plugins.utils.HexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PublicKeyUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PublicKeyUtils.class);

    private PublicKeyUtils() {
    }

    static String fingerprint(PGPPublicKey publicKey) {
        return HexUtils.fingerprintToString(publicKey.getFingerprint());
    }

    public static String fingerprintForMaster(KeyInfo keyInfo) {
        return Optional.ofNullable(keyInfo.getMaster()).orElse(keyInfo.getFingerprint()).toString();
    }

    public static String keyIdDescription(KeyInfo keyInfo) {
        if (keyInfo.getMaster() != null) {
            return String.format("SubKeyId: %s of %s", keyInfo.getFingerprint(), keyInfo.getMaster());
        }
        return "KeyId: " + keyInfo.getFingerprint();
    }

    static Optional<PGPPublicKey> getMasterKey(PGPPublicKey publicKey, PGPPublicKeyRing publicKeyRing) {
        if (publicKey.isMasterKey()) {
            return Optional.empty();
        }
        Iterator signatures = publicKey.getSignaturesOfType(24);
        if (signatures.hasNext()) {
            PGPSignature sig = (PGPSignature)signatures.next();
            return Optional.ofNullable(publicKeyRing.getPublicKey(sig.getKeyID()));
        }
        return Optional.empty();
    }

    static Collection<String> getUserIDs(PGPPublicKey publicKey, PGPPublicKeyRing publicKeyRing) {
        LinkedHashSet ret = new LinkedHashSet();
        publicKey.getRawUserIDs().forEachRemaining(ret::add);
        PublicKeyUtils.getMasterKey(publicKey, publicKeyRing).ifPresent(masterKey -> masterKey.getRawUserIDs().forEachRemaining(ret::add));
        return ret.stream().map(b -> new String((byte[])b, StandardCharsets.UTF_8)).collect(Collectors.toSet());
    }

    public static PublicKeyRingPack loadPublicKeyRing(InputStream keyStream, KeyId keyId) throws IOException, PGPException {
        InputStream keyIn = PGPUtil.getDecoderStream((InputStream)keyStream);
        PGPObjectFactory pgpFact = new PGPObjectFactory(keyIn, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        Optional<Object> publicKeyRing = Optional.empty();
        Optional<Object> revocationSignature = Optional.empty();
        Object obj = pgpFact.nextObject();
        while (obj != null) {
            if (obj instanceof PGPPublicKeyRing) {
                PGPPublicKeyRing ring = (PGPPublicKeyRing)obj;
                if (keyId.getKeyFromRing(ring) != null) {
                    publicKeyRing = Optional.of(ring);
                }
            } else if (obj instanceof PGPSignatureList) {
                PGPSignatureList signatureList = (PGPSignatureList)obj;
                revocationSignature = StreamSupport.stream(signatureList.spliterator(), false).filter(s -> s.getSignatureType() == 32).filter(s -> s.getKeyID() == keyId.getId()).findAny();
            } else {
                LOGGER.warn("Invalid object item {} for keyId: {}", (Object)obj.getClass().getName(), (Object)keyId);
            }
            obj = pgpFact.nextObject();
        }
        if (publicKeyRing.isPresent()) {
            Iterator signaturesOfType;
            PublicKeyUtils.verifyPublicKeyRing((PGPPublicKeyRing)publicKeyRing.get());
            PGPPublicKey key = keyId.getKeyFromRing((PGPPublicKeyRing)publicKeyRing.get());
            if (key.hasRevocation() && !revocationSignature.isPresent() && (signaturesOfType = key.getSignaturesOfType(32)).hasNext()) {
                revocationSignature = Optional.of(signaturesOfType.next());
            }
        }
        return PublicKeyRingPack.builder().publicKeyRing(publicKeyRing.orElse(null)).revocationSignature(revocationSignature.orElse(null)).build();
    }

    private static void verifyPublicKeyRing(PGPPublicKeyRing publicKeyRing) {
        StreamSupport.stream(publicKeyRing.spliterator(), false).filter(key -> !key.isMasterKey()).forEach(key -> {
            Void cfr_ignored_0 = (Void)Try.run(() -> PublicKeyUtils.verifySigForSubKey(key, publicKeyRing)).get();
        });
    }

    private static void verifySigForSubKey(PGPPublicKey subKey, PGPPublicKeyRing publicKeyRing) throws PGPException {
        int signatureTypeToCheck = subKey.hasRevocation() ? 40 : 24;
        AtomicBoolean hasValidSignature = new AtomicBoolean(false);
        Iterator it = subKey.getSignaturesOfType(signatureTypeToCheck);
        it.forEachRemaining(s -> {
            Void cfr_ignored_0 = (Void)Try.run(() -> {
                PGPSignature sig = (PGPSignature)s;
                PGPPublicKey masterKey = publicKeyRing.getPublicKey(sig.getKeyID());
                if (masterKey != null) {
                    sig.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), masterKey);
                    if (sig.verifyCertification(masterKey, subKey)) {
                        hasValidSignature.set(true);
                    } else {
                        LOGGER.debug("Invalid signature [{}] type: {} for subKey: {}", new Object[]{sig.getCreationTime(), sig.getSignatureType(), PublicKeyUtils.fingerprint(subKey)});
                    }
                } else {
                    throw new PGPException(String.format("Signature type: %d Not found key 0x%016X for subKeyId: %s", sig.getSignatureType(), sig.getKeyID(), PublicKeyUtils.fingerprint(subKey)));
                }
            }).get();
        });
        if (!hasValidSignature.get()) {
            throw new PGPException(String.format("No valid signature type: %d for subKey: %s", signatureTypeToCheck, PublicKeyUtils.fingerprint(subKey)));
        }
    }
}

