/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.pgp;

import java.beans.ConstructorProperties;
import java.util.Date;
import lombok.Generated;

public final class RevocationSignatureInfo {
    private final Date date;
    private final byte reason;
    private final String description;

    public String getReasonAsString() {
        switch (this.reason) {
            case 0: {
                return "No reason specified";
            }
            case 1: {
                return "Key is superseded";
            }
            case 2: {
                return "Key material has been compromised";
            }
            case 3: {
                return "Key is retired and no longer used";
            }
        }
        return String.format("Unknown reason: %X", this.reason);
    }

    @ConstructorProperties(value={"date", "reason", "description"})
    @Generated
    RevocationSignatureInfo(Date date, byte reason, String description) {
        this.date = date;
        this.reason = reason;
        this.description = description;
    }

    @Generated
    public static RevocationSignatureInfoBuilder builder() {
        return new RevocationSignatureInfoBuilder();
    }

    @Generated
    public Date getDate() {
        return this.date;
    }

    @Generated
    public byte getReason() {
        return this.reason;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevocationSignatureInfo)) {
            return false;
        }
        RevocationSignatureInfo other = (RevocationSignatureInfo)o;
        if (this.getReason() != other.getReason()) {
            return false;
        }
        Date this$date = this.getDate();
        Date other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getReason();
        Date $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RevocationSignatureInfo(date=" + this.getDate() + ", reason=" + this.getReason() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public static class RevocationSignatureInfoBuilder {
        @Generated
        private Date date;
        @Generated
        private byte reason;
        @Generated
        private String description;

        @Generated
        RevocationSignatureInfoBuilder() {
        }

        @Generated
        public RevocationSignatureInfoBuilder date(Date date) {
            this.date = date;
            return this;
        }

        @Generated
        public RevocationSignatureInfoBuilder reason(byte reason) {
            this.reason = reason;
            return this;
        }

        @Generated
        public RevocationSignatureInfoBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public RevocationSignatureInfo build() {
            return new RevocationSignatureInfo(this.date, this.reason, this.description);
        }

        @Generated
        public String toString() {
            return "RevocationSignatureInfo.RevocationSignatureInfoBuilder(date=" + this.date + ", reason=" + this.reason + ", description=" + this.description + ")";
        }
    }
}

