/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.pgp;

import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.bouncycastle.bcpg.sig.IssuerFingerprint;
import org.bouncycastle.bcpg.sig.RevocationReason;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.simplify4u.plugins.keyserver.PGPKeyNotFound;
import org.simplify4u.plugins.keyserver.PGPKeysCache;
import org.simplify4u.plugins.pgp.ArtifactInfo;
import org.simplify4u.plugins.pgp.KeyFingerprint;
import org.simplify4u.plugins.pgp.KeyId;
import org.simplify4u.plugins.pgp.KeyInfo;
import org.simplify4u.plugins.pgp.PublicKeyRingPack;
import org.simplify4u.plugins.pgp.PublicKeyUtils;
import org.simplify4u.plugins.pgp.RevocationSignatureInfo;
import org.simplify4u.plugins.pgp.SignatureCheckResult;
import org.simplify4u.plugins.pgp.SignatureException;
import org.simplify4u.plugins.pgp.SignatureInfo;
import org.simplify4u.plugins.pgp.SignatureStatus;
import org.simplify4u.plugins.utils.HexUtils;

@Named
@Singleton
public class SignatureUtils {
    public String checkWeakHashAlgorithm(int hashAlgorithm) {
        switch (hashAlgorithm) {
            case 1: {
                return "MD5";
            }
            case 4: {
                return "double-width SHA";
            }
            case 5: {
                return "MD2";
            }
            case 6: {
                return "TIGER/192";
            }
            case 7: {
                return "HAVAL (5 pass, 160-bit)";
            }
            case 11: {
                return "SHA-224";
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                return null;
            }
        }
        throw new UnsupportedOperationException("Unknown hash algorithm value encountered: " + hashAlgorithm);
    }

    public PGPSignature loadSignature(InputStream input) throws SignatureException {
        try {
            Object nextObject;
            InputStream sigInputStream = PGPUtil.getDecoderStream((InputStream)input);
            PGPObjectFactory pgpObjectFactory = new PGPObjectFactory(sigInputStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            while ((nextObject = pgpObjectFactory.nextObject()) != null) {
                if (nextObject instanceof PGPSignatureList) {
                    return ((PGPSignatureList)nextObject).get(0);
                }
                if (nextObject instanceof PGPCompressedData) {
                    pgpObjectFactory = new PGPObjectFactory(((PGPCompressedData)nextObject).getDataStream(), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                }
                if (!(nextObject instanceof PGPLiteralData)) continue;
                InputStream dataStream = ((PGPLiteralData)nextObject).getDataStream();
                byte[] buf = new byte[8192];
                while (dataStream.read(buf) > 0) {
                }
            }
        }
        catch (IOException | PGPException e) {
            throw new SignatureException(e.getMessage(), e);
        }
        throw new SignatureException("PGP signature not found.");
    }

    public PGPSignature loadSignature(File file) throws IOException, SignatureException {
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            PGPSignature pGPSignature = this.loadSignature(in);
            return pGPSignature;
        }
    }

    public void readFileContentInto(PGPSignature signature, File file) throws IOException {
        try (BufferedInputStream inArtifact = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            int t;
            byte[] buf = new byte[8192];
            while ((t = ((InputStream)inArtifact).read(buf)) >= 0) {
                signature.update(buf, 0, t);
            }
        }
    }

    public KeyId retrieveKeyId(PGPSignature signature) throws SignatureException {
        Optional<Long> issuerKeyId;
        Optional<PGPSignatureSubpacketVector> hashedSubPackets = Optional.ofNullable(signature.getHashedSubPackets());
        Optional<PGPSignatureSubpacketVector> unHashedSubPackets = Optional.ofNullable(signature.getUnhashedSubPackets());
        Optional<IssuerFingerprint> issuerFingerprint = hashedSubPackets.map(PGPSignatureSubpacketVector::getIssuerFingerprint);
        if (!issuerFingerprint.isPresent()) {
            issuerFingerprint = unHashedSubPackets.map(PGPSignatureSubpacketVector::getIssuerFingerprint);
        }
        if (!(issuerKeyId = unHashedSubPackets.map(PGPSignatureSubpacketVector::getIssuerKeyID).filter(id -> id != 0L)).isPresent()) {
            issuerKeyId = hashedSubPackets.map(PGPSignatureSubpacketVector::getIssuerKeyID).filter(id -> id != 0L);
        }
        if (issuerKeyId.isPresent() && signature.getKeyID() != issuerKeyId.get().longValue()) {
            throw new SignatureException(String.format("Signature KeyID 0x%016X is not equals to IssuerKeyID 0x%016X", signature.getKeyID(), issuerKeyId.get()));
        }
        if (issuerKeyId.isPresent() && issuerFingerprint.isPresent() && issuerFingerprint.get().getKeyVersion() == 4) {
            byte[] bKey = new byte[8];
            byte[] fingerprint = issuerFingerprint.get().getFingerprint();
            System.arraycopy(fingerprint, fingerprint.length - 8, bKey, 0, 8);
            BigInteger bigInteger = new BigInteger(bKey);
            if (bigInteger.longValue() != issuerKeyId.get().longValue()) {
                throw new SignatureException(String.format("Signature IssuerFingerprint 0x%s not contains IssuerKeyID 0x%016X", HexUtils.fingerprintToString(fingerprint), issuerKeyId.get()));
            }
        }
        KeyId keyId = issuerFingerprint.isPresent() ? KeyId.from(issuerFingerprint.get().getFingerprint()) : (issuerKeyId.isPresent() ? KeyId.from(issuerKeyId.get()) : KeyId.from(signature.getKeyID()));
        return keyId;
    }

    private SignatureCheckResult checkSignature(Artifact artifact, Artifact artifactAsc, boolean onlyResolve, PGPKeysCache cache) {
        SignatureCheckResult.SignatureCheckResultBuilder signatureCheckResultBuilder = SignatureCheckResult.builder();
        signatureCheckResultBuilder.artifact(ArtifactInfo.builder().groupId(artifact.getGroupId()).artifactId(artifact.getArtifactId()).type(artifact.getType()).classifier(artifact.getClassifier()).version(artifact.getVersion()).build());
        if (!artifact.isResolved()) {
            return signatureCheckResultBuilder.status(SignatureStatus.ARTIFACT_NOT_RESOLVED).build();
        }
        if (artifactAsc == null || !artifactAsc.isResolved()) {
            return signatureCheckResultBuilder.status(SignatureStatus.SIGNATURE_NOT_RESOLVED).build();
        }
        PGPSignature signature = (PGPSignature)Try.of((CheckedFunction0 & Serializable)() -> this.loadSignature(artifactAsc.getFile())).onFailure(e -> signatureCheckResultBuilder.errorCause((Throwable)e).status(SignatureStatus.SIGNATURE_ERROR)).getOrNull();
        if (signature == null) {
            return signatureCheckResultBuilder.build();
        }
        KeyId keyId = (KeyId)Try.of((CheckedFunction0 & Serializable)() -> this.retrieveKeyId(signature)).onFailure(e -> signatureCheckResultBuilder.errorCause((Throwable)e).status(SignatureStatus.SIGNATURE_ERROR)).getOrNull();
        if (keyId == null) {
            return signatureCheckResultBuilder.build();
        }
        signatureCheckResultBuilder.signature(SignatureInfo.builder().hashAlgorithm(signature.getHashAlgorithm()).keyAlgorithm(signature.getKeyAlgorithm()).date(signature.getCreationTime()).keyId(keyId).version(signature.getVersion()).build());
        PublicKeyRingPack publicKeys = (PublicKeyRingPack)Try.of((CheckedFunction0 & Serializable)() -> cache.getKeyRing(keyId)).onFailure(e -> signatureCheckResultBuilder.errorCause((Throwable)e).status(SignatureStatus.ERROR)).onFailure(PGPKeyNotFound.class, e -> signatureCheckResultBuilder.status(SignatureStatus.KEY_NOT_FOUND)).getOrNull();
        signatureCheckResultBuilder.keyShowUrl(cache.getUrlForShowKey(keyId));
        if (publicKeys == null) {
            return signatureCheckResultBuilder.build();
        }
        if (publicKeys.hasPublicKeys()) {
            PGPPublicKey publicKey = keyId.getKeyFromRing(publicKeys.getPublicKeyRing());
            signatureCheckResultBuilder.key(KeyInfo.builder().fingerprint(new KeyFingerprint(publicKey.getFingerprint())).master(PublicKeyUtils.getMasterKey(publicKey, publicKeys.getPublicKeyRing()).map(PGPPublicKey::getFingerprint).map(KeyFingerprint::new).orElse(null)).uids(PublicKeyUtils.getUserIDs(publicKey, publicKeys.getPublicKeyRing())).version(publicKey.getVersion()).algorithm(publicKey.getAlgorithm()).bits(publicKey.getBitStrength()).date(publicKey.getCreationTime()).revoked(publicKey.hasRevocation()).build());
        }
        if (publicKeys.hasRevocationSignature()) {
            PGPSignature revocationSignature = publicKeys.getRevocationSignature();
            if (!publicKeys.hasPublicKeys()) {
                KeyId keyIdRecSignature = (KeyId)Try.of((CheckedFunction0 & Serializable)() -> this.retrieveKeyId(revocationSignature)).onFailure(e -> signatureCheckResultBuilder.errorCause((Throwable)e).status(SignatureStatus.SIGNATURE_ERROR)).getOrNull();
                if (keyIdRecSignature == null) {
                    return signatureCheckResultBuilder.build();
                }
                signatureCheckResultBuilder.key(KeyInfo.builder().fingerprint(new KeyFingerprint(keyIdRecSignature.toString())).revoked(true).build());
            }
            signatureCheckResultBuilder.revocationSignature(SignatureUtils.getRevocationSignatureInfo(revocationSignature));
        }
        if (onlyResolve) {
            return signatureCheckResultBuilder.status(SignatureStatus.RESOLVED).build();
        }
        if (publicKeys.hasPublicKeys()) {
            Boolean verifyStatus = (Boolean)Try.of((CheckedFunction0 & Serializable)() -> {
                signature.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), keyId.getKeyFromRing(publicKeys.getPublicKeyRing()));
                this.readFileContentInto(signature, artifact.getFile());
                return signature.verify();
            }).onFailure(e -> signatureCheckResultBuilder.errorCause((Throwable)e).status(SignatureStatus.ERROR)).getOrNull();
            if (verifyStatus == null) {
                return signatureCheckResultBuilder.build();
            }
            return signatureCheckResultBuilder.status(Boolean.TRUE.equals(verifyStatus) ? SignatureStatus.SIGNATURE_VALID : SignatureStatus.SIGNATURE_INVALID).build();
        }
        return signatureCheckResultBuilder.status(SignatureStatus.KEY_REVOCATION).build();
    }

    private static RevocationSignatureInfo getRevocationSignatureInfo(PGPSignature signature) {
        if (signature.getSignatureType() != 32) {
            return null;
        }
        Optional<RevocationReason> revocationReason = Optional.ofNullable(signature.getHashedSubPackets()).map(PGPSignatureSubpacketVector::getRevocationReason);
        if (!revocationReason.isPresent()) {
            revocationReason = Optional.ofNullable(signature.getUnhashedSubPackets()).map(PGPSignatureSubpacketVector::getRevocationReason);
        }
        return revocationReason.map(r -> RevocationSignatureInfo.builder().date(signature.getCreationTime()).reason(r.getRevocationReason()).description(r.getRevocationDescription()).build()).orElse(null);
    }

    public SignatureCheckResult checkSignature(Artifact artifact, Artifact artifactAsc, PGPKeysCache cache) {
        return this.checkSignature(artifact, artifactAsc, false, cache);
    }

    public SignatureCheckResult resolveSignature(Artifact artifact, Artifact artifactAsc, PGPKeysCache cache) {
        return this.checkSignature(artifact, artifactAsc, true, cache);
    }

    public String keyAlgorithmName(int keyAlgorithm) {
        switch (keyAlgorithm) {
            case 0: {
                return "-";
            }
            case 1: {
                return "RSA (Encrypt or Sign)";
            }
            case 2: {
                return "RSA Encrypt-Only";
            }
            case 3: {
                return "RSA Sign-Only";
            }
            case 16: {
                return "Elgamal (Encrypt-Only)";
            }
            case 17: {
                return "DSA (Digital Signature Algorithm)";
            }
            case 18: {
                return "Elliptic Curve";
            }
            case 19: {
                return "Elliptic Curve Digital Signature";
            }
            case 20: {
                return "Elgamal (Encrypt or Sign)";
            }
            case 21: {
                return "Diffie-Hellman";
            }
            case 22: {
                return "EdDSA";
            }
            case 23: {
                return "AEDH";
            }
            case 24: {
                return "AEDSA";
            }
            case 25: {
                return "X25519";
            }
            case 26: {
                return "X448";
            }
            case 27: {
                return "Ed25519";
            }
            case 28: {
                return "Ed448";
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: {
                return "Experimental - " + keyAlgorithm;
            }
        }
        throw new UnsupportedOperationException("Unknown key algorithm value encountered: " + keyAlgorithm);
    }

    public String digestName(int hashAlgorithm) {
        switch (hashAlgorithm) {
            case 2: {
                return "SHA1";
            }
            case 4: {
                return "double-width SHA";
            }
            case 5: {
                return "MD2";
            }
            case 301: {
                return "MD4";
            }
            case 1: {
                return "MD5";
            }
            case 7: {
                return "HAVAL (5 pass, 160-bit)";
            }
            case 3: {
                return "RIPEMD160";
            }
            case 8: {
                return "SHA256";
            }
            case 9: {
                return "SHA384";
            }
            case 10: {
                return "SHA512";
            }
            case 11: {
                return "SHA224";
            }
            case 12: 
            case 313: {
                return "SHA256";
            }
            case 314: {
                return "SHA384";
            }
            case 14: 
            case 315: {
                return "SHA512";
            }
            case 312: {
                return "SHA224";
            }
            case 6: {
                return "TIGER";
            }
            case 326: {
                return "SM3";
            }
        }
        throw new UnsupportedOperationException("Unknown hash algorithm tag in digestName: " + hashAlgorithm);
    }
}

