/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.simplify4u.plugins.KeyInfo;

public class ArtifactInfo {
    private final KeyInfo keyInfo;
    private final Pattern groupIdPattern;
    private final Pattern artifactIdPattern;
    private final Pattern versionPattern;
    private static final Pattern DOT_REPLACE = Pattern.compile("\\.");
    private static final Pattern STAR_REPLACE = Pattern.compile("\\*");

    public ArtifactInfo(String strArtifact, KeyInfo keyInfo) {
        String[] split = strArtifact.split(":");
        String groupId = split.length > 0 ? split[0].trim().toLowerCase(Locale.US) : "";
        String artifactId = split.length > 1 ? split[1].trim().toLowerCase(Locale.US) : "";
        String version = split.length > 2 ? split[2].trim().toLowerCase(Locale.US) : "";
        this.groupIdPattern = Pattern.compile(this.patternPrepare(groupId));
        this.artifactIdPattern = Pattern.compile(this.patternPrepare(artifactId));
        this.versionPattern = Pattern.compile(this.patternPrepare(version));
        this.keyInfo = keyInfo;
    }

    private String patternPrepare(String str) {
        if (str.length() == 0) {
            return ".*";
        }
        String ret = DOT_REPLACE.matcher(str).replaceAll("\\\\.");
        ret = STAR_REPLACE.matcher(ret).replaceAll(".*");
        return ret;
    }

    public boolean isMatch(Artifact artifact) {
        return this.isMatchPattern(this.groupIdPattern, artifact.getGroupId()) && this.isMatchPattern(this.artifactIdPattern, artifact.getArtifactId()) && this.isMatchPattern(this.versionPattern, artifact.getVersion());
    }

    private boolean isMatchPattern(Pattern pattern, String str) {
        Matcher m = pattern.matcher(str.toLowerCase(Locale.US));
        return m.matches();
    }

    public boolean isKeyMatch(PGPPublicKey key) {
        return this.keyInfo.isKeyMatch(key);
    }
}

