/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.ProjectDependenciesResolver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.simplify4u.plugins.AscArtifactHandler;
import org.simplify4u.plugins.KeysMap;
import org.simplify4u.plugins.PGPKeysCache;
import org.simplify4u.plugins.skipfilters.ProvidedDependencySkipper;
import org.simplify4u.plugins.skipfilters.ReactorDependencySkipper;
import org.simplify4u.plugins.skipfilters.SkipFilter;
import org.simplify4u.plugins.skipfilters.SnapshotDependencySkipper;
import org.simplify4u.plugins.skipfilters.SystemDependencySkipper;

@Mojo(name="check", requiresProject=true, requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.VALIDATE)
public class PGPVerifyMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private ProjectDependenciesResolver resolver;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private KeysMap keysMap;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(property="pgpverify.keycache", defaultValue="${settings.localRepository}/pgpkeys-cache", required=true)
    private File pgpKeysCachePath;
    @Parameter(property="pgpverify.scope", defaultValue="test")
    private String scope;
    @Parameter(property="pgpverify.keyserver", defaultValue="hkps://hkps.pool.sks-keyservers.net", required=true)
    private String pgpKeyServer;
    @Parameter(property="pgpverify.failNoSignature", defaultValue="false")
    private boolean failNoSignature;
    @Parameter(property="pgpgverify.failWeakSignature", defaultValue="false")
    private boolean failWeakSignature;
    @Parameter(property="pgpverify.verifyPomFiles", defaultValue="true")
    private boolean verifyPomFiles;
    @Parameter(property="pgpverify.verifySnapshots", defaultValue="false")
    private boolean verifySnapshots;
    @Parameter(property="pgpverify.verifyProvidedDependencies", defaultValue="false")
    private boolean verifyProvidedDependencies;
    @Parameter(property="pgpverify.verifySystemDependencies", defaultValue="false")
    private boolean verifySystemDependencies;
    @Parameter(property="pgpverify.verifyReactorDependencies", defaultValue="false")
    private boolean verifyReactorDependencies;
    @Parameter(property="pgpverify.keysMapLocation", defaultValue="")
    private String keysMapLocation;
    @Parameter(property="pgpverify.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="pgpverify.quiet", defaultValue="false")
    private boolean quiet;
    private PGPKeysCache pgpKeysCache;
    private List<SkipFilter> skipFilters;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping pgpverify:check");
        } else {
            this.prepareSkipFilters();
            this.prepareForKeys();
            try {
                this.verifyArtifacts(this.getArtifactsToVerify());
            }
            catch (ArtifactNotFoundException | ArtifactResolutionException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
    }

    private void prepareSkipFilters() {
        LinkedList<SkipFilter> filters = new LinkedList<SkipFilter>();
        if (!this.verifySnapshots) {
            filters.add(new SnapshotDependencySkipper());
        }
        if (!this.verifyProvidedDependencies) {
            filters.add(new ProvidedDependencySkipper());
        }
        if (!this.verifySystemDependencies) {
            filters.add(new SystemDependencySkipper());
        }
        if (!this.verifyReactorDependencies) {
            filters.add(new ReactorDependencySkipper(this.project, this.session));
        }
        this.skipFilters = filters;
    }

    private void prepareForKeys() throws MojoFailureException, MojoExecutionException {
        this.initCache();
        try {
            this.keysMap.load(this.keysMapLocation);
        }
        catch (IOException | ResourceNotFoundException e) {
            throw new MojoExecutionException("load keys map", (Exception)e);
        }
    }

    private Set<Artifact> getArtifactsToVerify() throws ArtifactResolutionException, ArtifactNotFoundException {
        Set artifacts = this.resolver.resolve(this.project, Arrays.asList(this.scope.split(",")), this.session);
        if (this.verifyPomFiles) {
            artifacts.addAll(this.getPomArtifacts(artifacts));
        }
        return artifacts;
    }

    private Set<Artifact> getPomArtifacts(Set<Artifact> artifacts) {
        HashSet<Artifact> poms = new HashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (this.shouldSkipArtifact(artifact)) continue;
            ArtifactResolutionRequest rreq = this.getArtifactResolutionRequestForPom(artifact);
            ArtifactResolutionResult result = this.repositorySystem.resolve(rreq);
            if (result.isSuccess()) {
                poms.add(rreq.getArtifact());
                continue;
            }
            this.getLog().warn((CharSequence)("No pom for " + artifact.getId()));
        }
        return poms;
    }

    private void verifyArtifacts(Set<Artifact> artifacts) throws MojoExecutionException, MojoFailureException {
        HashMap<Artifact, Artifact> artifactToAsc = new HashMap<Artifact, Artifact>();
        this.getLog().debug((CharSequence)"Start resolving ASC files");
        for (Artifact artifact : artifacts) {
            Artifact ascArtifact = this.resolveAscArtifact(artifact);
            if (ascArtifact == null) continue;
            artifactToAsc.put(artifact, ascArtifact);
        }
        this.verifyArtifactSignatures(artifactToAsc);
    }

    private Artifact resolveAscArtifact(Artifact artifact) throws MojoExecutionException {
        Artifact ascArtifact = null;
        if (!this.shouldSkipArtifact(artifact)) {
            ArtifactResolutionRequest ascReq = this.getArtifactResolutionRequestForAsc(artifact);
            ArtifactResolutionResult ascResult = this.repositorySystem.resolve(ascReq);
            if (ascResult.isSuccess()) {
                ascArtifact = ascReq.getArtifact();
                this.getLog().debug((CharSequence)(ascArtifact.toString() + " " + ascArtifact.getFile()));
            } else {
                if (this.failNoSignature) {
                    this.getLog().error((CharSequence)("No signature for " + artifact.getId()));
                    throw new MojoExecutionException("No signature for " + artifact.getId());
                }
                this.getLog().warn((CharSequence)("No signature for " + artifact.getId()));
            }
        }
        return ascArtifact;
    }

    private ArtifactResolutionRequest getArtifactResolutionRequestForAsc(Artifact artifact) {
        Artifact aAsc = this.repositorySystem.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), artifact.getClassifier());
        ArtifactResolutionRequest rreq = new ArtifactResolutionRequest();
        aAsc.setArtifactHandler((ArtifactHandler)new AscArtifactHandler(aAsc));
        rreq.setArtifact(aAsc);
        rreq.setResolveTransitively(false);
        rreq.setLocalRepository(this.localRepository);
        rreq.setRemoteRepositories(this.remoteRepositories);
        return rreq;
    }

    private ArtifactResolutionRequest getArtifactResolutionRequestForPom(Artifact artifact) {
        Artifact aAsc = this.repositorySystem.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        ArtifactResolutionRequest rreq = new ArtifactResolutionRequest();
        rreq.setArtifact(aAsc);
        rreq.setResolveTransitively(false);
        rreq.setLocalRepository(this.localRepository);
        rreq.setRemoteRepositories(this.remoteRepositories);
        return rreq;
    }

    private void initCache() throws MojoFailureException {
        if (this.pgpKeysCachePath.exists()) {
            if (!this.pgpKeysCachePath.isDirectory()) {
                throw new MojoFailureException("PGP keys cache path exist but is not a directory: " + this.pgpKeysCachePath);
            }
        } else if (this.pgpKeysCachePath.mkdirs()) {
            this.getLog().info((CharSequence)("Create cache for PGP keys: " + this.pgpKeysCachePath));
        } else {
            throw new MojoFailureException("Cache directory create error");
        }
        try {
            this.pgpKeysCache = new PGPKeysCache(this.getLog(), this.pgpKeysCachePath, this.pgpKeyServer);
        }
        catch (IOException | URISyntaxException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private void verifyArtifactSignatures(Map<Artifact, Artifact> artifactToAsc) throws MojoFailureException, MojoExecutionException {
        boolean isAllSigOk = true;
        for (Map.Entry<Artifact, Artifact> artifactEntry : artifactToAsc.entrySet()) {
            Artifact artifact = artifactEntry.getKey();
            Artifact ascArtifact = artifactEntry.getValue();
            boolean isLastOk = this.verifyPGPSignature(artifact, ascArtifact);
            isAllSigOk = isAllSigOk && isLastOk;
        }
        if (!isAllSigOk) {
            throw new MojoExecutionException("PGP signature error");
        }
    }

    private boolean verifyPGPSignature(Artifact artifact, Artifact ascArtifact) throws MojoFailureException {
        File artifactFile = artifact.getFile();
        File signatureFile = ascArtifact.getFile();
        ImmutableMap weakSignatures = ImmutableMap.builder().put((Object)1, (Object)"MD5").put((Object)4, (Object)"DOUBLE_SHA").put((Object)5, (Object)"MD2").put((Object)6, (Object)"TIGER_192").put((Object)7, (Object)"HAVAL_5_160").put((Object)11, (Object)"SHA224").build();
        this.getLog().debug((CharSequence)("Artifact file: " + artifactFile));
        this.getLog().debug((CharSequence)("Artifact sign: " + signatureFile));
        try {
            InputStream sigInputStream = PGPUtil.getDecoderStream((InputStream)new FileInputStream(signatureFile));
            PGPObjectFactory pgpObjectFactory = new PGPObjectFactory(sigInputStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            PGPSignatureList sigList = (PGPSignatureList)pgpObjectFactory.nextObject();
            if (sigList == null) {
                throw new MojoFailureException("Invalid signature file: " + signatureFile);
            }
            PGPSignature pgpSignature = sigList.get(0);
            PGPPublicKey publicKey = this.pgpKeysCache.getKey(pgpSignature.getKeyID());
            if (!this.keysMap.isValidKey(artifact, publicKey)) {
                String msg = String.format("%s=0x%X", ArtifactUtils.key((Artifact)artifact), publicKey.getKeyID());
                String keyUrl = this.pgpKeysCache.getUrlForShowKey(publicKey.getKeyID());
                this.getLog().error((CharSequence)String.format("Not allowed artifact %s and keyID:%n\t%s%n\t%s%n", artifact.getId(), msg, keyUrl));
                return false;
            }
            pgpSignature.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), publicKey);
            try (BufferedInputStream inArtifact = new BufferedInputStream(new FileInputStream(artifactFile));){
                int t;
                while ((t = ((InputStream)inArtifact).read()) >= 0) {
                    pgpSignature.update((byte)t);
                }
            }
            String msgFormat = "%s PGP Signature %s\n       KeyId: 0x%X UserIds: %s";
            if (pgpSignature.verify()) {
                String logMessageOK = String.format(msgFormat, artifact.getId(), "OK", publicKey.getKeyID(), Lists.newArrayList((Iterator)publicKey.getUserIDs()));
                if (this.quiet) {
                    this.getLog().debug((CharSequence)logMessageOK);
                } else {
                    this.getLog().info((CharSequence)logMessageOK);
                }
                if (weakSignatures.containsKey(pgpSignature.getHashAlgorithm())) {
                    String logMessageWeakSignature = "Weak signature algorithm used: " + (String)weakSignatures.get(pgpSignature.getHashAlgorithm());
                    if (this.failWeakSignature) {
                        this.getLog().error((CharSequence)logMessageWeakSignature);
                        throw new MojoFailureException(logMessageWeakSignature);
                    }
                    this.getLog().warn((CharSequence)logMessageWeakSignature);
                }
                return true;
            }
            this.getLog().warn((CharSequence)String.format(msgFormat, artifact.getId(), "ERROR", publicKey.getKeyID(), Lists.newArrayList((Iterator)publicKey.getUserIDs())));
            this.getLog().warn((CharSequence)artifactFile.toString());
            this.getLog().warn((CharSequence)signatureFile.toString());
            return false;
        }
        catch (IOException | PGPException e) {
            throw new MojoFailureException(e.getMessage(), e);
        }
    }

    private boolean shouldSkipArtifact(Artifact artifact) {
        for (SkipFilter filter : this.skipFilters) {
            if (!filter.shouldSkipArtifact(artifact)) continue;
            return true;
        }
        return false;
    }
}

