/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins;

import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.simplify4u.plugins.ArtifactInfo;
import org.simplify4u.plugins.KeyInfo;

@Component(role=KeysMap.class)
public class KeysMap {
    @Requirement
    private ResourceManager resourceManager;
    private final List<ArtifactInfo> keysMapList = new ArrayList<ArtifactInfo>();

    public void load(String locale) throws ResourceNotFoundException, IOException {
        if (!Strings.isNullOrEmpty((String)locale) && !Strings.isNullOrEmpty((String)locale.trim())) {
            try (InputStream inputStream = this.resourceManager.getResourceAsInputStream(locale);){
                this.loadKeysMap(inputStream);
            }
        }
    }

    public boolean isNoKey(Artifact artifact) {
        for (ArtifactInfo artifactInfo : this.keysMapList) {
            if (!artifactInfo.isMatch(artifact)) continue;
            return artifactInfo.isNoKey();
        }
        return false;
    }

    public boolean isValidKey(Artifact artifact, PGPPublicKey key) {
        if (this.keysMapList.isEmpty()) {
            return true;
        }
        for (ArtifactInfo artifactInfo : this.keysMapList) {
            if (!artifactInfo.isMatch(artifact)) continue;
            return artifactInfo.isKeyMatch(key);
        }
        return false;
    }

    private void loadKeysMap(InputStream inputStream) throws IOException {
        String currentLine;
        BufferedReader mapReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.US_ASCII));
        while ((currentLine = this.getNextLine(mapReader)) != null) {
            String[] parts = currentLine.split("=");
            if (parts.length > 2) {
                throw new IllegalArgumentException("Property line is malformed: " + currentLine);
            }
            ArtifactInfo artifactInfo = this.createArtifactInfo(parts[0], parts.length == 1 ? "" : parts[1]);
            this.keysMapList.add(artifactInfo);
        }
    }

    private String getNextLine(BufferedReader mapReader) throws IOException {
        String ret;
        String line;
        StringBuilder nextLine = new StringBuilder();
        while ((line = this.getNextNotEmptyLine(mapReader)) != null) {
            if (line.charAt(line.length() - 1) == '\\') {
                nextLine.append(line, 0, line.length() - 1);
                nextLine.append(" ");
                continue;
            }
            nextLine.append(line);
            break;
        }
        return (ret = nextLine.toString().trim()).length() == 0 ? null : ret;
    }

    private String getNextNotEmptyLine(BufferedReader readLine) throws IOException {
        String line;
        String nextLine = null;
        while ((line = readLine.readLine()) != null && (nextLine = this.stripComments(line.trim())).isEmpty()) {
        }
        return nextLine == null || nextLine.length() == 0 ? null : nextLine;
    }

    private String stripComments(String line) {
        if (line.length() < 1) {
            return line;
        }
        int hashIndex = line.indexOf(35);
        return hashIndex >= 0 ? line.substring(0, hashIndex).trim() : line;
    }

    private ArtifactInfo createArtifactInfo(String strArtifact, String strKeys) {
        return new ArtifactInfo(strArtifact.trim(), new KeyInfo(strKeys.trim()));
    }
}

