/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins;

import com.google.common.io.ByteStreams;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.event.RetryEvent;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedRunnable;
import io.vavr.control.Try;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.simplify4u.plugins.PGPKeysServerClientHttp;
import org.simplify4u.plugins.PGPKeysServerClientHttps;
import org.simplify4u.plugins.RoundRobinRouterPlaner;

abstract class PGPKeysServerClient {
    private static final int DEFAULT_CONNECT_TIMEOUT = 5000;
    private static final int DEFAULT_READ_TIMEOUT = 20000;
    public static final int DEFAULT_MAX_RETRIES = 10;
    private final URI keyserver;
    private final int connectTimeout;
    private final int readTimeout;
    private final int maxAttempts;

    protected PGPKeysServerClient(URI keyserver, int connectTimeout, int readTimeout, int maxAttempts) {
        this.keyserver = keyserver;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.maxAttempts = maxAttempts;
    }

    static PGPKeysServerClient getClient(String keyServer) throws IOException {
        return PGPKeysServerClient.getClient(keyServer, 5000, 20000, 10);
    }

    static PGPKeysServerClient getClient(String keyServer, int connectTimeout, int readTimeout, int maxAttempts) throws IOException {
        String protocol;
        URI uri = (URI)Try.of((CheckedFunction0 & Serializable)() -> new URI(keyServer)).getOrElseThrow(IOException::new);
        switch (protocol = uri.getScheme().toLowerCase(Locale.ROOT)) {
            case "hkp": 
            case "http": {
                return new PGPKeysServerClientHttp(uri, connectTimeout, readTimeout, maxAttempts);
            }
            case "hkps": 
            case "https": {
                return new PGPKeysServerClientHttps(uri, connectTimeout, readTimeout, maxAttempts);
            }
        }
        throw new IOException("Unsupported protocol: " + protocol);
    }

    private String getQueryStringForGetKey(long keyID) {
        return String.format("op=get&options=mr&search=0x%016X", keyID);
    }

    URI getUriForGetKey(long keyID) {
        try {
            return new URI(this.keyserver.getScheme(), this.keyserver.getUserInfo(), this.keyserver.getHost(), this.keyserver.getPort(), "/pks/lookup", this.getQueryStringForGetKey(keyID), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("URI exception for keyId 0x%016X", keyID), e);
        }
    }

    private String getQueryStringForShowKey(long keyID) {
        return String.format("op=vindex&fingerprint=on&search=0x%016X", keyID);
    }

    URI getUriForShowKey(long keyID) {
        try {
            return new URI(this.keyserver.getScheme(), this.keyserver.getUserInfo(), this.keyserver.getHost(), this.keyserver.getPort(), "/pks/lookup", this.getQueryStringForShowKey(keyID), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("URI exception for keyId 0x%016X", keyID), e);
        }
    }

    void copyKeyToOutputStream(long keyId, OutputStream outputStream, OnRetryConsumer onRetryConsumer) throws IOException {
        URI keyUri = this.getUriForGetKey(keyId);
        HttpGet request = new HttpGet(keyUri);
        RoundRobinRouterPlaner planer = new RoundRobinRouterPlaner();
        RetryConfig config = RetryConfig.custom().maxAttempts(this.maxAttempts).waitDuration(Duration.ofMillis(500L)).intervalFunction(IntervalFunction.ofExponentialBackoff()).ignoreExceptions(new Class[]{FileNotFoundException.class}).build();
        Retry retry = Retry.of((String)"id", (RetryConfig)config);
        retry.getEventPublisher().onRetry(event -> this.processOnRetry((RetryEvent)event, planer, onRetryConsumer)).onError(event -> this.processOnRetry((RetryEvent)event, planer, onRetryConsumer));
        CheckedRunnable checkedRunnable = Retry.decorateCheckedRunnable((Retry)retry, () -> this.lambda$copyKeyToOutputStream$2(planer, (HttpUriRequest)request, outputStream));
        try {
            checkedRunnable.run();
        }
        catch (FileNotFoundException e) {
            throw new IOException("PGP server returned an error: HTTP/1.1 404 Not Found for: " + keyUri);
        }
        catch (Throwable e) {
            throw new IOException(e.getMessage() + " for: " + keyUri, e);
        }
    }

    private void processOnRetry(RetryEvent event, RoundRobinRouterPlaner planer, OnRetryConsumer onRetryConsumer) {
        HttpRoute httpRoute = planer.lastRouteCauseError();
        if (onRetryConsumer != null) {
            onRetryConsumer.onRetry(httpRoute.getTargetHost().getAddress(), event.getNumberOfRetryAttempts(), event.getLastThrowable());
        }
    }

    protected abstract HttpClientBuilder createClientBuilder();

    private void processKeyResponse(CloseableHttpResponse response, OutputStream outputStream) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() == 404) {
            throw new FileNotFoundException();
        }
        if (statusLine.getStatusCode() == 200) {
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity == null) {
                throw new IOException("No response body returned.");
            }
            try (InputStream inputStream = responseEntity.getContent();){
                ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
        } else {
            throw new IOException("PGP server returned an error: " + statusLine);
        }
    }

    private CloseableHttpClient buildClient(RoundRobinRouterPlaner planer) {
        HttpClientBuilder clientBuilder = this.createClientBuilder();
        this.applyTimeouts(clientBuilder);
        clientBuilder.setRoutePlanner((HttpRoutePlanner)planer);
        return clientBuilder.build();
    }

    private void applyTimeouts(HttpClientBuilder builder) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.connectTimeout).setConnectTimeout(this.connectTimeout).setSocketTimeout(this.readTimeout).build();
        builder.setDefaultRequestConfig(requestConfig);
    }

    private /* synthetic */ void lambda$copyKeyToOutputStream$2(RoundRobinRouterPlaner planer, HttpUriRequest request, OutputStream outputStream) throws Throwable {
        try (CloseableHttpClient client = this.buildClient(planer);
             CloseableHttpResponse response = client.execute(request);){
            this.processKeyResponse(response, outputStream);
        }
    }

    @FunctionalInterface
    public static interface OnRetryConsumer {
        public void onRetry(InetAddress var1, int var2, Throwable var3);
    }
}

