/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Locale;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.simplify4u.plugins.PGPKeysServerClient;

public class PGPKeysServerClientHttps
extends PGPKeysServerClient {
    private final SSLConnectionSocketFactory sslSocketFactory;

    protected PGPKeysServerClientHttps(URI uri, int connectTimeout, int readTimeout, int maxAttempts) throws IOException {
        super(PGPKeysServerClientHttps.prepareKeyServerURI(uri), connectTimeout, readTimeout, maxAttempts);
        try {
            if (uri.getHost().toLowerCase(Locale.ROOT).endsWith("sks-keyservers.net")) {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                Certificate ca = cf.generateCertificate(this.getClass().getClassLoader().getResourceAsStream("sks-keyservers.netCA.pem"));
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, null);
                keyStore.setCertificateEntry("ca", ca);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(keyStore);
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, tmf.getTrustManagers(), null);
                this.sslSocketFactory = new SSLConnectionSocketFactory(context, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
            } else {
                this.sslSocketFactory = SSLConnectionSocketFactory.getSystemSocketFactory();
            }
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IOException(e);
        }
    }

    private static URI prepareKeyServerURI(URI keyserver) throws IOException {
        try {
            return new URI("https", keyserver.getUserInfo(), keyserver.getHost(), keyserver.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected HttpClientBuilder createClientBuilder() {
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)this.sslSocketFactory);
    }
}

