/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.protocol.HttpContext;

public class RoundRobinRouterPlaner
implements HttpRoutePlanner {
    private HttpRoute lastRoute;
    private List<InetAddress> errorAddresses = new ArrayList<InetAddress>();

    public HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        if (this.lastRoute == null || !this.lastRoute.getTargetHost().getHostName().equals(target.getHostName())) {
            List<InetAddress> resolvedAddresses = this.resolve(target.getHostName());
            Optional<InetAddress> address = resolvedAddresses.stream().filter(a -> !this.errorAddresses.contains(a)).findFirst();
            if (!address.isPresent()) {
                this.errorAddresses.removeIf(resolvedAddresses::contains);
                address = Optional.of(resolvedAddresses.get(0));
            }
            HttpHost httpHost = new HttpHost(address.get(), target.getHostName(), target.getPort(), target.getSchemeName());
            boolean secure = "https".equalsIgnoreCase(target.getSchemeName());
            this.lastRoute = new HttpRoute(httpHost, null, secure);
        }
        return this.lastRoute;
    }

    private List<InetAddress> resolve(String hostName) throws HttpException {
        try {
            return Arrays.asList(InetAddress.getAllByName(hostName));
        }
        catch (UnknownHostException e) {
            throw new HttpException(e.getMessage(), (Throwable)e);
        }
    }

    public HttpRoute lastRouteCauseError() {
        HttpRoute ret = this.lastRoute;
        if (this.lastRoute != null) {
            this.errorAddresses.add(this.lastRoute.getTargetHost().getAddress());
            this.lastRoute = null;
        }
        return ret;
    }
}

