/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.simplify4u.plugins.AscArtifactHandler;
import org.simplify4u.plugins.MavenCompilerUtils;
import org.simplify4u.plugins.skipfilters.SkipFilter;

final class ArtifactResolver {
    private final Log log;
    private final RepositorySystem repositorySystem;
    private final ArtifactRepository localRepository;
    private final List<ArtifactRepository> remoteRepositories;
    private final List<ArtifactRepository> remoteRepositoriesIgnoreCheckSum;

    ArtifactResolver(Log log, RepositorySystem repositorySystem, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) {
        this.log = Objects.requireNonNull(log);
        this.repositorySystem = Objects.requireNonNull(repositorySystem);
        this.localRepository = Objects.requireNonNull(localRepository);
        this.remoteRepositories = Objects.requireNonNull(remoteRepositories);
        this.remoteRepositoriesIgnoreCheckSum = this.repositoriesIgnoreCheckSum(remoteRepositories);
    }

    private List<ArtifactRepository> repositoriesIgnoreCheckSum(List<ArtifactRepository> repositories) {
        return Optional.ofNullable(repositories).orElse(Collections.emptyList()).stream().map(this::repositoryIgnoreCheckSum).collect(Collectors.toList());
    }

    private ArtifactRepository repositoryIgnoreCheckSum(ArtifactRepository repository) {
        ArtifactRepository newRepository = this.repositorySystem.createArtifactRepository(repository.getId(), repository.getUrl(), repository.getLayout(), this.policyIgnoreCheckSum(repository.getSnapshots()), this.policyIgnoreCheckSum(repository.getReleases()));
        newRepository.setAuthentication(repository.getAuthentication());
        newRepository.setProxy(repository.getProxy());
        newRepository.setMirroredRepositories(this.repositoriesIgnoreCheckSum(repository.getMirroredRepositories()));
        return newRepository;
    }

    private ArtifactRepositoryPolicy policyIgnoreCheckSum(ArtifactRepositoryPolicy policy) {
        return new ArtifactRepositoryPolicy(policy.isEnabled(), policy.getUpdatePolicy(), "ignore");
    }

    Set<Artifact> resolveProjectArtifacts(MavenProject project, Configuration config) throws MojoExecutionException {
        LinkedHashSet<Artifact> allArtifacts = new LinkedHashSet<Artifact>(this.resolveArtifacts(project.getArtifacts(), config.dependencyFilter, config.verifyPomFiles));
        if (config.verifyPlugins) {
            allArtifacts.addAll(this.resolveArtifacts(project.getPluginArtifacts(), config.pluginFilter, config.verifyPomFiles));
            allArtifacts.addAll(this.resolveArtifacts(project.getReportArtifacts(), config.pluginFilter, config.verifyPomFiles));
            allArtifacts.addAll(this.resolveArtifacts(project.getBuildPlugins().stream().flatMap(p -> p.getDependencies().stream()).map(arg_0 -> ((RepositorySystem)this.repositorySystem).createDependencyArtifact(arg_0)).collect(Collectors.toList()), config.dependencyFilter, config.verifyPomFiles));
        }
        if (config.verifyAtypical) {
            allArtifacts.addAll(this.resolveArtifacts(this.searchCompilerAnnotationProcessors(project), config.dependencyFilter, config.verifyPomFiles));
        }
        this.log.debug((CharSequence)("Discovered project artifacts: " + allArtifacts));
        return allArtifacts;
    }

    private Collection<Artifact> searchCompilerAnnotationProcessors(MavenProject project) {
        return project.getBuildPlugins().stream().filter(MavenCompilerUtils::checkCompilerPlugin).flatMap(p -> MavenCompilerUtils.extractAnnotationProcessors(this.repositorySystem, p).stream()).collect(Collectors.toList());
    }

    Map<Artifact, Artifact> resolveSignatures(Iterable<Artifact> artifacts, SignatureRequirement requirement) throws MojoExecutionException {
        this.log.debug((CharSequence)"Start resolving ASC files");
        LinkedHashMap<Artifact, Artifact> artifactToAsc = new LinkedHashMap<Artifact, Artifact>();
        for (Artifact artifact : artifacts) {
            Artifact ascArtifact = this.resolveSignature(artifact, requirement);
            if (ascArtifact == null && requirement != SignatureRequirement.STRICT) continue;
            artifactToAsc.put(artifact, ascArtifact);
        }
        return artifactToAsc;
    }

    private Artifact resolveSignature(Artifact artifact, SignatureRequirement requirement) throws MojoExecutionException {
        Artifact aAsc = this.repositorySystem.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), artifact.getClassifier());
        aAsc.setArtifactHandler((ArtifactHandler)new AscArtifactHandler(aAsc));
        ArtifactResolutionResult ascResult = this.request(aAsc, this.remoteRepositoriesIgnoreCheckSum);
        if (ascResult.isSuccess()) {
            this.log.debug((CharSequence)(aAsc.toString() + " " + aAsc.getFile()));
            return aAsc;
        }
        switch (requirement) {
            case NONE: {
                this.log.warn((CharSequence)("No signature for " + artifact.getId()));
                break;
            }
            case STRICT: {
                this.log.debug((CharSequence)("No signature for " + artifact.getId()));
                break;
            }
            case REQUIRED: {
                this.log.error((CharSequence)("No signature for " + artifact.getId()));
                throw new MojoExecutionException("No signature for " + artifact.getId());
            }
            default: {
                throw new UnsupportedOperationException("Unsupported signature requirement.");
            }
        }
        return null;
    }

    private Set<Artifact> resolveArtifacts(Iterable<Artifact> artifacts, SkipFilter filter, boolean verifyPom) throws MojoExecutionException {
        LinkedHashSet<Artifact> collection = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            Artifact resolved = this.resolveArtifact(artifact);
            if (filter.shouldSkipArtifact(artifact)) {
                this.log.debug((CharSequence)("Skipping artifact: " + artifact));
                continue;
            }
            if (!resolved.isResolved()) {
                throw new MojoExecutionException("Failed to resolve artifact: " + artifact);
            }
            collection.add(resolved);
            if (!verifyPom) continue;
            Artifact resolvedPom = this.resolvePom(artifact);
            if (resolvedPom.isResolved()) {
                collection.add(resolvedPom);
                continue;
            }
            this.log.warn((CharSequence)("Failed to resolve pom artifact: " + resolvedPom));
        }
        return collection;
    }

    private Artifact resolvePom(Artifact artifact) {
        Artifact pomArtifact = this.repositorySystem.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        ArtifactResolutionResult result = this.request(pomArtifact, this.remoteRepositories);
        if (!result.isSuccess()) {
            result.getExceptions().forEach(e -> this.log.debug((CharSequence)("Failed to resolve pom " + pomArtifact.getId() + ": " + e.getMessage())));
        }
        return pomArtifact;
    }

    private Artifact resolveArtifact(Artifact artifact) {
        ArtifactResolutionResult result = this.request(artifact, this.remoteRepositories);
        if (!result.isSuccess()) {
            result.getExceptions().forEach(e -> {
                this.log.warn((CharSequence)("Failed to resolve " + artifact.getId() + ": " + e.getMessage()));
                this.log.debug((Throwable)e);
            });
        }
        return artifact;
    }

    private ArtifactResolutionResult request(Artifact artifact, List<ArtifactRepository> remoteRepositoriesToResolve) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setResolveTransitively(false);
        request.setLocalRepository(this.localRepository);
        request.setRemoteRepositories(remoteRepositoriesToResolve);
        return this.repositorySystem.resolve(request);
    }

    public static final class Configuration {
        final SkipFilter dependencyFilter;
        final SkipFilter pluginFilter;
        final boolean verifyPomFiles;
        final boolean verifyPlugins;
        final boolean verifyAtypical;

        public Configuration(SkipFilter dependencyFilter, SkipFilter pluginFilter, boolean verifyPomFiles, boolean verifyPlugins, boolean verifyAtypical) {
            this.dependencyFilter = Objects.requireNonNull(dependencyFilter);
            this.pluginFilter = Objects.requireNonNull(pluginFilter);
            this.verifyPomFiles = verifyPomFiles;
            this.verifyPlugins = verifyPlugins;
            this.verifyAtypical = verifyAtypical;
        }
    }

    static enum SignatureRequirement {
        NONE,
        STRICT,
        REQUIRED;

    }
}

