/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.keyserver;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.impl.client.HttpClientBuilder;
import org.simplify4u.plugins.keyserver.PGPKeysServerClient;

class PGPKeysServerClientHttp
extends PGPKeysServerClient {
    protected PGPKeysServerClientHttp(URI keyserver, int connectTimeout, int readTimeout, int maxAttempts) throws IOException {
        super(PGPKeysServerClientHttp.prepareKeyServerURI(keyserver), connectTimeout, readTimeout, maxAttempts);
    }

    private static URI prepareKeyServerURI(URI keyServer) throws IOException {
        int port = -1;
        if (keyServer.getPort() > 0) {
            port = keyServer.getPort();
        } else if ("hkp".equalsIgnoreCase(keyServer.getScheme())) {
            port = 11371;
        }
        try {
            return new URI("http", keyServer.getUserInfo(), keyServer.getHost(), port, null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected HttpClientBuilder createClientBuilder() {
        return HttpClientBuilder.create();
    }
}

