/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.utils;

import io.vavr.control.Try;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PublicKeyUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublicKeyUtils.class);

    private PublicKeyUtils() {
    }

    public static String fingerprint(PGPPublicKey publicKey) {
        StringBuilder ret = new StringBuilder("0x");
        byte[] byArray = publicKey.getFingerprint();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte b = byArray[i];
            ret.append(String.format("%02X", b));
        }
        return ret.toString();
    }

    public static String fingerprintForMaster(PGPPublicKey publicKey, PGPPublicKeyRing publicKeyRing) {
        return PublicKeyUtils.fingerprint(PublicKeyUtils.getMasterKey(publicKey, publicKeyRing).orElse(publicKey));
    }

    public static String keyIdDescription(PGPPublicKey publicKey, PGPPublicKeyRing publicKeyRing) {
        Optional<PGPPublicKey> masterKey = PublicKeyUtils.getMasterKey(publicKey, publicKeyRing);
        if (masterKey.isPresent()) {
            return String.format("SubKeyId: 0x%16X of %s", publicKey.getKeyID(), PublicKeyUtils.fingerprint(masterKey.get()));
        }
        return "KeyId: " + PublicKeyUtils.fingerprint(publicKey);
    }

    public static Optional<PGPPublicKey> getMasterKey(PGPPublicKey publicKey, PGPPublicKeyRing publicKeyRing) {
        if (publicKey.isMasterKey()) {
            return Optional.empty();
        }
        Iterator signatures = publicKey.getSignaturesOfType(24);
        if (signatures.hasNext()) {
            PGPSignature sig = (PGPSignature)signatures.next();
            return Optional.ofNullable(publicKeyRing.getPublicKey(sig.getKeyID()));
        }
        return Optional.empty();
    }

    public static Collection<String> getUserIDs(PGPPublicKey publicKey, PGPPublicKeyRing publicKeyRing) {
        LinkedHashSet ret = new LinkedHashSet();
        publicKey.getRawUserIDs().forEachRemaining(ret::add);
        PublicKeyUtils.getMasterKey(publicKey, publicKeyRing).ifPresent(masterKey -> masterKey.getRawUserIDs().forEachRemaining(ret::add));
        return ret.stream().map(b -> new String((byte[])b, StandardCharsets.UTF_8)).collect(Collectors.toSet());
    }

    public static Optional<PGPPublicKeyRing> loadPublicKeyRing(InputStream keyStream, long keyId) throws IOException, PGPException {
        InputStream keyIn = PGPUtil.getDecoderStream((InputStream)keyStream);
        PGPPublicKeyRingCollection pgpRing = new PGPPublicKeyRingCollection(keyIn, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        Optional<PGPPublicKeyRing> publicKeyRing = Optional.ofNullable(pgpRing.getPublicKeyRing(keyId));
        publicKeyRing.ifPresent(PublicKeyUtils::verifyPublicKeyRing);
        return publicKeyRing;
    }

    private static void verifyPublicKeyRing(PGPPublicKeyRing publicKeyRing) {
        StreamSupport.stream(publicKeyRing.spliterator(), false).filter(key -> !key.isMasterKey()).forEach(key -> {
            Void cfr_ignored_0 = (Void)Try.run(() -> PublicKeyUtils.verifySigForSubKey(key, publicKeyRing)).get();
        });
    }

    private static void verifySigForSubKey(PGPPublicKey subKey, PGPPublicKeyRing publicKeyRing) throws PGPException {
        int signatureTypeToCheck = subKey.hasRevocation() ? 40 : 24;
        AtomicBoolean hasValidSignature = new AtomicBoolean(false);
        subKey.getSignaturesOfType(signatureTypeToCheck).forEachRemaining(s -> {
            Void cfr_ignored_0 = (Void)Try.run(() -> {
                PGPSignature sig = (PGPSignature)s;
                PGPPublicKey masterKey = publicKeyRing.getPublicKey(sig.getKeyID());
                if (masterKey != null) {
                    sig.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), masterKey);
                    if (sig.verifyCertification(masterKey, subKey)) {
                        hasValidSignature.set(true);
                    } else {
                        LOGGER.debug("Invalid signature [{}] type: {} for subKey: {}", new Object[]{sig.getCreationTime(), sig.getSignatureType(), PublicKeyUtils.fingerprint(subKey)});
                    }
                } else {
                    throw new PGPException(String.format("Signature type: %d Not found key 0x%016X for subKeyId: %s", sig.getSignatureType(), sig.getKeyID(), PublicKeyUtils.fingerprint(subKey)));
                }
            }).get();
        });
        if (!hasValidSignature.get()) {
            throw new PGPException(String.format("No valid signature type: %d for subKey: %s", signatureTypeToCheck, PublicKeyUtils.fingerprint(subKey)));
        }
    }
}

