/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.keysmap;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Optional;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.simplify4u.plugins.keysmap.KeyInfoItem;
import org.simplify4u.plugins.utils.PublicKeyUtils;

public class KeyInfoItemKey
implements KeyInfoItem {
    private final byte[] fingerPrint;

    public KeyInfoItemKey(String key) {
        this.fingerPrint = this.strKeyToBytes(key.substring(2));
    }

    @Override
    public boolean isKeyMatch(PGPPublicKey pgpPublicKey, PGPPublicKeyRing pgpPublicKeyRing) {
        if (this.compareArrays(this.fingerPrint, pgpPublicKey.getFingerprint())) {
            return true;
        }
        Optional<PGPPublicKey> masterKey = PublicKeyUtils.getMasterKey(pgpPublicKey, pgpPublicKeyRing);
        return masterKey.filter(publicKey -> this.isKeyMatch((PGPPublicKey)publicKey, pgpPublicKeyRing)).isPresent();
    }

    private byte[] strKeyToBytes(String key) {
        BigInteger bigInteger = new BigInteger(key.replace(" ", ""), 16);
        byte[] bytes = bigInteger.toByteArray();
        if (bytes[0] == 0) {
            bytes = Arrays.copyOfRange(bytes, 1, bytes.length);
        }
        if (bytes.length < 8 || bytes.length > 20) {
            throw new IllegalArgumentException(String.format("Key length for = 0x%s is %d bits, should be between 64 and 160 bits", key, bytes.length * 8));
        }
        return bytes;
    }

    private boolean compareArrays(byte[] keyBytes, byte[] fingerprint) {
        for (int i = 1; i <= keyBytes.length && i <= fingerprint.length; ++i) {
            if (keyBytes[keyBytes.length - i] == fingerprint[fingerprint.length - i]) continue;
            return false;
        }
        return true;
    }
}

